#ifndef PARAMETER_LIST_H
#define PARAMETER_LIST_H

#include <string>
#include <list>

using namespace std;

enum { PARAM_TYPE_INT, PARAM_TYPE_DOUBLE, PARAM_TYPE_STRING };

class ParameterDefinition {
public:
	ParameterDefinition(const string &n, int t, void *v):param_name(n), param_type(t), bind_variable(v) {}
	string param_name;
	int param_type;
	void *bind_variable;
};

class ParameterList {
protected:
	list<ParameterDefinition*> parameter_list;

public:
	ParameterList() {}
	~ParameterList();

	void addParameter(const string &param_name, int param_type, void *bind_variable);

	void setParameter(const string &param_name, const string &param_value);
	void setParameter(const string &param_name, int param_value);
	void setParameter(const string &param_name, double param_value); 

	string parameterAsString(const string &param_name);
	int parameterAsInt(const string &param_name);
	double parameterAsDouble(const string &param_name);

	void listParameters();
};

#endif //PARAMETER_LIST_H
