/*
 * Electric(tm) VLSI Design System
 *
 * File: simals.h
 * Header file for asynchronous logic simulator
 * From algorithms by: Brent Serbin and Peter J. Gallant
 * Last maintained by: Steven M. Rubin
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

/* the meaning of "SIM_irsim_state": */
#define IRSIMPARASITICS   03		/* the nature of parasitics for IRSIM */
#define IRSIMPARAQUICK     0		/*   quick IRSIM parasitics (transistor only) */
#define IRSIMPARALOCAL     1		/*   local IRSIM parasitics (facet level only) */
#define IRSIMPARAFULL      2		/*   full IRSIM parasitics (hierarchical) */

#define DEFIRSIMTIMERANGE  10.0E-9f			/* initial size of simulation window: 10ns */
#define DEFIRSIMPARAMFILE  "scmos0.3.prm"	/* default parameter file name */
#define DEFIRSIMSTATE      IRSIMPARALOCAL	/* default value of "SIM_irsim_state" */

#define NOIRSIMTRANSISTOR ((IRSIMTRANSISTOR *)-1)

typedef struct Iirsimtransistor
{
	INTBIG                   transistortype;			/* type of transistor */
	struct Iirsimtransistor *nextsourcelist;			/* next in list of transistors with source on diffusion area */
	struct Iirsimtransistor *nextdrainlist;				/* next in list of transistors with drain on diffusion area */
	INTBIG                   xpos, ypos;				/* location of transistor */
	INTBIG                   length, width;				/* size of transistor */
	INTBIG                   source, gate, drain;		/* network of source, gate, drain */
	INTBIG                   sourcex, sourcey;			/* location of transistor source */
	INTBIG                   drainx, drainy;			/* location of transistor drain */
	float                    sarea, darea;				/* area of source/drain */
	INTBIG                   sperimeter, dperimeter;	/* perimeter of source/drain */
	struct Iirsimtransistor *nextirsimtransistor;		/* next in list of all transistors */
	struct Iirsimtransistor *nextfacetirsimtransistor;	/* next in list of transistors in this facet */
} IRSIMTRANSISTOR;

/* the meaning of IRSIMNETWORK->flags: */
#define IRSIMNETVALID      1					/* set if network is valid */
#define IRSIMNETSHOWN      2					/* set if network is shown */

typedef struct Iirsimnetwork
{
	char      *name;							/* net name in IRSIM */
	INTBIG     signal;							/* waveform pointer */
	INTBIG     flags;							/* flags for this network */
} IRSIMNETWORK;

extern IRSIMNETWORK    *sim_irsimnets;
extern IRSIMTRANSISTOR *sim_firstirsimtransistor;
extern INTBIG           sim_irsimnetnumber;
extern INTBIG           sim_irsim_statekey;		/* variable key for "SIM_irsim_state" */

void     sim_irsimgeneratedeck(NODEPROTO *facet, FILE *f);
#if SIMTOOLIRSIM != 0
BOOLEAN  irsim_startsimulation(NODEPROTO *np);
BOOLEAN  irsim_charhandlerschem(WINDOWPART *w, INTSML chr, INTBIG special);
BOOLEAN  irsim_charhandlerwave(WINDOWPART *w, INTSML chr, INTBIG special);
void     irsim_clearallvectors(void);
void     irsim_loadvectorfile(char *filename);
void     irsim_savevectorfile(char *filename);
void     irsim_level_up(void);
void     irsim_level_set(char *level);
BOOLEAN  irsim_topofinstances(char **c);
char    *irsim_nextinstance(void);
void     irsim_freememory(void);
#endif
