/* $Id: e2_button.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_BUTTON_H
#define E2_BUTTON_H

typedef enum
{
	E2_BTN_DEFAULT = 1 << 0,
	E2_BTN_HIDDEN  = 1 << 1,
	E2_BTN_GREY    = 1 << 2,
	E2_BTN_RENAMED = 1 << 3,
	E2_BTN_TIPPED  = 1 << 4,	//the button has a custom tip
	E2_BTN_FREETIP = 1 << 5,	//the button has a custom tip to be freed after use
} E2_ButtonType;

typedef struct _E2_Button
{
	gchar *label;
	gchar *default_label;
	gchar *stock;
	//only used for dialogs
	gchar *tip;	//custom tip or NULL
	E2_ButtonType showflags;
	E2_ButtonType default_flags;
	gint response;
} E2_Button;

typedef enum
{
	E2_BUTTON_FREE_DATA         = 1 << 0,
	E2_BUTTON_ICON_ABOVE_LABEL  = 1 << 1,
	E2_BUTTON_CAN_FOCUS         = 1 << 2,
	E2_BUTTON_CAN_DEFAULT       = 1 << 3,
	E2_BUTTON_SHOW_MISSING_ICON = 1 << 4
} E2_ButtonFlags;

E2_Button E2_BUTTON_OK;
E2_Button E2_BUTTON_CANCEL;
E2_Button E2_BUTTON_YES;
E2_Button E2_BUTTON_NO;
E2_Button E2_BUTTON_YESTOALL;
E2_Button E2_BUTTON_NOTOALL;
E2_Button E2_BUTTON_APPLY;
E2_Button E2_BUTTON_APPLYTOALL;
E2_Button E2_BUTTON_REFRESH;
E2_Button E2_BUTTON_CLOSE;
E2_Button E2_BUTTON_CREATE;
E2_Button E2_BUTTON_REMOVE;

// custom button signal responses, used in dialogs
#define E2_RESPONSE_YESTOALL	111
#define E2_RESPONSE_APPLYTOALL	112
#define E2_RESPONSE_NOTOALL		113
#define E2_RESPONSE_CREATE		114
#define E2_RESPONSE_REFRESH		115
#define E2_RESPONSE_REMOVE		116
#define E2_RESPONSE_FIND		117
#define E2_RESPONSE_USER1		120
#define E2_RESPONSE_USER2		121
#define E2_RESPONSE_USER3		122

void e2_button_setup_labels (void);
void e2_button_set_image (GtkWidget *button, gchar *stock);
GtkWidget *e2_button_get (gchar *label, gchar *stock, gchar *tip,
	gpointer callback, gpointer data);
GtkWidget *e2_button_get_full (gchar *label, gchar *stock, GtkIconSize size,
	gchar *tip, gpointer callback, gpointer data, E2_ButtonFlags flags);
GtkWidget *e2_button_add (GtkWidget *box, gboolean exp, guint pad,
	gchar *label, gchar *stock, gchar *tip, gpointer callback, gpointer data);
GtkWidget *e2_button_add_end (GtkWidget *box, gboolean exp, guint pad,
	gchar *label, gchar *stock, gchar *tip, gpointer callback, gpointer data);
GtkWidget *e2_button_get_toggle (gboolean check, gboolean state,
	gchar *label, gchar *tip, gpointer func, gpointer data);
GtkWidget *e2_button_add_toggle (GtkWidget *box,  gboolean check, gboolean state,
	gchar *label, gchar *tip, gboolean exp, guint pad, gpointer func, gpointer data);
GtkWidget *e2_button_add_radio (GtkWidget *box, gchar *label, GSList *group,
	gboolean state, gboolean exp, guint pad, gpointer func, gpointer data);
GtkWidget *e2_button_add_to_table (GtkWidget *table, gchar *label,
	gpointer func, gpointer data, gint left, gint right, gint top, gint bottom);
GtkWidget *e2_button_add_toggle_to_table(GtkWidget *table, gchar *label,
	gboolean state, gpointer func, gpointer data, gint left, gint right, gint top,
	gint bottom);
GtkWidget *e2_button_add_radio_to_table (GtkWidget *table, gchar *label,
	GSList *group, gboolean state, gpointer func, gpointer data, gint left,
	gint right, gint top, gint bottom);

#endif //ndef E2_BUTTON_H
