#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "../include/disk.h"

gchar *g_strsub(const gchar *s, const gchar *token, const gchar *value)
{
	gint i;
	gchar **strv, *rtn_s, *tmp_s, *s2;

	if(value == NULL)
	    value = "";

	if(s == NULL)
	    return(NULL);

	if(token == NULL)
	    return(g_strdup(s));

/* Need to add " characters around s */
s2 = g_strconcat("\"", s, "\"", NULL);
	strv = g_strsplit(s2, token, -1);
g_free(s2);
	if(strv == NULL)
	    return(g_strdup(s));

	if(strv[0] == NULL)
	    return(g_strdup(s));

	rtn_s = g_strdup(strv[0]);
	if(rtn_s == NULL)
	    return(NULL);

	for(i = 1; strv[i] != NULL; i++)
	{
	    tmp_s = g_strconcat(
		rtn_s,
		value,
		strv[i],
		NULL
	    );
	    g_free(rtn_s);
	    rtn_s = tmp_s;
	    if(rtn_s == NULL)
		break;
	}

	g_strfreev(strv);

 s2 = rtn_s;
 while(*s2 != '\0')
 {
  *s2 = *(s2 + 1);
  s2++;
 }
 if((gint)(s2 - rtn_s) >= 2)
  *(s2 - 2) = '\0';

	return(rtn_s);
}

int main(int argc, char *argv[])
{
#if 1
	gint status;
	gchar *path;

	if(argc <= 1)
	    return(2);

	path = g_strdup(argv[1]);
	path = (gchar *)CompletePath((char *)path, (int *)&status);
	g_print(
"\"%s\" %i\n",
	    path, status
	);
	g_free(path);

	return(0);
#else
	gchar *s;

	if(argc <= 2)
	    return(2);

	s = g_strsub(
	    argv[1],
	    "%s",
	    argv[2]
	);
	g_print(
	    "Result: \"%s\"\n",
	    s
	);
	g_free(s);

	return(0);
#endif
}
