/*
                 Endeavour HEdit Compile Time Configuration
 */

#ifndef CONFIG_HEDIT_H
#define CONFIG_HEDIT_H

#include "../config.h"


/*
 *      Program name and version:
 */
#undef PROG_NAME
#define PROG_NAME			"HEdit"
#undef PROG_NAME_FULL
#define PROG_NAME_FULL			"Hex Editor"



/*
 *	Standard output help message:
 */
#ifdef PROG_HELP_MESG
# undef PROG_HELP_MESG
#endif

#ifdef PROG_LANGUAGE_ENGLISH
#define PROG_HELP_MESG  "\
Usage: hedit [path] [options] [GUI_options]\n\
\n\
    The [path] pecifies the path to the file to open at startup.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --address <position>    Sets the cursor position at startup,\n\
                                the position must be a positive integer\n\
                                value or -1 for end of the data.\n\
        -a                      Same as --address.\n\
\n\
        --view-font-name <s>    Sets the view font. This font must be a\n\
                                fixed-width font.\n\
\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints the version information and exits.\n\
\n\
    The [GUI_options] can be any options standard to your GUI,\n\
    consult your GUI's manual for available options.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_SPANISH
#define PROG_HELP_MESG	"\
El uso: hedit [path] [options] [GUI_options]\n\
\n\
    The [path] pecifies the path to the file to open at startup.\n\
\n\
    The [options] puede ser cualquiera de lo Siguiente:\n\
\n\
        --address <address>     La posicin fija de la direccin en inicio.\n\
        --help                  Pantalla de ayuda de Impresiones (esto) de ayuda y salidas.\n\
        --version               Versin Imprime informacin de versin y salidas.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#endif
#ifdef PROG_LANGUAGE_FRENCH
#define PROG_HELP_MESG  "\
Usage: hedit [path] [options] [GUI_options]\n\
\n\
    The [path] pecifies the path to the file to open at startup.\n\
\n\
    The [options] peut tre n'importe quel du suivre:\n\
\n\
        --address <address>     L'adresse initiale au dmarrage.\n\
        --help                  Affiche (ceci) cran d'aide et sort.\n\
        --version               Affiche information de version et sort.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options  votre\n\
    GUI, consulter le manuel de votre GUI pour les options disponibles.\n\
\n"
#endif


/*
 *	Widget Names:
 */
#define HEDIT_TOPLEVEL_WIDGET_NAME	"hedit"
#define HEDIT_HVIEW_WIDGET_NAME		"hedit-hex-view"


/*
 *      Drag and drop target type names and info values:
 */
#define HEDIT_DND_TYPE_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define HEDIT_DND_TYPE_INFO_TEXT_URI_LIST	1	/* "text/uri-list" */
#define HEDIT_DND_TYPE_INFO_STRING		2	/* "STRING" */


#endif	/* CONFIG_HEDIT_H */
