/***************************************************************************
                          pointsetstyles.h  -  description
                             -------------------
    begin                : Wed Nov 13 2002
    copyright            : (C) 2002 by 
    email                : mmdigitizer@earthlink.net
    $Log: pointsetstyles.h,v $
    Revision 1.3  2005/03/20 01:47:06  markmitch
    After KDevelop 3 restructuring

    Revision 1.11  2004/09/27 04:52:26  markmitch
    KDevelop does not allow renaming source directory to src

    Revision 1.9  2004/09/12 22:29:21  markmitch
    Settings archival complete. Qt2-compatibility code removed

    Revision 1.8  2004/09/11 05:59:18  markmitch
    First phase of settings archival

    Revision 1.7  2004/01/04 08:41:00  markmitch
    Dialog for point match settings

    Revision 1.6  2003/12/29 06:55:10  markmitch
    Cvs log cleanup. Color chooser


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POINTSETSTYLES_H
#define POINTSETSTYLES_H

#include <qstringlist.h>
#include <qpainter.h>
#include <qpen.h>
#include <qbrush.h>

#include "digitdef.h"

// this singleton class draws points and lines for both axes and curve pointsets
class PointSetStyles
{
  public: 

    static void create(void)
    {
      if (!pointSetStyles)
        pointSetStyles = new PointSetStyles;
    }
    static void destroy(void)
    {
      if (pointSetStyles)
      {
        delete pointSetStyles;
        pointSetStyles = 0;
      }
    }
    static PointSetStyles& instance(void)
    {
      return *pointSetStyles;
    }

    QString pointShapeName(PointShape shape);
    QString pointSizeName(PointSize size);
    QString pointLineSizeName(PointLineSize size);
    QString lineSizeName(LineSize size);
    QString colorName(Color color);
    QString lineConnectAsName(LineConnectAs method);

    PointShape pointShape(QString text);
    PointSize pointSize(QString text);
    PointLineSize pointLineSize(QString text);
    LineSize lineSize(QString text);
    Color color(QString text);
    LineConnectAs lineConnectAs(QString text);
        
    QStringList pointShapeNames(void);
    QStringList pointSizeNames(void);
    QStringList pointLineSizeNames(void);
    QStringList lineSizeNames(void);
    QStringList colorNames(void);
    QStringList lineConnectAsNames(void);

    // drawing methods for canvas polygon objects
    QPointArray areaPoints(int xScreen, int yScreen, PointSetStyle pointSetStyle) const;
    void drawShape(QPainter &p, int xScreen, int yScreen, PointSetStyle pointSetStyle);

    // set pen and brush. this works on both the point line and the line
    QPen pointSetPen(Color color, int size, Qt::PenStyle style = Qt::SolidLine);
    QBrush pointSetBrush(Color color);
    QColor pointSetColor(Color color);

  protected:
  
    PointSetStyles();
    ~PointSetStyles();

  private:

    // conversion of pointSize from displayed index (1-8) to halfwidth in pixels
    int pointSizeToHalfwidth(PointSize size) const { return 2 * ((int) size + 1); }

    // this singleton object
    static PointSetStyles* pointSetStyles;
    
};

#endif
