#ifndef __ENODE_EVENT_H__
#define __ENODE_EVENT_H__


/* These should not be bit flags..., there is no need for passing * more than 
 * one event on at a time. */
typedef enum {
    ENODE_ONATTRIBCHANGE = 1 << 1,
    ENODE_ONCHILDATTRIBCHANGE = 1 << 2,
    ENODE_ONDATACHANGE = 1 << 3,
    ENODE_ONCHILDDATACHANGE = 1 << 4,
    ENODE_ONDELETE = 1 << 5,
    ENODE_ONCHILDDELETE = 1 << 6,
    ENODE_ONCHILDNEW = 1 << 7
} ENodeEventFlags;

#define ENODE_CHILDCHANGEFLAGS (ENODE_ONCHILDATTRIBCHANGE | ENODE_ONCHILDDATACHANGE \
			       | ENODE_ONCHILDDELETE | ENODE_ONCHILDNEW)

typedef struct _ENodeEventWatcher ENodeEventWatcher;

struct _ENodeEventWatcher {
    ENodeEventFlags flags;
    ENode *node;
    gpointer dispatch;
    gpointer user_data;
    gint id;
};


/* void         enode_event_render (ENode *node); */
#define 	enode_event_render(node) 	element_render_notify(node);

void enode_event_parent (ENode * parent, ENode * child);

void enode_event_delete (ENode * node);

void enode_event_set_attrib (ENode * node, EBuf * attr, EBuf * value, gint notify_renderer);

/* void         enode_event_get_attrib (ENode *node, EBuf *attr); */
#define	        enode_event_get_attrib(node,attr)	      element_get_attrib_notify(node,attr)

void enode_event_set_data (ENode * node, EBuf * data);

/* 
 * EBufConst *     enode_event_get_data (ENode *node);
 * 
 * void         enode_event_insert_data (ENode *node, unsigned long offset,
 * EBuf *data);
 * 
 * void         enode_event_delete_data (ENode *node, unsigned long offset,
 * unsigned long count);
 * 
 * void         enode_event_append_data (ENode *node, EBuf *data); */
#define 	enode_event_get_data(node)		       element_get_data_notify(node);
#define	        enode_event_insert_data(node,offset,data)      element_insert_data_notify(node,offset,data)
#define	        enode_event_delete_data(node,offset,count)     element_delete_data_notify(node,offset,count)
#define	        enode_event_append_data(node,data)	       element_append_data_notify(node,data)

void enode_event_new_child (ENode * parent, ENode * child);

/* ondelete onchilddelete
 * 
 * onchildnew
 * 
 * onattribchange onchildattribchange
 * 
 * ondatachange onchilddatachange */
/* Hooking up events. */

typedef void (*EventAttribChange) (ENode * node, EBuf * attr, EBuf * value,
				   gpointer user_data);
gint enode_event_watch_attrib (ENode * node, EventAttribChange onchange,
			       gpointer user_data);
gint enode_event_watch_child_attrib (ENode * node, EventAttribChange onchange,
				     gpointer user_data);

typedef void (*EventDataChange) (ENode * node, EBuf * data, gpointer user_data);
gint enode_event_watch_data (ENode * node, EventDataChange onchange,
			     gpointer user_data);
gint enode_event_watch_child_data (ENode * node, EventDataChange onchange,
				   gpointer user_data);

typedef void (*EventDelete) (ENode * node, gpointer user_data);
gint enode_event_watch_delete (ENode * node, EventDelete onchange,
			       gpointer user_data);
gint enode_event_watch_child_delete (ENode * node, EventDelete onchange,
				     gpointer user_data);

typedef void (*EventNewChild) (ENode * node, gpointer user_data);
gint enode_event_watch_child_new (ENode * node, EventNewChild onchange,
				  gpointer user_data);

/* Release events */
void enode_event_release (ENode * node, gint watcher_id);

#endif				/* __ENODE_EVENT_H__ */


