#include <entity.h>
#include <gnome.h>
#include <applet-widget.h>
#include <gtk-common.h>
#include <rendgnome.h>

static void
rendcanvas_canvas_ondestroy_callback (GtkWidget *widget, gpointer * data)
{
  ENode *node = (ENode *)data;
  gchar *function = NULL;
  
  function = enode_attrib_str (node, "ondelete", NULL);  
  enode_call(node, function, "");
}

static void
rendcanvas_canvas_destroy (ENode *node) {
  GtkObject *canvas;
  
  canvas = (GtkObject*)enode_get_kv (node, "top-widget");
  gtk_object_destroy (canvas);
  enode_set_kv(node, "top-widget", NULL);
  enode_set_kv(node, "bottom-widget", NULL);
}

void
rendcanvas_item_destroy (ENode * node)
{
  GtkObject *item;
  
  item = (GtkObject*)enode_get_kv (node, "rendcanvas-item");
  gtk_object_destroy (item);
}



void
rendcanvas_event (GnomeCanvas *c, GdkEvent *event, gpointer data)
{
  /* the first parameter is not used. */
  rendcanvas_item_event (NULL, event, data);  
}

gboolean
rendcanvas_item_event (GnomeCanvasItem *c, GdkEvent *event, gpointer data)
{
  gchar *function;
  EBuf *path;
  ENode *node = (ENode*)data;

  path = enode_path (node);
  EDEBUG(("canvas-event", "event on %s", path->str));
  ebuf_free (path);

  switch(event->type) {
  case GDK_BUTTON_PRESS:
    function = enode_attrib_str (node, "on-button-press", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "idd", 
			      event->button.button,
			      event->button.x, 
			      event->button.y);
    return FALSE;

  case GDK_BUTTON_RELEASE:
    function = enode_attrib_str (node, "on-button-release", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "idd", 
			      event->button.button,
			      event->button.x, 
			      event->button.y);
    return FALSE;
    
  case GDK_MOTION_NOTIFY:
    function = enode_attrib_str (node, "on-cursor-motion", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "dd",
			      event->motion.x, 
			      event->motion.y);
    return FALSE;
  
  case GDK_KEY_PRESS:
    function = enode_attrib_str (node, "on-key-press", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "si", 
			      gdk_keyval_name (event->key.keyval),
			      event->key.keyval);
    return FALSE;

  case GDK_KEY_RELEASE:
    function = enode_attrib_str (node, "on-key-release", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "si", 
			      gdk_keyval_name (event->key.keyval),
			      event->key.keyval);
    return FALSE;
    
  case GDK_ENTER_NOTIFY:
    function = enode_attrib_str (node, "on-cursor-enter", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "dd",
			      event->crossing.x, 
			      event->crossing.y);
    return FALSE;
    
  case GDK_LEAVE_NOTIFY:
    function = enode_attrib_str (node, "on-cursor-leave", NULL);
    if (function == NULL)
      break;

    enode_call_ignore_return (node, function, "dd",
			      event->crossing.x, 
			      event->crossing.y);
    return FALSE;

  default:
    break;
  }

  return FALSE;
}


static void
rendcanvas_canvas_render (ENode * node)
{
  GnomeCanvas *canvas;
  EBuf *buf;
  double xmin=0, xmax=100, ymin=0, ymax=100;

  EDEBUG(("canvas", "creating canvas widget.."));

  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());

  if (enode_attrib_is_true(node, "aa")) {
    canvas = (GnomeCanvas*)gnome_canvas_new_aa();
  } else {
    canvas = (GnomeCanvas*)gnome_canvas_new();
  }

  gtk_widget_pop_visual();
  gtk_widget_pop_colormap();



  EDEBUG(("canvas", "setting canvas scale.."));
  buf = enode_attrib(node, "pixels-per-unit", NULL);
  if (!ebuf_empty(buf)) {
    double ppu = strtod (buf->str, NULL);
    EDEBUG(("canvas", "setting canvas pixels per unit to %f\n", ppu));
    gnome_canvas_set_pixels_per_unit (canvas, ppu);
  }



  EDEBUG(("canvas", "setting canvas area.."));
  buf = enode_attrib(node, "area-x-min", NULL);
  if (!ebuf_empty(buf)) {
    xmin = strtod(buf->str, NULL);
  }

  buf = enode_attrib(node, "area-x-max", NULL);
  if (!ebuf_empty(buf)) {
    xmax = strtod(buf->str, NULL);
  }

  buf = enode_attrib(node, "area-y-min", NULL);
  if (!ebuf_empty(buf)) {
    ymin = strtod(buf->str, NULL);
  }

  buf = enode_attrib(node, "area-y-max", NULL);
  if (!ebuf_empty(buf)) {
    ymax = strtod(buf->str, NULL);
  }


  EDEBUG(("canvas", "setting canvas scroll area to (%f,%f) to (%f,%f)\n", xmin, ymin, xmax, ymax));
  gnome_canvas_set_scroll_region (canvas, xmin, ymin, xmax, ymax);

  EDEBUG(("canvas", "connecting event handler."));
  gtk_signal_connect(GTK_OBJECT(canvas), "event",
		     GTK_SIGNAL_FUNC(rendcanvas_event),
		     node);
  


  EDEBUG(("canvas", "setting node keys .."));
  /* FIXME: i am unclear (ie i have no idea) on what these do .. */
  enode_set_kv (node, "top-widget", canvas);
  enode_set_kv (node, "bottom-widget", canvas);
  enode_set_kv (node, "rendcanvas-group", gnome_canvas_root (canvas));

  EDEBUG(("canvas", "connection canvas widget destroy signal  .."));
  gtk_signal_connect (GTK_OBJECT (canvas), "destroy", 
		      GTK_SIGNAL_FUNC (rendcanvas_canvas_ondestroy_callback),
		      (gpointer)node);

  EDEBUG(("canvas", "synching attribs  .."));
  enode_attribs_sync (node);

  EDEBUG(("canvas", "showing canavswidget  .."));
  gtk_widget_show((GtkWidget*)canvas);

}


void
rendcanvas_register_pos_attrs (Element *element)
{
  ElementAttr *e_attr;

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "x";
  e_attr->description = "X coordinate in parent group";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "y";
  e_attr->description = "X coordinate in parent group";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);
}

void
rendcanvas_init (RendererFlags flags)
{
  Element *element;
  ElementAttr *e_attr;

  rendcanvas_group_init (flags);
  rendcanvas_text_init (flags);
  rendcanvas_rect_init (flags);
  /*rendcanvas_line_init (flags);
  rendcanvas_polygon_init (flags);
  rendcanvas_ellipse_init (flags);
  rendcanvas_image_init (flags);*/

  if (!flags & RENDERER_REGISTER)
    return;

  EDEBUG(("canvas", "registering canvas tag."));

  element = g_new0 (Element, 1);
  element->tag = "canvas";
  element->render_func = rendcanvas_canvas_render;
  element->destroy_func = rendcanvas_canvas_destroy;
  element->parent_func = rendcanvas_group_parent;
  element_register (element);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "pixels-per-unit";
  e_attr->description = "Pixels of screen space per canvas unit";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "area-x-min";
  e_attr->description = "Pixels of screen space per canvas unit";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "area-x-max";
  e_attr->description = "Pixels of screen space per canvas unit";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "area-y-min";
  e_attr->description = "Pixels of screen space per canvas unit";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "area-y-max";
  e_attr->description = "Pixels of screen space per canvas unit";
  e_attr->value_desc = "float";
  element_register_attrib (element, e_attr);

}
