
<!-- This is the actual properties window -->
<window name="properties" width="279" height="304"
 title="Stembuilder: Node Properties" border="3" dialog="true">
  <notebook expand="true">
    <notepage title="Common">
      <valign name="common_properties" spacing="5" border="5">
        <halign>
          <label text="name:" xalign="100" width="80"/>
          <entry name="properties_name" onenter="properties_name_changed"/>
        </halign>
      </valign>
    </notepage>
    <notepage title="All">
      <valign name="all_properties" border="5" spacing="5">
        <halign>
          <label text="Supported:" width="80" xalign="100"/>
          <dropdown name="supported" onselect="properties_dropdown_selected" onopen="properties_supported_attribs_reload"/>
        </halign>
        <halign>
          <label text="Currently Set:" width="80" xalign="100"/>
          <dropdown name="set" onselect="properties_dropdown_selected" onopen="properties_set_attribs_reload"/>
        </halign>
        <halign>
          <label text="Description:" yalign="0" xalign="100" width="80"/>
          <hwrapalign name="property_description" expand="true">
          </hwrapalign>
        </halign>
      </valign>
    </notepage>
    <notepage title="Arbitrary">
      <valign spacing="5" border="5">
        <halign>
          <label text="Set Attribute:" width="80" xalign="100"/>
          <entry name="properties_arbitrary_attrib" onenter="properties_get_arbitrary"/>
        </halign>
        <halign>
          <label text="To Value:" width="80" xalign="100"/>
          <entry name="properties_arbitrary_value" onenter="properties_set_arbitrary"/>
        </halign>
	<halign expand="true" width="150">
	  <halign width="80" expand="false" fill="true"/>
	  <button label="Set" onclick="properties_set_arbitrary" width="160"/>
	</halign>
      </valign>
    </notepage>
  </notebook>
</window>

<norender name="integer">
  <temporary>
        <halign>
          <label name="element" text="Integer:" width="80" xalign="100"/>
          <spinner max="1000000" min="-1000" value="0" onchange="properties_value_changed"/>
        </halign>
  </temporary>
</norender>

<norender name="float">
  <temporary>
        <halign>
          <label name="element" text="Float:" width="80" xalign="100"/>
          <spinner max="1000000" min="-10000000" value="0" onchange="properties_value_changed"/>
        </halign>
  </temporary>
</norender>

<norender name="function">
  <temporary>
        <halign>
          <label name="element" text="Function:" width="80" xalign="100"/>
          <entry onenter="properties_string_changed"/>
        </halign>
  </temporary>
</norender>

<norender name="string">
  <temporary>
        <halign>
          <label name="element" text="String:" width="80" xalign="100"/>
          <entry onenter="properties_string_changed"/>
        </halign>
  </temporary>
</norender>

<norender name="boolean">
  <temporary>
        <halign>
          <label name="element" text="Boolean:" width="80" xalign="100"/>
          <radio-group >
            <radio name="true" onselect="properties_boolean_changed" label="True" selected="false"/>
            <radio name="false" onselect="properties_boolean_changed" label="False" selected="false"/>
            <radio name="unset" onselect="properties_boolean_changed" label="Unset" selected="true"/>
          </radio-group>
        </halign>
  </temporary>
</norender>

<norender name="choice">
  <temporary>
        <halign>
          <label name="element" text="Choice:" width="80" xalign="100"/>
          <dropdown editable="false" onselect="properties_dropdown_changed"/>
        </halign>
  </temporary>
</norender>


<norender name="percentage">
  <temporary>
        <halign>
          <label name="element" text="Percentage:" width="80" xalign="100"/>
          <spinner max="100" min="0" value="100" onchange="properties_value_changed"/>
        </halign>
  </temporary>
</norender>




<?javascript

function important_properties (element)
{
    node = enode ("window.elements");
    try {
	stembuilder_element = node.children_attrib ("element", element);
   
	element = stembuilder_element[0];
    } catch (e) {
	return (null);
    }

    important = element.attrib.important;
    attribs = important.split (",");

    hash = new Object;
    for (attrib in attribs) {
	hash[attrib] = 1;
    }

    // We cheat a little and add a bunch of real common ones, as well as
    // ones that are normally implemented by parents (usually containers)
    hash.expand = 1;
    hash.fill = 1;
    hash.width = 1;
    hash.height = 1;
    hash["x-fixed"] = 1;
    hash["y-fixed"] = 1;

    return (hash);
}

function xml_for_attribute (node, attribute)
{
    try {
        value_desc = node.attrib_value_type(attribute);
    } catch (e) {
	// unknowns revert to string type (freeform entry) 
	value_desc = "string";
    }

    basename = "norender." + value_desc;
    n = enode (basename);
    if (n == null) {
	print ("ACK! Unknown value type:", value_desc);
	n = enode ("norender.string");
	value_desc = "string";
    }

    label = n.child ("label.element");
    label.attrib.text = attribute + ":";

    temp = n.child ("temporary");
    temp.attrib.attribute = attribute;

    switch (value_desc) {
	case "float":
        case "percentage":
	case "integer":
	    i = n.child ("spinner");
	    i.attrib.value = node.attribval[attribute];
	    break;
	case "function":
	case "string":
	    i = n.child ("entry");
	    i.attrib.text = node.attrib[attribute];
	    break;
	case "boolean":
	    //print ("setting initial value for attribute", attribute, "to", node.attrib[attribute]);

	    /* first step is to reset all the selected nodes */
	    radios = n.children_attrib_rx ("selected", ".*");
	    for (radio in radios) {
		radio.attrib.selected = "";
	    }

	    if (node.attrib[attribute] == "") {
		i = n.child ("radio.unset");
	    } else {
		if (node.attrib_is_true (attribute)) {
		    i = n.child ("radio.true");
		} else {
		    i = n.child ("radio.false");
		}
    	    }
	    i.attrib.selected = "true";

	    break;

	case "choice":
	    
	    try {
		strings = n.children ("string");
		for (string in strings) {
		    string.destroy ();
		}
	    } catch (e) {}

	    i = n.child ("dropdown");
	    
	    try {
		c = node.attrib_possible_values (attribute);
		choices = c.split (",");
		for (choice in choices) {
		    s = i.new_child ("string");
		    s.attrib.text = choice;
		}
	    } catch (e) { 
		print ("Error getting choices for node", node.path + ".  You should fix this!"); 
		print ("possible_values is", node.attrib_possible_values (attribute)); 
	    }

	    // Set value of dropdown 
	    i.attrib.value = node.attrib[attribute];

	    break;

	default:
	    print ("Unknown type", value_desc);
    }
	  
    return (n.get_child_xml());
}

function properties_working_node ()
{
    window = enode ("window.properties");
    path = window.attrib.working_node;
    
    if (path == "")
	return (null);

    working_node = enode (path);
    return (working_node);
}
	
function properties (ctree, ctree_row)
{
    // Get the destination node that this entry is referring to
    dest_node = enode(ctree_row.attrib["dest-node"]);

    if (dest_node == "")
	return;

    // Clean out all the temporary nodes used for last item
    window = enode ("window.properties");
    try {
	nodes = window.children ("temporary");
	for (node in nodes) {
	    node.destroy ();
	}
    } catch (e) {}
    
    // Clear previous dropdown setting stuff
    clear_dropdowns ();
    
    // save the working node here..
    window.attrib.working_node = dest_node.path;

    valign = enode ("valign.common_properties");
    
    // Check the important properties, and make an entry for each
    prop_hash = important_properties (dest_node.type);
    attributes = dest_node.supported_attribs();
    
    try {
	for (attrib in attributes) {
	    if (prop_hash[attrib]) {
		xml = xml_for_attribute (dest_node, attrib);
		valign.append_xml (xml);
	    }
	}
    } catch (e) {}

    enode ("entry.properties_name").attrib.text = dest_node.attrib.name;
}

function properties_dropdown_selected (node)
{
    attrib = node.attrib.text;
    dest = properties_working_node ();
    valign = enode ("valign.all_properties");
    
    // Clean out all the old stuff.. 
    try {
	nodes = valign.children ("temporary");
	for (n in nodes) {
	    n.destroy ();
	}
    } catch (e) {}

    // Get description
    try {
    	description = dest.attrib_description(attrib);
    } catch (e) {
	description = "";
    }

    // we have to do funky things to make it look good.. 
    try {
	d = enode ("hwrapalign.property_description");
	t = d.new_child ("temporary");
	words = description.split(" ");
    	for (word in words) {
	    n = t.new_child ("label");
	    n.attrib.text = word + " ";
	}
    } catch (e) {}

    xml = xml_for_attribute (dest, attrib);
    valign.append_xml (xml);
}

function properties_get_arbitrary (node)
{
    attrib_node = enode ("entry.properties_arbitrary_attrib");
    value_node = enode ("entry.properties_arbitrary_value");
    dest = properties_working_node ();
   
    attribute = attrib_node.attrib.text;
    value = dest.attrib[attribute];

    value_node.attrib.text = value;
}

function properties_set_arbitrary (node)
{
    attrib_node = enode ("entry.properties_arbitrary_attrib");
    value_node = enode ("entry.properties_arbitrary_value");
    dest = properties_working_node ();
   
    attribute = attrib_node.attrib.text;
    value = value_node.attrib.text;

    if (attribute != "")
	dest.attrib[attribute] = value;
}

function clear_dropdowns ()
{
    enode ("dropdown.set").attrib.text = "";
    enode ("dropdown.supported").attrib.text = "";
}

function properties_set_attribs_reload (node)
{
    dest = properties_working_node ();
    attributes = dest.list_set_attribs();

    clear_dropdowns ();

    /* clean out old entries */
    node.destroy_children ();
    
    try {
	attributes.sort ();
	for (attrib in attributes) {
	    n = node.new_child ("string");
	    n.attrib.text = attrib;
	}
    } catch (e) {}
}

function properties_supported_attribs_reload (node)
{
    dest = properties_working_node ();
    if (!dest)
	return;

    attributes = dest.supported_attribs();

    clear_dropdowns ();
    
    /* clean out old entries */
    node.destroy_children ();
    
    try {
	attributes.sort ();
	for (attrib in attributes) {
	    n = node.new_child ("string");
	    n.attrib.text = attrib;
	}
    } catch (e) {}
}


/*******************************************************************
 * The rest deal with callbacks from the various things above      *
 *******************************************************************/

function properties_boolean_changed (node)
{
    // Find out what attribute this is for.
    temp = node.parent ("temporary");
    attribute = temp.attrib.attribute;
    
    dest = properties_working_node ();
    if (node.attrib.name == "unset") {
	dest.attrib[attribute] = "";
    } else {
	dest.attrib[attribute] = node.attrib.name;
    }
}

function properties_dropdown_changed (node)
{
    // Find out what attribute this is for.
    temp = node.parent ("temporary");
    attribute = temp.attrib.attribute;
  
    dest = properties_working_node ();
    dest.attrib[attribute] = node.attrib.text;
}

function properties_value_changed (node)
{
    // Find out what attribute this is for.
    temp = node.parent ("temporary");
    attribute = temp.attrib.attribute;
   
    dest = properties_working_node ();
    dest.attrib[attribute] = node.attrib.value;
}

function properties_string_changed (node)
{
    // Find out what attribute this is for.
    temp = node.parent ("temporary");
    attribute = temp.attrib.attribute;
    
    dest = properties_working_node ();
    dest.attrib[attribute] = node.attrib.text;
}

function properties_name_changed (node)
{
    dest = properties_working_node ();
    dest.attrib.name = node.attrib.text;
}

?>

