# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to configure the various view profiles.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Ui_ViewProfileDialog import Ui_ViewProfileDialog


class ViewProfileDialog(QDialog, Ui_ViewProfileDialog):
    """
    Class implementing a dialog to configure the various view profiles.
    """
    def __init__(self, profiles, separateShell, separateBrowser, parent = None):
        """
        Constructor
        
        @param profiles dictionary of tuples containing the visibility
            of the windows for the various profiles
        @param separateShell flag indicating that the Python shell 
            is a separate window
        @param separateBrowser flag indicating that the file browser
            is a separate window
        @param parent parent widget of this dialog (QWidget)
        """
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        self.profiles = profiles
        
        # set the editor profile
        profile = self.profiles["edit"][0]
        self.eppbCheckBox.setChecked(profile[0])
        if separateBrowser:
            self.epfbCheckBox.setChecked(profile[1])
        else:
            self.epfbCheckBox.setChecked(False)
            self.epfbCheckBox.setEnabled(False)
        self.epdbCheckBox.setChecked(profile[2])
        if separateShell:
            self.eppsCheckBox.setChecked(profile[3])
        else:
            self.eppsCheckBox.setChecked(False)
            self.eppsCheckBox.setEnabled(False)
        self.eplvCheckBox.setChecked(profile[4])
        self.eptvCheckBox.setChecked(profile[5])
        self.eptevCheckBox.setChecked(profile[6])
        
        # set the debug profile
        profile = self.profiles["debug"][0]
        self.dppbCheckBox.setChecked(profile[0])
        if separateBrowser:
            self.dpfbCheckBox.setChecked(profile[1])
        else:
            self.dpfbCheckBox.setChecked(False)
            self.dpfbCheckBox.setEnabled(False)
        self.dpdbCheckBox.setChecked(profile[2])
        if separateShell:
            self.dppsCheckBox.setChecked(profile[3])
        else:
            self.dppsCheckBox.setChecked(False)
            self.dppsCheckBox.setEnabled(False)
        self.dplvCheckBox.setChecked(profile[4])
        self.dptvCheckBox.setChecked(profile[5])
        self.dptevCheckBox.setChecked(profile[6])
    
    def getProfiles(self):
        """
        Public method to retrieve the configured profiles.
        
        @return dictionary of tuples containing the visibility
            of the windows for the various profiles
        """
        # get the edit profile
        self.profiles["edit"][0] = [\
            self.eppbCheckBox.isChecked(),
            self.epfbCheckBox.isChecked(),
            self.epdbCheckBox.isChecked(),
            self.eppsCheckBox.isChecked(),
            self.eplvCheckBox.isChecked(),
            self.eptvCheckBox.isChecked(),
            self.eptevCheckBox.isChecked(),
        ]
        
        # get the debug profile
        self.profiles["debug"][0] = [\
            self.dppbCheckBox.isChecked(),
            self.dpfbCheckBox.isChecked(),
            self.dpdbCheckBox.isChecked(),
            self.dppsCheckBox.isChecked(),
            self.dplvCheckBox.isChecked(),
            self.dptvCheckBox.isChecked(),
            self.dptevCheckBox.isChecked(),
        ]
        
        return self.profiles
