/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-msg-params.h,v 1.7 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_MSG_PARAMS_DECL_H

#define ETPAN_MSG_PARAMS_DECL_H

#include <libetpan/libetpan.h>
#include <inttypes.h>
#include "etpan-msg-params-types.h"

struct etpan_msg_params * etpan_msg_params_new(void);

void etpan_msg_params_free(struct etpan_msg_params * params);

int etpan_msg_params_add_list(struct etpan_msg_params * params,
    carray * msg_list);

void etpan_msg_params_remove(struct etpan_msg_params * params,
    mailmessage * msg);

void etpan_msg_params_clear(struct etpan_msg_params * params);

void etpan_msg_set_score(struct etpan_msg_params * params,
    mailmessage * msg, int32_t value);

void etpan_msg_add_score(struct etpan_msg_params * params,
    mailmessage * msg, int32_t value);

int32_t etpan_msg_get_score(struct etpan_msg_params * params,
    mailmessage * msg);

void etpan_msg_stop_score(struct etpan_msg_params * params,
    mailmessage * msg);

void etpan_msg_hide(struct etpan_msg_params * params,
    mailmessage * msg, int do_hide);

int etpan_msg_is_hidden(struct etpan_msg_params * params,
    mailmessage * msg);


struct etpan_node_msg_params * etpan_node_msg_params_new(void);

void etpan_node_msg_params_free(struct etpan_node_msg_params * params);

int etpan_node_msg_params_add_recursive(struct etpan_node_msg_params * params,
    struct etpan_msg_params * msg_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_params_clear(struct etpan_node_msg_params * params);


int etpan_node_msg_is_opened(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_set_opened(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree,
    int opened);

void etpan_node_msg_change_opened(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_set_visibility(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree, int visible);

int etpan_node_msg_is_visible(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_set_selected(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree,
    int sel);

void etpan_node_msg_change_selected(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

int etpan_node_msg_is_selected(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_set_score(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree, int32_t value);

int32_t etpan_node_msg_get_score(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

struct etpan_node_msg_param *
etpan_node_msg_get_param(struct etpan_node_msg_params * tree_params,
    struct mailmessage_tree * msg_tree);

struct etpan_msg_param *
etpan_msg_get_param(struct etpan_msg_params * msg_params,
    mailmessage * msg);

struct etpan_node_msg_param *
etpan_node_msg_param_new(struct etpan_msg_params * msg_params,
    struct mailmessage_tree * msg_tree);

void etpan_node_msg_param_free(struct etpan_node_msg_param * param);

struct etpan_msg_param * etpan_msg_param_new(void);

void etpan_msg_param_free(struct etpan_msg_param * param);

int etpan_msg_param_ref_message(struct etpan_msg_params * params,
    mailmessage * msg);

int etpan_msg_param_message_get_ref_count(struct etpan_msg_params * params,
    mailmessage * msg);

int etpan_msg_param_ref_mime(struct etpan_msg_params * params,
    mailmessage * msg);

int etpan_msg_param_unref_message(struct etpan_msg_params * params,
    mailmessage * msg);

int etpan_msg_param_unref_mime(struct etpan_msg_params * params,
    mailmessage * msg);

#endif
