/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-subapp.h,v 1.9 2005/02/01 02:32:01 hoa Exp $
 */

#ifndef ETPAN_SUBAPP_H

#define ETPAN_SUBAPP_H

#include "etpan-subapp-types.h"

/*
  these 3 headers MUST be included before <sys/select.h>
  to insure compatibility with Mac OS X (this is true for 10.2)
*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/select.h>

void etpan_subapp_idle(struct etpan_subapp * app);
void etpan_subapp_set_fd(struct etpan_subapp * app, fd_set * fds,
    int * pmaxfd);
void etpan_subapp_handle_fd(struct etpan_subapp * app, fd_set * fds);
void etpan_subapp_handle_key(struct etpan_subapp * app, int key);
void etpan_subapp_handle_resize(struct etpan_subapp * app);
void etpan_subapp_set_relative_coord(struct etpan_subapp * app);

void etpan_subapp_display(struct etpan_subapp * app);
void etpan_subapp_set_color(struct etpan_subapp * app);
struct etpan_subapp * etpan_subapp_new(struct etpan_app * app,
    struct etpan_subapp_driver * driver);
void etpan_subapp_free(struct etpan_subapp * subapp);

void etpan_subapp_leave(struct etpan_subapp * app,
    struct etpan_subapp * new_app);
void etpan_subapp_enter(struct etpan_subapp * app,
    struct etpan_subapp * old_app);

void etpan_subapp_set_parent(struct etpan_subapp * app,
    struct etpan_subapp * parent_app);

struct etpan_subapp * etpan_subapp_get_parent(struct etpan_subapp * app);

int etpan_subapp_display_init(struct etpan_subapp * app);

void etpan_subapp_display_done(struct etpan_subapp * app);

int etpan_subapp_set_title(struct etpan_subapp * app, char * title);

void etpan_subapp_update_display_size(struct etpan_subapp * app);

int etpan_subapp_get_idle_delay(struct etpan_subapp * app);

int etpan_subapp_get_idle_udelay(struct etpan_subapp * app,
    struct timeval * delay);

#endif
