/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: shrink.h
 *
 */

/*
 * Global functions exported by shrink.c
 */

/* External APIs provided by shrink.c */

extern int evms_can_shrink(object_handle_t thing);

extern int evms_get_shrink_points(object_handle_t           thing,
                                  shrink_handle_array_t * * shrink_points);

extern int evms_shrink(object_handle_t  thing,
                       handle_array_t * objects,
                       option_array_t * options);

/* Internal functions to share with other Engine source modules */

extern int get_object_shrink_points(storage_object_t * obj,
                                    u_int64_t          max_delta_size,
                                    list_anchor_t      shrink_points);

extern int get_volume_shrink_points(logical_volume_t * volume,
                                    list_anchor_t      shrink_points);

extern int get_container_shrink_points(storage_container_t * con,
				       list_anchor_t         shrink_points);

extern int engine_can_shrink_by(storage_object_t * object,
                                sector_count_t   * delta_size);

