/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: Error Plugin
 * File: evms2/engine/plugins/error/options.h
 */

#define ERROR_OPTION_NAME_IDX	0
#define ERROR_OPTION_NAME_STR	"name"
#define ERROR_OPTION_SIZE_IDX	1
#define ERROR_OPTION_SIZE_STR	"size"
#define ERROR_OPTION_TYPE_IDX	2
#define ERROR_OPTION_TYPE_STR	"type"
#define ERROR_OPTION_COUNT	3

extern void generate_error_name(char *input_name, char *error_name);
extern int init_create_task(task_context_t *context);
extern int set_create_option(task_context_t *context, u_int32_t index,
			     value_t *value, task_effect_t *effect);
extern void parse_options(option_array_t *options, char **input_name,
			  u_int64_t *size, object_type_t *type);
extern int verify_options(char *error_name, object_type_t type);

