/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libgpt.so
 *
 *   File: dm.c
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <uuid/uuid.h>

#include <plugin.h>

#include "gpt.h"
#include "helpers.h"
#include "dm.h"


/*
 * Function: GPT_can_activate
 */
int GPT_can_activate( DISKSEG *seg )
{
	LOG_ENTRY();

	LOG_EXIT_INT(0);
	return 0;
}

/*
 *  Function: GPT_activate
 *
 *  Called in order to create a mapping of a disk partition
 *  in the kernel.
 */
int GPT_activate( DISKSEG *seg )
{
        LOGICALDISK *ld = get_logical_disk(seg);
        dm_target_t target;
        dm_device_t linear;
        int rc=EINVAL;

        LOG_ENTRY();

        if (ld) {
                target.start = 0;
                target.length = seg->size;
                target.type = DM_TARGET_LINEAR;
                target.data.linear = &linear;
                target.params = NULL;
                target.next = NULL;
                linear.major = ld->dev_major;
                linear.minor = ld->dev_minor;
                linear.start = seg->start;

                rc = EngFncs->dm_activate(seg, &target);
                if (!rc) {
                        seg->flags &= ~SOFLAG_NEEDS_ACTIVATE;
                }
        }

        LOG_EXIT_INT(rc);
        return rc;
}


/*
 * Function: GPT_can_activate
 */
int GPT_can_deactivate( DISKSEG *seg )
{
	LOG_ENTRY();

	LOG_EXIT_INT(0);
	return 0;
}

/*
 *  Function: GPT_deactivate
 *
 *  Called in order to delete an existing mapping of a disk
 *  partition in the kernel.
 */
int GPT_deactivate( DISKSEG *seg )
{
        int rc;

        LOG_ENTRY();

        rc = EngFncs->dm_deactivate(seg);

	if (!rc) {
		seg->flags &= ~SOFLAG_NEEDS_DEACTIVATE;
	}

        LOG_EXIT_INT(rc);
        return rc;
}

