<?php
/*
   Provides syncing (or simply transfering) pages with remote Wiki
   installation, via special RPCs or open Wiki XML-RPC interface - in
   future.
*/

#-- load libs
#$_SERVER["SERVER_NAME"] .= " {.-prevents-readonly-test-account}";
include("t_config.php");
if (!function_exists("xmlrpc")) include("plugins/lib/xmlrpc.php");
if (!function_exists("phprpc")) include("plugins/lib/phprpc.php");


#-- serve XML-RPC and PHP-RPC requests
define("WIKISYNC_VER", 0.1);
header("X-WikiSync: " . WIKISYNC_VER);
if ($_SERVER["REQUEST_METHOD"] != "GET") {
   $xmlrpc_methods = array(
      "ewiki_db" => "ewiki_db",
      "ewiki.sync" => "wikisync",
   );
   phprpc_server();
   xmlrpc_server();
}

#-- start
$action = $_REQUEST["action"];
$proto = $_REQUEST["proto"];
$url = $_REQUEST["url"];
if ($url) {
  setcookie("last_sync_url", $url, time() + 90 * 24 * 60 * 60, dirname($_SERVER["REQUEST_URI"])); //, strtok($_SERVER["SERVER_NAME"], " "));
}

?>
<html>
<head>
 <title>syncing with remote wiki database</title>
 <link rel="stylesheet" type="text/css" href="t_config.css">
</head>
<body bgcolor="#ffffff" text="#000000">
<h1>WikiSync&trade;</h1>

<?php

  if (!action || !$proto || !$url) {

?>
This tool allows you to maintain some pages of a public Wiki in a separate
installation but keep both synchronized. You of course must have the sync
interface installed on both systems (or at least have the XML-RPC service
enabled on the other site).

<br>
<br>

There is currently no conflict resolution code built-in, so you have to
correct these yourself, whenever you edited a page that also was edited
(by someone else) on the remote WikiWikiWeb server. So this is very safe
as it never overwrites stuff, and quick as it typically only copies the
latest version of every page.

<br>
<br>

<form action="t_sync.php" method="GET">
  <label for="proto">protocol</label>
  <select id="proto" name="proto">
    <option value="sync">WikiSync&trade; <?php echo WIKISYNC_VER; ?></option>
    <option value="db">ewiki_db::RPC</option>
    <option value="wiki">WikiXmlRpc v2</option>
  </select>
  <br>
  <label for="url">interface</label>
  <input type="text" name="url" id="url" size="48" value="<?php
     if ($url = $_COOKIE["last_sync_url"]) {
        echo $url;
     }
     else {
        echo "http://user:password@" . strtok($_SERVER["SERVER_NAME"], " ") . $_SERVER["REQUEST_URI"];
     }
  ?>">
  <br>
  <small>
     Must be either the URL to a remote <tt>z.php</tt> script or better
     to a remote <tt>t_sync.php</tt>.
  </small>
  <br>
  <br>
  <select id="action" name="action" title="action">
    <option value="sync">sync</option>
    <option value="up">upload</option>
    <option value="down">download</option>
    <option value="exact">exact</option>
  </select>
  <!-- ... -->
  <input type="submit" value="transfer">
</form>
<?php



 }

 #-- minimal checks beforehand ------------------------------------------
 elseif ($proto != "sync") {

    echo "Sorry, currently only the WikiSync&trade; protocol is supported.";

 }

 #-- get list of (remotely) existing page versions
 elseif (! ($rlist = remote_list())) {

    echo "No connection to '$proto+$url' could be established.";

 }

 
 #-- perform sync -------------------------------------------------------
 else {

    #-- init
    set_time_limit(+2999);
    $locall = WikiSync("LIST", 0);
    $sync = ($action=="sync");
    $correct = 1;

    #-- info
    echo "<i>info</i>: " . count($locall) . " pages found in local Wiki database<br>\n";
    echo "&nbsp; &nbsp; &nbsp; and " . count($rlist) . " are on remote server<br>\n";
    echo "\n\n";
    flush();


    #-- upload
    if ($action != "download") {
       echo "<br>\n<h3>upload</h3>\n";
       one_direction(
	"upload",
	$locall,	$rlist,
	"local_get",	"remote_get",
	       		"remote_write"
       );
    }

    #-- download
    if ($action != "upload") {
       echo "<br>\n<h3>download</h3>\n";
       one_direction(
	"download",
	$rlist,		$locall,
	"remote_get",	"local_get",
	       		"local_write"
       );
    }
    
    #-- do an in-deepth analyzation of remaining files
    if ($action == "exact") {
       echo "<br>\n<h3>sync - exact comparison</h3>\n";
       foreach ($locall as $id=>$ver) {
          if ($rlist[$id] == $ver) {

             echo htmlentities($id);
             flush();

             $L = local_get($id);
             $R = remote_get($id);
             
             if (!half_identical($L, $R)) {
                echo " - conflict";
             }
             else {
                echo " - ok";
             }
             echo "<br>\n";
          }
       }
    }



    
 
 }


?>
<br>
<br>
</body>
</html>
<?php
#------------------------------------------------------ helper functions ---


#-- copy pages in one direction
function one_direction($title, &$FROM_list, &$DEST_list, $FROM_get, $DEST_get, $DEST_write) {
    foreach ($FROM_list as $id=>$FROM_ver) {
       set_time_limit(+2999);
              
       $DEST_ver = $DEST_list[$id];
       if ($DEST_ver < $FROM_ver) {

          echo "{$title}ing " . htmlentities($id) . "[{$FROM_ver}]... ";
          $L = $FROM_get($id);

          #-- did never exist,
          #   or this version is identical on both systems
          if (!$DEST_ver || no_conflict($id, $FROM_get, $DEST_get)) {
             echo ($DEST_write($L) ? "ok" : "error");
          }
          #-- conflict
          else {
             echo "<b>cannot</b> synchronize with [{$DEST_ver}] - conflict!";
          }

          echo "<br>\n";
          flush();
          
          #-- no further processing with these entries
          unset($FROM_list[$id]);
          unset($DEST_list[$id]);
       }
       else {
#          echo "nothing to do for '$id' because $FROM_ver==$DEST_ver<br>\n";
       }
    }
}


#-- compare remote against local version for conflicts
function no_conflict($id, $OLD_get, $NEWER_get) {

   // fetch
   $OLD = $OLD_get($id);  // last
   $NEW = $NEWER_get($id, $R["version"]);

   // 700% identical!
   if (md5(serialize($OLD)) == serialize(md5($NEW))) {
      return true;
   }
   return half_identical($OLD, $NEW);
}


#-- less exact comparison 
#   - it only skips the {hits} entry when matching fields,
#   because that's where differences are (huh, big secret!)
function half_identical($A, $B) {
   
   return
     true
     && (strtolower($A["id"]) == strtolower($B["id"]))
     && ($A["flags"] == $B["flags"])
     && ($A["version"] == $B["version"])
     && ($A["lastmodified"] == $B["lastmodified"])
     && (serialize($A["meta"]) == serialize($B["meta"]))

       #-- you may wish to remove the following (two/???) :
     && ($A["lastmodified"] == $B["lastmodified"])
     && ($A["author"] == $B["author"])
   ;  
}





#-- wrapper to get page from far server
function remote_get($id, $version=false) {
   global $proto, $url;
   if ($proto == "sync") {
      return phprpc($url, "WikiSync", array("::GET", array($id, $version)));
   }
}

#-- wrapper to save page remotely
function remote_write($hash) {
   global $proto, $url;
   if ($proto == "sync") {
      return phprpc($url, "WikiSync", array("::WRITE", $hash));
   }
}

#-- wrapper fetching list of remotely existing pages+versions
function remote_list() {
   global $proto, $url;
   if ($proto == "sync") {
      return phprpc($url, "WikiSync", array("::LIST", false));
   }
   elseif ($proto == "db") {
      // $r = phprpc($url, "ewiki_db::GETALL", array(array("id","version","flags")));
      // what do we get from here?
      // - an object?
      //   (it eventually only has a page name list inside)
   }
   elseif ($proto == "wiki") {
      // uh, even more complicated
   }
}




#-- aliases
function local_list() {
   return WikiSync("LIST");
}
function local_get($id,$ver=false) {
   return WikiSync("GET", array($id,$ver));
}
function local_write($hash) {
   return WikiSync("WRITE", $hash);
}


#-- the public/main API
function WikiSync($func, $args=NULL) {
   switch (strtoupper(trim($func, ":"))) {
      case "GET":
         return ewiki_db::GET($args[0], $args[1]);
      case "WRITE":
         return ewiki_db::WRITE($args);
      case "LIST":
         $all = ewiki_db::GETALL(array("id", "version"));
         $r = array();
         while ($row = $all->get()) {
            $r[$row["id"]] = $row["version"];
         }
         return $r;
      default:
   }
}



?>