#include <stdio.h>
#include <stdlib.h>

int ext2_sparse_groups(uint32_t *three, uint32_t *five, uint32_t *seven)
{
	uint32_t *min = three;
	uint32_t mult = 3;
	uint32_t ret;

	if (*five < *min) {
		min = five;
		mult = 5;
	}
	if (*seven < *min) {
		min = seven;
		mult = 7;
	}

	ret = *min;
	*min *= mult;

	return ret;
}

int main(int argc, char *argv[])
{
	uint32_t three = 1, five = 5, seven = 7;
	uint32_t max, ret;

	if (argc < 2) {
		fprintf(stderr, "usage: %s max_groups\n", argv[0]);
		return 1;
	}

	max = strtoul(argv[1], NULL, 0);

	printf("0\n");
	while ((ret = ext2_sparse_groups(&three, &five, &seven)) < max)
		printf("%u\n", ret);

	return 0;
}
