/***************************************************************************
                          FLFieldMetaData.cpp  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLFieldMetaData.h"
#include "FLRelationMetaData.h"

FLFieldMetaData::FLFieldMetaData (const QString & n, const QString & a,
								  const bool aN, const bool iPK, const int t,
								  const int l, const bool c, const bool v, const bool ed, const int pI, const int pD,
								  const bool iNX, const bool uNI, const bool coun, const QVariant defValue):
name_ (n.lower ()),
alias_ (a),
allowNull_ ((!c) ? aN : true),
isPrimaryKey_ (iPK),
type_ (t),
length_ (l),
calculated_ (c),
visible_ (v),
editable_ (ed),
partInteger_ (pI),
partDecimal_ (pD),
isIndex_ (iNX),
isUnique_ (uNI),
contador_ (coun),
relationList_ (0),
relationM1_ (0),
associatedField_ (0),
defaultValue_(defValue)
{
  if (l < 0)
	length_ = 0;
  if (pI < 0)
	partInteger_ = 0;
  if (pD < 0)
	partDecimal_ = 0;

  if (t != QVariant::String && l != 0)
	length_ = 0;

  if (t != QVariant::Int && t != QVariant::UInt && t != QVariant::Double && pI != 0)
	partInteger_ = 0;

  if (t != QVariant::Double && pD != 0)
	partDecimal_ = 0;
}

FLFieldMetaData::~FLFieldMetaData ()
{
  if (relationList_)
	{
	  relationList_->clear ();
	  delete relationList_;
	}

  if (relationM1_)
	delete relationM1_;
}

void
FLFieldMetaData::addRelationMD (FLRelationMetaData * r)
{
  if (r->cardinality () == FLRelationMetaData::RELATION_M1 && relationM1_)
	{
	  qWarning ("FLFieldMetaData: Se ha intentado crear ms de una relacin muchos a uno para el mismo campo");
	  return;
	}

  r->setField (name_);
  if (r->cardinality () == FLRelationMetaData::RELATION_M1)
	{
	  relationM1_ = r;
	  return;
	}

  if (!relationList_)
	{
	  relationList_ = new FLRelationMetaDataList;
	  relationList_->setAutoDelete (true);
	}

  relationList_->append (r);
}

void
FLFieldMetaData::setRelationList (FLRelationMetaDataList * rl)
{
  if (!rl)
	return;

  if (rl->isEmpty ())
	return;

  if (relationList_)
	{
	  relationList_->clear ();
	  delete relationList_;
	}

  if (relationM1_)
	{
	  delete relationM1_;

	  relationM1_ = 0;
	}

  FLRelationMetaData *relation;

  for (unsigned int i = 0; i < rl->count (); i++)
	{
	  relation = rl->at (i);
	  if (relation->cardinality () == FLRelationMetaData::RELATION_M1 && relationM1_)
		{
		  qWarning ("FLFieldMetaData: Se ha intentado crear ms de una relacin muchos a uno para el mismo campo");
		  continue;
		}

	  relation->setField (name_);
	  if (relation->cardinality () == FLRelationMetaData::RELATION_M1)
		{
		  relationM1_ = relation;
		  continue;
		}

	  if (!relationList_)
		{
		  relationList_ = new FLRelationMetaDataList;
		  relationList_->setAutoDelete (true);
		}

	  relationList_->append (relation);
	}
}
