/* $Header: /home/yav/catty/fkiss/RCS/fkiss.c,v 1.68 2000/10/17 05:00:28 yav Exp $
 * fkiss "French-KISS!" (Not Fast-KISS, sorry...)
 *  - KISekae Set system for X Window System
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

char id_fkiss[] = "$Id: fkiss.c,v 1.68 2000/10/17 05:00:28 yav Exp $";

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <stdio.h>

#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"
#include "timer.h"
#define PUBLIC_FKISS_C
#include "extern.h"


#include "icon.xbm"

static int topbw = 1;		/* top window border width */
static int viewx = 0;
static int viewy;
static int viewbw = 0;		/* view window border width */
static Window imgwin = None;
static GC imggc;
static Pixmap world_pixmap;
static char *str_display = "";
static char *str_color[SPX_MAX];
static Bool pointer_move = False;
static int catched_dx, catched_dy, catched_cell;
static int catched_cell2;
static int catched_objx, catched_objy;
static int mobjn, mobjx, mobjy;
static int menu_mode = 0;	/* bit0: off:top on:bottom  */
static int catch_x, catch_y;
static int mapping_changed_cell = -1;
static int scroll_limit = 1;
static int pesi_count;
static int fixed = -1;
static int unfixed = 100;
static int alpha_level = 0;
static int info_mode = 0;	/* != 0 : information window on */
static char *tmpdir = "/tmp";	/* temporary directory to extract files */
static GC *paint_gc = NULL;	/* [colcnt] */
static GC true_color_gc;
static char **extract_files = NULL;
static char **conf_files = NULL;
static char *startup_sound_file = NULL;
static int image_mode = -1;
static int true_color_cell;
typedef struct {
  char *suffix;
  char *command;
} ARTBL;
static ARTBL artype[] = {
  {".lzh",	"lha xfqw=%D %A"},
  {".tar.gz",	"tar xzCf %D %A"},
  {".tgz",	"tar xzCf %D %A"},
  {".hes",	"hesper '-k%K' %A|lha xfiqw=%D -"},
  {NULL, NULL}
};

/*
 * Document file browse command
 * Uncomment only one line in following #define DOC_COMMAND lines.
 */

/* Debian especific, will find user's preferred editor */
#define DOC_COMMAND  "/usr/bin/sensible-editor"

/* #define DOC_COMMAND	"xemacs" */
/* #define DOC_COMMAND	"xemacs --eval '(view-file \"%P\")'" */
/* #define DOC_COMMAND	"emacs" */
/* #define DOC_COMMAND	"kedit" */
/* #define DOC_COMMAND	"xterm -e less" */
/* #define DOC_COMMAND	"kterm -e less" */
/* #define DOC_COMMAND	"(cd %A; kterm -km sjis -e jless %F) &" */

static char doc_suffix_free[] = "(free)";
static char *doc_suffix[] = {
  ".doc", ".DOC", ".txt", ".TXT",
  doc_suffix_free, doc_suffix_free, doc_suffix_free, doc_suffix_free,
  doc_suffix_free, doc_suffix_free, doc_suffix_free, doc_suffix_free,
  doc_suffix_free, doc_suffix_free, doc_suffix_free, doc_suffix_free,
  NULL				/* End mark */
};

/* Get the user's prefered editor   */
// char *doc_command = DOC_COMMAND; 
char *doc_command; 

#define BUTTON_FUNC_NONE	0
#define BUTTON_FUNC_CELL	1
#define BUTTON_FUNC_ICONIFY	2
#define BUTTON_FUNC_COMMENT	3
#define BUTTON_FUNC_MAX	4

static int button_func_tbl[BUTTON_FUNC_MAX] = {
  BUTTON_FUNC_NONE,		/* 0 AnyButton */
  BUTTON_FUNC_CELL,		/* 1 Button1 */
  BUTTON_FUNC_ICONIFY,		/* 2 Button2 */
  BUTTON_FUNC_COMMENT		/* 3 Button3 */
};

void print_version()
{
  printf("%s %s\n", str_fullname, str_version);
}

void opt_version()
{
  print_version();
  kiss_exit(0);
}

void print_compile_options()
{
  int i, n;

  n = 0;
  while (coptions[n] != NULL) {
    for (i = 0; i < 4; i++) {
      if (coptions[n] == NULL)
	break;
      fprintf(stderr, "%s%s", i?"\t":"", coptions[n]);
      n++;
    }
    fputc('\n', stderr);
  }
}

void usage()
{
  printf("usage : %s [option ...] [file.lzh ...] [file.cnf]\n",
	  *oargv);
  printf("option :\n");
  printf("  -display dpy\n");
  printf("  -geometry WxH+X+Y\n");
  printf("  -verbose\n");
  printf("  -font name\n");
  printf("  -fg color\n");
  printf("  -bg color\n");
  printf("  -cursor [0-3]\n");
  printf("Report bugs to yav@bigfoot.com\n");
  kiss_exit(0);
}

void exec_test()
{
  char *p;
  char **av;
  int i;
  
  av = (char **)ks_malloc(sizeof(char *)*(oargc+2));
  *av = "time";
  for (i = 0; i < oargc; i++) {
    p = *(oargv+i);
    if (strcmp(p, "-t") == 0)
      p = "-test";
    *(av+1+i) = p;
  }
  *(av+1+i) = NULL;
  execvp(*av, av);
  /* time command exec error! */
  msg("E ``%s'' exec error!\n", *av);
}

int is_free_doc_suffix(p)
     char *p;
{
  return (p == doc_suffix_free);
}

/* new, 1998-12-27, dirk */
void set_maxtimer(str)
     char *str;
{
/* maybe someone wants to disable all timers ? */
#define MIN_MAXTIMER	0
#define MAX_MAXTIMER	(MAXSHORT/2)

  int result, maxtimer;

  result = sscanf(str, " %d ", &maxtimer);
  if (result == EOF || result == 0) {
    fprintf(stderr,"\"%s\" is not a valid maxtimer value, ignored !\n", str);
    return;
  }
  debug_printf("\tstr=\"%s\", result=%d, maxtimer=%d\n",
	       str, result, maxtimer); 

  if (maxtimer < MIN_MAXTIMER || maxtimer > MAX_MAXTIMER) {
    fprintf(stderr,
	    "invalid maxtimer value %d ignored, must be between %d and %d !\n",
	    maxtimer, MIN_MAXTIMER, MAX_MAXTIMER);
    return;
  }
  
  MAXTIMER   = maxtimer; /* ignore higher timer channels */
  WARN_TIMER = maxtimer; /* warn if higher timer channel, never happens */

}

/* new, 1998-12-27, dirk */
void set_maxevent(str)
     char *str;
{
/* maybe someone wants to disable all events ? */
#define MIN_MAXEVENT	0
#define MAX_MAXEVENT	(MAXSHORT/2)

  int result, maxevent;

  result = sscanf(str, " %d ", &maxevent);
  if (result == EOF || result == 0) {
    fprintf(stderr,"\"%s\" is not a valid maxevent value, ignored !\n", str);
    return;
  }
  debug_printf("\tstr=\"%s\", result=%d, maxevent=%d\n",
	       str, result, maxevent); 

  if (maxevent < MIN_MAXEVENT || maxevent > MAX_MAXEVENT) {
    fprintf(stderr,
	    "invalid maxevent value %d ignored, must be between %d and %d !\n",
	    maxevent, MIN_MAXEVENT, MAX_MAXEVENT);
    return;
  }
  
  MAXEVENT   = maxevent; /* ignore higher event numbers */
  WARN_EVENT = maxevent; /* warn if higher event number, never happens */

}

/* new, 1998-12-27, dirk */
void set_maxsoundfile(str)
     char *str;
{
/* maybe someone wants to disable all soundfiles ? */
#define MIN_MAXSOUNDFILE	0
#define MAX_MAXSOUNDFILE	(MAXSHORT/2)

  int result, maxsoundfile;

  result = sscanf(str, " %d ", &maxsoundfile);
  if (result == EOF || result == 0) {
    fprintf(stderr,"\"%s\" is not a valid maxsoundfile value, ignored !\n", str);
    return;
  }
  debug_printf("\tstr=\"%s\", result=%d, maxsoundfile=%d\n",
	       str, result, maxsoundfile); 

  if (maxsoundfile < MIN_MAXSOUNDFILE || maxsoundfile > MAX_MAXSOUNDFILE) {
    fprintf(stderr,
	    "invalid maxsoundfile value %d ignored, must be between %d and %d !\n",
	    maxsoundfile, MIN_MAXSOUNDFILE, MAX_MAXSOUNDFILE);
    return;
  }
  
  MAXSOUNDFILE   = maxsoundfile; /* ignore higher soundfile numbers */
  WARN_SOUNDFILE = maxsoundfile; /* warn if higher soundfile number, never happens */

}

/* 1999-03-14, dirk --
** silly dirk made a mistake the first time. It was easier than I thought.
*/
void set_maxaction(str)
     char *str;
{
/* maybe someone wants to disable all actions for some strange testing ? */
#define MIN_MAXACTION	0
#define MAX_MAXACTION	(MAXSHORT/2)
  int result, maxaction = 0;

  result = sscanf(str, " %d ", &maxaction);
  if (result == EOF || result == 0) {
    fprintf(stderr,"\"%s\" is not a valid maxaction value, ignored !\n",str);
    return;
  }
  debug_printf("\tstr=\"%s\", result=%d, maxaction=%d\n",
	       str, result, maxaction); 

  if (maxaction < MIN_MAXACTION || maxaction > MAX_MAXACTION) {
    fprintf(stderr,
	    "invalid maxaction value %d ignored, must be between %d and %d !\n",
	    maxaction, MIN_MAXACTION, MAX_MAXACTION);
    return;
  }
  MAXACTION   = maxaction; /* ignore higher action numbers */
  WARN_ACTION = maxaction; /* warn if higher action number */
}

void opt_add_doc_suffix(str)
     char *str;
{
  char **p;
  
  for (p = doc_suffix; *p; p++) {
    if (is_free_doc_suffix(*p)) {
      *p = str;
      return;
    }
  }
}

void opt_del_doc_suffix(str)
     char *str;
{
  char **p;
  
  for (p = doc_suffix; *p; p++) {
    if (!is_free_doc_suffix(*p) && !strcmp(*p, str)) {
      *p = doc_suffix_free;
      return;
    }
  }
}

char *search_dir_list(name, list0)
     char *name;
     char **list0;
{
  char *p;
  char **list;
  
  if (list0 != NULL) {
    for (list = list0; *list != NULL; list++) {
      if (strcmp(*list, name) == 0)
	return *list;
    }
    for (list = list0; *list != NULL; list++) {
      p = dos_pathname(*list);
      if (strcmp(p, name) == 0) {
	free(p);
	return *list;
      }
      free(p);
    }
    for (list = list0; *list != NULL; list++) {
      p = dos_filename(*list);
      if (strcmp(p, name) == 0) {
	free(p);
	return *list;
      }
      free(p);
    }
  }
  return NULL;
}

char *ks_filename0(name)
     char *name;
{
  char *r;
  char *p;
  char *dir;
  char *buf;
  
  r = NULL;
  buf = get_filename(name);
  dir = ks_strdup(name);
  p = rindex(dir, '/');
  if (p == NULL) {
    free(dir);
    dir = NULL;
  } else {
    *(p+1) = '\0';
    dir = ks_realloc(dir, strlen(dir) + strlen(buf) + 1);
    strcat(dir, buf);
    if ((p = search_dir_list(dir, conf_files)) != NULL) {
      r = ks_malloc(strlen(conf_dir) + 1 + strlen(p) + 1);
      sprintf(r, "%s/%s", conf_dir, p);
      free(dir);
      return r;
    } else if ((p = search_dir_list(dir, extract_files)) != NULL) {
      r = ks_malloc(strlen(extract_dir) + 1 + strlen(p) + 1);
      sprintf(r, "%s/%s", extract_dir, p);
      free(dir);
      return r;
    }    
  }
  if ((p = search_dir_list(buf, conf_files)) != NULL) {
    r = ks_malloc(strlen(conf_dir) + 1 + strlen(p) + 1);
    sprintf(r, "%s/%s", conf_dir, p);
  } else if ((p = search_dir_list(buf, extract_files)) != NULL) {
    r = ks_malloc(strlen(extract_dir) + 1 + strlen(p) + 1);
    sprintf(r, "%s/%s", extract_dir, p);
  }
  return r;
}

char *ks_filename(name)
     char *name;
{
  char *r;
  char *buf;
  
  r = ks_filename0(name);
  if (r == NULL) {
    buf = dos_pathname(name);
    r = ks_filename0(buf);
    free(buf);
  }
  return r;
}

FILE *ks_fopen(name, mode)
     char *name;
     char *mode;
{
  FILE *fp;
  char *buf;
  
  buf = ks_filename(name);
  debug_printf("ks_fopen [%s] -> [%s]\n", name, buf);
  fp = fopen(buf, mode);
  free(buf);
  return fp;
}

void read_directory()
{
  if (extract_dir != NULL && strcmp(extract_dir, conf_dir)) {
    debug_printf("read_directory extract_dir ``%s''\n", extract_dir);
    extract_files = dir_ls(extract_dir, NULL);
  }
  debug_printf("read_directory conf_dir ``%s''\n", conf_dir);
  conf_files = dir_ls(conf_dir, NULL);
}

void free_directory()
{
  dir_free(extract_files);
  dir_free(conf_files);
}

void get_effective_area(buf, w, h, newx, newy, neww, newh, byteperpixel)
     unsigned char *buf;
     int w;
     int h;
     int *newx;
     int *newy;
     int *neww;
     int *newh;
     int byteperpixel;
{
  int x, y;
  int xtop, xend, ytop, yend;
  Bool f;
  unsigned char *p;
  
  xtop = w;
  ytop = h;
  xend = yend = 0;
  for (y = 0; y < h; y++) {
    f = False;
    p = buf;
    for (x = 0; x < w; x++) {
      if (*p) {
	f = True;
	if (x < xtop)
	  xtop = x;
	break;
      }
      p += byteperpixel;
    }
    p = buf + w * byteperpixel;
    for (x = w-1; x >= 0; --x) {
      p -= byteperpixel;
      if (*p) {
	f = True;
	if (x > xend)
	  xend = x;
	break;
      }
    }
    buf += w * byteperpixel;
    if (f) {
      if (y < ytop)
	ytop = y;
      if (y > yend)
	yend = y;
    }
  }
  *newx = xtop;
  *newy = ytop;
  *neww = xend - xtop + 1;
  if (*neww < 0)
    *neww = 0;
  *newh = yend - ytop + 1;
  if (*newh < 0)
    *newh = 0;
}

unsigned char *store_image(iline, buf, w, h, newx, newy, neww, newh)
     long **iline;
     unsigned char *buf;
     int w;
     int h;
     int newx;
     int newy;
     int neww;
     int newh;
{
  int x, y, len;
  unsigned char lastpix;
  unsigned char *p;
  unsigned char *np;
  unsigned char *nbuf;
  long *lp;
  
  lp = (long *)ks_malloc(sizeof(*lp) * newh);
  *iline = lp;
  np = nbuf = (unsigned char *)ks_malloc(neww * 2 * newh);
  for (y = newy; y < newy+newh; y++) {
    *lp++ = np - nbuf;
    p = buf + w*y + newx;
    lastpix = *p;
    len = 0;
    for (x = 0; x < neww; p++, x++) {
      if (*p == lastpix && ++len < 255)
	continue;
      *np++ = lastpix;
      *np++ = len;
      len = *p != lastpix;
      lastpix = *p;
    }
    if (len) {
      *np++ = lastpix;
      *np++ = len;
    }
  }
  return (unsigned char *)ks_realloc(nbuf, np - nbuf);
}

unsigned long get_colorpixel(p)
     unsigned char *p;
{
  int b, r, g, a;
  
  b = *p++;
  g = *p++;
  r = *p++;
  a = *p++;
  return (a<<24)|(r<<16)|(g<<8)|b;
}

void set_colorpixel(p, pixel)
     unsigned char **p;
     unsigned long pixel;
{
  int b, r, g, a;
  
  b = pixel & 0xff;
  pixel >>= 8;
  g = pixel & 0xff;
  pixel >>= 8;
  r = pixel & 0xff;
  pixel >>= 8;
  a = pixel;
  
  *((*p)++) = b;
  *((*p)++) = g;
  *((*p)++) = r;
  *((*p)++) = a;
}

unsigned char *store_image32(iline, buf, w, h, newx, newy, neww, newh)
     long **iline;
     unsigned char *buf;
     int w;
     int h;
     int newx;
     int newy;
     int neww;
     int newh;
{
  int x, y, len;
  unsigned long lastpix;
  unsigned char *p;
  unsigned char *np;
  unsigned char *nbuf;
  long *lp;
  
  lp = (long *)ks_malloc(sizeof(*lp) * newh);
  *iline = lp;
  np = nbuf = (unsigned char *)ks_malloc(neww * newh * (sizeof(unsigned long) + 1));
  for (y = newy; y < newy+newh; y++) {
    *lp++ = np - nbuf;
    p = buf + (w*y + newx) * 32/8;
    lastpix = get_colorpixel(p);
    len = 0;
    for (x = 0; x < neww; p += 32/8, x++) {
      if (get_colorpixel(p) == lastpix && ++len < 255)
	continue;
      set_colorpixel(&np, lastpix);
      *np++ = len;
      len = get_colorpixel(p) != lastpix;
      lastpix = get_colorpixel(p);
    }
    if (len) {
      set_colorpixel(&np, lastpix);
      *np++ = len;
    }
  }
  return (unsigned char *)ks_realloc(nbuf, np - nbuf);
}

int read_cell_file(fp, p)
     FILE *fp;
     CELL *p;
{
  int i, y;
  int ox, oy, w, h;
  int newx, newy, neww, newh;
  int bpp;			/* bit per pixel (cel file) */
  int byteperpixel;		/* byte per pixel (internal) */
  unsigned char *ip, *ip2;
  unsigned char *ip0;
  unsigned char buf[1024];
  
  p->width = p->height = 0;
  i = 4;			/* max(4, strlen(kiss_magic_number)) */
  if (!fread(buf, i, 1, fp))
    return 1;
  buf[i] = '\0';
  if (strcmp(buf, kiss_magic_number) == 0) {
    if (!fread(buf+i, CEL_HEADER_SIZE-i, 1, fp)) {
      msg("W ``%s'' cannot read header.\n", p->filename);
      return 1;
    }
    if (buf[CEL_MARK] != 0x20 && buf[CEL_MARK] != 0x21) {
      msg("W ``%s'' header mark 0x%02x is not cel mark (0x20 or 0x21).\n",
	  p->filename, buf[CEL_MARK]);
    }
    bpp = buf[CEL_BPP];
    byteperpixel = (bpp + 7) / 8;
    if (!byteperpixel)
      byteperpixel = 1;
    w = GET_SHORT(buf+CEL_WIDTH);
    h = GET_SHORT(buf+CEL_HEIGHT);
    ox = GET_SHORT(buf+CEL_XOFS);
    oy = GET_SHORT(buf+CEL_YOFS);
  } else {
    bpp = 4;
    byteperpixel = 1;
    w = GET_SHORT(buf+CEL_OLD_WIDTH);
    h = GET_SHORT(buf+CEL_OLD_HEIGHT);
    ox = oy = 0;
  }
  debug_printf("%-16s %d %2d %3dx%3d%+4d%+4d ",
	       p->filename, bpp, p->colfile, w, h, ox, oy);
  p->orgw = w;
  p->orgh = h;
  p->orgx = ox;
  p->orgy = oy;

  /* check cell over screen size */
  if ((ox+w) > imgw0 || (oy+h) > imgh0) {
    msg("W ``%s'' %3dx%3d%+4d%+4d over screen %3dx%3d.\n",
	p->filename, w, h, ox, oy, imgw0, imgh0);
    if ((ox+w) > imgw0)
      imgw0 = ox + w;
    if ((oy+h) > imgh0)
      imgh0 = oy + h;
    msg("W change screen size %3dx%3d.\n", imgw0, imgh0);
  }
  if ((object+p->obj)->width < ox + w)
    (object+p->obj)->width = ox + w;
  if ((object+p->obj)->height < oy + h)
    (object+p->obj)->height = oy + h;
  (object+p->obj)->ncel++;
  i = w * h * byteperpixel;
  ip = ip0 = (unsigned char *)ks_malloc(i);
  if (bpp <= 4) {
    for (y = 0; y < h && fread(ip, (w+1)/2, 1, fp); y++) {
      /* expand pixel 4 bit -> 8 bit */
      i = w / 2;
      ip2 = ip + w;
      if (w & 1)
	*--ip2 = *(ip+i) >> 4;
      while (--i >= 0) {
	*--ip2 = *(ip+i) & 15;
	*--ip2 = *(ip+i) >> 4;
      }
      ip += w;
    }
  } else {
    for (y = 0; y < h && fread(ip, w * byteperpixel, 1, fp); y++)
      ip += w * byteperpixel;
  }
  if (y < h) {
    msg("W ``%s'' read %d lines less than %d.\n", p->filename, y, h);
    if (w)
      bzero((char *)ip, w*(h-y)); /* clear read error line image */
  }
  get_effective_area(bpp > 8 ? ip0 + 3 : ip0, w, h, &newx, &newy, &neww, &newh,
		     byteperpixel);
  if (neww == 0 || newh == 0) {
    ip = NULL;
  } else {
    if (bpp > 8) {
      ip = store_image32(&p->iline, ip0, w, h, newx, newy, neww, newh);
    } else {
      ip = store_image(&p->iline, ip0, w, h, newx, newy, neww, newh);
    }
  }
  if (neww != w || newh != h) {
    w = neww;
    h = newh;
    ox += newx;
    oy += newy;
    debug_printf("-> %3dx%3d%+4d%+4d", w, h, ox, oy);
  }
  free(ip0);
  p->image = ip;
  if (w && p) {
    p->width = w;
    p->height = h;
  }
  p->ofsx = ox;
  p->ofsy = oy;
  p->bpp = bpp;
  debug_printf("\n");
  return 0;
}

int read_cells()
{
  int i;
  CELL *cp;
  FILE *fp;
  char *p;
  
  true_color_cell = 0;
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    p = NULL;
    if ((fp = ks_fopen(cp->filename, "rb")) != NULL) {
      if (read_cell_file(fp, cp))
	p = "W ``%s'' read error! ignore.\n";
      if (cp->bpp > 8) {
	image_mode = 0;
	true_color_cell = 1;
      }
      fclose(fp);
    } else {
      p = "W ``%s'' not found! ignore.\n";
    }
    if (p != NULL)
      msg(p, cp->filename);
  }
  objcnt2 = 0;
  for (i = 0; i < objcnt; i++)
    if ((object+i)->ncel)
      objcnt2++;
  return 0;
}

int create_cell_pixmap()
{
  int i;
  CELL *cp;
  
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (cp->width) {
      cp->pixmap = XCreatePixmap(dsp, imgwin, cp->width, cp->height,
				 screen_depth);
      cp->gc = XCreateGC(dsp, imgwin, 0, 0);
      /* cp->clip = XCreatePixmap(dsp, imgwin, cp->width, cp->height, 1); */
      cp->pixpal = -1;
    }
  }
  return 0;
}

static GC bitmapgc0;		/* for bitmap bit reset */
static GC bitmapgc1;		/* for bitmap bit set */
#define DITHERW 8		/* dither pattern width */
#define DITHERH 8		/* dither pattern height */
#define DITHERLEVEL (DITHERW*DITHERH + 1) /* dether level */
static GC dithergc[DITHERLEVEL];
static char dither_table[DITHERH][DITHERW] = {
  { 0, 48, 12, 60,  3, 51, 15, 63},
  {32, 16, 44, 28, 35, 19, 47, 31},
  { 8, 56,  4, 52, 11, 59,  7, 55},
  {40, 24, 36, 20, 43, 27, 39, 23},
  { 2, 50, 14, 62,  1, 49, 13, 61},
  {34, 18, 46, 30, 33, 17, 45, 29},
  {10, 58,  6, 54,  9, 57,  5, 53},
  {42, 26, 38, 22, 41, 25, 37, 21}
};

/* make dither pattern CG
 * Caution! call after bitmapgc* initialized.
 */
int make_transparency_dither()
{
  int x, y, n;
  Pixmap px;
  
  for (n = 0; n < DITHERLEVEL; n++) {
    px = XCreatePixmap(dsp, imgwin, DITHERW, DITHERH, 1);
    XFillRectangle(dsp, px, bitmapgc0, 0, 0, DITHERW, DITHERH);
    for (y = 0; y < DITHERH; y++) {
      for (x = 0; x < DITHERW; x++) {
	if (n > dither_table[y][x])
	  XDrawPoint(dsp, px, bitmapgc1, x, y);
      }
    }
    dithergc[n] = XCreateGC(dsp, px, 0, 0);
    XSetForeground(dsp, dithergc[n], 0);
    XSetStipple(dsp, dithergc[n], px);
    XSetFillStyle(dsp, dithergc[n], FillStippled);
  }
  return DITHERLEVEL;
}

/* set cell transparency level */
void set_transparency(cp, n)
     CELL *cp;
     int n;			/* transparency [0, 256] */
{
  if (!transparency_mode)
    return;

  if (cp->transclip == None)
    cp->transclip = XCreatePixmap(dsp, imgwin, cp->width, cp->height, 1);
  XCopyArea(dsp, cp->clip, cp->transclip, bitmapgc1,
	    0, 0, cp->width, cp->height, 0, 0);
  cp->transparency = n;
  n = (n * (DITHERLEVEL-1)) / 256; /* [0, 256] -> [0, DITHERLEVEL-1] */
  XSetClipMask(dsp, dithergc[n], cp->clip);
  XSetTSOrigin(dsp, dithergc[n],
	       ((kset[cset].obj+cp->obj)->x + cp->ofsx) % DITHERW,
	       ((kset[cset].obj+cp->obj)->y + cp->ofsy) % DITHERH);
  XFillRectangle(dsp, cp->transclip, dithergc[n], 0, 0, cp->width, cp->height);
  XSetClipMask(dsp, cp->gc, cp->transclip);
}

void set_initial_transparency()
{
  int i;
  CELL *cp;
  
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (cp->width) {
      cp->transclip = None;
      if (cp->transparency) {
	set_transparency(cp, cp->transparency);
	debug_printf("set initial transparency ``%s'' %d\n",
		     cp->filename, cp->transparency);
      }
    }
  }
}


/* make cell clip pixmap */
Pixmap make_cell_clip(cp)
     CELL *cp;
{
  int x, y;
  unsigned long b;
  int a;
  int len;
  unsigned char *ip;
  Pixmap px;
  
  px = XCreatePixmap(dsp, imgwin, cp->width, cp->height, 1);
  XFillRectangle(dsp, px, bitmapgc0, 0, 0, cp->width, cp->height);
  ip = cp->image;
  if (cp->bpp <= 8) {
    for (y = 0; y < cp->height; y++) {
      for (x = 0; x < cp->width; x += len) {
	b = *ip++;
	len = *ip++;
	if (b)
	  XFillRectangle(dsp, px, bitmapgc1, x, y, len, 1);
      }
    }
  } else {
    for (x = 0; x < DITHERLEVEL; x++)
      XSetForeground(dsp, dithergc[x], 1);
    for (y = 0; y < cp->height; y++) {
      for (x = 0; x < cp->width; x += len) {
	b = get_colorpixel(ip);
	ip += 32/8;
	len = *ip++;
	a = b >> 24;
	if (a) {
	  if (a == 0xff) {
	    XFillRectangle(dsp, px, bitmapgc1, x, y, len, 1);
	  } else {
	    a += alpha_level;
	    if (a < 0) {
	      a = 0;
	    } else if (a > 0xff) {
	      a = 0xff;
	    }
	    a = (a * DITHERLEVEL) / 256;
	    XFillRectangle(dsp, px, dithergc[a], x, y, len, 1);
	  }
	}
      }
    }
    for (x = 0; x < DITHERLEVEL; x++)
      XSetForeground(dsp, dithergc[x], 0);
  }
  
  return px;
}

void make_clip_gc()
{
  Pixmap px;
  
  px = XCreatePixmap(dsp, imgwin, 1, 1, 1);
  bitmapgc0 = XCreateGC(dsp, px, 0, 0);
  XSetForeground(dsp, bitmapgc0, 0);
  bitmapgc1 = XCreateGC(dsp, px, 0, 0);
  XSetForeground(dsp, bitmapgc1, 1);
  XFreePixmap(dsp, px);
}

void make_clip()
{
  int i;
  CELL *cp;
  
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (!cp->width)
      continue;
    cp->clip = make_cell_clip(cp);
    XSetClipMask(dsp, cp->gc, cp->clip);
  }
}

static int pixel_direct = 0;	/* Calc pixel code from RGB color */
static int pixel_shift;
static int red_d, red_n, red_m;
static int green_d, green_n, green_m;
static int blue_d, blue_n, blue_m;

void set_gcpixel(b)
     unsigned long b;
{
  XColor c;
  unsigned mask;

  c.red = ((b>>16) & 0xff) * 0x100;
  c.green = ((b>>8) & 0xff) * 0x100;
  c.blue = (b & 0xff) * 0x100;
  mask = 0xff;
  while (!XAllocColor(dsp, cmap, &c)) {
    mask = (mask << 1) | 1;
    c.red &= ~mask;
    c.green &= ~mask;
    c.blue &= ~mask;
  }
  XSetForeground(dsp, true_color_gc, c.pixel);
}

void make_cell_pixmap()
{
  int i, x, y, len;
  unsigned long b;
  unsigned char *ip;
  CELL *cp;
  int topcol;
  unsigned char *skip_pixel;
  
  skip_pixel = ks_malloc(colcnt);
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (!cp->width || !cp->setflag[cset] || cp->pixpal == cpal)
      continue;
    if (private_color_mode && cp->pixpal >= 0) {
      cp->pixpal = cpal;
      continue;
    }
    if (cp->bpp <= 8) {
      /* decide draw skip pixel */
      bzero(skip_pixel, colcnt);
      topcol = *(colindex+cp->colfile);
      skip_pixel[topcol] = 1;	/* transparent pixel */
      if (cp->pixpal >= 0) {
	for (x = 0; x < colcnt; x++) {
	  if (private_color_mode ||
	      (xcol[cp->pixpal]+x)->pixel == (xcol[cpal]+x)->pixel)
	    skip_pixel[x] = 1;
	}
      }
      ip = cp->image;
      for (y = 0; y < cp->height; y++) {
	for (x = 0; x < cp->width; x += len) {
	  b = *ip++;
	  len = *ip++;
	  if (!skip_pixel[topcol+b])
	    XFillRectangle(dsp, cp->pixmap, *(paint_gc+topcol+b), x, y, len, 1);
	}
      }
    } else {
      ip = cp->image;
      if (pixel_direct) {
	if (pixel_shift) {
	  for (y = 0; y < cp->height; y++) {
	    for (x = 0; x < cp->width; x += len) {
	      b = get_colorpixel(ip);
	      ip += 32/8;
	      len = *ip++;
	      b =
		((red_d ? ((b & 0x00ff0000U) << red_n) :
		  ((b & 0x00ff0000U) >> red_n)) & red_m)
		|
		((green_d ? ((b & 0x0000ff00U) << green_n) :
		  ((b & 0x0000ff00U) >> green_n)) & green_m)
		|
		((blue_d ? ((b & 0x000000ffU) << blue_n) :
		  ((b & 0x000000ffU) >> blue_n)) & blue_m)
		;
	      XSetForeground(dsp, true_color_gc, b);
	      XFillRectangle(dsp, cp->pixmap, true_color_gc, x, y, len, 1);
	    }
	  }
	} else {		/* pixel_shift */
	  for (y = 0; y < cp->height; y++) {
	    for (x = 0; x < cp->width; x += len) {
	      b = get_colorpixel(ip);
	      ip += 32/8;
	      len = *ip++;
	      b &= 0x00ffffffU;
	      XSetForeground(dsp, true_color_gc, b);
	      XFillRectangle(dsp, cp->pixmap, true_color_gc, x, y, len, 1);
	    }
	  }
	}
      } else {			/* pixel_direct */
	fprintf(stderr, "* %s\n", cp->filename);
	for (y = 0; y < cp->height; y++) {
	  for (x = 0; x < cp->width; x += len) {
	    b = get_colorpixel(ip);
	    ip += 32/8;
	    len = *ip++;
	    set_gcpixel(b);
	    XFillRectangle(dsp, cp->pixmap, true_color_gc, x, y, len, 1);
	  }
	}
      }
    }
    cp->pixpal = cpal;
  }
  free(skip_pixel);
}

void make_cell_pixmap_image()
{
  int i, j, x, y, len;
  unsigned char b, *ip;
  CELL *cp;
  XImage *image;
  char *xip;
  XColor *xp;
  
  image = XCreateImage(dsp, vis,
		       screen_depth, ZPixmap, 0, NULL, imgw, imgh,
		       screen_depth > 8 ? 32 : 8, 0);
  if (image == NULL)
    msg("E make_cell_pixmap_image create image error!\n");
  image->data = ks_malloc(image->bytes_per_line * imgh);
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (!cp->width || !cp->setflag[cset] || cp->pixpal == cpal)
      continue;
    if (private_color_mode && cp->pixpal >= 0) {
      cp->pixpal = cpal;
      continue;
    }
    XSetClipOrigin(dsp, cp->gc, 0, 0);
    xp = xcol[cpal]+*(colindex+cp->colfile);
    ip = cp->image;
    xip = image->data;
    if (image->bitmap_unit == 8) {
      for (y = 0; y < cp->height; y++) {
	for (x = 0; x < cp->width; x += len) {
	  b = *ip++;
	  len = *ip++;
	  if (b)
	    memset(xip+x, (xp+b)->pixel, len);
	}
	xip += image->bytes_per_line;
      }
    } else {
      for (y = 0; y < cp->height; y++) {
	for (x = 0; x < cp->width; x += len) {
	  b = *ip++;
	  len = *ip++;
	  if (b)
	    for (j = 0; j < len; j++)
	      XPutPixel(image, x+j, y, (xp+b)->pixel);
	}
	xip += image->bytes_per_line;
      }
    }
    XPutImage(dsp, cp->pixmap, cp->gc, image,
	      0, 0, 0, 0, cp->width, cp->height);
    cp->pixpal = cpal;
  }
  free(image->data);
  XFree(image);
}

int make_world_pixmap()
{
  static Bool world_pixmap_created = False;
  
  if (world_pixmap_created)
    XFreePixmap(dsp, world_pixmap);
  world_pixmap = XCreatePixmap(dsp, imgwin, imgw, imgh, screen_depth);
  world_pixmap_created = True;
  return 0;
}

void expose_image(x, y, w, h)
     int x;
     int y;
     int w;
     int h;
{
  XCopyArea(dsp, world_pixmap, imgwin, imggc, x, y, w, h, x, y);
}

void redraw_cells(x0, y0, w0, h0)
     int x0;
     int y0;
     int w0;
     int h0;
{
  int i;
  int x, y, w, h;
  int ox, oy;			/* cell left-top position */
  int xe, ye;
  CELL *p;
  OBJPOS *objp;
  
  /* area limit */
  if (x0 < 0) {
    w0 += x0;
    x0 = 0;
  }
  if (y0 < 0) {
    h0 += y0;
    y0 = 0;
  }
  if (x0 + w0 >= imgw)
    w0 = imgw - x0;
  if (y0 + h0 >= imgh)
    h0 = imgh - y0;
  XFillRectangle(dsp, world_pixmap, imggc, x0, y0, w0, h0);
  xe = x0 + w0;
  ye = y0 + h0;
  objp = kset[cset].obj;
  for (p = cell+celcnt-1, i = celcnt; i; --p, --i) {
    if (p->width && p->setflag[cset] && !p->unmap &&
	(ox = (objp+p->obj)->x + p->ofsx) < xe &&
	ox + p->width >= x0 &&
	(oy = (objp+p->obj)->y + p->ofsy) < ye &&
	oy + p->height >= y0) {
      ox = (objp+p->obj)->x + p->ofsx;
      oy = (objp+p->obj)->y + p->ofsy;
      x = ox > x0 ? ox : x0;
      y = oy > y0 ? oy : y0;
      w = (ox + p->width < xe) ? ox + p->width - x : xe - x;
      h = (oy + p->height < ye) ? oy + p->height - y : ye - y;
      XSetClipOrigin(dsp, p->gc, ox, oy);
      XCopyArea(dsp, p->pixmap, world_pixmap, p->gc,
		x-ox, y-oy, w, h, x, y);
    }
  }
  /* transfer image to window */
  expose_image(x0, y0, w0, h0);
}

void redraw_all_cells()
{
  redraw_cells(0, 0, imgw, imgh);
}

void set_topwin_attributes()
{
  Pixmap px;

  if (border_color >= colcnt) {
    msg("W bad border %d.\n", border_color);
    border_color = (colcnt > 0 ? 0 : -1);
  }
  if (border_color < 0) {
    px =
      XCreatePixmapFromBitmapData(dsp, viewwin,
				  (char *)hatch_ptrn, 8, 8,
				  BlackPixel(dsp, scr),
				  WhitePixel(dsp, scr),
				  screen_depth);
    XSetWindowBackgroundPixmap(dsp, viewwin, px);
    XFreePixmap(dsp, px);
  } else {
    XSetWindowBackground(dsp, viewwin,
			 (xcol[kset[cset].pal]+border_color)->pixel);
  }
  XSetWindowBackgroundPixmap(dsp, imgwin, None);
  XClearWindow(dsp, viewwin);
  
  if (colcnt > 0) {
    XSetForeground(dsp, imggc, (xcol[kset[cset].pal])->pixel);
  } else {
#if 0
    XSetForeground(dsp, imggc, BlackPixel(dsp, scr));
#else
    XSetForeground(dsp, imggc, spx[SPX_BG]);
#endif
  }
}

void change_palette(n)
     int n;
{
  int i;
  XColor *xp;
  
  cpal = n;
  if (private_color_mode) {
    set_private_colorcells(n);
    n = 0;
  }
  if (!image_mode) {
    for (xp = xcol[n], i = 0; i < colcnt; xp++, i++) {
      XSetForeground(dsp, *(paint_gc+i), xp->pixel);
    }
  }
  set_topwin_attributes();
  menu_setpal_change();
}

void init_system_color_name()
{
  int i;
  
  for (i = 0; i < SPX_MAX; i++)
    str_color[i] = NULL;
}

void set_system_color_name()
{
  int i;
  char **p;
  static struct {
    char *colorname[SPX_MAX];
  } spx_color_default[3] = {
    {{"#fae0c7", "Black", "#febfbd", "#db975b", "#c0f3a2"}},
    {{"White",   "Black", "#e1e1e1", "#9a9a9a", "#eaeaea"}},
    {{"White",	 "Black", "Black",   "White",	"White"}}
  };
  
  p = spx_color_default[gray_mode].colorname;
  for (i = 0; i < SPX_MAX; i++) {
    if (str_color[i] == NULL)
      str_color[i] = *p;
    p++;
  }
}

void setup_system_gc()
{
  int i;
  static struct {
    int bg;
    int fg;
  } pa[SGC_MAX] = {
    {SPX_BG, SPX_FG},		/* SGC_GEN */
    {SPX_MN, SPX_FG},		/* SGC_MN */
    {SPX_BT, SPX_FG},		/* SGC_BT0 */
    {SPX_FG, SPX_BT},		/* SGC_BT1 */
    {SPX_BG, SPX_BG2},		/* SGC_IN0 */
    {SPX_BG2, SPX_BG},		/* SGC_IN1 */
    {SPX_BG, SPX_FG},		/* SGC_T8 */
    {SPX_BG, SPX_FG}		/* SGC_T16 */
  };
  
  for (i = 0; i < SGC_MAX; i++) {
    XSetBackground(dsp, sysgc[i], spx[pa[i].bg]);
    XSetForeground(dsp, sysgc[i], spx[pa[i].fg]);
  }
}

void parse_system_colors(p)
     XColor *p;
{
  int i;
  
  for (i = 0; i < SPX_MAX; i++) {
    if (!XParseColor(dsp, cmap, str_color[i], p))
      msg("E color ``%s'' unknown!\n", str_color[i]);
    p++;
  }
}

void alloc_system_colors()
{
  int i;
  XColor col[SPX_MAX];
  
  parse_system_colors(col);
  for (i = 0; i < SPX_MAX; i++) {
    if (!XAllocColor(dsp, cmap, &col[i])) {
      msg("W color ``%s'' allocation miss.\n", str_color[i]);
      col[i].pixel =
	col[i].green & 0x8000 ? WhitePixel(dsp, scr) : BlackPixel(dsp, scr);
    }
    spx[i] = col[i].pixel;
  }
}

void pix_shift(dir, n, c, m)
     int *dir;			/* 1:left */
     int *n;			/* shift bits */
     unsigned long c;		/* cell RGB bit mask */
     unsigned long m;		/* display pixel RGB bit mask vis->*_mask */
{
  int i;
  unsigned long b;
  
  *dir = (c < m);
  if (*dir) {
    for (b = c; (b >>= 1); c |= b)
      ;
    for (i = 0; m > c; i++)
      m >>= 1;
  } else {
    for (b = m; (b >>= 1); m |= b)
      ;
    for (i = 0; c > m; i++)
      c >>= 1;
  }
  *n = i;
}

void set_rgb_pixel()
{
  red_m = vis->red_mask;
  green_m = vis->green_mask;
  blue_m = vis->blue_mask;
  pix_shift(&red_d,   &red_n,   0x00ff0000U, red_m);
  pix_shift(&green_d, &green_n, 0x0000ff00U, green_m);
  pix_shift(&blue_d,  &blue_n,  0x000000ffU, blue_m);
  pixel_shift = red_d | red_n | green_d | green_n | blue_d | blue_n;
  debug_printf("*pixel_shift %d\n", pixel_shift);
  debug_printf("* R %s %2d %08x\n", (red_d?"<<":">>"), red_n, red_m);
  debug_printf("* G %s %2d %08x\n", (green_d?"<<":">>"), green_n, green_m);
  debug_printf("* B %s %2d %08x\n", (blue_d?"<<":">>"), blue_n, blue_m);
}

#if 0
void change_visual()
{
  Status result;
  XVisualInfo v;
  
  if (XMatchVisualInfo(dsp, scr, screen_depth, TrueColor, &v)) {
    fprintf(stderr, "* change TruleColor visual\n");
    vis = v.visual;
  }
}
#endif

void init_screen()
{
  int i;
  char *p;
  
  dsp = XOpenDisplay(str_display);
  if (dsp == NULL)
    msg("E Cannot open display ``%s''!\n", str_display);
  
  p = get_server_info();
  if (debug_mode || test_mode)
    fprintf(stderr, "%s\n", p);
  scr = DefaultScreen(dsp);
  rootwin = DefaultRootWindow(dsp);
  screen_depth = DefaultDepth(dsp, scr);
  vis = DefaultVisual(dsp, scr);
#if 0
  change_visual();
#endif
  if (screen_depth == 1) {
    gray_mode = 2;
  } else {
    switch(vis->class) {
    case GrayScale:
    case StaticGray:
      gray_mode = 1;
      break;
    case TrueColor:
    case DirectColor:
      pixel_direct = 1;
      set_rgb_pixel();
      break;
    }
  }
  cmap = DefaultColormap(dsp, scr);
  p = get_visual_info();
  if (debug_mode || test_mode)
    fprintf(stderr, "%s\n", p);
  if (image_mode < 0)
    image_mode = screen_depth == 8;
  set_system_color_name();
  for (i = 0; i < SGC_MAX; i++)
    sysgc[i] = XCreateGC(dsp, rootwin, 0, 0);
  alloc_system_colors();
  setup_system_gc();
  if (str_curs_fore == NULL)
    str_curs_fore = str_color[SPX_BG];
  if (str_curs_back == NULL)
    str_curs_back = str_color[SPX_FG];
  load_font();
  init_cursor();
}

void calc_window_geom(w, h)
     int w;
     int h;
{
  int menu_total_height;
  
  topw = w;
  toph = h;
  menu_total_height = mnh + mnbw*2;
  mnw = topw - mnbw*2;
  if (menu_mode & 1) {
    viewy = 0;
    mny = toph - menu_total_height;
  } else {
    mny = 0;
    viewy = menu_total_height;
  }
  vieww = topw - viewbw*2;
  viewh = toph - menu_total_height - viewbw*2;
  if (vieww <= 0)
    vieww = 1;
  if (viewh <= 0)
    viewh = 1;
  imgw = vieww - imgbw*2;
  if (imgw < imgw0)
    imgw = imgw0;
  imgh = viewh - imgbw*2;
  if (imgh < imgh0)
    imgh = imgh0;
}

void recenter()
{
  imgx = (vieww - imgw - imgbw*2)/2;
  imgy = (viewh - imgh - imgbw*2)/2;
  XMoveWindow(dsp, imgwin, imgx, imgy);
}

void resize_topwin(w, h)
     int w;
     int h;
{
  int oimgw, oimgh;
  int ovieww, oviewh;
  
  ovieww = vieww;
  oviewh = viewh;
  oimgw = imgw;
  oimgh = imgh;
  calc_window_geom(w, h);
  XMoveResizeWindow(dsp, mnwin, mnx, mny, mnw, mnh);
  menu_resize();
  XMoveResizeWindow(dsp, viewwin, viewx, viewy, vieww, viewh);
  XMoveResizeWindow(dsp, aboutwin, viewx, viewy, vieww, viewh);
  if (vieww != ovieww || viewh != oviewh)
    recenter();
  if (imgw != oimgw || imgh != oimgh) {
    make_world_pixmap();
    redraw_all_cells();
    XResizeWindow(dsp, imgwin, imgw, imgh);
  }
}

void set_window_attributes()
{
  XSetWindowBorder(dsp, viewwin, spx[SPX_FG]);
  XSetWindowBorder(dsp, imgwin, spx[SPX_FG]);
}

char *get_window_name()
{
  static char *p = NULL;
  char *buf;
  
  if (p == NULL) {
    p = get_filename(conf_file);
    if (strcmp(p, "kiss.cnf") == 0) {
      if (arcfilecnt) {
	p = get_filename(*(arcfilelist+arcfilecnt-1));
      } else {
	buf = ks_strdup(conf_file);
	p = rindex(buf, '/');
	if (p != NULL) {
	  *p = '\0';
	  p = rindex(buf, '/');
	  if (p != NULL)
	    p++;
	}
	if (p == NULL)
	  p = buf;
	p = ks_strdup(p);
	free(buf);
      }
    }
  }
  return p;
}

static Atom wm_delete_window;

void init_window()
{
  int i, x, y;
  int f;
  XSizeHints hint;
  
  iconw = icon_width;
  iconh = icon_height;
  iconp = XCreateBitmapFromData(dsp, rootwin, icon_bits, iconw, iconh);
  if (iconp == None)
    msg("W icon bitmap create missed.\n");
  hint.flags = 0;
  f = XGeometry(dsp, scr, str_geometry, "",
		1, 1, 1, 0, 0, &x, &y, &topw, &toph);
  if (f & WidthValue) {
    hint.flags |= USSize;
  } else {
    topw = imgw0+imgbw*2+viewbw*2;
    i = DisplayWidth(dsp, scr) - (topbw*2 + 16);
    if (topw > i)
      topw = i;
  }
  if (f & HeightValue) {
    hint.flags |= USSize;
  } else {
    toph = imgh0+imgbw*2+mnh+mnbw*2+viewbw*2;
    i = DisplayHeight(dsp, scr) - (topbw*2 + 42);
    if (toph > i)
      toph = i;
  }
  if (!(f & XValue))
    x = 0;
  if (!(f & YValue))
    y = 0;
  if (test_mode || f & XValue || f & YValue)
    hint.flags |= USPosition;
  hint.x = x;
  hint.y = y;
  hint.width = topw;
  hint.height = toph;
  topwin = XCreateSimpleWindow(dsp, rootwin,
			       x, y, topw, toph, topbw,
			       spx[SPX_FG], spx[SPX_BG]);
  XSetStandardProperties(dsp, topwin, get_window_name(),
			 get_window_name(), iconp,
			 oargv, oargc, &hint);
  XSelectInput(dsp, topwin, ExposureMask|StructureNotifyMask|KeyPressMask);
  
  wm_delete_window = XInternAtom(dsp, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(dsp, topwin, &wm_delete_window, 1);
  debug_printf("wm_delete_window %ld\n", wm_delete_window);
  
  calc_window_geom(topw, toph);
  viewwin = XCreateSimpleWindow(dsp, topwin,
				viewx, viewy, vieww, viewh, viewbw,
				spx[SPX_FG], spx[SPX_BG]);
  XSelectInput(dsp, viewwin,
	       ButtonPressMask|ButtonReleaseMask|ButtonMotionMask);
  imgwin = XCreateSimpleWindow(dsp, viewwin,
			       imgx, imgy, imgw, imgh, imgbw,
			       spx[SPX_FG], spx[SPX_BG]);
  recenter();
  XSelectInput(dsp, imgwin,
	       ExposureMask|ButtonPressMask|ButtonReleaseMask|
	       ButtonMotionMask|EnterWindowMask);
  imggc = XCreateGC(dsp, imgwin, 0, 0);
  
  mnwin = XCreateSimpleWindow(dsp, topwin,
			      mnx, mny, mnw, mnh, mnbw,
			      spx[SPX_FG], spx[SPX_MN]);
  XSelectInput(dsp, mnwin, ExposureMask|ButtonPressMask);
  aboutwin = XCreateSimpleWindow(dsp, topwin,
				 viewx, viewy, vieww, viewh, viewbw,
				 spx[SPX_FG], spx[SPX_BG]);
  XSelectInput(dsp, aboutwin, ExposureMask|ButtonPressMask);
  set_window_attributes();
  set_menu_window_attributes();
}

int get_cell_pixel(p, x, y)
     CELL *p;
     int x;
     int y;
{
  int len;
  unsigned long b;
  unsigned char *ip;
  
  ip = p->image;
  if (p->bpp <= 8) {
    ip += *(p->iline + y);
    len = 0;
    while (len < p->width) {
      b = *ip++;
      len += *ip++;
      if (len > x)
	return b;		/* pixel code */
    }
  } else {
    ip += *(p->iline + y);
    len = 0;
    while (len < p->width) {
      b = get_colorpixel(ip);
      ip += 32/8;
      len += *ip++;
      if (len > x)
	return b >> 24;		/* alpha channel */
    }
  }
  return 0;
}

/* get pointed cell number in imgwin */
int search_cell(x, y)
     int x;
     int y;
{
  int i, ox, oy;
  CELL *p;
  
  for (p = cell, i = 0; i < celcnt; p++, i++) {
    if (p->setflag[cset] && !p->unmap &&
	(ox = (kset[cset].obj+p->obj)->x + p->ofsx) <= x &&
	x < ox + p->width &&
	(oy = (kset[cset].obj+p->obj)->y + p->ofsy) <= y &&
	y < oy + p->height && 
	get_cell_pixel(p, (x - ox), (y - oy)))
      return i;			/* cel number */
  }
  return -1;			/* Not found! */
}

int move_object2(n, x, y, a)
     int n;
     int x;
     int y;
     AREA *a;
{
  OBJPOS *pp;
  OBJECT *op;
  CELL *cp;
  int i;
  
  op = object+n;
  pp = kset[cset].obj+n;
  /* move limit */
  if (x + op->width > imgw)
    x = imgw - op->width;
  if (x < 0)
    x = 0;
  if (y + op->height > imgh)
    y = imgh - op->height;
  if (y < 0)
    y = 0;
  if (pp->x == x && pp->y == y)
    return 0;			/* not update */
  /* calcurate area for redraw */
  if (pp->x < x) {
    a->x = pp->x;
    a->w = x;
  } else {
    a->x = x;
    a->w = pp->x;
  }
  if (pp->y < y) {
    a->y = pp->y;
    a->h = y;
  } else {
    a->y = y;
    a->h = pp->y;
  }
  a->w += op->width - a->x;
  a->h += op->height - a->y;
  pp->x = x;
  pp->y = y;
  if (transparency_mode >= 2) {
    for (cp = cell, i = 0; i < celcnt; cp++, i++) {
      if (cp->width && cp->obj == n && cp->transparency) {
	set_transparency(cp, cp->transparency);
      }
    }
  }
  return 1;			/* update */
}

void move_object(n, x, y)
     int n;
     int x;
     int y;
{
  OBJECT *op;
  AREA ar;
  
  op = object+n;
  /* scroll check */
  if (op->width <= vieww) {
    if ((x+imgbw) < -imgx) {
      scrdx = -imgx - (x+imgbw);
      pointer_move = True;
    } else if ((x+imgbw) + op->width > -imgx + vieww) {
      scrdx = -((x+imgbw) + op->width) + (-imgx + vieww);
      pointer_move = True;
    }
  }
  if (op->height <= viewh) {
    if ((y+imgbw) < -imgy) {
      scrdy = -imgy - (y+imgbw);
      pointer_move = True;
    } else if ((y+imgbw) + op->height > -imgy + viewh) {
      scrdy = -((y+imgbw) + op->height) + (-imgy + viewh);
      pointer_move = True;
    }
  }
  if (move_object2(n, x, y, &ar))
    redraw_cells(ar.x, ar.y, ar.w, ar.h);
}

void revert_all_object_position()
{
  int i;
  OBJPOS *p;
  
  for (p = kset[cset].obj, i = 0; i < objcnt; p++, i++) {
    p->x = p->ox;
    p->y = p->oy;
  }
  redraw_all_cells();
}

#define OPT_ABBREV_MASK	0x10
#define OPT_FUNC	1
#define OPT_SET_INT	2
#define OPT_GET_INT	3
#define OPT_GET_STR	4

typedef struct {
  char *name;
  VOIDPTR parm;
  char type;
  char setvalue;		/* for OPT_SET_INT */
} OPTION;

#define OPTTBL(name,type,ptr,val) {(name), (VOIDPTR)(ptr), (type), (val)}

static OPTION opttbl[] = {
  OPTTBL("--version",	OPT_FUNC,	opt_version,		0),
  OPTTBL("-V",		OPT_FUNC,	opt_version,		0),
  OPTTBL("--help",	OPT_FUNC,	usage,			0),
  OPTTBL("-help",	OPT_FUNC,	usage,			0),
  OPTTBL("-?",		OPT_FUNC,	usage,			0),
  OPTTBL("-t",		OPT_FUNC,	exec_test,		0),
  OPTTBL("-nowarncase",	OPT_SET_INT,	&warncase,		0),
  OPTTBL("-maxaction",	OPT_FUNC,	set_maxaction,		1),
  OPTTBL("-maxtimer",	OPT_FUNC,	set_maxtimer,		1),
  OPTTBL("-maxevent",	OPT_FUNC,	set_maxevent,		1),
  OPTTBL("-maxsoundfile",OPT_FUNC,	set_maxsoundfile,	1),
  OPTTBL("--debug",	OPT_SET_INT,	&debug_mode,		1),
  OPTTBL("-debug",	OPT_SET_INT,	&debug_mode,		1),
  OPTTBL("-d",		OPT_SET_INT,	&debug_mode,		1),
  OPTTBL("-test",	OPT_SET_INT,	&test_mode,		1),
  OPTTBL("--silent",	OPT_SET_INT,	&verbose_mode,		0),
  OPTTBL("-silent",	OPT_SET_INT,	&verbose_mode,		0),
  OPTTBL("--quiet",	OPT_SET_INT,	&verbose_mode,		0),
  OPTTBL("--verbose",	OPT_SET_INT,	&verbose_mode,		3),
  OPTTBL("-verbose",	OPT_SET_INT,	&verbose_mode,		3),
  OPTTBL("-v",		OPT_SET_INT,	&verbose_mode,		3),
  OPTTBL("-scroll",	OPT_SET_INT,	&scroll_limit,		0),
  OPTTBL("-gray",	OPT_SET_INT,	&gray_mode,		1),
  OPTTBL("-mono",	OPT_SET_INT,	&gray_mode,		2),
  OPTTBL("-info",	OPT_SET_INT,	&info_mode,		1),
  OPTTBL("-s",		OPT_SET_INT,	&cursor_mode,		1),
  OPTTBL("-trace",	OPT_SET_INT,	&motion_compress,	0),
  OPTTBL("-nosound",	OPT_SET_INT,	&sound_mode,		0),
  OPTTBL("-noevent",	OPT_SET_INT,	&event_mode,		0),
  OPTTBL("-eventshell",	OPT_SET_INT,	&enable_event_shell,	1),
  OPTTBL("-nosleep",	OPT_SET_INT,	&sleep_tick,		0),
  OPTTBL("-display",	OPT_GET_STR,	&str_display,		0),
  OPTTBL("-geometry",	OPT_GET_STR,	&str_geometry,		0),
  OPTTBL("-font",	OPT_GET_STR,	&str_font,		0),
  OPTTBL("-font8",	OPT_GET_STR,	&str_font8,		0),
  OPTTBL("-font16",	OPT_GET_STR,	&str_font16,		0),
  OPTTBL("-fg",		OPT_GET_STR,	&str_color[SPX_FG],	0),
  OPTTBL("-bg",		OPT_GET_STR,	&str_color[SPX_BG],	0),
  OPTTBL("-bg2",	OPT_GET_STR,	&str_color[SPX_BG2],	0),
  OPTTBL("-menucolor",	OPT_GET_STR,	&str_color[SPX_MN],	0),
  OPTTBL("-buttoncolor",OPT_GET_STR,	&str_color[SPX_BT],	0),
  OPTTBL("-cursorfg",	OPT_GET_STR,	&str_curs_fore,		0),
  OPTTBL("-cursorbg",	OPT_GET_STR,	&str_curs_back,		0),
  OPTTBL("-evid",	OPT_GET_STR,	&evid,			0),
  OPTTBL("-soundcache",	OPT_GET_STR,	&str_sound_cache_limit,	0),
  OPTTBL("-esd",	OPT_GET_STR,	&esd_host,		0),
  OPTTBL("-noesd",	OPT_SET_INT,	&use_esd,		0),
  OPTTBL("-bw",		OPT_GET_INT,	&topbw,			0),
  OPTTBL("-viewbw",	OPT_GET_INT,	&viewbw,		0),
  OPTTBL("-imagebw",	OPT_GET_INT,	&imgbw,			0),
  OPTTBL("-menubw",	OPT_GET_INT,	&mnbw,			0),
  OPTTBL("-cursor",	OPT_GET_INT,	&cursor_mode,		0),
  OPTTBL("-menu",	OPT_GET_INT,	&menu_mode,		0),
  OPTTBL("-fixed",	OPT_GET_INT,	&fixed,			0),
  OPTTBL("-unfix",	OPT_GET_INT,	&unfixed,		0),
  OPTTBL("-sound",	OPT_GET_INT,	&sound_mode,		0),
  OPTTBL("-tick",	OPT_GET_INT,	&sleep_tick,		0),
  OPTTBL("-randseed",	OPT_GET_INT,	&randseed,		0),
  OPTTBL("-p",		OPT_SET_INT,	&private_color_mode,	1),
  OPTTBL("-nocolormap",	OPT_SET_INT,	&private_colormap_mode,	0),
  OPTTBL("-u",		OPT_SET_INT,	&objpos_first_align,	1),
  OPTTBL("-o",		OPT_SET_INT,	&oldcnf_comaptible,	1),
  OPTTBL("-k",		OPT_GET_STR|OPT_ABBREV_MASK,	&hes_keyword,	0),
  OPTTBL("-image",	OPT_SET_INT,	&image_mode,		1),
  OPTTBL("-noimage",	OPT_SET_INT,	&image_mode,		0),
  OPTTBL("-wkiss",	OPT_SET_INT,	&wkiss_bug_emulation,	1),
  OPTTBL("-transparency",OPT_GET_INT,	&transparency_mode,	0),
  OPTTBL("-comment",	OPT_GET_INT,	&comment_mode,		0),
  OPTTBL("-commentline",OPT_SET_INT,	&comment_linenum,	1),
  OPTTBL("-commentbw",	OPT_GET_INT,	&combw,			0),
  OPTTBL("-button1",	OPT_GET_INT,	&button_func_tbl[1],	0),
  OPTTBL("-button2",	OPT_GET_INT,	&button_func_tbl[2],	0),
  OPTTBL("-button3",	OPT_GET_INT,	&button_func_tbl[3],	0),
  OPTTBL("-document",	OPT_GET_STR,	&doc_command,		0),
  OPTTBL("-doc",	OPT_GET_STR,	&doc_command,		0),
  OPTTBL("-suffix",	OPT_FUNC,	opt_add_doc_suffix,	1),
  OPTTBL("-nosuffix",	OPT_FUNC,	opt_del_doc_suffix,	1),
  OPTTBL("-autoadjust",	OPT_GET_INT,	&auto_adjust,		0),
  OPTTBL("-alpha",	OPT_GET_INT,	&alpha_level,		0),
  OPTTBL("-midiplayer", OPT_GET_STR,    &midi_player,           0),
  OPTTBL(NULL,		0,		NULL,			0)
};

int parse_option(ac, av)
     int *ac;
     char ***av;
{
  OPTION *p;
  int i;
  typedef void (*VOIDFUNCPTR)();
  
  for (p = opttbl; p->name != NULL; p++) {
    if (strcmp(**av, p->name) == 0) {
      --*ac;
      ++*av;
      switch(p->type & ~OPT_ABBREV_MASK) {
      case OPT_FUNC:
	if (p->setvalue) {
	  if (*ac) {
	    ((VOIDFUNCPTR)(p->parm))(**av);
	    ++*av;
	    --*ac;
	  }
	} else {
	  ((VOIDFUNCPTR)(p->parm))();
	}
	break;
      case OPT_SET_INT:
	*((int *)(p->parm)) = p->setvalue;
	break;
      case OPT_GET_INT:
	if (*ac) {
	  *((int *)(p->parm)) = strtol(**av, NULL, 0);
	  ++*av;
	  --*ac;
	}
	break;
      case OPT_GET_STR:
	if (*ac) {
	  *((char **)(p->parm)) = **av;
	  ++*av;
	  --*ac;
	}
	break;
      }
      return 0;
    } else if (p->type & OPT_ABBREV_MASK && 
	       strncmp(**av, p->name, i = strlen(p->name)) == 0) {
      switch(p->type & ~OPT_ABBREV_MASK) {
      case OPT_GET_INT:
	*((int *)(p->parm)) = strtol(**av+i, NULL, 0);
	break;
      case OPT_GET_STR:
	*((char **)(p->parm)) = **av+i;
	break;
      }
      ++*av;
      --*ac;
      return 0;
    }
  }
  return 1;
}

ARTBL *get_archive_type(name)
     char *name;
{
  ARTBL *p;
  
  for (p = artype; p->suffix != NULL; p++)
    if (is_suffix(name, p->suffix))
      return p;
  return NULL;
}

char *quote_filename(p)
     char *p;
{
  LSTR work;
  
  lstr_init(&work);
  while (*p) {
    switch (*p) {
    case ';':
    case '&':
    case '(':
    case ')':
    case '`':
    case '\'':
    case '"':
      lstr_ch(&work, '\\');
      /* FALL THROUGH */
    default:
      lstr_ch(&work, *p);
      break;
    }
    p++;
  }
  return work.buf;
}

char *gen_arcommand(form, name, file)
     char *form;		/* format template */
     char *name;		/* archive file */
     char **file;		/* file list */
{
  int i;
  char *p;
  LSTR s;
  char *p2;
  char **rbuf;
  char *prefix;
  char *replace_str[2];
  
  lstr_init(&s);
  for (p = form; *p != '\0'; p++) {
    if (*p == '%') {
      prefix = replace_str[0] = replace_str[1] = NULL;
      rbuf = replace_str;
      switch(*++p) {
      case '%':			/* %% : '%' itself */
	*rbuf = "%";
	break;
      case 'P':			/* %P : "name/file[0] ... name/file[n]" */
	prefix = name;
	/* FALL THROUGH */
      case 'F':			/* %F : "file[0] ... file[n]" */
	rbuf = file;
	break;
      case 'A':			/* %A : "name" (archive file) */
	*rbuf = name;
	break;
      case 'D':			/* %D : target directory */
	*rbuf = extract_dir;
	break;
      case 'K':			/* %K : hesper keyword */
	*rbuf = hes_keyword;
	break;
      default:
	msg("E ``%s'' bad archiver command!\n", form);
	/* NOT REACHED */
      }
      for (i = 0; *(rbuf+i) != NULL; i++) {
	if (i)
	  lstr_cat(&s, " ");
	if (prefix != NULL) {
	  lstr_cat(&s, prefix);
	  if (*(prefix + strlen(prefix) - 1) != '/')
	    lstr_cat(&s, "/");
	}
	p2 = quote_filename(*(rbuf+i));
	lstr_cat(&s, p2);
	free(p2);
      }
    } else {
      lstr_ch(&s, *p);
    }
  }
  return s.buf;
}

int extract_archive(name)
     char *name;		/* archive file */
{
  int r;
  char *buf;
  char *cmd;
  ARTBL *p;
  
  if (!is_regular_file(name))
    msg("E archive ``%s'' not found!\n", name);
  if (extract_dir == NULL) {
    buf = ks_malloc(strlen(tmpdir) + 32);
    sprintf(buf, "%s/fkiss%d", tmpdir, (int)getpid());
    extract_dir = ks_strdup(buf);
    buf = ks_realloc(buf, 6 + strlen(extract_dir) + 1);
    sprintf(buf, "mkdir %s", extract_dir);
    ks_system(buf);
    free(buf);
  }
  p = get_archive_type(name);
  if (p == NULL)
    return -1;
  cmd = gen_arcommand(p->command, name, NULL);
  r = ks_system2(cmd);
  free(cmd);
  return r;
}

/* return number of extracted archive */
int extract_arc_in_arc()
{
  int r;
  char **p;
  char **list;
  char *buf;

  r = 0;
  if (extract_dir == NULL)
    return 0;
  debug_printf("extract_arc_in_arc extract_dir ``%s''\n", extract_dir);
  list = dir_ls(extract_dir, NULL);
  if (list != NULL) {
    for (p = list; *p != NULL; p++) {
      buf = ks_malloc(strlen(extract_dir) + 1 + strlen(*p) + 1);
      sprintf(buf, "%s/%s", extract_dir, *p);
      if (get_archive_type(buf) != NULL) {
	if (extract_archive(buf) == 0)
	  r++;
	unlink(buf);
      }
      free(buf);
    }
    dir_free(list);
  }
  return r;
}

int extract_archives(list, n)
     char **list;		/* archive file list */
     int n;			/* number of files */
{
  int r;
  
  for (r = 0; r < n && get_archive_type(*list) != NULL; r++)
    extract_archive(*list++);
  while (extract_arc_in_arc())
    ;
  return r;
}

void image_scroll()
{
  if (scroll_limit) {
    if (scrdx > 0 && imgx + scrdx > 0)
      scrdx = - imgx;
    if (scrdx < 0 && imgx + scrdx + imgw + imgbw*2 < vieww)
      scrdx = vieww - (imgx + imgw + imgbw*2);
    if (scrdy > 0 && imgy + scrdy > 0)
      scrdy = - imgy;
    if (scrdy < 0 && imgy + scrdy + imgh + imgbw*2 < viewh)
      scrdy = viewh - (imgy + imgh + imgbw*2);
  }
  if (scrdx || scrdy) {
    imgx += scrdx;
    imgy += scrdy;
    if (pointer_move) {
      XWarpPointer(dsp, None, None, 0, 0, 0, 0, scrdx, scrdy);
      pointer_move = False;
    }
    XMoveWindow(dsp, imgwin, imgx, imgy);
    scrdx = scrdy = 0;
  }
}

void redraw_all()
{
  change_palette(kset[cset].pal);
  if (image_mode)
    make_cell_pixmap_image();
  else
    make_cell_pixmap();
  redraw_all_cells();
}

void free_system_colors()
{
  int i;
  unsigned long pixels[SPX_MAX];
  
  if (pixel_direct)
    return;
  for (i = 0; i < SPX_MAX; i++)
    pixels[i] = spx[i];
  XFreeColors(dsp, cmap, pixels, SPX_MAX, 0);
}

void set_system_pixels()
{
  setup_system_gc();
  set_window_attributes();
  set_menu_window_attributes();
}

void poor_system_pixels()
{
  free_system_colors();
  gray_mode = 2;
  init_system_color_name();
  set_system_color_name();
  alloc_system_colors();
  set_system_pixels();
  str_curs_fore = "White";
  str_curs_back = "Black";
  init_cursor();
}

int initialize_main1()
{
  int i;
  char *p;
  
  /**/
  read_directory();
  if (read_config(conf_file))
    return 1;			/* cnf read error! */
  if (cset < 0)
    return 1;			/* No effective set! */
  if (read_colors())
    return 1;
  if (read_cells())
    return 1;
  free_directory();
  p = get_cell_info();
  if (debug_mode || test_mode)
    fprintf(stderr, "%s\n", p);
  
  if (true_color_cell && !pixel_direct) {
    msg("E Visual TrueColor or DirectColor needed to display true color cell!\n");
  }

  init_window();
  debug_printf("image_mode = %d\n", image_mode);

  for (i = 0; i < MAXPAL; i++) {
    xcol[i] = (XColor *)ks_malloc(sizeof(XColor)*colcnt);
  }
  if (!image_mode) {
    paint_gc = (GC *)ks_malloc(sizeof(GC) * colcnt);
    for (i = 0; i < colcnt; i++)
      *(paint_gc+i) = XCreateGC(dsp, imgwin, 0, 0);
    true_color_gc = XCreateGC(dsp, imgwin, 0, 0);
  }

  debug_printf("colcnt %d, palcnt %d\n", colcnt, palcnt);
  if (alloc_colors())
    return 1;
  for (i = 0; i < MAXPAL; i++) {
    free(kcol[i]);
    kcol[i] = NULL;
  }
  set_topwin_attributes();
  make_world_pixmap();
  create_cell_pixmap();
  create_set_menu();
  make_clip_gc();
  if (transparency_mode) {
    make_transparency_dither();
  }
  make_clip();
  if (transparency_mode) {
    set_initial_transparency();
  }
  redraw_all();
  XMapRaised(dsp, topwin);
  XMapRaised(dsp, viewwin);
  XMapRaised(dsp, imgwin);
  return 0;
}

int change_setpal(s, p)
     int s;
     int p;
{
  int set_changed, pal_changed;	/* quick and darty hack */
  static int nest = 0;
  
  if (s < 0 || s >= setcnt || !active_set[s])
    s = cset;
  if (p < 0 || p >= palcnt)
    p = kset[s].pal;
  if (s == cset && p == kset[cset].pal)
    return 0;			/* not changed */
  set_changed = pal_changed = 0;
  if (cset != s) {
    cset = s;
    set_changed = 1;
  }
  if (kset[cset].pal != p) {
    kset[cset].pal = p;
    pal_changed = 1;
  }
  debug_printf("set = %d, pal = %d\n", cset, kset[cset].pal);
  nest++;
  if (set_changed)
    kissevent_handler(EVE_SET, s);
  if (pal_changed)
    kissevent_handler(EVE_COL, p);
  if (!--nest)
    redraw_all();
  return 1;			/* changed */
}

void kiss_iconify()
{
  XIconifyWindow(dsp,topwin,scr);
}

void alternate_cell_mapping()
{
  if (mapping_changed_cell >= 0) {
    change_cel_mapping(cell+mapping_changed_cell, ACT_ALTMAP);
  }
}

int next_set(d)
     int d;			/* direction -1:previous 1:next */
{
  int i;
  
  i = cset;
  while ((i += d) >= 0 && i < MAXSET) {
    if (active_set[i])
      return i;
  }
  return cset;
}

int match_doc(name)
     char *name;
{
  char **p;
  
  for (p = doc_suffix; *p; p++) {
    if (!is_free_doc_suffix(*p)) {
      if (is_suffix(name, *p)) {
	return 1;
      }
    }
  }
  return 0;
}


int browse_document()
{
  int r;
  char **filelist;
  char *cmd, *doc_dir, *cmd0;
  Window cw, rw;
  int wx, wy, rx, ry;
  unsigned keys_buttons;
  char buf[32];
  static char *selectfile[2] = {NULL, NULL};
  
  doc_dir = (extract_dir != NULL) ? extract_dir : conf_dir;
  filelist = dir_ls(doc_dir, match_doc);
  cmd = NULL;
  cmd0 = ks_strdup(doc_command);
  if (index(cmd0, '%') == NULL) {
    cmd0 = ks_strdup(cmd0, strlen(cmd0) + 4);
    strcat(cmd0, " %P");
  }
  if (*(cmd0 + strlen(cmd0) - 1) != '&') {
    cmd0 = ks_realloc(cmd0, strlen(cmd0) + 2);
    strcat(cmd0, "&");
  }
  XQueryPointer(dsp, rootwin, &rw, &cw, &rx, &ry, &wx, &wy, &keys_buttons);
  sprintf(buf, "%+d%+d", rx, ry);
  if ((r = select_menu("fkiss doc", buf, filelist)) >= 0) {
    selectfile[0] = *(filelist+r);
    cmd = gen_arcommand(cmd0, doc_dir, selectfile);
  }
  free(cmd0);
  dir_free(filelist);
  if (cmd != NULL) {
    ks_system2 (cmd);
    free (cmd);
  }
  return 0;
}

void key_event(p)
     XKeyEvent *p;
{
  int i, s;
  int keycode;
  KeySym key;
  XComposeStatus cs;
  char buf[32];
  static int change_col_mode = 0;
  
  i = XLookupString(p, buf, sizeof(buf)-1, &key, &cs);
  buf[i] = '\0';
  /* I don't use switch(key), because key is not int. */
  if (key == XK_Left)
    keycode = 'h';
  else if (key == XK_Right)
    keycode = 'l';
  else if (key == XK_Down)
    keycode = 'j';
  else if (key == XK_Up)
    keycode = 'k';
  else
    keycode = buf[0];
  s = -1;
  switch(keycode) {
  case '0':
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
    s = keycode - '0';		/* for ASCII and EBCDIC character set only */
    break;
  case '-':
    change_setpal(next_set(-1), -1);
    break;
  case '^':
  case '=':
    change_setpal(next_set(1), -1);
    break;
  case '[':
    change_setpal(-1, kset[cset].pal-1);
    break;
  case ']':
    change_setpal(-1, kset[cset].pal+1);
    break;
  case 'j':
    scrdy = -16;
    break;
  case 'J':
    scrdy = -1;
    break;
  case 'k':
    scrdy = 16;
    break;
  case 'K':
    scrdy = 1;
    break;
  case 'h':
    scrdx = 16;
    break;
  case 'H':
    scrdx = 1;
    break;
  case 'l':
    scrdx = -16;
    break;
  case 'L':
    scrdx = -1;
    break;
  case ' ':
    menu_mode ^= 1;
    resize_topwin(topw, toph);
    break;
  case 'L'-0x40:
    recenter();
    break;
  case 's':
    change_col_mode = 0;
    break;
  case 'c':
    change_col_mode = 1;
    break;
  case 'm':
    motion_compress = !motion_compress;
    XClearArea(dsp, aboutwin, 0, 0, 0, 0, True);
    break;
  case 'i':
    info_mode = !info_mode;
    break;
  case '?':
    change_menu_func(0);	/* About */
    break;
  case 'S'-0x40:		/* ^S Save cnf file */
    save_config(conf_file);
    break;
  case 'v':			/* alternate cel map/unmap */
    alternate_cell_mapping();
    break;
  case 0x1b:
    kiss_iconify();
    break;
  case 'q':
    change_menu_func(1);	/* Quit */
    break;
  case 'd':
    browse_document();
    break;
  case 'r':
    if (!event_detect)
      revert_all_object_position();
    break;
  }
  if (s >= 0) {
    if (change_col_mode)
      change_setpal(-1, s);
    else
      change_setpal(s, -1);
  }
}

void disp_info()
{
  XClearArea(dsp, infowin, 0, 0, 0, 0, True);
  XMapWindow(dsp, infowin);
}

void disp_pesi()
{
  CELL *p;
  
  p = cell+catched_cell;
  strcpy(infostr0, "Pointed: ");
  sprintf(infostr, "%s (%d,%d) %d/(%d,%d)",
	  p->filename, catched_cell, p->obj,
	  (object + p->obj)->pesi + pesi_count,
	  p->fix, (object + p->obj)->fix);
  if (info_mode)
    disp_info();
}

EVHITWK mouse_move_hit;
int moving_object = -1;

int celhitovl(c0, x0, y0, c1, x1, y1, w, h)
     CELL *c0;
     int x0;
     int y0;
     CELL *c1;
     int x1;
     int y1;
     int w;
     int h;
{
  int x, y;
  
  for (y = 0; y < h; y++) {
    for (x = 0; x < w; x++) {
      if (get_cell_pixel(c0, x0+x, y0+y) &&
	  get_cell_pixel(c1, x1+x, y1+y)) {
	return 1;
      }
    }    
  }
  return 0;
} 

int celhit1(cp, objx, objy, n)
     CELL *cp;
     int objx;
     int objy;
     int n;
{
  int x0, y0, w0, h0;
  int x1, y1, w1, h1;
  int x2, y2, w2, h2;
  CELL *p;
  
  p = cell + n;
  
  if (!cp->setflag[cset] || cp->unmap || !p->setflag[cset] || p->unmap)
    return 0;

  x0 = objx + cp->ofsx;
  y0 = objy + cp->ofsy;
  w0 = cp->width;
  h0 = cp->height;
  
  x1 = (kset[cset].obj + p->obj)->x + p->ofsx;
  y1 = (kset[cset].obj + p->obj)->y + p->ofsy;
  w1 = p->width;
  h1 = p->height;
  
  x2 = x0 > x1 ? x0 : x1;
  w2 = ((x0 + w0 < x1 + w1) ? x0 + w0 : x1 + w1) - x2;
  y2 = y0 > y1 ? y0 : y1;
  h2 = ((y0 + h0 < y1 + h1) ? y0 + h0 : y1 + h1) - y2;

  if (w2 <= 0 || h2 <= 0)
    return 0;			/* None overlap rect region */
  
  return celhitovl(cp, x2-x0, y2-y0, p, x2-x1, y2-y1, w2, h2);
}


void check_cell_hit_before(objn)
     int objn;
{
  CELL *cp;
  int i, j;
  int objx, objy;
  
  objx = (kset[cset].obj + objn)->x;
  objy = (kset[cset].obj + objn)->y;
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (cp->obj == objn) {
      for (j = 0; j < cp->hitn; j++) {
	(cp->hitp+j)->s = celhit1(cp, objx, objy, (cp->hitp+j)->n);
      }
    }
  }
}

void check_cell_hit_after(objn)
     int objn;
{
  CELL *cp;
  int i, j;
  int objx, objy;
  int before, after;

  objx = (kset[cset].obj + objn)->x;
  objy = (kset[cset].obj + objn)->y;
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (cp->obj == objn) {
      for (j = 0; j < cp->hitn; j++) {
	
	before = (cp->hitp+j)->s;
	after = celhit1(cp, objx, objy, (cp->hitp+j)->n);
	if (!before && after) {
	  kissevent_handler2(EVE_COLLIDE, i, (cp->hitp+j)->n);
	}
	if (before && !after) {
	  kissevent_handler2(EVE_APART, i, (cp->hitp+j)->n);
	}
      }
    }
  }
}

int check_obj_hit_cel(cp, objx, objy, o2)
     CELL *cp;
     int objx;
     int objy;
     int o2;
{
  CELL *p;
  int i;
  int x0, y0, x1, y1;
  int x2, y2;
  OBJPOS *pp;
  
  pp = kset[cset].obj + cp->obj;
  x0 = objx + cp->orgx;
  y0 = objy + cp->orgy;
  x1 = x0 + cp->orgw;
  y1 = y0 + cp->orgh;
  
  pp = kset[cset].obj + o2;
  x2 = pp->x;
  y2 = pp->y;
  for (p = cell, i = 0; i < celcnt; p++, i++) {
    if (p->obj == o2 && p->setflag[cset] && !p->unmap) {
      if (x0 < x2 + p->orgx + p->orgw && x2 + p->orgx < x1 &&
	  y0 < y2 + p->orgy + p->orgh && y2 + p->orgy < y1) {
	return 1;
      }
    }
  }
  return 0;
}

int check_obj_hit1(o1, objx, objy, o2)
     int o1;
     int objx;
     int objy;
     int o2;
{
  int i;
  CELL *cp;
  
  for (cp = cell, i = 0; i < celcnt; cp++, i++) {
    if (cp->obj == o1 && cp->setflag[cset] && !cp->unmap) {
      if (check_obj_hit_cel(cp, objx, objy, o2))
	return 1;
    }
  }
  return 0;
}

void check_obj_hit_before(objn)
     int objn;
{
  OBJECT *op;
  int i;
  int o1, o2;
  int objx, objy;
  
  o1 = objn;
  op = object + o1;
  for (i = 0; i < op->ohitn; i++) {
    o2 = (op->ohitp + i)->n;
    objx = (kset[cset].obj + o1)->x;
    objy = (kset[cset].obj + o1)->y;
    (op->ohitp + i)->s = check_obj_hit1(o1, objx, objy, o2);
  }
}

void check_obj_hit_after(objn)
     int objn;
{
  OBJECT *op;
  int i;
  int o1, o2;
  int objx, objy;
  int before, after;
  
  o1 = objn;
  op = object + o1;
  for (i = 0; i < op->ohitn; i++) {
    o2 = (op->ohitp + i)->n;
    
    before = (op->ohitp + i)->s;
    
    objx = (kset[cset].obj + o1)->x;
    objy = (kset[cset].obj + o1)->y;
    after = check_obj_hit1(o1, objx, objy, o2);

    if (after) {
      if (!before)
	kissevent_handler2(EVE_IN, o1, o2);
      kissevent_handler2(EVE_STILLIN, o1, o2);
    } else {
      if (before)
	kissevent_handler2(EVE_OUT, o1, o2);
      kissevent_handler2(EVE_STILLOUT, o1, o2);
    }
  }
}


void move_object_start(p, n)
     EVHITWK *p;
     int n;
{
  p->objn = n;
  p->objx = (kset[cset].obj + n)->x;
  p->objy = (kset[cset].obj + n)->y;
  check_cell_hit_before(n);
  check_obj_hit_before(n);
}

void move_object_end(p)
     EVHITWK *p;
{
  OBJPOS *pp;
  
  pp = kset[cset].obj + p->objn;
  check_cell_hit_after(p->objn);
  check_obj_hit_after(p->objn);
}

void catch_check(x, y)
     int x;
     int y;
{
  CELL *p;
  
  catched_cell = search_cell(x, y);
  catched_cell2 = catched_cell;
  if (catched_cell >= 0) {
    pesi_count = 0;		/* pesi-pesi start */
    disp_pesi();
    p = cell+catched_cell;
    if ((object + p->obj)->fix >= fixed)
      catched_cell = -1;
    catched_objx = (kset[cset].obj+p->obj)->x;
    catched_objy = (kset[cset].obj+p->obj)->y;
    catched_dx = x - (catched_objx + p->ofsx);
    catched_dy = y - (catched_objy + p->ofsy);
  }
  if (catched_cell >= 0) {
    moving_object = (cell+catched_cell)->obj;
    move_object_start(&mouse_move_hit, (cell+catched_cell)->obj);
  }
}

void update_pesi(p)
     OBJECT *p;
{
  int i;
  
  i = p->pesi + pesi_count;
  if (i > p->fix)
    i = p->fix;
  p->pesi = i;
  pesi_count = 0;
}

void adjust_pos()
{
  OBJPOS *p;
  int x, y, d, d0, s, n;
  
  if (!auto_adjust)
    return;
  d0 = auto_adjust * 2;
  n = -1;
  for (s = 0; s < setcnt; s++) {
    if (active_set[s]) {
      p = kset[s].obj + mobjn;
      x = mobjx - p->ox;
      y = mobjy - p->oy;
      if (x >= -auto_adjust && x <= auto_adjust &&
	  y >= -auto_adjust && y <= auto_adjust) {
	d = (x < 0 ? -x : x) + (y < 0 ? -y : y);
	if (d < d0) {
	  d0 = d;
	  n = s;
	}
      }
    }
  }
  if (n < 0)
    return;
  p = kset[n].obj + mobjn;
  mobjx = p->ox;
  mobjy = p->oy;
}

void release_object()
{
  OBJECT *p;
  AREA ar;
  
  if (mobjn >= 0) {
    adjust_pos();
    p = object + mobjn;
    if (p->pesi < p->fix) {
      /* return last position */
      mobjx = catched_objx;
      mobjy = catched_objy;
      kissevent_handler(EVE_FIXDROP, catched_cell);
    }
    kissevent_handler(EVE_DROP, catched_cell);

    if (move_object2(mobjn, mobjx, mobjy, &ar))
      redraw_cells(ar.x, ar.y, ar.w, ar.h);

    mobjn = -1;
    moving_object = -1;
    move_object_end(&mouse_move_hit);
  }
  catched_cell = -1;
  XUnmapWindow(dsp, infowin);
}

void pesi_pesi()
{
  int move_limit, pesi_limit;
  OBJECT *p;
  
  p = object + (cell+catched_cell)->obj;
  if (p->pesi >= p->fix)
    return;
  pesi_limit = p->pesi/20 + 1;
  move_limit = ((p->pesi + pesi_limit) * 16) / p->fix + 1;
  ++pesi_count;
  if (mobjx < catched_objx - move_limit) {
    mobjx = catched_objx - move_limit;
    pesi_count = pesi_limit;
  } else if (mobjx > catched_objx + move_limit) {
    mobjx = catched_objx + move_limit;
    pesi_count = pesi_limit;
  }    
  if (mobjy < catched_objy - move_limit) {
    mobjy = catched_objy - move_limit;
    pesi_count = pesi_limit;
  } else if (mobjy > catched_objy + move_limit) {
    mobjy = catched_objy + move_limit;
    pesi_count = pesi_limit;
  }
  disp_pesi();
  if (pesi_count >= pesi_limit) {
    pesi_count = pesi_limit;
    update_pesi(p);
    if (p->pesi < p->fix && p->pesi < unfixed) {
      /* return original position */
      /* move_object(mobjn, mobjx, mobjy); */
      cursor_hand();
      release_object();
    } else {
      /* without this the object must be dragged against a resistance */
      p->pesi = p->fix;
      /* unfixed! free moving! */
      kissevent_handler(EVE_UNFIX, catched_cell);
    }
  }
}

void move_check(x, y)
     int x;
     int y;
{
  CELL *p;
  
  if (catched_cell >= 0) {
    p = cell+catched_cell;
    mobjn = p->obj;
    mobjx = x - catched_dx - p->ofsx;
    mobjy = y - catched_dy - p->ofsy;
    pesi_pesi();
  } else if (catched_cell == -2) {
    if (!scrdx && !scrdy) {
      scrdx = x - catch_x;
      scrdy = y - catch_y;
    }
  }
}

/* startup initialize
 * called before parse options
 */
void init0()
{
  int i;
  char *p;
  
  /* all set active */
  for (i = 0; i < MAXSET; i++)
    active_set[i] = 1;
  init_system_color_name();
  p = getenv("TMPDIR");
  if (p != NULL)
    tmpdir = p;
}

char *get_startup_sound_sub(dir)
     char *dir;
{
  char *buf;
  char **p;
  static char *startup_sound[] = {"/fkiss.au", "/.fkiss.au", NULL};

  for (p = startup_sound; *p != NULL; p++) {
    buf = ks_malloc(strlen(dir) + strlen(*p) + 1);
    strcpy(buf, dir);
    strcat(buf, *p);
    if (is_regular_file(buf))
      return buf;
    free(buf);
  }
  return NULL;
}

char *get_startup_sound_file()
{
  char *p;
  
  p = get_startup_sound_sub(".");
  if (p == NULL) {
    if ((p = getenv("HOME")) != NULL)
      p = get_startup_sound_sub(p);
  }
  return p;
}

void play_startup_sound()
{
  if (startup_sound_file != NULL)
    bg_play(startup_sound_file);
}

void adjust_option()
{
  char *p;
  
  if (debug_mode)
    sound_debug = 2;
#ifndef USE_USLEEP
  if (sleep_tick % 1000) {
    sleep_tick = sleep_tick - (sleep_tick % 1000) + 1000;
    msg("W sleep tick correct %d millisec.\n", sleep_tick);
  }
#endif
  startup_sound_file = get_startup_sound_file();
  /* disable sound, if silent mode is selected */
  if (!verbose_mode)
    sound_mode = 0;
  if (sound_mode) {
    p = str_sound_cache_limit;
    if (p != NULL) {
      sound_cache_limit = strtol(p, &p, 0);
      switch (*p) {
      case 'm':
      case 'M':
	sound_cache_limit *= 1024;
	/* FALL THROUGH */
      case 'k':
      case 'K':
	sound_cache_limit *= 1024;
	break;
      }
    }
  }
}

int button_func(p)
     XButtonEvent *p;
{
  int i;
  
  switch (p->button) {
  case Button1:
    i = 1;
    break;
  case Button2:
    i = 2;
    break;
  case Button3:
    i = 3;
    break;
  default:
    i = 0;
    break;
  }
  return button_func_tbl[i];
}

int parse_rc(file)
     char *file;
{
  char *p;
  char *str;
  FILE *fp;
  int ac;
  char **av;
  char buf[4096];		/* RC file max line length */
  static char charset[] =
    "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
  
  fp = fopen(file, "r");
  if (fp == NULL)
    return 1;			/* file open error! */
  ac = 0;
  av = (char **)ks_malloc(sizeof(char *));
  while (fgets(buf, sizeof(buf), fp) != NULL) {
    cut_crlf(buf);
    if ((p = index(buf, '#')) != NULL)
      *p = '\0';		/* erase comment */
    for (p = buf; *p; ) {
      str = parse_string(&p, charset);
      *(av+ac) = str;
      ac++;
      av = (char **)ks_realloc(av, sizeof(char *)*(ac+1));
    }
  }
  *(av+ac) = NULL;
  fclose(fp);
  while (ac > 0) {
    if (parse_option(&ac, &av)) {
      if (**av == '-') {
	msg("W unknown option ``%s''.\n", *av);
	kiss_exit(1);
      }
      break;
    }
  }
  return 0;			/* Success */
}

void read_fkissrc()
{
  char *p;
  char *buf;
  
  p = getenv("HOME");
  if (p != NULL) {
    buf = ks_malloc(strlen(p) + 9 + 1);
    sprintf(buf, "%s/.fkissrc", p);
    parse_rc(buf);
    free(buf);
  }
}

int main(argc, argv)
     int argc;
     char **argv;
{
  int i, n;
  XEvent ev;
  Bool mapped;
  char *p;
  Bool first_map;
  Bool button_pressed;
  char msgbuf[1024];
  
  /* set pgid */
  if(setpgrp()) {
	  perror("Could not set process group id");
	  exit(EXIT_FAILURE);
  }
  /* Get user's prefered editor */
  if ( (doc_command = getenv("EDITOR")) == NULL)
 	 if ( (doc_command = getenv("VISUAL")) == NULL)
  		doc_command = DOC_COMMAND;
  
  setup_signal_handler();
  oargc = argc--;
  oargv = argv++;
  msg_init(msgbuf);
  init0();
  read_fkissrc();
  while (argc > 0) {
    if (parse_option(&argc, &argv)) {
      if (**argv == '-') {
	msg("W unknown option ``%s''.\n", *argv);
	usage();
      }
      break;
    }
  }
  adjust_option();
  if (debug_mode || test_mode || verbose_mode & 2)
    print_version();
  if (debug_mode)
    print_compile_options();
  if (sound_mode == 1) {
    if (sound_init()) {
      msg("W sound device ``%s'' initialize error.\n", sound_device);
    }
  }
  if (background())
    msg("W cannot to fork background process!\n");
  p = get_client_info();
  if (debug_mode || test_mode)
    fprintf(stderr, "%s\n", p);
  init_screen();
  init_object_cell();
  arcfilelist = argv;
  n = argc;			/* number of archive and cnf arguments */
  i = extract_archives(argv, argc);
  argv += i;
  arcfilecnt += i;
  argc -= i;
  switch(select_cnf(argc?*argv:NULL)) {
  case -2:			/* No cnf */
    if (!n)
      usage();			/* no archive or cnf given, print usage */
    msg("E *.cnf not found!\n");
    /* NOT REACHED */
  case -1:			/* Cancel */
    kiss_exit(0);
    /* NOT REACHED */
  }
  
  if (initialize_main1()) {
    kiss_exit(1);
    /* NOT REACHED */
  }
  /* This is NOT standard implementation! */
  if (fixed < 0) {
    if (wkiss_bug_emulation)
      max_fix = 99999;
    fixed = max_fix > 0 ? max_fix : FIXED_OBJECT;
  }
  catched_cell2 = catched_cell = -1;
  scrdx = scrdy = 0;
  button_pressed = mapped = False;
  first_map = True;
  while (!quit_flag) {
    mobjn = -1;
    while (!XEventsQueued(dsp, QueuedAfterReading)) {
      /* background operation */
      image_scroll();
      kissevent_timer();
      if (XEventsQueued(dsp, QueuedAfterFlush) || !event_detect)
	break;
      if (sleep_tick && !button_pressed)
	sleep_time(get_sleep_time());
    }
    XNextEvent(dsp, &ev);
    switch(ev.type) {
    case Expose:
      if (ev.xexpose.window == imgwin)
	expose_image(ev.xexpose.x, ev.xexpose.y,
		     ev.xexpose.width, ev.xexpose.height);
      else if (ev.xexpose.window == comwin)
	expose_comment(&ev.xexpose);
      else
	expose_menu(&ev.xexpose);
      break;
    case MotionNotify:
      if (motion_compress)
	while (XCheckTypedEvent(dsp, MotionNotify, &ev))
	  ;
      move_check(ev.xmotion.x, ev.xmotion.y);
      if (ev.xmotion.window == viewwin) {
	catch_x = ev.xmotion.x;
	catch_y = ev.xmotion.y;
      }
      break;
    case ButtonPress:
      switch (button_func(&ev.xbutton)) {
      case BUTTON_FUNC_CELL:
	if (!button_pressed) {
	  /* for multi button pressing, check only first press */
	  catch_x = ev.xbutton.x;
	  catch_y = ev.xbutton.y;
	  if (ev.xbutton.window == imgwin) {
	    button_pressed = True;
	    catch_check(ev.xbutton.x, ev.xbutton.y);
	    if (catched_cell2 >= 0 && ev.xbutton.state & ControlMask) {
	      mapping_changed_cell = catched_cell2;
	      alternate_cell_mapping();
	    }
	    kissevent_handler(EVE_PRESS, catched_cell2);
	    if (catched_cell >= 0) {
	      if ((object + (cell+catched_cell)->obj)->pesi <
		  (object + (cell+catched_cell)->obj)->fix)
		kissevent_handler(EVE_FIXCATCH, catched_cell);
	      kissevent_handler(EVE_CATCH, catched_cell);
	      cursor_grip();
	    } else {
	      cursor_scroll();
	      catched_cell = -2;
	    }
	  } else if (ev.xbutton.window == viewwin) {
	    button_pressed = True;
	    cursor_scroll();
	    catched_cell = -2;
	  } else if (ev.xbutton.window == comwin) {
	    button_pressed = True;
	    unmap_comment();	/* Can't happen! */
	  }
	}
        press_menu(&ev.xbutton);
	break;
      case BUTTON_FUNC_ICONIFY:
	kiss_iconify();
	/* Menu select is not available */
	break;
      case BUTTON_FUNC_COMMENT:
	if (ev.xbutton.window == imgwin)
	  map_comment(&ev.xbutton);
	else
	  unmap_comment();
	press_menu(&ev.xbutton);
	break;
      }
      break;
    case ButtonRelease:
      switch (button_func(&ev.xbutton)) {
      case BUTTON_FUNC_CELL:
	if (button_pressed) {
	  /* for multi button pressing, check only first release */
	  button_pressed = False;
	  cursor_hand();
	  move_check(ev.xbutton.x, ev.xbutton.y);
	  if (mobjn >= 0) {
	    update_pesi(object+mobjn);
	    release_object();
	  }
	  kissevent_handler(EVE_RELEASE, catched_cell2);
	  catched_cell2 = -1;
	  catched_cell = -1;
	}
	press_menu(&ev.xbutton);
	break;
      case BUTTON_FUNC_COMMENT:
	unmap_comment();
	press_menu(&ev.xbutton);
	break;
      }
      break;
    case EnterNotify:
      if (ev.xcrossing.window == imgwin ||
	  ev.xcrossing.window == comwin) {
	if (catched_cell >= 0)
	  cursor_grip();
	else if (catched_cell == -2)
	  cursor_scroll();
	else
	  cursor_hand();
      }
      enter_menu(&ev.xcrossing);
      break;
    case LeaveNotify:
      leave_menu(&ev.xcrossing);
      break;
    case KeyPress:
      key_event(&ev.xkey);
      break;
    case ConfigureNotify:
      resize_topwin(ev.xconfigure.width, ev.xconfigure.height);
      break;
    case MapNotify:
      mapped = True;
      if (first_map) {
	i = cset;
	cset = -1;
	change_setpal(i, -1);	/* trigger first set event */
	kissevent_handler(EVE_VERSION, 2);
	if (!(kissevent_handler(EVE_BEGIN, 0) & ACTBIT_SOUND))
	  play_startup_sound();
	if (!event_detect)
	  bg_exit();		/* terminate background process */
	first_map = False;
      }
      break;
    case UnmapNotify:
      unmap_comment();
      break;
    case MappingNotify:
      XRefreshKeyboardMapping(&ev.xmapping);
      break;
    case ClientMessage:
      debug_printf("ClientMessage message_type %ld, format %d, data %ld\n",
		   ev.xclient.message_type,
		   ev.xclient.format,
		   ev.xclient.data.l[0]);
      if (ev.xclient.data.l[0] == wm_delete_window)
	quit_flag = 1;
      break;
    }
    if (mobjn >= 0)
      move_object(mobjn, mobjx, mobjy);
    image_scroll();
    if (test_mode == 1 && mapped && !XEventsQueued(dsp, QueuedAfterFlush)) {
      if (!change_setpal(cset+1, -1)) {
	test_mode = 2;		/* test Done. */
	change_menu_func(1);	/* Quit */
      }
      XSync(dsp, 0);
    }
  }
  kissevent_handler(EVE_END, 0);
  kiss_exit(0);
  return 0;			/* NOT REACHED */
}

/* End of file */
