#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999, 1999, 2000
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
#
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
#
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/examples/misc/server.py,v $
# Version:      @(#)$RCSfile: server.py,v $ $Revision: 1.22 $
#
#############################################################################
""" Implementation of the ExampleIF interface. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Stubs and skeletons generated by 'fnidl'.
import Example, Example_skel


class SpriteServer(Example_skel.Sprite_skel):

    def __init__(self, name):
        CORBA.Object_skel.__init__(self)
        self._name = name

    def get_name(self):
        return self._name;

class ExampleServer(Example_skel.ExampleIF_skel):
    """ Implementation of the 'ExampleIF' interface. """

    def __init__(self):

        # Base class constructor.
        CORBA.Object_skel.__init__(self)

        self.width = 100
        self.quality = 'shoddy!'
        return

    def hello_world(self):
        return "Hello CORBA World!"

    # Ok, spot the difference ;^)
    def double_it(self, n):
        return n * 2

    def double_it_again(self, n):
        return n * 2

    def double_it_one_last_time(self, n):
        return n * 2

    def move_by(self, p, delta_x, delta_y):

        return Example.ExampleIF.Point(p.x + delta_x, p.y + delta_y)
    
    def take_tree(self, tree):

        self.print_tree(tree, 0)

    def print_indent(self, indent_level):
        
        print ' ' * (indent_level * 2),

    def print_tree(self, tree, indent_level):

        self.print_indent(indent_level)
        print "Name:", tree.name

        for child in tree.children:
            self.print_tree(child, indent_level+1)
        
    def take_that(self, u):

        (discriminator, value) = (u.d, u.v)
        if discriminator == 0:
            print 'Got long', value

        elif discriminator == 1:
            print 'Got float', value

        else:
            print 'Got string', value

        return

    def ten_hello_worlds(self, x):

        return ["hello world"] * 10

    def lots_of_hello_worlds(self, n):

        return ["hello world"] * n

    def next_color(self, c):

        if c == Example.ExampleIF.red:
            next = Example.ExampleIF.green

        elif c == Example.ExampleIF.green:
            next = Example.ExampleIF.blue

        else:
            next = Example.ExampleIF.red

        return next

    def get_beer(self):

        raise Example.ExampleIF.DOH("Moe's is shut!")

    def get_peanuts(self):

        raise CORBA.NO_MEMORY()

    def _get_width(self):
        return self.width

    def _set_width(self, width):
        self.width = width
        return

    def _get_quality(self):
        return self.quality


    def create_sprite(self, name):
        boa = BOA.BOA_init()

        obj = boa.create(name, SpriteServer._FNORB_ID)
        sprite = SpriteServer(name)
        boa.obj_is_ready(obj, sprite)

        return obj

    def take_nested_struct(self, outer_struct):
        print "Outer struct:"
        print "  l:", outer_struct.l
        print "  Inner struct:"
        print "    x:", outer_struct.inner.x
        print "    y:", outer_struct.inner.y

    def take_nested_struct_with_union(self, outer_struct):
        print "Outer struct with union:"
        print "  l:", outer_struct.l
        print "  Inner union:"
        if outer_struct.inner.d:
            print "    x:", outer_struct.inner.v
        else:
            print "    y:", outer_struct.inner.v

    def take_nested_union(self, outer_union):
        print "Outer union with struct:"
        if outer_union.d:
            print "  l:", outer_union.v
        else:
            if outer_union.v.d:
                print "    x:", outer_union.v.v
            else:
                print "    y:", outer_union.v.v

    def take_nested_union_with_struct(self, outer_union):
        print "Outer union with struct:"
        if outer_union.d:
            print "  l:", outer_union.v
        else:
            print "  Inner struct:"
            print "    x:", outer_union.v.x
            print "    y:", outer_union.v.y
        
    def quit(self):

        boa = BOA.BOA_init()
        boa._fnorb_quit()

        return

def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(argv, BOA.BOA_ID)

    print 'Creating object reference...'

    # Create an object reference ('fred' is the object key).
    obj = boa.create('fred', ExampleServer._FNORB_ID)

    print 'Creating implementation...'

    # Create an instance of the implementation class.
    impl = ExampleServer()

    print 'Activating the implementation...'

    # Activate the implementation (ie. connect the generated object reference
    # to the implementation).  Note that the implementation will not receive
    # any operation requests until we start the event loop (see below).
    boa.obj_is_ready(obj, impl)

    # Write the stringified object reference to a file (this is just a 'cheap
    # and cheerful' way of making the object reference available to the
    # client!).
    ref_file = open('Server.ref', 'w')
    ref_file.write(orb.object_to_string(obj))
    ref_file.close()

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    print 'Server complete!'

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    try:
        sys.exit(main(sys.argv))
    except KeyboardInterrupt:
        print
        print "Server done"

#############################################################################
