#***************************************************************************
#                            kalyptusDataDict.pm -  A Qt/KDE types data dictionary
#                             -------------------
#    begin                : Fri Oct 20 12:00:00 2000
#    copyright            : (C) 2000-2001 Lost Highway Ltd. All Rights Reserved.
#    email                : Richard_Dale@tipitina.demon.co.uk
#    author               : Richard Dale.
#***************************************************************************/

#/***************************************************************************
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License as published by  *
# *   the Free Software Foundation; either version 2 of the License, or     *
# *   (at your option) any later version.                                   *
# *                                                                         *
#***************************************************************************/

package kalyptusDataDict;

use strict;
no strict "subs";

use vars qw/ %interfacemap %ctypemap %pastypemap %builtins %pasenummap/;

BEGIN
{
%interfacemap = (
'QPaintDevice' => 'QPaintDeviceInterface',
'QMenuData' => 'QMenuDataInterface',
'QRangeControl' => 'QRangeControlInterface',
'QMimeSource' => 'QMimeSourceInterface',
'QLayoutItem' => 'QLayoutItemInterface',
'QUrl' => 'QUrlInterface',
'QIODevice' => 'QIODeviceInterface',
'QXmlContentHandler' => 'QXmlContentHandlerInterface',
'QXmlErrorHandler' => 'QXmlErrorHandlerInterface',
'QXmlDTDHandler' => 'QXmlDTDHandlerInterface',
'QXmlEntityResolver' => 'QXmlEntityResolverInterface',
'QXmlLexicalHandler' => 'QXmlLexicalHandlerInterface',
'QXmlDeclHandler' => 'QXmlDeclHandlerInterface',
'KInstance' => 'KInstanceInterface',
'QwAbsSpriteFieldView' => 'QwAbsSpriteFieldViewInterface',
'PartBase' => 'PartBaseInterface',
'KCompletionBase' => 'KCompletionBaseInterface',
'KDirNotify' => 'KDirNotifyInterface',
'KXMLGUIClient' => 'KXMLGUIClientInterface',
'KFileView' => 'KFileViewInterface',
'KXMLGUIBuilder' => 'KXMLGUIBuilderInterface',
'DCOPObject' => 'DCOPObjectInterface',
'KDevCore' => 'KDevCoreInterface',
'QSqlQuery' => 'QSqlQueryInterface',
);

%pasenummap = (
'QtKey_Key_Agrave' => 'QtKey_Key_UCAgrave',
'QtKey_Key_Aacute' => 'QtKey_Key_UCAacute',
'QtKey_Key_Acircumflex' => 'QtKey_Key_UCAcircumflex',
'QtKey_Key_Atilde' => 'QtKey_Key_UCAtilde',
'QtKey_Key_Adiaeresis' => 'QtKey_Key_UCAdiaeresis',
'QtKey_Key_Aring' => QtKey_Key_UCAring,
'QtKey_Key_AE' => 'QtKey_Key_UCAE',
'QtKey_Key_Ccedilla' => 'QtKey_Key_UCCcedilla',
'QtKey_Key_Egrave' => 'QtKey_Key_UCEgrave',
'QtKey_Key_Eacute' => 'QtKey_Key_UCEacute',
'QtKey_Key_Ecircumflex' => 'QtKey_Key_UCEcircumflex',
'QtKey_Key_Ediaeresis' => 'QtKey_Key_UCEdiaeresis',
'QtKey_Key_Igrave' => 'QtKey_Key_UCIgrave',
'QtKey_Key_Iacute' => 'QtKey_Key_UCIacute',
'QtKey_Key_Icircumflex' => 'QtKey_Key_UCIcircumflex',
'QtKey_Key_Idiaeresis' => 'QtKey_Key_UCIdiaeresis',
'QtKey_Key_Ntilde' => 'QtKey_Key_UCNtilde',
'QtKey_Key_Ograve' => 'QtKey_Key_UCOgrave',
'QtKey_Key_Oacute' => 'QtKey_Key_UCOacute',
'QtKey_Key_Ocircumflex' => 'QtKey_Key_UCOcircumflex',
'QtKey_Key_Otilde' => 'QtKey_Key_UCOtilde',
'QtKey_Key_Odiaeresis' => 'QtKey_Key_UCOdiaeresis',
'QtKey_Key_Ooblique' => 'QtKey_Key_UCOoblique',
'QtKey_Key_Ugrave' => 'QtKey_Key_UCUgrave',
'QtKey_Key_Uacute' => 'QtKey_Key_UCUacute',
'QtKey_Key_Ucircumflex' => 'QtKey_Key_UCUcircumflex',
'QtKey_Key_Udiaeresis' => 'QtKey_Key_UCUdiaeresis',
'QtKey_Key_Yacute' => 'QtKey_Key_UCYacute',
'QLCDNumberMode_HEX' => 'LCDNumberMode_Hex_',
'QLCDNumberMode_DEC' => 'LCDNumberMode_Dec_',
'QLCDNumberMode_OCT' => 'LCDNumberMode_Oct_',
'QLCDNumberMode_BIN' => 'LCDNumberMode_Bin_',
'QNetworkProtocolOperation_OpMkdir' => 'NetworkProtocolOperation_OpMkDir_',
'QNetworkProtocolError_ErrMkdir' => 'QNetworkProtocolError_ErrMkDir_',
'QtKey_Key_BackTab' => 'QtKey_Key_Backtab_',
'QtKey_Key_BackSpace' => 'QtKey_Key_Backspace_',
'QtKey_Key_ETH' => 'QtKey_Key_UCETH',
'QtKey_Key_THORN' => 'QtKey_Key_UCTHORN',
);

%pastypemap = (
'ASConsumer*' => 'PASConsumer',
'ASProducer*' => 'PASProducer',
'ASYNC'  =>  'void' ,
'Address&'  =>  'kde_Address*' ,
'Address*' => 'PAddress',
'AddressBook*' => 'PAddressBook',
'AddressBook::Entry&'  =>  'kde_Entry*' ,
'Addressee&' => 'kde_Addressee*',
'Addressee*' => 'PAddressee',
'AddresseeData*' => 'PAddresseeData',
'AddresseeDialog*' => 'PAddresseeDialog',
'AddresseeItem*' => 'PAddresseeItem',
'AlsaOut*' => 'PAlsaOut',
'AnyConstRef&' => 'kde_AnyConstRef*',
'AnyConstRef*' => 'PAnyConstRef',
'AnyRef&' => 'kde_AnyRef*',
'AnyRef*' => 'PAnyRef',
'AnyRefBase&' => 'kde_AnyRefBase*',
'AnyRefBase*' => 'PAnyRefBase',
'ArgList'  =>  'longint' ,
'ArrowType'  =>  'longint' ,
'Arts*' => 'PArts',
'Arts::AudioManagerClient' => 'longint',
'Arts::Buffer&' => 'kde_Arts_Buffer*',
'Arts::Buffer*' => 'kde_Arts_Buffer*',
'Arts::ByteSoundProducer' => 'kde_Arts_ByteSoundProducer*',
'Arts::Connection*' => 'kde_Arts_Connection*',
'Arts::DynamicCast&' => 'kde_Arts_DynamicCast*',
'Arts::FlowSystemReceiver' => 'kde_Arts_FlowSystemReceiver*',
'Arts::FlowSystemSender' => 'kde_Arts_FlowSystemSender*',
'Arts::Format&' => 'kde_Arts_Format*',
'Arts::Format' => 'kde_Arts_Format',
'Arts::GenericAsyncStream*' => 'kde_Arts_GenericAsyncStream*',
'Arts::GenericDataChannel*' => 'kde_Arts_GenericDataChannel*',
'Arts::InterfaceDef' => 'kde_Arts_InterfaceDef*',
'Arts::MethodDef&' => 'kde_Arts_MethodDef*',
'Arts::ModuleDef&' => 'kde_Arts_ModuleDef*',
'Arts::Notification&' => 'kde_Arts_Notification*',
'Arts::Object' => 'kde_Arts_Object*',
'Arts::Object::Pool&' => 'kde_Arts_Object_Pool*',
'Arts::ObjectReference' => 'kde_Arts_ObjectReference*',
'Arts::PlayObject' => 'kde_Arts_PlayObject*',
'Arts::Reference&' => 'kde_Arts_Reference*',
'Arts::StereoEffect' => 'kde_Arts_StereoEffect*',
'Arts::StereoEffectStack' => 'kde_Arts_StereoEffectStack*',
'Arts::SubClass&' => 'kde_Arts_SubClass*',
'Arts::TypeDef' => 'kde_Arts_TypeDef*',
'Arts::poTime&' => 'kde_Arts_poTime*',
'Arts::poTime' => 'kde_Arts_poTime',
'AsyncStream*' => 'PAsyncStream',
'Attr&' => 'kde_Attr*',
'Attr' => 'kde_Attr*',
'Attr*' => 'PAttr',
'AttrImpl*' => 'PAttrImpl',
'AttributeDef&' => 'kde_AttributeDef*',
'AttributeDef*' => 'PAttributeDef',
'AudioManager&' => 'kde_AudioManager*',
'AudioManager' => 'kde_AudioManager*',
'AudioManager*' => 'PAudioManager',
'AudioManagerClient&' => 'kde_AudioManagerClient*',
'AudioManagerClient' => 'kde_AudioManagerClient*',
'AudioManagerClient*' => 'PAudioManagerClient',
'AudioManagerClient_base*' => 'PAudioManagerClient_base',
'AudioManagerClient_skel*' => 'PAudioManagerClient_skel',
'AudioManagerClient_stub*' => 'PAudioManagerClient_stub',
'AudioManagerInfo&' => 'kde_AudioManagerInfo*',
'AudioManagerInfo*' => 'PAudioManagerInfo',
'AudioManager_base*' => 'PAudioManager_base',
'AudioManager_skel*' => 'PAudioManager_skel',
'AudioManager_stub*' => 'PAudioManager_stub',
'AudioPort*' => 'PAudioPort',
'AudioSubSystem*' => 'PAudioSubSystem',
'AudioSubSystemStart*' => 'PAudioSubSystemStart',
'AuthAccept&' => 'kde_AuthAccept*',
'AuthAccept*' => 'PAuthAccept',
'AuthInfo&' => 'kde_AuthInfo*',
'AuthInfo*' => 'PAuthInfo',
'BGMode' => 'longint',
'BMToken*' => 'PBMToken',
'BackgroundMode' => 'longint',
'BlockSelectionInterface*' => 'PBlockSelectionInterface',
'BookmarkTokenizer*' => 'PBookmarkTokenizer',
'Bool'  =>  'longint' ,
'Boolean&' => 'var boolean',
'Boolean*' => 'pboolean',
'BrowserExtension*' => 'PBrowserExtension',
'BrowserHostExtension*' => 'PBrowserHostExtension',
'BrowserInterface*' => 'PBrowserInterface',
'BrushStyle' => 'longint',
'Buffer&' => 'kde_Buffer*',
'Buffer*' => 'PBuffer',
'ButtonCode'  =>  'longint' ,
'ButtonState'  =>  'longint' ,
'ByteAsyncStream*' => 'PByteAsyncStream',
'ByteDataPacket*' => 'PByteDataPacket',
'ByteSoundProducer&' => 'kde_ByteSoundProducer*',
'ByteSoundProducer' => 'kde_ByteSoundProducer*',
'ByteSoundProducer*' => 'PByteSoundProducer',
'ByteSoundProducer_base*' => 'PByteSoundProducer_base',
'ByteSoundProducer_skel*' => 'PByteSoundProducer_skel',
'ByteSoundProducer_stub*' => 'PByteSoundProducer_stub',
'ByteStreamToAudio&' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio*' => 'PByteStreamToAudio',
'ByteStreamToAudio_base*' => 'PByteStreamToAudio_base',
'ByteStreamToAudio_skel*' => 'PByteStreamToAudio_skel',
'ByteStreamToAudio_stub*' => 'PByteStreamToAudio_stub',
'CDATASection&' => 'kde_CDATASection*',
'CDATASection' => 'kde_CDATASection*',
'CDATASection*' => 'PCDATASection',
'CFlags' => 'longint',
'COORD'  =>  'word' ,
'CSSCharsetRule&' => 'kde_CSSCharsetRule*',
'CSSCharsetRule*' => 'PCSSCharsetRule',
'CSSCharsetRuleImpl*' => 'PCSSCharsetRuleImpl',
'CSSException&' => 'kde_CSSException*',
'CSSException*' => 'PCSSException',
'CSSFontFaceRule&' => 'kde_CSSFontFaceRule*',
'CSSFontFaceRule*' => 'PCSSFontFaceRule',
'CSSFontFaceRuleImpl*' => 'PCSSFontFaceRuleImpl',
'CSSImportRule&' => 'kde_CSSImportRule*',
'CSSImportRule*' => 'PCSSImportRule',
'CSSImportRuleImpl*' => 'PCSSImportRuleImpl',
'CSSMediaRule&' => 'kde_CSSMediaRule*',
'CSSMediaRule*' => 'PCSSMediaRule',
'CSSMediaRuleImpl*' => 'PCSSMediaRuleImpl',
'CSSPageRule&' => 'kde_CSSPageRule*',
'CSSPageRule*' => 'PCSSPageRule',
'CSSPageRuleImpl*' => 'PCSSPageRuleImpl',
'CSSPrimitiveValue&' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue*' => 'PCSSPrimitiveValue',
'CSSPrimitiveValueImpl*' => 'PCSSPrimitiveValueImpl',
'CSSRule&' => 'kde_CSSRule*',
'CSSRule' => 'kde_CSSRule*',
'CSSRule*' => 'PCSSRule',
'CSSRuleImpl*' => 'PCSSRuleImpl',
'CSSRuleList&' => 'kde_CSSRuleList*',
'CSSRuleList' => 'kde_CSSRuleList*',
'CSSRuleList*' => 'PCSSRuleList',
'CSSRuleListImpl*' => 'PCSSRuleListImpl',
'CSSStyleDeclaration&' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration*' => 'PCSSStyleDeclaration',
'CSSStyleDeclarationImpl*' => 'PCSSStyleDeclarationImpl',
'CSSStyleRule&' => 'kde_CSSStyleRule*',
'CSSStyleRule*' => 'PCSSStyleRule',
'CSSStyleRuleImpl*' => 'PCSSStyleRuleImpl',
'CSSStyleSheet&' => 'kde_CSSStyleSheet*',
'CSSStyleSheet' => 'kde_CSSStyleSheet*',
'CSSStyleSheet*' => 'PCSSStyleSheet',
'CSSStyleSheetImpl*' => 'PCSSStyleSheetImpl',
'CSSUnknownRule&' => 'kde_CSSUnknownRule*',
'CSSUnknownRule*' => 'PCSSUnknownRule',
'CSSUnknownRuleImpl*' => 'PCSSUnknownRuleImpl',
'CSSValue&' => 'kde_CSSValue*',
'CSSValue' => 'kde_CSSValue*',
'CSSValue*' => 'PCSSValue',
'CSSValueImpl*' => 'PCSSValueImpl',
'CSSValueList&' => 'kde_CSSValueList*',
'CSSValueList*' => 'PCSSValueList',
'CSSValueListImpl*' => 'PCSSValueListImpl',
'CString&' => 'kde_CString*',
'CString' => 'kde_CString*',
'CString*' => 'PCString',
'Cache*' => 'PCache',
'CacheInfo*' => 'PCacheInfo',
'CachedObject*' => 'PCachedObject',
'CachedWav*' => 'PCachedWav',
'Cardinal'  =>  'longint' ,
'CharSet' => 'longint',
'CharacterData&' => 'kde_CharacterData*',
'CharacterData*' => 'PCharacterData',
'CharacterDataImpl*' => 'PCharacterDataImpl',
'ChmodJob*' => 'PChmodJob',
'ClassInfo*' => 'PClassInfo',
'ClassStore*' => 'PClassStore',
'ClassTreeNode*' => 'PClassTreeNode',
'ClientHello&' => 'kde_ClientHello*',
'ClientHello*' => 'PClientHello',
'ClipboardInterface*' => 'PClipboardInterface',
'CodeCompletionInterface*' => 'PCodeCompletionInterface',
'ColorMode' => 'longint',
'Comment&' => 'kde_Comment*',
'Comment' => 'kde_Comment*',
'Comment*' => 'PComment',
'CommentImpl*' => 'PCommentImpl',
'ComparisonFlags' => 'longint',
'Compl' => 'kde_Compl',
'Completion&' => 'kde_Completion*',
'Completion*' => 'PCompletion',
'CompletionEntry&' => 'kde_CompletionEntry*',
'CompletionEntry*' => 'PCompletionEntry',
'ComplexControl' => 'longint',
'ComponentFactory*' => 'PComponentFactory',
'ConfigInterface*' => 'PConfigInterface',
'Connection*' => 'PConnection',
'ConstIterator'  =>  'longint' ,
'Constructor' => 'kde_Constructor*',
'Constructor*' => 'PConstructor',
'ConstructorImp*' => 'PConstructorImp',
'ContentsType' => 'longint',
'Context&' => 'kde_Context*',
'Context*' => 'PContext',
'ControlElement' => 'longint',
'CopyInfo*' => 'PCopyInfo',
'CopyJob*' => 'PCopyJob',
'Core*' => 'PCore',
'Counter&' => 'kde_Counter*',
'Counter' => 'kde_Counter*',
'Counter*' => 'PCounter',
'Cursor*' => 'PCursor',
'CursorInterface*' => 'PCursorInterface',
'DCOPClient*' => 'PDCOPClient',
'DCOPClientTransaction*'  =>  'kde_DCOPClientTransaction*' ,
'DCOPObject*' => 'PDCOPObject',
'DCOPObjectProxy*' => 'PDCOPObjectProxy',
'DCOPRef&'  =>  'kde_DCOPRef*' ,
'DCOPRef*' => 'PDCOPRef',
'DCOPStub*' => 'PDCOPStub',
'DOM*' => 'PDOM',
'DOM::CSSProperty*'  =>  'kde_CSSProperty*' ,
'DOM::DOMString&'  =>  'kde_DOMString*' ,
'DOM::DOMString'  =>  'kde_DOMString*' ,
'DOM::Document&'  =>  'kde_DOMDocument*' ,
'DOM::Document'  =>  'kde_DOMDocument*' ,
'DOM::Document*'  =>  'kde_DOMDocument*' ,
'DOM::ElementImpl*'  =>  'kde_DOM_ElementImpl*' ,
'DOM::HTMLDocument'  =>  'kde_HTMLDocument*' ,
'DOM::MediaList&' => 'kde_MediaList*',
'DOM::MediaList' => 'kde_MediaList',
'DOM::MediaList*' => 'kde_MediaList*',
'DOM::Node&'  =>  'kde_DOMNode*' ,
'DOM::Node'  =>  'kde_DOMNode*' ,
'DOM::NodeList&' => 'kde_DOMNodeList*',
'DOM::NodeList' => 'kde_DOMNodeList*',
'DOM::NodeList*' => 'kde_DOMNodeList*',
'DOM::Range'  =>  'kde_Range*' ,
'DOM::StyleSheetList&' => 'kde_StyleSheetList*',
'DOM::StyleSheetList' => 'kde_StyleSheetList',
'DOM::StyleSheetList*' => 'kde_StyleSheetList*',
'DOMException&' => 'kde_DOMException*',
'DOMException*' => 'PDOMException',
'DOMImplementation&' => 'kde_DOMImplementation*',
'DOMImplementation' => 'kde_DOMImplementation*',
'DOMImplementation*' => 'PDOMImplementation',
'DOMImplementationImpl*' => 'PDOMImplementationImpl',
'DOMString&' => 'kde_DOMString*',
'DOMString' => 'kde_DOMString*',
'DOMString*' => 'PDOMString',
'DOMStringImpl*' => 'PDOMStringImpl',
'DW_EXPORT*' => 'pointer',
'DataPacket*' => 'PDataPacket',
'DateFormat' => 'longint',
'Debug*' => 'PDebug',
'DecoderFn'  =>  'longint' ,
'DefaultProgress*' => 'PDefaultProgress',
'DeleteJob*' => 'PDeleteJob',
'DeviceManager*' => 'PDeviceManager',
'Direction' => 'longint',
'DispatchFunction' => 'kde_DispatchFunction*',
'Dispatcher*' => 'PDispatcher',
'Display' => 'Display',
'Display*' => 'PDisplay',
'DistributionList*' => 'PDistributionList',
'DistributionListEditor*' => 'PDistributionListEditor',
'DistributionListManager*' => 'PDistributionListManager',
'Dock&' => 'longint',
'Dock' => 'longint',
'DockMainWindow*' => 'PDockMainWindow',
'DockPosData&'  =>  'kde_DockPosData*' ,
'DockPosData*' => 'PDockPosData',
'DockWindowData*' => 'longint',
'Document&' => 'kde_Document*',
'Document' => 'kde_Document*',
'Document*' => 'PDocument',
'DocumentFragment&' => 'kde_DocumentFragment*',
'DocumentFragment' => 'kde_DocumentFragment*',
'DocumentFragment*' => 'PDocumentFragment',
'DocumentFragmentImpl*' => 'PDocumentFragmentImpl',
'DocumentImpl*' => 'PDocumentImpl',
'DocumentStyle&' => 'kde_DocumentStyle*',
'DocumentStyle*' => 'PDocumentStyle',
'DocumentType&' => 'kde_DocumentType*',
'DocumentType' => 'kde_DocumentType*',
'DocumentType*' => 'PDocumentType',
'DocumentationContext*' => 'PDocumentationContext',
'DomShared*' => 'PDomShared',
'DrageMode' => 'longint',
'DrawContentsEvent*' => 'PDrawContentsEvent',
'DwAddress&' => 'kde_DwAddress*',
'DwAddress*' => 'PDwAddress',
'DwAddressList&' => 'kde_DwAddressList*',
'DwAddressList*' => 'PDwAddressList',
'DwBody&' => 'kde_DwBody*',
'DwBody*' => 'PDwBody',
'DwBodyPart&' => 'kde_DwBodyPart*',
'DwBodyPart*' => 'PDwBodyPart',
'DwBool' => 'longint',
'DwDateTime&' => 'kde_DwDateTime*',
'DwDateTime*' => 'PDwDateTime',
'DwDispositionType&' => 'kde_DwDispositionType*',
'DwDispositionType*' => 'PDwDispositionType',
'DwEntity&' => 'kde_DwEntity*',
'DwField&' => 'kde_DwField*',
'DwField*' => 'PDwField',
'DwFieldBody&' => 'kde_DwFieldBody*',
'DwFieldBody*' => 'PDwFieldBody',
'DwGroup&' => 'kde_DwGroup*',
'DwGroup*' => 'PDwGroup',
'DwHeaders&' => 'kde_DwHeaders*',
'DwHeaders*' => 'PDwHeaders',
'DwInt32' => 'longint',
'DwMailbox&' => 'kde_DwMailbox*',
'DwMailbox*' => 'PDwMailbox',
'DwMailboxList&' => 'kde_DwMailboxList*',
'DwMailboxList*' => 'PDwMailboxList',
'DwMechanism&' => 'kde_DwMechanism*',
'DwMechanism*' => 'PDwMechanism',
'DwMediaType&' => 'kde_DwMediaType*',
'DwMediaType*' => 'PDwMediaType',
'DwMessage&' => 'kde_DwMessage*',
'DwMessage*' => 'PDwMessage',
'DwMessageComponent&' => 'kde_DwMessageComponent*',
'DwMessageComponent*' => 'PDwMessageComponent',
'DwMime*' => 'PDwMime',
'DwMsgId&' => 'kde_DwMsgId*',
'DwMsgId*' => 'PDwMsgId',
'DwObserver*' => 'PDwObserver',
'DwParameter&' => 'kde_DwParameter*',
'DwParameter*' => 'PDwParameter',
'DwProtocolClient*' => 'PDwProtocolClient',
'DwString&' => 'kde_DwString*',
'DwString' => 'kde_DwString',
'DwString*' => 'PDwString',
'DwText&' => 'kde_DwText*',
'DwText*' => 'PDwText',
'DwTokenizer&' => 'kde_DwTokenizer*',
'DwUint16' => 'word',
'DwUint32' => 'dword',
'DwUint8' => 'byte',
'DynamicCast*' => 'PDynamicCast',
'DynamicRequest&' => 'kde_DynamicRequest*',
'DynamicRequest*' => 'PDynamicRequest',
'EXPORT_DOCKCLASS*' => 'PEXPORT_DOCKCLASS',
'EchoMode' => 'longint',
'EditInterface*' => 'PEditInterface',
'Editor*' => 'PEditor',
'EditorContext*' => 'PEditorContext',
'Element&' => 'kde_Element*',
'Element' => 'kde_Element*',
'Element*' => 'PElement',
'ElementImpl*' => 'PElementImpl',
'EmailSelectDialog*' => 'PEmailSelectDialog',
'EncoderFn'  =>  'longint' ,
'Endian' => 'longint',
'Entity&' => 'kde_Entity*',
'Entity*' => 'PEntity',
'EntityReference&' => 'kde_EntityReference*',
'EntityReference' => 'kde_EntityReference*',
'EntityReference*' => 'PEntityReference',
'Entry&'  =>  'kde_Entry*' ,
'Entry*' => 'PEntry',
'Entry::Address&'  =>  'kde_EntryAddress' ,
'EnumComponent&' => 'kde_EnumComponent*',
'EnumComponent*' => 'PEnumComponent',
'EnumDef&' => 'kde_EnumDef*',
'EnumDef*' => 'PEnumDef',
'EnumEntry*' => 'PEnumEntry',
'Error*' => 'PError',
'Event*' => 'PEvent',
'ExecState*' => 'PExecState',
'ExtensionLoader*' => 'PExtensionLoader',
'FALSE' => '0',
'FILE*' => 'PFILE',
'FMOut*' => 'PFMOut',
'Factory*' => 'PFactory',
'False' => '0',
'FileCopyJob*' => 'PFileCopyJob',
'FileProtocol*' => 'PFileProtocol',
'FileView&'  =>  'longint' ,
'FloatAsyncStream*' => 'PFloatAsyncStream',
'FloatDataPacket*' => 'PFloatDataPacket',
'FlowSystem&' => 'kde_FlowSystem*',
'FlowSystem' => 'kde_FlowSystem*',
'FlowSystem*' => 'PFlowSystem',
'FlowSystemReceiver&' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver*' => 'PFlowSystemReceiver',
'FlowSystemReceiver_base*' => 'PFlowSystemReceiver_base',
'FlowSystemReceiver_skel*' => 'PFlowSystemReceiver_skel',
'FlowSystemReceiver_stub*' => 'PFlowSystemReceiver_stub',
'FlowSystemSender&' => 'kde_FlowSystemSender*',
'FlowSystemSender' => 'kde_FlowSystemSender*',
'FlowSystemSender*' => 'PFlowSystemSender',
'FlowSystemSender_base*' => 'PFlowSystemSender_base',
'FlowSystemSender_skel*' => 'PFlowSystemSender_skel',
'FlowSystemSender_stub*' => 'PFlowSystemSender_stub',
'FlowSystem_base*' => 'PFlowSystem_base',
'FlowSystem_impl*' => 'PFlowSystem_impl',
'FlowSystem_skel*' => 'PFlowSystem_skel',
'FlowSystem_stub*' => 'PFlowSystem_stub',
'FocusPolicy' => 'longint',
'Format&' => 'kde_Format*',
'Format*' => 'PFormat',
'Function*' => 'PFunction',
'FunctionImp*' => 'PFunctionImp',
'GCI&'  =>  'GCI*' ,
'GCI'  =>  'GCI*' ,
'GCI*'  =>  'GCI*' ,
'GUIActivateEvent*' => 'PGUIActivateEvent',
'GUIStyle' => 'longint',
'GUSOut*' => 'PGUSOut',
'GenericAsyncStream*' => 'PGenericAsyncStream',
'GenericDataChannel*' => 'PGenericDataChannel',
'GenericDataPacket*' => 'PGenericDataPacket',
'GenericFactory*' => 'PGenericFactory',
'GenericFactoryBase*' => 'PGenericFactoryBase',
'Global*' => 'PGlobal',
'GlobalComm&' => 'kde_GlobalComm*',
'GlobalComm' => 'kde_GlobalComm*',
'GlobalComm*' => 'PGlobalComm',
'GlobalComm_base*' => 'PGlobalComm_base',
'GlobalComm_skel*' => 'PGlobalComm_skel',
'GlobalComm_stub*' => 'PGlobalComm_stub',
'Qt::HANDLE' => 'dword',
'HANDLE' => 'dword',
'HBITMAP'  =>  'pointer' ,
'HCURSOR'  =>  'void *' ,
'HDC'  =>  'void *' ,
'HFONT'  =>  'void *' ,
'HPALETTE'  =>  'void *' ,
'HRGN'  =>  'void *' ,
'HTMLAnchorElement&' => 'kde_HTMLAnchorElement*',
'HTMLAnchorElement*' => 'PHTMLAnchorElement',
'HTMLAnchorElementImpl*' => 'PHTMLAnchorElementImpl',
'HTMLAppletElement&' => 'kde_HTMLAppletElement*',
'HTMLAppletElement*' => 'PHTMLAppletElement',
'HTMLAppletElementImpl*' => 'PHTMLAppletElementImpl',
'HTMLAreaElement&' => 'kde_HTMLAreaElement*',
'HTMLAreaElement*' => 'PHTMLAreaElement',
'HTMLAreaElementImpl*' => 'PHTMLAreaElementImpl',
'HTMLBRElement&' => 'kde_HTMLBRElement*',
'HTMLBRElement*' => 'PHTMLBRElement',
'HTMLBRElementImpl*' => 'PHTMLBRElementImpl',
'HTMLBaseElement&' => 'kde_HTMLBaseElement*',
'HTMLBaseElement*' => 'PHTMLBaseElement',
'HTMLBaseElementImpl*' => 'PHTMLBaseElementImpl',
'HTMLBaseFontElement&' => 'kde_HTMLBaseFontElement*',
'HTMLBaseFontElement*' => 'PHTMLBaseFontElement',
'HTMLBaseFontElementImpl*' => 'PHTMLBaseFontElementImpl',
'HTMLBlockquoteElement&' => 'kde_HTMLBlockquoteElement*',
'HTMLBlockquoteElement*' => 'PHTMLBlockquoteElement',
'HTMLBlockquoteElementImpl*' => 'PHTMLBlockquoteElementImpl',
'HTMLBodyElement&' => 'kde_HTMLBodyElement*',
'HTMLBodyElement*' => 'PHTMLBodyElement',
'HTMLBodyElementImpl*' => 'PHTMLBodyElementImpl',
'HTMLButtonElement&' => 'kde_HTMLButtonElement*',
'HTMLButtonElement*' => 'PHTMLButtonElement',
'HTMLButtonElementImpl*' => 'PHTMLButtonElementImpl',
'HTMLCollection&' => 'kde_HTMLCollection*',
'HTMLCollection' => 'kde_HTMLCollection*',
'HTMLCollection*' => 'PHTMLCollection',
'HTMLCollectionImpl*' => 'PHTMLCollectionImpl',
'HTMLDListElement&' => 'kde_HTMLDListElement*',
'HTMLDListElement*' => 'PHTMLDListElement',
'HTMLDListElementImpl*' => 'PHTMLDListElementImpl',
'HTMLDirectoryElement&' => 'kde_HTMLDirectoryElement*',
'HTMLDirectoryElement*' => 'PHTMLDirectoryElement',
'HTMLDirectoryElementImpl*' => 'PHTMLDirectoryElementImpl',
'HTMLDivElement&' => 'kde_HTMLDivElement*',
'HTMLDivElement*' => 'PHTMLDivElement',
'HTMLDivElementImpl*' => 'PHTMLDivElementImpl',
'HTMLDocument&' => 'kde_HTMLDocument*',
'HTMLDocument*' => 'PHTMLDocument',
'HTMLDocumentImpl*' => 'PHTMLDocumentImpl',
'HTMLElement&' => 'kde_HTMLElement*',
'HTMLElement' => 'kde_HTMLElement*',
'HTMLElement*' => 'PHTMLElement',
'HTMLElementImpl*' => 'PHTMLElementImpl',
'HTMLFieldSetElement&' => 'kde_HTMLFieldSetElement*',
'HTMLFieldSetElement*' => 'PHTMLFieldSetElement',
'HTMLFieldSetElementImpl*' => 'PHTMLFieldSetElementImpl',
'HTMLFontElement&' => 'kde_HTMLFontElement*',
'HTMLFontElement*' => 'PHTMLFontElement',
'HTMLFontElementImpl*' => 'PHTMLFontElementImpl',
'HTMLFormElement&' => 'kde_HTMLFormElement*',
'HTMLFormElement' => 'kde_HTMLFormElement*',
'HTMLFormElement*' => 'PHTMLFormElement',
'HTMLFormElementImpl*' => 'PHTMLFormElementImpl',
'HTMLFrameElement&' => 'kde_HTMLFrameElement*',
'HTMLFrameElement*' => 'PHTMLFrameElement',
'HTMLFrameElementImpl*' => 'PHTMLFrameElementImpl',
'HTMLFrameSetElement&' => 'kde_HTMLFrameSetElement*',
'HTMLFrameSetElement*' => 'PHTMLFrameSetElement',
'HTMLFrameSetElementImpl*' => 'PHTMLFrameSetElementImpl',
'HTMLHRElement&' => 'kde_HTMLHRElement*',
'HTMLHRElement*' => 'PHTMLHRElement',
'HTMLHRElementImpl*' => 'PHTMLHRElementImpl',
'HTMLHeadElement&' => 'kde_HTMLHeadElement*',
'HTMLHeadElement*' => 'PHTMLHeadElement',
'HTMLHeadElementImpl*' => 'PHTMLHeadElementImpl',
'HTMLHeadingElement&' => 'kde_HTMLHeadingElement*',
'HTMLHeadingElement*' => 'PHTMLHeadingElement',
'HTMLHeadingElementImpl*' => 'PHTMLHeadingElementImpl',
'HTMLHtmlElement&' => 'kde_HTMLHtmlElement*',
'HTMLHtmlElement*' => 'PHTMLHtmlElement',
'HTMLHtmlElementImpl*' => 'PHTMLHtmlElementImpl',
'HTMLIFrameElement&' => 'kde_HTMLIFrameElement*',
'HTMLIFrameElement*' => 'PHTMLIFrameElement',
'HTMLIFrameElementImpl*' => 'PHTMLIFrameElementImpl',
'HTMLImageElement&' => 'kde_HTMLImageElement*',
'HTMLImageElement*' => 'PHTMLImageElement',
'HTMLImageElementImpl*' => 'PHTMLImageElementImpl',
'HTMLInputElement&' => 'kde_HTMLInputElement*',
'HTMLInputElement*' => 'PHTMLInputElement',
'HTMLInputElementImpl*' => 'PHTMLInputElementImpl',
'HTMLIsIndexElement&' => 'kde_HTMLIsIndexElement*',
'HTMLIsIndexElement*' => 'PHTMLIsIndexElement',
'HTMLIsIndexElementImpl*' => 'PHTMLIsIndexElementImpl',
'HTMLLIElement&' => 'kde_HTMLLIElement*',
'HTMLLIElement*' => 'PHTMLLIElement',
'HTMLLIElementImpl*' => 'PHTMLLIElementImpl',
'HTMLLabelElement&' => 'kde_HTMLLabelElement*',
'HTMLLabelElement*' => 'PHTMLLabelElement',
'HTMLLabelElementImpl*' => 'PHTMLLabelElementImpl',
'HTMLLegendElement&' => 'kde_HTMLLegendElement*',
'HTMLLegendElement*' => 'PHTMLLegendElement',
'HTMLLegendElementImpl*' => 'PHTMLLegendElementImpl',
'HTMLLinkElement&' => 'kde_HTMLLinkElement*',
'HTMLLinkElement*' => 'PHTMLLinkElement',
'HTMLLinkElementImpl*' => 'PHTMLLinkElementImpl',
'HTMLMapElement&' => 'kde_HTMLMapElement*',
'HTMLMapElement*' => 'PHTMLMapElement',
'HTMLMapElementImpl*' => 'PHTMLMapElementImpl',
'HTMLMenuElement&' => 'kde_HTMLMenuElement*',
'HTMLMenuElement*' => 'PHTMLMenuElement',
'HTMLMenuElementImpl*' => 'PHTMLMenuElementImpl',
'HTMLMetaElement&' => 'kde_HTMLMetaElement*',
'HTMLMetaElement*' => 'PHTMLMetaElement',
'HTMLMetaElementImpl*' => 'PHTMLMetaElementImpl',
'HTMLModElement&' => 'kde_HTMLModElement*',
'HTMLModElement*' => 'PHTMLModElement',
'HTMLModElementImpl*' => 'PHTMLModElementImpl',
'HTMLOListElement&' => 'kde_HTMLOListElement*',
'HTMLOListElement*' => 'PHTMLOListElement',
'HTMLOListElementImpl*' => 'PHTMLOListElementImpl',
'HTMLObjectElement&' => 'kde_HTMLObjectElement*',
'HTMLObjectElement*' => 'PHTMLObjectElement',
'HTMLObjectElementImpl*' => 'PHTMLObjectElementImpl',
'HTMLOptGroupElement&' => 'kde_HTMLOptGroupElement*',
'HTMLOptGroupElement*' => 'PHTMLOptGroupElement',
'HTMLOptGroupElementImpl*' => 'PHTMLOptGroupElementImpl',
'HTMLOptionElement&' => 'kde_HTMLOptionElement*',
'HTMLOptionElement*' => 'PHTMLOptionElement',
'HTMLOptionElementImpl*' => 'PHTMLOptionElementImpl',
'HTMLParagraphElement&' => 'kde_HTMLParagraphElement*',
'HTMLParagraphElement*' => 'PHTMLParagraphElement',
'HTMLParagraphElementImpl*' => 'PHTMLParagraphElementImpl',
'HTMLParamElement&' => 'kde_HTMLParamElement*',
'HTMLParamElement*' => 'PHTMLParamElement',
'HTMLParamElementImpl*' => 'PHTMLParamElementImpl',
'HTMLPreElement&' => 'kde_HTMLPreElement*',
'HTMLPreElement*' => 'PHTMLPreElement',
'HTMLPreElementImpl*' => 'PHTMLPreElementImpl',
'HTMLQuoteElement&' => 'kde_HTMLQuoteElement*',
'HTMLQuoteElement*' => 'PHTMLQuoteElement',
'HTMLQuoteElementImpl*' => 'PHTMLQuoteElementImpl',
'HTMLScriptElement&' => 'kde_HTMLScriptElement*',
'HTMLScriptElement*' => 'PHTMLScriptElement',
'HTMLScriptElementImpl*' => 'PHTMLScriptElementImpl',
'HTMLSelectElement&' => 'kde_HTMLSelectElement*',
'HTMLSelectElement*' => 'PHTMLSelectElement',
'HTMLSelectElementImpl*' => 'PHTMLSelectElementImpl',
'HTMLStyleElement&' => 'kde_HTMLStyleElement*',
'HTMLStyleElement*' => 'PHTMLStyleElement',
'HTMLStyleElementImpl*' => 'PHTMLStyleElementImpl',
'HTMLTableCaptionElement&' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement*' => 'PHTMLTableCaptionElement',
'HTMLTableCaptionElementImpl*' => 'PHTMLTableCaptionElementImpl',
'HTMLTableCellElement&' => 'kde_HTMLTableCellElement*',
'HTMLTableCellElement*' => 'PHTMLTableCellElement',
'HTMLTableCellElementImpl*' => 'PHTMLTableCellElementImpl',
'HTMLTableColElement&' => 'kde_HTMLTableColElement*',
'HTMLTableColElement*' => 'PHTMLTableColElement',
'HTMLTableColElementImpl*' => 'PHTMLTableColElementImpl',
'HTMLTableElement&' => 'kde_HTMLTableElement*',
'HTMLTableElement*' => 'PHTMLTableElement',
'HTMLTableElementImpl*' => 'PHTMLTableElementImpl',
'HTMLTableRowElement&' => 'kde_HTMLTableRowElement*',
'HTMLTableRowElement*' => 'PHTMLTableRowElement',
'HTMLTableRowElementImpl*' => 'PHTMLTableRowElementImpl',
'HTMLTableSectionElement&' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement*' => 'PHTMLTableSectionElement',
'HTMLTableSectionElementImpl*' => 'PHTMLTableSectionElementImpl',
'HTMLTextAreaElement&' => 'kde_HTMLTextAreaElement*',
'HTMLTextAreaElement*' => 'PHTMLTextAreaElement',
'HTMLTextAreaElementImpl*' => 'PHTMLTextAreaElementImpl',
'HTMLTitleElement&' => 'kde_HTMLTitleElement*',
'HTMLTitleElement*' => 'PHTMLTitleElement',
'HTMLTitleElementImpl*' => 'PHTMLTitleElementImpl',
'HTMLUListElement&' => 'kde_HTMLUListElement*',
'HTMLUListElement*' => 'PHTMLUListElement',
'HTMLUListElementImpl*' => 'PHTMLUListElementImpl',
'HandlerType'  =>  'HandlerTypeH' ,
'HashEntry*' => 'PHashEntry',
'HashTable*' => 'PHashTable',
'Header&' => 'kde_Header*',
'Header*' => 'PHeader',
'HighlightingInterface*' => 'PHighlightingInterface',
'HistoryProvider*' => 'PHistoryProvider',
'HostImp*' => 'PHostImp',
'IDLFileReg*' => 'PIDLFileReg',
'IOManager*' => 'PIOManager',
'IONotify*' => 'PIONotify',
'IOType*' => 'PIOType',
'IOWatchFD*' => 'PIOWatchFD',
'Icon' => 'longint',
'IconListBox*' => 'PIconListBox',
'Imp*' => 'pointer',
'Info*' => 'PInfo',
'InterfaceDef&' => 'kde_InterfaceDef*',
'InterfaceDef' => 'kde_InterfaceDef*',
'InterfaceDef*' => 'PInterfaceDef',
'InterfaceEntry*' => 'PInterfaceEntry',
'InterfaceRepo&' => 'kde_InterfaceRepo*',
'InterfaceRepo' => 'kde_InterfaceRepo*',
'InterfaceRepo*' => 'PInterfaceRepo',
'InterfaceRepo_base*' => 'PInterfaceRepo_base',
'InterfaceRepo_impl*' => 'PInterfaceRepo_impl',
'InterfaceRepo_skel*' => 'PInterfaceRepo_skel',
'InterfaceRepo_stub*' => 'PInterfaceRepo_stub',
'InternalFunctionImp*' => 'PInternalFunctionImp',
'Interpreter*' => 'PInterpreter',
'Invocation&' => 'kde_Invocation*',
'Invocation*' => 'PInvocation',
'Item&'  =>  'var pointer' ,
'Item'  =>  'pointer' ,
'Item*'  =>  'ppointer' ,
'Iterator'  =>  'pointer' ,
'iterator'  =>  'pointer' ,
'_iterator'  =>  'pointer' ,
'Job*' => 'pointer',
'K&'  =>  'var K' ,
'KAboutApplication*' => 'PKAboutApplication',
'KAboutContainer*'  =>  'kde_KAboutContainer*' ,
'KAboutContributor*' => 'PKAboutContributor',
'KAboutData*'  =>  'kde_KAboutData*' ,
'KAboutDialog*' => 'PKAboutDialog',
'KAboutKDE*' => 'PKAboutKDE',
'KAboutPerson*' => 'PKAboutPerson',
'KAboutTranslator*' => 'PKAboutTranslator',
'KAboutWidget*' => 'PKAboutWidget',
'KAccel*'  =>  'kde_KAccel*' ,
'KAccelAction&' => 'kde_KAccelAction*',
'KAccelAction*' => 'PKAccelAction',
'KAccelActions&' => 'kde_KAccelActions*',
'KAccelActions*' => 'PKAccelActions',
'KAccelBase*' => 'PKAccelBase',
'KAccelGen*' => 'PKAccelGen',
'KAccelMenu*' => 'PKAccelMenu',
'KAccelSequence&' => 'kde_KAccelSequence*',
'KAccelSequence' => 'kde_KAccelSequence*',
'KAccelSequence*' => 'PKAccelSequence',
'KAccelShortcut&' => 'kde_KAccelShortcut*',
'KAccelShortcut' => 'kde_KAccelShortcut*',
'KAccelShortcut*' => 'PKAccelShortcut',
'KAccelShortcuts&' => 'kde_KAccelShortcuts*',
'KAccelShortcuts*' => 'PKAccelShortcuts',
'KAction*'  =>  'kde_KAction*' ,
'KActionCollection&'  => 'kde_KActionCollection*' ,
'KActionCollection'  => 'kde_KActionCollection*' ,
'KActionCollection*'  => 'kde_KActionCollection*' ,
'KActionMenu*' => 'PKActionMenu',
'KActionSeparator*' => 'PKActionSeparator',
'KAddressInfo*' => 'PKAddressInfo',
'KAlphaPainter*' => 'PKAlphaPainter',
'KAnimWidget*'  =>  'kde_KAnimWidget*' ,
'KAppTreeListItem*'  =>  'kde_KAppTreeListItem*' ,
'KApplication*'  =>  'kde_KApplication*' ,
'KApplicationPropsPlugin*' => 'PKApplicationPropsPlugin',
'KApplicationTree*' => 'PKApplicationTree',
'KArchive*' => 'PKArchive',
'KArchiveDirectory*' => 'PKArchiveDirectory',
'KArchiveEntry*' => 'PKArchiveEntry',
'KArchiveFile*' => 'PKArchiveFile',
'KArrowButton*' => 'PKArrowButton',
'KArtsDispatcher*' => 'PKArtsDispatcher',
'KArtsFloatWatch*' => 'PKArtsFloatWatch',
'KAsyncIO*' => 'PKAsyncIO',
'KAudioPlayer*' => 'PKAudioPlayer',
'KAuthIcon*' => 'PKAuthIcon',
'KAutoMount*' => 'PKAutoMount',
'KAutoUnmount*' => 'PKAutoUnmount',
'KBindingPropsPlugin*' => 'PKBindingPropsPlugin',
'KBlankEffect*' => 'PKBlankEffect',
'KBufferedIO*' => 'PKBufferedIO',
'KBugReport*' => 'PKBugReport',
'KButtonBox*' => 'PKButtonBox',
'KCModule*'  =>  'kde_KCModule*' ,
'KCatalogue&' => 'kde_KCatalogue*',
'KCatalogue*' => 'PKCatalogue',
'KCharSelect*' => 'PKCharSelect',
'KCharSelectTable*' => 'PKCharSelectTable',
'KCharsets*'  =>  'kde_KCharsets*' ,
'KCmdLineArgs*'  =>  'kde_KCmdLineArgs*' ,
'KCmdLineOptions*'  => 'kde_KCmdLineOptions*' ,
'KCodecs*' => 'PKCodecs',
'KColor&'  => 'kde_KColor*' ,
'KColor*' => 'PKColor',
'KColorButton*' => 'PKColorButton',
'KColorCells*' => 'PKColorCells',
'KColorCombo*' => 'PKColorCombo',
'KColorDialog*' => 'PKColorDialog',
'KColorDrag*'  =>  'kde_KColorDrag*' ,
'KColorPatch*' => 'PKColorPatch',
'KCombiView*' => 'PKCombiView',
'KComboBox*'  =>  'kde_KComboBox*' ,
'KCommand*' => 'PKCommand',
'KCommandHistory*' => 'PKCommandHistory',
'KCompletion*'  =>  'kde_KCompletion*' ,
'KCompletionBase*' => 'PKCompletionBase',
'KCompletionBase::KeyBindingType'  => 'kde_KCompletionBase_KeyBindingType*' ,
'KCompletionBox*' => 'PKCompletionBox',
'KConfig*'  => 'kde_KConfig*' ,
'KConfigBackEnd*' => 'PKConfigBackEnd',
'KConfigBase&' => 'kde_KConfigBase*',
'KConfigBase*'  => 'kde_KConfigBase*' ,
'KConfigBase::ConfigState'  => 'kde_KConfigBase_ConfigState' ,
'KConfigGroup*' => 'PKConfigGroup',
'KConfigGroupSaver*' => 'PKConfigGroupSaver',
'KConfigINIBackEnd*' => 'PKConfigINIBackEnd',
'KContainerLayout*' => 'PKContainerLayout',
'KContainerLayoutItem*'  => 'kde_KContainerLayoutItem*' ,
'KContextMenuManager*' => 'PKContextMenuManager',
'KCookie*' => 'PKCookie',
'KCrash*' => 'PKCrash',
'KCursor*' => 'PKCursor',
'KDBGFUNC'  => 'void *' ,
'KDCOPActionProxy*' => 'PKDCOPActionProxy',
'KDCOPPropertyProxy*' => 'PKDCOPPropertyProxy',
'KDEAniMenu*' => 'PKDEAniMenu',
'KDEDModule*' => 'PKDEDModule',
'KDEDesktopMimeType*' => 'PKDEDesktopMimeType',
'KDEDesktopMimeType::Service&'  => 'kde_KDEDesktopMimeType_Service*' ,
'KDESasl*' => 'PKDESasl',
'KDEStyle*' => 'PKDEStyle',
'KDEsuClient*' => 'PKDEsuClient',
'KDataTool*' => 'PKDataTool',
'KDataToolAction*' => 'PKDataToolAction',
'KDataToolInfo&' => 'kde_KDataToolInfo*',
'KDataToolInfo*' => 'PKDataToolInfo',
'KDateInternalMonthPicker*' => 'PKDateInternalMonthPicker',
'KDateInternalYearSelector*' => 'PKDateInternalYearSelector',
'KDatePicker*' => 'PKDatePicker',
'KDateTable*' => 'PKDateTable',
'KDateValidator*' => 'PKDateValidator',
'KDateWidget*' => 'PKDateWidget',
'KDesktopFile*'  => 'kde_KDesktopFile*' ,
'KDevApi*' => 'PKDevApi',
'KDevAppFrontend*' => 'PKDevAppFrontend',
'KDevCompilerOptions*' => 'PKDevCompilerOptions',
'KDevCore*' => 'PKDevCore',
'KDevFactory*' => 'PKDevFactory',
'KDevLanguageSupport*' => 'PKDevLanguageSupport',
'KDevMakeFrontend*' => 'PKDevMakeFrontend',
'KDevPart*' => 'PKDevPart',
'KDevProject*' => 'PKDevProject',
'KDevVersionControl*' => 'PKDevVersionControl',
'KDevicePropsPlugin*' => 'PKDevicePropsPlugin',
'KDialog*' => 'PKDialog',
'KDialogBase*'  =>  'kde_KDialogBase*' ,
'KDialogBaseTile*' => 'PKDialogBaseTile',
'KDialogQueue*' => 'PKDialogQueue',
'KDirLister*' => 'PKDirLister',
'KDirNotify*' => 'PKDirNotify',
'KDirNotify_stub*' => 'PKDirNotify_stub',
'KDirOperator*' => 'PKDirOperator',
'KDirSelectDialog*' => 'PKDirSelectDialog',
'KDirSize*'  =>  'kde_KDirSize*' ,
'KDirWatch*'  =>  'kde_KDirWatch*' ,
'KDirectionButton*' => 'PKDirectionButton',
'KDockArea*' => 'PKDockArea',
'KDockMainWindow*' => 'PKDockMainWindow',
'KDockManager*'  => 'kde_KDockManager*' ,
'KDockTabBar*' => 'PKDockTabBar',
'KDockTabBar::TabPos' => 'longint',
'KDockTabBarPainter*' => 'PKDockTabBarPainter',
'KDockTabCtl*' => 'PKDockTabCtl',
'KDockTabCtl_PrivateStruct*'  =>  'kde_KDockTabCtl_PrivateStruct*' ,
'KDockTabGroup*'  =>  'kde_KDockTabGroup*' ,
'KDockWidget*'  => 'kde_KDockWidget*' ,
'KDockWidgetAbstractHeader*'  => 'kde_KDockWidgetAbstractHeader*' ,
'KDockWidgetAbstractHeaderDrag*' => 'PKDockWidgetAbstractHeaderDrag',
'KDockWidgetHeader*' => 'PKDockWidgetHeader',
'KDockWidgetHeaderDrag*' => 'PKDockWidgetHeaderDrag',
'KDockWindow*' => 'PKDockWindow',
'KDoubleNumInput*' => 'PKDoubleNumInput',
'KDualColorButton*' => 'PKDualColorButton',
'KEMailSettings*' => 'PKEMailSettings',
'KEdFind*' => 'PKEdFind',
'KEdGotoLine*' => 'PKEdGotoLine',
'KEdReplace*' => 'PKEdReplace',
'KEdit*' => 'PKEdit',
'KEditListBox*' => 'PKEditListBox',
'KEditToolbar*' => 'PKEditToolbar',
'KEditToolbarWidget*' => 'PKEditToolbarWidget',
'KEntry&'  => 'kde_KEntry*' ,
'KEntry'  => 'kde_KEntry*' ,
'KEntry*' => 'PKEntry',
'KEntryKey&'  => 'kde_KEntryKey*' ,
'KEntryKey*' => 'PKEntryKey',
'KEntryMap'  => 'kde_KEntryMap*' ,
'KEntryMap*'  => 'kde_KEntryMap*' ,
'KExecMimeType*' => 'PKExecMimeType',
'KExecPropsPlugin*' => 'PKExecPropsPlugin',
'KExtendedSocket*' => 'PKExtendedSocket',
'KFile*' => 'PKFile',
'KFile::FileView'  => 'longint' ,
'KFile::Mode'  => 'longint' ,
'KFile::SelectionMode'  => 'longint' ,
'KFileBookmark*'  =>  'kde_KFileBookmark*' ,
'KFileBookmarkManager*' => 'PKFileBookmarkManager',
'KFileComboBox*' => 'PKFileComboBox',
'KFileDetailView*' => 'PKFileDetailView',
'KFileDialog*'  =>  'kde_KFileDialog*' ,
'KFileFilter*' => 'PKFileFilter',
'KFileFilterCombo*' => 'PKFileFilterCombo',
'KFileIconView*' => 'PKFileIconView',
'KFileIconViewItem*' => 'PKFileIconViewItem',
'KFileItem&' => 'kde_KFileItem*',
'KFileItem*'  => 'kde_KFileItem*' ,
'KFileItemList&'  => 'kde_KFileItemList*' ,
'KFileItemList'  => 'kde_KFileItemList*' ,
'KFileItemList*'  => 'kde_KFileItemList*' ,
'KFileListViewItem*' => 'PKFileListViewItem',
'KFileMetaInfo*' => 'PKFileMetaInfo',
'KFileMetaInfoItem*' => 'PKFileMetaInfoItem',
'KFileMetaInfoProvider*' => 'PKFileMetaInfoProvider',
'KFileOpenWithHandler*' => 'PKFileOpenWithHandler',
'KFilePermissionsPropsPlugin*' => 'PKFilePermissionsPropsPlugin',
'KFilePlugin*' => 'PKFilePlugin',
'KFilePreview*' => 'PKFilePreview',
'KFilePropsPlugin*' => 'PKFilePropsPlugin',
'KFileReader*'  => 'kde_KFileReader*' ,
'KFileTreeBranch*' => 'PKFileTreeBranch',
'KFileTreeView*' => 'PKFileTreeView',
'KFileTreeViewItem*' => 'PKFileTreeViewItem',
'KFileTreeViewToolTip*' => 'PKFileTreeViewToolTip',
'KFileView*'  => 'kde_KFileView*' ,
'KFileView::FileView' => 'longint',
'KFileViewItem&' => 'kde_KFileViewItem*',
'KFileViewItem*'  => 'kde_KFileViewItem*' ,
'KFileViewItem**'  => 'kde_KFileViewItem**' ,
'KFileViewItemList&'  => 'kde_KFileViewItemList*' ,
'KFileViewItemList*'  => 'kde_KFileViewItemList*' ,
'KFileViewSignaler*' => 'PKFileViewSignaler',
'KFilterBase*' => 'PKFilterBase',
'KFilterDev*' => 'PKFilterDev',
'KFloatValidator*' => 'PKFloatValidator',
'KFloatWatchProxy&' => 'kde_KFloatWatchProxy*',
'KFloatWatchProxy' => 'kde_KFloatWatchProxy*',
'KFloatWatchProxy*' => 'PKFloatWatchProxy',
'KFolderType*' => 'PKFolderType',
'KFontAction*' => 'PKFontAction',
'KFontChooser*' => 'PKFontChooser',
'KFontCombo*' => 'PKFontCombo',
'KFontDialog*' => 'PKFontDialog',
'KFontSizeAction*' => 'PKFontSizeAction',
'KGenericFactory*' => 'PKGenericFactory',
'KGenericFactoryBase*' => 'PKGenericFactoryBase',
'KGlobal*' => 'PKGlobal',
'KGlobalAccel*'  =>  'kde_KGlobalAccel*' ,
'KGlobalSettings*' => 'PKGlobalSettings',
'KGlobalSettings::Completion'  => 'longint' ,
'KGradientSelector*' => 'PKGradientSelector',
'KGuiItem&' => 'kde_KGuiItem*',
'KGuiItem' => 'kde_KGuiItem*',
'KGuiItem*' => 'PKGuiItem',
'KHSSelector*' => 'PKHSSelector',
'KHTMLPart*'  =>  'kde_KHTMLPart*' ,
'KHTMLSettings&' => 'kde_KHTMLSettings*',
'KHTMLSettings*'  => 'kde_KHTMLSettings*' ,
'KHTMLView*'  => 'kde_KHTMLView*' ,
'KHelpMenu*' => 'PKHelpMenu',
'KHistoryCombo*' => 'PKHistoryCombo',
'KIO*' => 'PKIO',
'KIO::AuthInfo&' => 'kde_AuthInfo*',
'KIO::CopyJob*'  => 'kde_CopyJob*' ,
'KIO::DeleteJob*'  => 'kde_DeleteJob*' ,
'KIO::Job*'  => 'kde_Job*' ,
'KIO::ListJob*'  => 'kde_ListJob*' ,
'KIO::MetaData&' => 'kde_MetaData*',
'KIO::RenameDlg_Mode' => 'longint',
'KIO::RenameDlg_Result' => 'longint',
'KIO::SimpleJob*' => 'kde_SimpleJob*',
'KIO::SkipDlg_Result' => 'longint',
'KIO::Slave*' => 'kde_Slave*',
'KIO::UDSEntry&'  => 'kde_UDSEntry*' ,
'KIO::UDSEntryList&'  => 'kde_UDSEntryList*' ,
'KIOInputStream&' => 'kde_KIOInputStream*',
'KIOInputStream*' => 'PKIOInputStream',
'KIOTestSlow&' => 'kde_KIOTestSlow*',
'KIOTestSlow' => 'kde_KIOTestSlow*',
'KIOTestSlow*' => 'PKIOTestSlow',
'KIPC*' => 'PKIPC',
'KIcon'  => 'kde_KIcon*' ,
'KIcon*' => 'PKIcon',
'KIconButton*' => 'PKIconButton',
'KIconCanvas*' => 'PKIconCanvas',
'KIconDialog*' => 'PKIconDialog',
'KIconEffect*'  =>  'kde_KIconEffect*' ,
'KIconLoader*'  => 'kde_KIconLoader*' ,
'KIconSelectAction*' => 'PKIconSelectAction',
'KIconTheme*'  => 'kde_KIconTheme*' ,
'KIconView*' => 'PKIconView',
'KIconViewItem*' => 'PKIconViewItem',
'KImageEffect*' => 'PKImageEffect',
'KImageFilePreview*' => 'PKImageFilePreview',
'KImageIO*' => 'PKImageIO',
'KInetSocketAddress&' => 'kde_KInetSocketAddress*',
'KInetSocketAddress*' => 'PKInetSocketAddress',
'KInstance&'  => 'kde_KInstance*' ,
'KInstance'  => 'kde_KInstance*' ,
'KInstance*'  => 'kde_KInstance*' ,
'KIntNumInput*' => 'PKIntNumInput',
'KIntSpinBox*' => 'PKIntSpinBox',
'KIntValidator*' => 'PKIntValidator',
'KJS*' => 'PKJS',
'KJS::KJSO&' => 'kde_KJS_KJSO*',
'KJS::UString&' => 'kde_KJS_UString*',
'KJSO&' => 'kde_KJSO*',
'KJSO' => 'kde_KJSO*',
'KJSO*' => 'PKJSO',
'KJScript*' => 'PKJScript',
'KJanusWidget*' => 'PKJanusWidget',
'KJavaApplet*'  =>  'kde_KJavaApplet*' ,
'KJavaAppletContext*'  => 'kde_KJavaAppletContext*' ,
'KJavaAppletServer*'  =>  'kde_KJavaAppletServer*' ,
'KJavaAppletWidget*' => 'PKJavaAppletWidget',
'KJavaProcess*' => 'PKJavaProcess',
'KJavaScriptAdvice&'  => 'kde_KJavaScriptAdvice*' ,
'KKeyChooser*' => 'PKKeyChooser',
'KKeyChooserItem*' => 'PKKeyChooserItem',
'KKeyDialog*' => 'PKKeyDialog',
'KKeyEntry&'  => 'kde_KKeyEntry*' ,
'KKeyEntry*' => 'PKKeyEntry',
'KKeyEntryMap&'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap*'  => 'kde_KKeyEntryMap*' ,
'KKeySequence&' => 'kde_KKeySequence*',
'KKeySequence' => 'kde_KKeySequence*',
'KKeySequence*' => 'PKKeySequence',
'KKeySequence::I18N' => 'longint',
'KKeySequences&' => 'kde_KKeySequences*',
'KKeySequences' => 'kde_KKeySequences*',
'KKeySequences*' => 'PKKeySequences',
'KLed*' => 'PKLed',
'KLibFactory*'  =>  'kde_KLibFactory*' ,
'KLibLoader*'  =>  'kde_KLibLoader*' ,
'KLibrary*'  => 'kde_KLibrary*' ,
'KLineEdit*'  =>  'kde_KLineEdit*' ,
'KLineEditDlg*' => 'PKLineEditDlg',
'KListAction*' => 'PKListAction',
'KListBox*' => 'PKListBox',
'KListView*'  => 'kde_KListView*' ,
'KListViewItem*' => 'PKListViewItem',
'KLocale&'  => 'kde_KLocale*' ,
'KLocale*'  => 'kde_KLocale*' ,
'KMJobViewer*' => 'PKMJobViewer',
'KMMainView*' => 'PKMMainView',
'KMManager*' => 'PKMManager',
'KMObject*' => 'PKMObject',
'KMPrinter&' => 'kde_KMPrinter*',
'KMPrinter*' => 'PKMPrinter',
'KMPrinterList*' => 'PKMPrinterList',
'KMPrinterPage*' => 'PKMPrinterPage',
'KMacroCommand*' => 'PKMacroCommand',
'KMainWindow*' => 'PKMainWindow',
'KMainWindowInterface*' => 'PKMainWindowInterface',
'KMenuBar*'  => 'kde_KMenuBar*' ,
'KMessageBox*' => 'PKMessageBox',
'KMidSimpleAPI*' => 'PKMidSimpleAPI',
'KMimeMagic*'  =>  'kde_KMimeMagic*' ,
'KMimeMagicResult*'  => 'kde_KMimeMagicResult*' ,
'KMimeSourceFactory*'  => 'kde_KMimeSourceFactory*' ,
'KMimeType*' => 'PKMimeType',
'KMimeType::List&'  => 'kde_KMimeType_List*' ,
'KMimeType::Ptr&'  => 'kde_KMimeType_Ptr*' ,
'KMimeType::Ptr'  => 'kde_KMimeType_Ptr' ,
'KMouseSettings*' => 'PKMouseSettings',
'KMultipleDrag*' => 'PKMultipleDrag',
'KNDBGFUNC'  => 'void *' ,
'KNotifyClient*' => 'PKNotifyClient',
'KNumInput*'  => 'kde_KNumInput*' ,
'KOCRDialog*' => 'PKOCRDialog',
'KOCRDialogFactory*' => 'PKOCRDialogFactory',
'KOpenSSLProxy*' => 'PKOpenSSLProxy',
'KOpenWithDlg*' => 'PKOpenWithDlg',
'KOpenWithHandler*'  =>  'kde_KOpenWithHandler*' ,
'KPAC*' => 'PKPAC',
'KPReloadObject*' => 'PKPReloadObject',
'KPalette&'  => 'kde_KPalette*' ,
'KPalette*' => 'PKPalette',
'KPaletteTable*' => 'PKPaletteTable',
'KPanelAppMenu*' => 'PKPanelAppMenu',
'KPanelApplet*' => 'PKPanelApplet',
'KPanelExtension*' => 'PKPanelExtension',
'KPanelMenu*'  =>  'kde_KPanelMenu*' ,
'KParts*' => 'PKParts',
'KParts::BrowserExtension*'  => 'kde_BrowserExtension*' ,
'KParts::GUIActivateEvent*'  => 'kde_GUIActivateEvent*' ,
'KParts::Part*' => 'kde_Part*',
'KParts::PartManager*'  => 'kde_PartManager*' ,
'KParts::ReadOnlyPart*'  => 'kde_ReadOnlyPart*' ,
'KParts::URLArgs&'  => 'kde_URLArgs*' ,
'KParts::URLArgs' => 'kde_URLArgs*',
'KPasswordDialog*' => 'PKPasswordDialog',
'KPasswordEdit*' => 'PKPasswordEdit',
'KPixmap&'  => 'kde_KPixmap*' ,
'KPixmap'  => 'kde_KPixmap*' ,
'KPixmap*' => 'PKPixmap',
'KPixmapEffect*' => 'PKPixmapEffect',
'KPixmapIO*' => 'PKPixmapIO',
'KPixmapProvider*'  => 'kde_KPixmapProvider*' ,
'KPixmapSplitter*' => 'PKPixmapSplitter',
'KPlayObject*' => 'PKPlayObject',
'KPlayObjectFactory*' => 'PKPlayObjectFactory',
'KPopupFrame*' => 'PKPopupFrame',
'KPopupMenu*'  => 'kde_KPopupMenu*' ,
'KPopupTitle*' => 'PKPopupTitle',
'KPreviewWidgetBase*' => 'PKPreviewWidgetBase',
'KPrintAction*' => 'PKPrintAction',
'KPrintDialogPage*' => 'PKPrintDialogPage',
'KPrinter*' => 'PKPrinter',
'KPrinterWrapper*' => 'PKPrinterWrapper',
'KProcIO*'  =>  'kde_KProcIO*' ,
'KProcess&'  => 'kde_KProcess*' ,
'KProcess*'  => 'kde_KProcess*' ,
'KProcessController*' => 'PKProcessController',
'KProcessRunner*' => 'PKProcessRunner',
'KProgress*' => 'PKProgress',
'KPropertiesDialog*'  => 'kde_KPropertiesDialog*' ,
'KPropsDlgPlugin*'  => 'kde_KPropsDlgPlugin*' ,
'KProtocolInfo*' => 'PKProtocolInfo',
'KProtocolManager*' => 'PKProtocolManager',
'KPushButton*' => 'PKPushButton',
'KRFCDate*' => 'PKRFCDate',
'KRadioAction*' => 'PKRadioAction',
'KRandomSequence*' => 'PKRandomSequence',
'KRecentDocument*' => 'PKRecentDocument',
'KRecentFilesAction*'  =>  'kde_KRecentFilesAction*' ,
'KRegExp*' => 'PKRegExp',
'KRegExpEditor*' => 'PKRegExpEditor',
'KRegExpEditorInterface*' => 'PKRegExpEditorInterface',
'KRestrictedLine*' => 'PKRestrictedLine',
'KRootPermsIcon*' => 'PKRootPermsIcon',
'KRootPixmap*' => 'PKRootPixmap',
'KRootProp*' => 'PKRootProp',
'KRuler*' => 'PKRuler',
'KRun*' => 'PKRun',
'KSSL&' => 'kde_KSSL*',
'KSSL*' => 'PKSSL',
'KSSLAuthAction' => 'longint',
'KSSLAuthAction*' => 'PKSSLAuthAction',
'KSSLCertBox*' => 'PKSSLCertBox',
'KSSLCertChain&' => 'kde_KSSLCertChain*',
'KSSLCertChain*' => 'PKSSLCertChain',
'KSSLCertDlg*' => 'PKSSLCertDlg',
'KSSLCertDlgRet' => 'kde_KSSLCertDlgRet*',
'KSSLCertDlgRet*' => 'PKSSLCertDlgRet',
'KSSLCertificate&' => 'kde_KSSLCertificate*',
'KSSLCertificate*' => 'PKSSLCertificate',
'KSSLCertificateCache*' => 'PKSSLCertificateCache',
'KSSLCertificateFactory*' => 'PKSSLCertificateFactory',
'KSSLCertificateHome*' => 'PKSSLCertificateHome',
'KSSLConnectionInfo&' => 'kde_KSSLConnectionInfo*',
'KSSLConnectionInfo*' => 'PKSSLConnectionInfo',
'KSSLInfoDlg*' => 'PKSSLInfoDlg',
'KSSLKeyGen*' => 'PKSSLKeyGen',
'KSSLKeyType' => 'kde_KSSLKeyType',
'KSSLPKCS12*' => 'PKSSLPKCS12',
'KSSLPKCS7*' => 'PKSSLPKCS7',
'KSSLPeerInfo&' => 'kde_KSSLPeerInfo*',
'KSSLPeerInfo*' => 'PKSSLPeerInfo',
'KSSLSettings*' => 'PKSSLSettings',
'KSSLSigners*' => 'PKSSLSigners',
'KSSLX509Map*' => 'PKSSLX509Map',
'KSSLX509V3&' => 'kde_KSSLX509V3*',
'KSSLX509V3*' => 'PKSSLX509V3',
'KSaveFile*' => 'PKSaveFile',
'KScanDialog*' => 'PKScanDialog',
'KScanDialogFactory*' => 'PKScanDialogFactory',
'KScreenSaver*' => 'PKScreenSaver',
'KScriptClientInterface*' => 'PKScriptClientInterface',
'KScriptClientInterface::Result' => 'longint',
'KScriptInterface*' => 'PKScriptInterface',
'KScriptManager*' => 'PKScriptManager',
'KSelectAction*' => 'PKSelectAction',
'KSelector*' => 'PKSelector',
'KSeparator*' => 'PKSeparator',
'KServerSocket*' => 'PKServerSocket',
'KService&'  => 'kde_KService*' ,
'KService*' => 'PKService',
'KService::List'  => 'kde_KService_List*' ,
'KService::Ptr'  => 'kde_KService_Ptr*' ,
'KServiceGroup*' => 'PKServiceGroup',
'KServiceOffer&'  => 'kde_KServiceOffer*' ,
'KServiceOffer*' => 'PKServiceOffer',
'KServiceType*' => 'PKServiceType',
'KServiceTypeProfile*'  =>  'kde_KServiceTypeProfile*' ,
'KSessionManaged*' => 'PKSessionManaged',
'KShared&'  => 'kde_KShared*' ,
'KShared*' => 'PKShared',
'KSharedPixmap*' => 'PKSharedPixmap',
'KSharedPtr&'  => 'kde_KSharedPtr*' ,
'KSharedPtr*' => 'PKSharedPtr',
'KShellCompletion*' => 'PKShellCompletion',
'KShellProcess*' => 'PKShellProcess',
'KShortcuts&' => 'kde_KShortcuts*',
'KShortcuts' => 'kde_KShortcuts*',
'KShortcuts*' => 'PKShortcuts',
'KShred*' => 'PKShred',
'KSimpleConfig&'  => 'kde_KSimpleConfig*' ,
'KSimpleConfig*' => 'PKSimpleConfig',
'KSimpleFileFilter*' => 'PKSimpleFileFilter',
'KSocket*' => 'PKSocket',
'KSocketAddress&' => 'kde_KSocketAddress*',
'KSocketAddress*' => 'PKSocketAddress',
'KSocks*' => 'PKSocks',
'KSpell*' => 'PKSpell',
'KSpellConfig&'  => 'kde_KSpellConfig*' ,
'KSpellConfig'  => 'kde_KSpellConfig*' ,
'KSpellConfig*'  => 'kde_KSpellConfig*' ,
'KSpellDlg*' => 'PKSpellDlg',
'KSqueezedTextLabel*' => 'PKSqueezedTextLabel',
'KStandardDirs*'  => 'kde_KStandardDirs*' ,
'KStartupInfo*' => 'PKStartupInfo',
'KStartupInfoData&' => 'kde_KStartupInfoData*',
'KStartupInfoData*' => 'PKStartupInfoData',
'KStartupInfoId&' => 'kde_KStartupInfoId*',
'KStartupInfoId' => 'kde_KStartupInfoId*',
'KStartupInfoId*' => 'PKStartupInfoId',
'KStaticDeleter*' => 'PKStaticDeleter',
'KStaticDeleterBase*'  => 'kde_KStaticDeleterBase*' ,
'KStatusBar*'  => 'kde_KStatusBar*' ,
'KStatusBar::BarStatusstat::Toggle'  =>  'longint' ,
'KStatusBarLabel*' => 'PKStatusBarLabel',
'KStdAccel*' => 'PKStdAccel',
'KStdAccel::StdAccel'  => 'longint' ,
'KStdAction*' => 'PKStdAction',
'KStdGuiItem*' => 'PKStdGuiItem',
'KStringHandler*' => 'PKStringHandler',
'KStyle*'  => 'kde_KStyle*' ,
'KSycoca*'  =>  'kde_KSycoca*' ,
'KSycocaEntry*'  => 'kde_KSycocaEntry*' ,
'KSycocaFactory*'  => 'kde_KSycocaFactory*' ,
'KSycocaFactoryId'  => 'kde_KSycocaFactoryId' ,
'KSycocaType&'  => 'kde_KSycocaType*' ,
'KSycocaType'  => 'kde_KSycocaType*' ,
'KSystemTray*' => 'PKSystemTray',
'KTMainWindow*' => 'PKTMainWindow',
'KTabButton*' => 'PKTabButton',
'KTabCtl*' => 'PKTabCtl',
'KTar*' => 'PKTar',
'KTarBase*'  =>  'kde_KTarBase*' ,
'KTarData*' => 'PKTarData',
'KTarDirectory*'  => 'kde_KTarDirectory*' ,
'KTarEntry*'  => 'kde_KTarEntry*' ,
'KTarFile*' => 'PKTarFile',
'KTarGz*' => 'PKTarGz',
'KTempFile*' => 'PKTempFile',
'KTextBrowser*' => 'PKTextBrowser',
'KTextEditor*' => 'PKTextEditor',
'KTextEditor__View&'  =>  'kde_KTextEditor__View*',
'KTextEditor__View'  =>  'kde_KTextEditor__View*',
'KTextEditor__View*'  =>  'kde_KTextEditor__View*',
'KThemeBase*'  =>  'kde_KThemeBase*', ,
'KThemeCache*'  =>  'kde_KThemeCache*',
'KThemePixmap&'  => 'kde_KThemePixmap*' ,
'KThemePixmap*'  => 'kde_KThemePixmap*' ,
'KThemeStyle*' => 'PKThemeStyle',
'KTipDatabase*' => 'PKTipDatabase',
'KTipDialog*' => 'PKTipDialog',
'KToggleAction*'  => 'kde_KToggleAction*' ,
'KToolBar*'  => 'kde_KToolBar*' ,
'KToolBar::BarStatus' => 'longint',
'KToolBar::BarStatusstat::Toggle'  =>  'longint' ,
'KToolBarButton*'  => 'kde_KToolBarButton*' ,
'KToolBarButtonList*' => 'PKToolBarButtonList',
'KToolBarPopupAction*' => 'PKToolBarPopupAction',
'KToolBarPos'  => 'longint' ,
'KToolBarRadioGroup*' => 'PKToolBarRadioGroup',
'KToolBarSeparator*' => 'PKToolBarSeparator',
'KToolButtonType'  => 'longint' ,
'KTrader*'  =>  'kde_KTrader*' ,
'KTypeList*' => 'PKTypeList',
'KURIFilter*'  =>  'kde_KURIFilter*' ,
'KURIFilterData&'  => 'kde_KURIFilterData*' ,
'KURIFilterData*' => 'PKURIFilterData',
'KURIFilterPlugin*' => 'PKURIFilterPlugin',
'KURIFilterPluginList*' => 'PKURIFilterPluginList',
'KURL& url ()' => 'kde_KURL*',
'KURL& urlName ()' => 'kde_KURL*',
'KURL&'  => 'kde_KURL*' ,
'KURL'  => 'kde_KURL*' ,
'KURL*' => 'PKURL',
'KURL::List&'  => 'kde_KURLList*' ,
'KURL::List'  => 'kde_KURLList*' ,
'KURLComboBox*' => 'PKURLComboBox',
'KURLComboItem*'  => 'kde_KURLComboItem*' ,
'KURLCompletion*' => 'PKURLCompletion',
'KURLDrag*' => 'PKURLDrag',
'KURLLabel*' => 'PKURLLabel',
'KURLPixmapProvider*' => 'PKURLPixmapProvider',
'KURLPropsPlugin*' => 'PKURLPropsPlugin',
'KURLRequester*' => 'PKURLRequester',
'KURLRequesterDlg*' => 'PKURLRequesterDlg',
'KUniqueApplication*' => 'PKUniqueApplication',
'KUnixSocketAddress*' => 'PKUnixSocketAddress',
'KValueSelector*' => 'PKValueSelector',
'KWin*' => 'PKWin',
'KWinModule*' => 'PKWinModule',
'KWindowListMenu*' => 'PKWindowListMenu',
'KWizard*' => 'PKWizard',
'KWordWrap*' => 'PKWordWrap',
'KWritePermsIcon*' => 'PKWritePermsIcon',
'KXMLGUIBuilder*'  =>  'kde_KXMLGUIBuilder*' ,
'KXMLGUIClient*'  => 'kde_KXMLGUIClient*' ,
'KXMLGUIFactory*'  => 'kde_KXMLGUIFactory*' ,
'KXMessages*' => 'PKXMessages',
'KXYSelector*' => 'PKXYSelector',
'KZoneAllocator*' => 'PKZoneAllocator',
'KabAPI*' => 'PKabAPI',
'KabKey&'  => 'kde_KabKey*' ,
'KabKey'  => 'kde_KabKey*' ,
'KabKey*' => 'PKabKey',
'Key&'  =>  'var' ,
'KeyBindingMap'  => 'kde_KeyBindingMap*' ,
'KeyValueMap&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*'  => 'kde_KeyValueMap*' ,
'Keymap*' => 'PKeymap',
'LinkStyle&' => 'kde_LinkStyle*',
'LinkStyle*' => 'PLinkStyle',
'List&' => 'kde_List*',
'List' => 'kde_List',
'List*' => 'PList',
'ListIterator&' => 'kde_ListIterator*',
'ListIterator' => 'kde_ListIterator',
'ListIterator*' => 'PListIterator',
'ListJob*' => 'PListJob',
'ListNode*' => 'PListNode',
'ListProgress*' => 'PListProgress',
'Lookup*' => 'PLookup',
'MCOPConfig*' => 'PMCOPConfig',
'MCOPUtils*' => 'PMCOPUtils',
'MSG*'  =>  'MSG*' ,
'MailServer&'  =>  'MailServer*' ,
'MailServer*' => 'PMailServer',
'MainWindow*' => 'PMainWindow',
'Mark*' => 'PMark',
'MarkInterface*' => 'PMarkInterface',
'MediaAsyncStream*' => 'PMediaAsyncStream',
'MediaDataPacket*' => 'PMediaDataPacket',
'MediaFrame*' => 'PMediaFrame',
'MediaList&' => 'kde_MediaList*',
'MediaList' => 'kde_MediaList',
'MediaList*' => 'PMediaList',
'MediaListImpl*' => 'PMediaListImpl',
'MediaModule&' => 'kde_MediaModule*',
'MediaModule' => 'kde_MediaModule*',
'MediaModule*' => 'PMediaModule',
'MediaModule_base*' => 'PMediaModule_base',
'MediaModule_skel*' => 'PMediaModule_skel',
'MediaModule_stub*' => 'PMediaModule_stub',
'MenuDockData*' => 'PMenuDockData',
'MetaData&' => 'kde_MetaData*',
'MetaData' => 'kde_MetaData*',
'MetaData*' => 'PMetaData',
'MethodDef&' => 'kde_MethodDef*',
'MethodDef*' => 'PMethodDef',
'MidiEvent*' => 'PMidiEvent',
'MidiFileInfo*' => 'PMidiFileInfo',
'MidiMapper*' => 'PMidiMapper',
'MidiOut*' => 'PMidiOut',
'MidiPlayer*' => 'PMidiPlayer',
'MidiStatus*' => 'PMidiStatus',
'MidiTrack*' => 'PMidiTrack',
'MimetypeJob*' => 'PMimetypeJob',
'Mode' => 'longint',
'ModuleDef&' => 'kde_ModuleDef*',
'ModuleDef*' => 'PModuleDef',
'MouseDoubleClickEvent*' => 'PMouseDoubleClickEvent',
'MouseEvent*' => 'PMouseEvent',
'MouseMoveEvent*' => 'PMouseMoveEvent',
'MousePressEvent*' => 'PMousePressEvent',
'MouseReleaseEvent*' => 'PMouseReleaseEvent',
'MultiGetJob*' => 'PMultiGetJob',
'MultiPort*' => 'PMultiPort',
'NET*' => 'PNET',
'NET::WindowType'  =>  'longint' ,
'NETIcon'  =>  'kdeNETIcon*' ,
'NETIcon*' => 'PNETIcon',
'NETPoint&'  =>  'kde_NETPoint*' ,
'NETPoint'  =>  'kde_NETPoint*' ,
'NETPoint*' => 'PNETPoint',
'NETRect&'  =>  'kde_NETRect*' ,
'NETRect'  =>  'kde_NETRect*' ,
'NETRect*' => 'PNETRect',
'NETRootInfo&'  =>  'kde_NETRootInfo*' ,
'NETRootInfo*' => 'PNETRootInfo',
'NETRootInfoPrivate*' => 'PNETRootInfoPrivate',
'NETSize&'  =>  'kde_NETSize*' ,
'NETSize'  =>  'kde_NETSize*' ,
'NETSize*' => 'PNETSize',
'NETStrut'  =>  'kde_NETStrut*' ,
'NETStrut*' => 'PNETStrut',
'NETWinInfo&'  =>  'kde_NETWinInfo*' ,
'NETWinInfo*' => 'PNETWinInfo',
'NETWinInfoPrivate*' => 'PNETWinInfoPrivate',
'NamedNodeMap&' => 'kde_NamedNodeMap*',
'NamedNodeMap' => 'kde_NamedNodeMap*',
'NamedNodeMap*' => 'PNamedNodeMap',
'NamedNodeMapImpl*' => 'PNamedNodeMapImpl',
'NetAccess*' => 'PNetAccess',
'NetRC*' => 'PNetRC',
'Node&' => 'kde_DOMNode*',
'Node' => 'kde_DOMNode*',
'Node*' => 'PNode',
'NodeFilter&' => 'kde_NodeFilter*',
'NodeFilter' => 'kde_NodeFilter*',
'NodeFilter*' => 'PNodeFilter',
'NodeFilterImpl*' => 'PNodeFilterImpl',
'NodeImpl*' => 'PNodeImpl',
'NodeIterator&' => 'kde_NodeIterator*',
'NodeIterator' => 'kde_NodeIterator*',
'NodeIterator*' => 'PNodeIterator',
'NodeIteratorImpl*' => 'PNodeIteratorImpl',
'NodeList&' => 'kde_DOMNodeList*',
'NodeList' => 'kde_DOMNodeList*',
'NodeList*' => 'PNodeList',
'NodeListImpl*' => 'PNodeListImpl',
'NodePtr'  =>  'longint' ,
'NodeType'  =>  'longint' ,
'Notation&' => 'kde_Notation*',
'Notation*' => 'PNotation',
'NoteArray*' => 'PNoteArray',
'Notification&' => 'kde_Notification*',
'Notification' => 'kde_Notification*',
'Notification*' => 'PNotification',
'NotificationClient*' => 'PNotificationClient',
'NotificationManager*' => 'PNotificationManager',
'Null*' => 'null',
'Number&' => 'kde_Number*',
'Number*' => 'PNumber',
'Object&' => 'kde_Object*',
'Object' => 'kde_Object*',
'Object*' => 'PObject',
'ObjectImp*' => 'PObjectImp',
'ObjectManager*' => 'PObjectManager',
'ObjectReference&' => 'kde_ObjectReference*',
'ObjectReference*' => 'PObjectReference',
'Object_base*' => 'PObject_base',
'Object_skel*' => 'PObject_skel',
'Object_stub*' => 'PObject_stub',
'Observer*' => 'PObserver',
'OfferList'  =>  'kde_OfferList*' ,
'Offset' => 'longint',
'OnewayDispatchFunction' => 'kde_OnewayDispatchFunction*',
'OnewayInvocation&' => 'kde_OnewayInvocation*',
'OnewayInvocation*' => 'POnewayInvocation',
'OpenURLEvent*' => 'POpenURLEvent',
'Orientation' => 'longint',
'PFlags' => 'longint',
'PIAccess' => 'longint',
'PID' => 'longint',
'PIType' => 'longint',
'PTY*' => 'PPTY',
'PageSize' => 'longint',
'ParamDef&' => 'kde_ParamDef*',
'ParamDef*' => 'PParamDef',
'ParsedArgument*' => 'PParsedArgument',
'ParsedAttribute*' => 'PParsedAttribute',
'ParsedClass&' => 'kde_ParsedClass&',
'ParsedClass*' => 'PParsedClass',
'ParsedClassContainer*' => 'PParsedClassContainer',
'ParsedContainer*' => 'PParsedContainer',
'ParsedItem*' => 'PParsedItem',
'ParsedMethod*' => 'PParsedMethod',
'ParsedParent*' => 'PParsedParent',
'ParsedScopeContainer*' => 'PParsedScopeContainer',
'ParsedSignalSlot*' => 'PParsedSignalSlot',
'ParsedStruct*' => 'PParsedStruct',
'Part*' => 'PPart',
'PartActivateEvent*' => 'PPartActivateEvent',
'PartBase*' => 'PPartBase',
'PartManager*' => 'PPartManager',
'PartSelectEvent*' => 'PPartSelectEvent',
'PassDlg*' => 'PPassDlg',
'PasswordDialog*' => 'PPasswordDialog',
'PenCapStyle'  =>  'longint' ,
'PenJoinStyle'  =>  'longint' ,
'PenStyle' => 'longint',
'PersistantClassStore*' => 'PPersistantClassStore',
'PhoneNumber&' => 'kde_PhoneNumber*',
'PhoneNumber*' => 'PPhoneNumber',
'PipeBuffer*' => 'PPipeBuffer',
'PipeSegment*' => 'PPipeSegment',
'Pix&'  =>  'kde_Pix*' ,
'Pix'  =>  'kde_Pix*' ,
'PixelMetric' => 'longint',
'PlayObject&' => 'kde_PlayObject*',
'PlayObject' => 'kde_PlayObject*',
'PlayObject*' => 'PPlayObject',
'PlayObjectFactory&' => 'kde_PlayObjectFactory*',
'PlayObjectFactory' => 'kde_PlayObjectFactory',
'PlayObjectFactory*' => 'PPlayObjectFactory',
'PlayObjectFactory_base*' => 'PPlayObjectFactory_base',
'PlayObjectFactory_skel*' => 'PPlayObjectFactory_skel',
'PlayObjectFactory_stub*' => 'PPlayObjectFactory_stub',
'PlayObject_base*' => 'PPlayObject_base',
'PlayObject_private&' => 'kde_PlayObject_private*',
'PlayObject_private' => 'kde_PlayObject_private',
'PlayObject_private*' => 'PPlayObject_private',
'PlayObject_private_base*' => 'PPlayObject_private_base',
'PlayObject_private_skel*' => 'PPlayObject_private_skel',
'PlayObject_private_stub*' => 'PPlayObject_private_stub',
'PlayObject_skel*' => 'PPlayObject_skel',
'PlayObject_stub*' => 'PPlayObject_stub',
'PlayerController*' => 'PPlayerController',
'Plugin*' => 'PPlugin',
'PluginInfo*' => 'PPluginInfo',
'Policy' => 'longint',
'Pool&' => 'kde_Pool*',
'Pool*' => 'PPool',
'PopupMenuInterface*' => 'PPopupMenuInterface',
'Port*' => 'PPort',
'PreviewJob*' => 'PPreviewJob',
'PrimitiveElement' => 'longint',
'PrintInterface*' => 'PPrintInterface',
'PrinterMode' => 'longint',
'ProcessingInstruction&' => 'kde_ProcessingInstruction*',
'ProcessingInstruction' => 'kde_ProcessingInstruction*',
'ProcessingInstruction*' => 'PProcessingInstruction',
'ProgressBase*' => 'PProgressBase',
'ProgressItem*' => 'PProgressItem',
'PropagationMode' => 'longint',
'ProtocolInfo*' => 'PProtocolInfo',
'Ptr' => 'void *',
'PtyProcess*' => 'PPtyProcess',
'QAccel*' => 'QAccelH',
'QAccessible*' => 'QAccessibleH',
'QAccessibleFactoryInterface*' => 'QAccessibleFactoryInterfaceH',
'QAccessibleInterface*' => 'QAccessibleInterfaceH',
'QAccessibleInterface**' => 'var QAccessibleInterfaceH',
'QAccessibleObject*' => 'QAccessibleObjectH',
'QAction*'  =>  'QActionH' ,
'QActionGroup*' => 'QActionGroupH',
'QApplication*'  => 'QApplicationH' ,
'QArabicCodec*' => 'QArabicCodecH',
'QArray*' => 'QArrayH',
'QAsciiBucket*' => 'QAsciiBucketH',
'QAsciiCache*' => 'QAsciiCacheH',
'QAsciiCacheIterator*' => 'QAsciiCacheIteratorH',
'QAsciiDict*' => 'QAsciiDictH',
'QAsciiDictIterator*' => 'QAsciiDictIteratorH',
'QAsyncIO*' => 'QAsyncIOH',
'QAuBucket*'  =>  'QAuBucketH' ,
'QAuServer*' => 'QAuServerH',
'QBaseBucket*'  =>  'QBaseBucketH' ,
'QBig5Codec*' => 'QBig5CodecH',
'QBitArray&'  => 'QBitArrayH' ,
'QBitArray'  => 'QBitArrayH' ,
'QBitArray*'  =>  'QBitArrayH' ,
'QBitVal&'  => 'QBitValH' ,
'QBitVal'  => 'QBitValH' ,
'QBitVal*' => 'QBitValH',
'QBitmap&' => 'QBitmapH',
'QBitmap' => 'QBitmapH',
'QBitmap*' => 'QBitmapH',
'QBoxLayout*' => 'QBoxLayoutH',
'QBrush&' => 'QBrushH',
'QBrush'  =>  'QBrushH' ,
'QBrush*'  => 'QBrushH' ,
'QBrushData*' => 'QBrushDataH',
'QBuffer*' => 'QBufferH',
'QButton*' => 'QButtonH',
'QButtonGroup*'  =>  'QButtonGroupH' ,
'QByteArray& arr ()' => 'QByteArrayH',
'QByteArray&'  => 'QByteArrayH' ,
'QByteArray' => 'QByteArrayH',
'QByteArray*' => 'QByteArrayH',
'QCDEStyle*' => 'QCDEStyleH',
'QCOORD&' => 'var word',
'QCOORD' => 'word',
'QCOORD*' => 'pword',
'QCString&'  =>  'QCStringH' ,
'QCString'  =>  'QCStringH' ,
'QCString*'  =>  'QCStringH' ,
'QCStringLess*'  =>  'QCStringLessH' ,
'QCStringList'  => 'QCStringListH' ,
'QCache*' => 'QCacheH',
'QCacheIterator*' => 'QCacheIteratorH',
'QCanvas*'  =>  'QCanvasH' ,
'QCanvasEllipse*' => 'QCanvasEllipseH',
'QCanvasItem*'  =>  'QCanvasItemH' ,
'QCanvasItemList'  =>  'QCanvasItemListH' ,
'QCanvasItemList*' => 'QCanvasItemListH',
'QCanvasLine*' => 'QCanvasLineH',
'QCanvasPixmap*'  =>  'QCanvasPixmapH' ,
'QCanvasPixmapArray*'  =>  'QCanvasPixmapArrayH' ,
'QCanvasPolygon*' => 'QCanvasPolygonH',
'QCanvasPolygonalItem*' => 'QCanvasPolygonalItemH',
'QCanvasRectangle*' => 'QCanvasRectangleH',
'QCanvasSpline*' => 'QCanvasSplineH',
'QCanvasSprite*' => 'QCanvasSpriteH',
'QCanvasText*' => 'QCanvasTextH',
'QCanvasView*'  =>  'QCanvasViewH' ,
'QChain*'  => 'QChainH' ,
'QChar&'  =>  'QCharH' ,
'QChar'  =>  'QCharH' ,
'QChar*'  =>  'QCharH' ,
'QChar::Category'  =>  'longint' ,
'QChar::Decomposition'  =>  'longint' ,
'QChar::Direction'  =>  'longint' ,
'QChar::Joining'  =>  'longint' ,
'QCharRef&'  =>  'QCharRefH' ,
'QCharRef'  =>  'QCharRefH' ,
'QCharRef*' => 'QCharRefH',
'QCheckBox*' => 'QCheckBoxH',
'QCheckListItem*' => 'QCheckListItemH',
'QCheckTableItem*' => 'QCheckTableItemH',
'QChildEvent*'  => 'QChildEventH' ,
'QClassInfo*'  =>  'QClassInfoH' ,
'QCleanupHandler*' => 'QCleanupHandlerH',
'QClipboard*' => 'QClipboardH',
'QCloseEvent*'  => 'QCloseEventH' ,
'QCollection&'  => 'QCollectionH' ,
'QCollection*' => 'QCollectionH',
'QCollection::Item&'  =>  'void *' ,
'QCollection::Item'  =>  'void *' ,
'QColor &' => 'QColorH',
'QColor&' => 'QColorH',
'QColor&fillColor::white'  =>  'longint' ,
'QColor&linkColor::blue'  =>  'longint' ,
'QColor' => 'QColorH',
'QColor*'  => 'QColorH' ,
'QColorDialog*' => 'QColorDialogH',
'QColorDrag*' => 'QColorDragH',
'QColorGroup&' => 'QColorGroupH',
'QColorGroup'  =>  'QColorGroupH' ,
'QColorGroup*'  => 'QColorGroupH' ,
'QColorGroup::ColorRole'  => 'longint' ,
'QComboBox*'  =>  'QComboBoxH' ,
'QComboBox::Policy'  => 'longint' ,
'QComboBox::Policypolicy::AtBottom'  => 'longint' ,
'QComboTableItem*' => 'QComboTableItemH',
'QCommonStyle*' => 'QCommonStyleH',
'QCompactStyle*' => 'QCompactStyleH',
'QComponentFactory*' => 'QComponentFactoryH',
'QComponentFactoryInterface*' => 'QComponentFactoryInterfaceH',
'QComponentInterface*' => 'QComponentInterfaceH',
'QComponentRegistration*' => 'QComponentRegistrationH',
'QComponentServerInterface*' => 'QComponentServerInterfaceH',
'QConfigDB*'  => 'QConfigDBH' ,
'QConnection*' => 'QConnectionH',
'QConnectionList&'  => 'QConnectionListH' ,
'QConnectionList*'  =>  'QConnectionListH' ,
'QConnectionListIt&'  => 'QConnectionListItH' ,
'QConnectionListIt*' => 'QConnectionListItH',
'QConstString' => 'QConstStringH',
'QConstString*' => 'QConstStringH',
'QContextMenuEvent*' => 'QContextMenuEventH',
'QCursor&' => 'QCursorH',
'QCursor'  =>  'QCursorH' ,
'QCursor*' => 'QCursorH',
'QCustomEvent*'  =>  'QCustomEventH' ,
'QCustomMenuItem*'  =>  'QCustomMenuItemH' ,
'QDOM_NodeListPrivate*'  =>  'pointer' ,
'QDOM_NodePrivate*'  =>  'pointer' ,
'QDataBrowser*' => 'QDataBrowserH',
'QDataPump*' => 'QDataPumpH',
'QDataSink*'  => 'QDataSinkH' ,
'QDataSource*'  => 'QDataSourceH' ,
'QDataStream&' => 'QDataStreamH',
'QDataStream*'  => 'QDataStreamH' ,
'QDataTable*' => 'QDataTableH',
'QDataView*' => 'QDataViewH',
'QDate &' => 'QDateH',
'QDate date()' => 'QDateH',
'QDate&' => 'QDateH',
'QDate' => 'QDateH',
'QDate*' => 'QDateH',
'QDateEdit*' => 'QDateEditH',
'QDateTime&' => 'QDateTimeH',
'QDateTime' => 'QDateTimeH',
'QDateTime*'  => 'QDateTimeH' ,
'QDateTimeEdit*' => 'QDateTimeEditH',
'QDateTimeEditBase*' => 'QDateTimeEditBaseH',
'QDesktopWidget*' => 'QDesktopWidgetH',
'QDial*' => 'QDialH',
'QDialog*' => 'QDialogH',
'QDict*' => 'QDictH',
'QDictIterator*' => 'QDictIteratorH',
'QDir&' => 'QDirH',
'QDir' => 'QDirH',
'QDir*' => 'QDirH',
'QDir::SortSpec&'  => 'longint' ,
'QDir::SortSpec'  => 'longint' ,
'QDirSortItem*' => 'QDirSortItemH',
'QDiskFont*' => 'QDiskFontH',
'QDispatchInterface*' => 'QDispatchInterfaceH',
'QDns*' => 'QDnsH',
'QDnsSocket*' => 'QDnsSocketH',
'QDockArea*' => 'QDockAreaH',
'QDockAreaLayout*' => 'QDockAreaLayoutH',
'QDockWindow*' => 'QDockWindowH',
'QDomAttr&'  =>  'QDomAttrH' ,
'QDomAttr'  =>  'QDomAttrH' ,
'QDomAttr*' => 'QDomAttrH',
'QDomCDATASection&'  =>  'QDomCDATASectionH' ,
'QDomCDATASection'  =>  'QDomCDATASectionH' ,
'QDomCDATASection*' => 'QDomCDATASectionH',
'QDomCharacterData&'  =>  'QDomCharacterDataH' ,
'QDomCharacterData'  =>  'QDomCharacterDataH' ,
'QDomCharacterData*' => 'QDomCharacterDataH',
'QDomComment&'  =>  'QDomCommentH' ,
'QDomComment'  =>  'QDomCommentH' ,
'QDomComment*' => 'QDomCommentH',
'QDomDocument&'  =>  'QDomDocumentH' ,
'QDomDocument'  =>  'QDomDocumentH' ,
'QDomDocument*' => 'QDomDocumentH',
'QDomDocumentFragment&'  =>  'QDomDocumentFragmentH' ,
'QDomDocumentFragment'  =>  'QDomDocumentFragmentH' ,
'QDomDocumentFragment*' => 'QDomDocumentFragmentH',
'QDomDocumentType&'  =>  'QDomDocumentTypeH' ,
'QDomDocumentType'  =>  'QDomDocumentTypeH' ,
'QDomDocumentType*' => 'QDomDocumentTypeH',
'QDomElement&'  =>  'QDomElementH' ,
'QDomElement'  =>  'QDomElementH' ,
'QDomElement*' => 'QDomElementH',
'QDomEntity&'  =>  'QDomEntityH' ,
'QDomEntity'  =>  'QDomEntityH' ,
'QDomEntity*' => 'QDomEntityH',
'QDomEntityReference&'  =>  'QDomEntityReferenceH' ,
'QDomEntityReference'  =>  'QDomEntityReferenceH' ,
'QDomEntityReference*' => 'QDomEntityReferenceH',
'QDomImplementation&'  =>  'QDomImplementationH' ,
'QDomImplementation'  =>  'QDomImplementationH' ,
'QDomImplementation*' => 'QDomImplementationH',
'QDomNamedNodeMap&'  =>  'QDomNamedNodeMapH' ,
'QDomNamedNodeMap'  =>  'QDomNamedNodeMapH' ,
'QDomNamedNodeMap*' => 'QDomNamedNodeMapH',
'QDomNode&'  =>  'QDomNodeH' ,
'QDomNode'  =>  'QDomNodeH' ,
'QDomNode*' => 'QDomNodeH',
'QDomNode::NodeType' => 'longint',
'QDomNodeList&'  =>  'QDomNodeListH' ,
'QDomNodeList'  =>  'QDomNodeListH' ,
'QDomNodeList*' => 'QDomNodeListH',
'QDomNodePrivate*' => 'QDomNodePrivateH',
'QDomNotation&'  =>  'QDomNotationH' ,
'QDomNotation'  =>  'QDomNotationH' ,
'QDomNotation*' => 'QDomNotationH',
'QDomProcessingInstruction&'  =>  'QDomProcessingInstructionH' ,
'QDomProcessingInstruction'  =>  'QDomProcessingInstructionH' ,
'QDomProcessingInstruction*' => 'QDomProcessingInstructionH',
'QDomText&'  =>  'QDomTextH' ,
'QDomText'  =>  'QDomTextH' ,
'QDomText*' => 'QDomTextH',
'QDoubleValidator*' => 'QDoubleValidatorH',
'QDragEnterEvent*'  => 'QDragEnterEventH' ,
'QDragLeaveEvent*'  => 'QDragLeaveEventH' ,
'QDragManager*' => 'QDragManagerH',
'QDragMoveEvent*'  => 'QDragMoveEventH' ,
'QDragObject*'  => 'QDragObjectH' ,
'QDragResponseEvent*' => 'QDragResponseEventH',
'QDropEvent*'  => 'QDropEventH' ,
'QDropSite*' => 'QDropSiteH',
'QEditorFactory*' => 'QEditorFactoryH',
'QErrorMessage*' => 'QErrorMessageH',
'QEucJpCodec*' => 'QEucJpCodecH',
'QEucKrCodec*' => 'QEucKrCodecH',
'QEvent*' => 'QEventH',
'QFeatureListInterface*' => 'QFeatureListInterfaceH',
'QFile&' => 'QFileH',
'QFile'  => 'QFileH' ,
'QFileDialog*' => 'QFileDialogH',
'QFileIconProvider*'  => 'QFileIconProviderH' ,
'QFileInfo&' => 'QFileInfoH',
'QFileInfo*' => 'QFileInfoH',
'QFileInfoList*'  => 'QFileInfoListH' ,
'QFilePreview*'  =>  'QFilePreviewH' ,
'QFocusData*'  =>  'QFocusDataH' ,
'QFocusEvent*'  => 'QFocusEventH' ,
'QFont&' => 'QFontH',
'QFont' => 'QFontH',
'QFont*' => 'QFontH',
'QFont::CharSet' => 'longint',
'QFont::CharSetcharset::Unicode'  => 'longint' ,
'QFont::StyleHint' => 'longint',
'QFontData&'  => 'QFontDataH' ,
'QFontDatabase*' => 'QFontDatabaseH',
'QFontDialog*' => 'QFontDialogH',
'QFontInfo&' => 'QFontInfoH',
'QFontInfo' => 'QFontInfoH',
'QFontInfo*' => 'QFontInfoH',
'QFontMetrics&' => 'QFontMetricsH',
'QFontMetrics' => 'QFontMetricsH',
'QFontMetrics*' => 'QFontMetricsH',
'QFrame*'  => 'QFrameH' ,
'QFtp*' => 'QFtpH',
'QGArray&'  => 'QGArrayH' ,
'QGArray*' => 'QGArrayH',
'QGCache&'  => 'QGCacheH' ,
'QGCache*' => 'QGCacheH',
'QGCacheIterator&'  => 'QGCacheIteratorH' ,
'QGCacheIterator*' => 'QGCacheIteratorH',
'QGDict&'  => 'QGDictH' ,
'QGDict*' => 'QGDictH',
'QGDictIterator&'  => 'QGDictIteratorH' ,
'QGDictIterator*' => 'QGDictIteratorH',
'QGL*' => 'QGLH',
'QGLColormap&' => 'QGLColormapH',
'QGLColormap*' => 'QGLColormapH',
'QGLContext*'  =>  'QGLContextH' ,
'QGLFormat&'  =>  'QGLFormatH' ,
'QGLFormat'  =>  'QGLFormatH' ,
'QGLFormat*' => 'QGLFormatH',
'QGLWidget*'  =>  'QGLWidgetH' ,
'QGLayoutIterator*'  =>  'QGLayoutIteratorH' ,
'QGList&'  => 'QGListH' ,
'QGList*'  =>  'QGListH' ,
'QGListIterator&'  => 'QGListIteratorH' ,
'QGListIterator*' => 'QGListIteratorH',
'QGPlugin*' => 'QGPluginH',
'QGPluginManager*' => 'QGPluginManagerH',
'QGVector&'  => 'QGVectorH' ,
'QGVector*'  => 'QGVectorH' ,
'QGbkCodec*' => 'QGbkCodecH',
'QGfx*'  =>  'QGfxH' ,
'QGrid*'  => 'QGridH' ,
'QGrid::Direction'  => 'longint' ,
'QGridLayout*' => 'QGridLayoutH',
'QGridView*' => 'QGridViewH',
'QGroupBox*' => 'QGroupBoxH',
'QGuardedPtr*' => 'QGuardedPtrH',
'QGuardedPtrPrivate*' => 'QGuardedPtrPrivateH',
'QHBox*'  => 'QHBoxH' ,
'QHBoxLayout*'  =>  'QHBoxLayoutH' ,
'QHButtonGroup*' => 'QHButtonGroupH',
'QHGroupBox*' => 'QHGroupBoxH',
'QHeader*' => 'QHeaderH',
'QHebrewCodec*' => 'QHebrewCodecH',
'QHideEvent*'  => 'QHideEventH' ,
'QHostAddress&'  =>  'QHostAddressH' ,
'QHostAddress'  =>  'QHostAddressH' ,
'QHostAddress*'  =>  'QHostAddressH' ,
'QHttp*' => 'QHttpH',
'QIMEvent*' => 'QIMEventH',
'QIODevice*' => 'QIODeviceH',
'QIODevice::Offset' => 'longint',
'QIODeviceSource*' => 'QIODeviceSourceH',
'QIOManager*' => 'QIOManagerH',
'QIOWatch*' => 'QIOWatchH',
'QIconDrag*' => 'QIconDragH',
'QIconDragItem&'  =>  'QIconDragItemH' ,
'QIconDragItem*' => 'QIconDragItemH',
'QIconSet&'  => 'QIconSetH' ,
'QIconSet'  => 'QIconSetH' ,
'QIconSet*'  =>  'QIconSetH' ,
'QIconView*'  => 'QIconViewH' ,
'QIconViewItem*'  =>  'QIconViewItemH' ,
'QImage&' => 'QImageH',
'QImage' => 'QImageH',
'QImage*'  => 'QImageH' ,
'QImageConsumer*'  =>  'QImageConsumerH' ,
'QImageData*' => 'QImageDataH',
'QImageDecoder*' => 'QImageDecoderH',
'QImageDrag*' => 'QImageDragH',
'QImageFormat*'  =>  'QImageFormatH' ,
'QImageFormatInterface*' => 'QImageFormatInterfaceH',
'QImageFormatPlugin*' => 'QImageFormatPluginH',
'QImageFormatType*'  => 'QImageFormatTypeH' ,
'QImageIO*' => 'QImageIOH',
'QImageTextKeyLang&'  =>  'QImageTextKeyLangH' ,
'QImageTextKeyLang*' => 'QImageTextKeyLangH',
'QInputDialog*' => 'QInputDialogH',
'QIntBucket*' => 'QIntBucketH',
'QIntCache*' => 'QIntCacheH',
'QIntCacheIterator*' => 'QIntCacheIteratorH',
'QIntDict*' => 'QIntDictH',
'QIntDictIterator*' => 'QIntDictIteratorH',
'QIntValidator*' => 'QIntValidatorH',
'QInterfaceListInterface*' => 'QInterfaceListInterfaceH',
'QInterfacePtr*' => 'QInterfacePtrH',
'QInterlaceStyle*' => 'QInterlaceStyleH',
'QInternal*' => 'QInternalH',
'QJisCodec*' => 'QJisCodecH',
'QJpUnicodeConv*'  =>  'QJpUnicodeConvH' ,
'QKeyEvent*'  => 'QKeyEventH' ,
'QKeySequence&' => 'QKeySequenceH',
'QKeySequence' => 'QKeySequenceH',
'QKeySequence*' => 'QKeySequenceH',
'QKoi8Codec*' => 'QKoi8CodecH',
'QLCDNumber*' => 'QLCDNumberH',
'QLNode*'  => 'QLNodeH' ,
'QLabel*' => 'QLabelH',
'QLayout*' => 'QLayoutH',
'QLayoutItem*'  =>  'QLayoutItemH' ,
'QLayoutIterator&'  =>  'QLayoutIteratorH' ,
'QLayoutIterator'  =>  'QLayoutIteratorH' ,
'QLayoutIterator*' => 'QLayoutIteratorH',
'QLibrary*' => 'QLibraryH',
'QLibrary::Policy' => 'longint',
'QLibraryInterface*' => 'QLibraryInterfaceH',
'QLineEdit*'  =>  'QLineEditH' ,
'QLineEdit::EchoMode'  =>  'longint' ,
'QList*' => 'QListH',
'QListBox*' => 'QListBoxH',
'QListBoxItem*' => 'QListBoxItemH',
'QListBoxPixmap*' => 'QListBoxPixmapH',
'QListBoxText*' => 'QListBoxTextH',
'QListIterator*' => 'QListIteratorH',
'QListView*' => 'QListViewH',
'QListViewItem*&' => 'QListViewItemH',
'QListViewItem*' => 'QListViewItemH',
'QListViewItemIterator&'  =>  'QListViewItemIteratorH' ,
'QListViewItemIterator'  =>  'QListViewItemIteratorH' ,
'QListViewItemIterator*' => 'QListViewItemIteratorH',
'QLocalFs*' => 'QLocalFsH',
'QMCPI*' => 'QMCPIH',
'QMSG*'  => 'QMSG*' ,
'QMainWindow*'  =>  'QMainWindowH' ,
'QMainWindow::ToolBarDock' => 'longint',
'QMainWindow::ToolBarDock::Top'  =>  'longint' ,
'QMap&'  =>  'QMapH' ,
'QMap*' => 'QMapH',
'QMapConstIterator*' => 'QMapConstIteratorH',
'QMapIterator*' => 'QMapIteratorH',
'QMapNode*' => 'QMapNodeH',
'QMapNodeBase*&'  =>  'QMapNodeBaseH' ,
'QMapNodeBase*'  =>  'QMapNodeBaseH' ,
'QMapPrivate*' => 'QMapPrivateH',
'QMapPrivateBase*'  =>  'QMapPrivateBaseH' ,
'QMemArray*' => 'QMemArrayH',
'QMember'  => 'QMemberH' ,
'QMember*'  => 'QMemberH' ,
'QMenuBar*' => 'QMenuBarH',
'QMenuData*' => 'QMenuDataH',
'QMenuData**'  => 'PQMenuDataH' ,
'QMenuItem*' => 'QMenuItemH',
'QMessageBox*' => 'QMessageBoxH',
'QMetaData*'  =>  'QMetaDataH' ,
'QMetaData::Access*'  =>  'plongint' ,
'QMetaEnum*'  =>  'QMetaEnumH' ,
'QMetaEnum::Item*'  =>  'plongint' ,
'QMetaObject*&' => 'QMetaObjectH',
'QMetaObject*' => 'QMetaObjectH',
'QMetaObjectCleanUp*' => 'QMetaObjectCleanUpH',
'QMetaObjectInit*' => 'QMetaObjectInitH',
'QMetaProperty*'  =>  'QMetaPropertyH' ,
'QMimeSource*'  =>  'QMimeSourceH' ,
'QMimeSourceFactory*'  =>  'QMimeSourceFactoryH' ,
'QMotifPlusStyle*' => 'QMotifPlusStyleH',
'QMotifStyle*' => 'QMotifStyleH',
'QMouseEvent*'  => 'QMouseEventH' ,
'QMoveEvent*'  =>  'QMoveEventH' ,
'QMovie&' => 'QMovieH',
'QMovie*' => 'QMovieH',
'QMultiLineEdit*' => 'QMultiLineEditH',
'QMultiLineEditRow*' => 'QMultiLineEditRowH',
'QMutex*' => 'QMutexH',
'QNPInstance*' => 'QNPInstanceH',
'QNPStream*' => 'QNPStreamH',
'QNPWidget*' => 'QNPWidgetH',
'QNPlugin*' => 'QNPluginH',
'QNetworkOperation*'  =>  'QNetworkOperationH' ,
'QNetworkProtocol*'  =>  'QNetworkProtocolH' ,
'QNetworkProtocol::Operation'  =>  'longint' ,
'QNetworkProtocol::State'  =>  'longint' ,
'QNetworkProtocolFactory*' => 'QNetworkProtocolFactoryH',
'QNetworkProtocolFactoryBase*'  =>  'QNetworkProtocolFactoryBaseH' ,
'QObject*' => 'QObjectH',
'QObjectCleanupHandler*' => 'QObjectCleanupHandlerH',
'QObjectDictionary&'  => 'QObjectDictionaryH' ,
'QObjectDictionary*' => 'QObjectDictionaryH',
'QObjectInterface*' => 'QObjectInterfaceH',
'QObjectList&'  => 'QObjectListH' ,
'QObjectList*' => 'QObjectListH',
'QObjectListIt&'  => 'QObjectListItH' ,
'QObjectListIt*' => 'QObjectListItH',
'QPDevCmdParam*'  =>  'QPDevCmdParamH' ,
'QPNGImagePacker*' => 'QPNGImagePackerH',
'QPNGImageWriter*' => 'QPNGImageWriterH',
'QPaintDevice*' => 'QPaintDeviceH',
'QPaintDeviceMetrics*' => 'QPaintDeviceMetricsH',
'QPaintDeviceX11Data*'  =>  'QPaintDeviceX11DataH' ,
'QPaintEvent*'  => 'QPaintEventH' ,
'QPainter&'  =>  'QPainterH' ,
'QPainter*' => 'QPainterH',
'QPair*' => 'QPairH',
'QPalData*' => 'QPalDataH',
'QPalette&' => 'QPaletteH',
'QPalette' => 'QPaletteH',
'QPalette*' => 'QPaletteH',
'QPen&' => 'QPenH',
'QPen'  =>  'QPenH' ,
'QPen*' => 'QPenH',
'QPenData*' => 'QPenDataH',
'QPicture&' => 'QPictureH',
'QPicture' => 'QPictureH',
'QPicture*' => 'QPictureH',
'QPicturePrivate*' => 'QPicturePrivateH',
'QPixmap& pixmap()' => 'kde_QPixmap*',
'QPixmap&' => 'QPixmapH',
'QPixmap' => 'QPixmapH',
'QPixmap*' => 'QPixmapH',
'QPixmap::Optimization'  =>  'longint' ,
'QPixmap::Optimization' => 'longint',
'QPixmap::Optimization::DefaultOptim'  =>  'longint' ,
'QPixmapCache*' => 'QPixmapCacheH',
'QPixmapData*' => 'QPixmapDataH',
'QPlatinumStyle*' => 'QPlatinumStyleH',
'QPluginManager*' => 'QPluginManagerH',
'QPoint&' => 'QPointH',
'QPoint&pos()'  =>  'longint' ,
'QPoint&pos::pos()'  =>  'longint' ,
'QPoint' => 'QPointH',
'QPoint*'  => 'QPointH' ,
'QPointArray&' => 'QPointArrayH',
'QPointArray' => 'QPointArrayH',
'QPointArray*' => 'QPointArrayH',
'QPointVal&'  => 'QPointValH' ,
'QPointVal'  => 'QPointValH' ,
'QPolygonScanner*' => 'QPolygonScannerH',
'QPopupMenu*' => 'QPopupMenuH',
'QPrintDialog*' => 'QPrintDialogH',
'QPrinter*'  => 'QPrinterH' ,
'QPrinter::PrinterMode' => 'longint',
'QProcess*' => 'QProcessH',
'QProgressBar*' => 'QProgressBarH',
'QProgressDialog*' => 'QProgressDialogH',
'QPtrBucket*' => 'QPtrBucketH',
'QPtrCollection&' => 'QPtrCollectionH',
'QPtrCollection*' => 'QPtrCollectionH',
'QPtrCollection::Item' => 'pointer',
'QPtrCollection::Item&' => 'var pointer',
'QPtrCollection::Item*' => 'ppointer',
'QPtrDict*' => 'QPtrDictH',
'QPtrDictIterator*' => 'QPtrDictIteratorH',
'QPtrList*' => 'QPtrListH',
'QPtrListIterator*' => 'QPtrListIteratorH',
'QPtrQueue*' => 'QPtrQueueH',
'QPtrStack*' => 'QPtrStackH',
'QPtrVector*' => 'QPtrVectorH',
'QPushButton*' => 'QPushButtonH',
'QQueue*' => 'QQueueH',
'QRESULT' => 'longint',
'QRadioButton*' => 'QRadioButtonH',
'QRangeControl*' => 'QRangeControlH',
'QRect&' => 'QRectH',
'QRect' => 'QRectH',
'QRect*' => 'QRectH',
'QRegExp&' => 'QRegExpH',
'QRegExp*' => 'QRegExpH',
'QRegExpValidator*' => 'QRegExpValidatorH',
'QRegion&' => 'QRegionH',
'QRegion' => 'QRegionH',
'QRegion*' => 'QRegionH',
'QRegionData*' => 'QRegionDataH',
'QRemoteFactory*' => 'QRemoteFactoryH',
'QRemotePlugin*' => 'QRemotePluginH',
'QResizeEvent*'  => 'QResizeEventH' ,
'QRgb' => 'dword',
'QRgb*' => 'plongint',
'QRichText&'  =>  'QRichTextH' ,
'QSGIStyle*' => 'QSGIStyleH',
'QScrollBar&'  =>  'QScrollBarH' ,
'QScrollBar*'  =>  'QScrollBarH' ,
'QScrollView*' => 'QScrollViewH',
'QSemaphore*' => 'QSemaphoreH',
'QSemiModal*' => 'QSemiModalH',
'QSenderObject*' => 'QSenderObjectH',
'QServerSocket*' => 'QServerSocketH',
'QSessionManager&'  =>  'QSessionManagerH' ,
'QSessionManager*' => 'QSessionManagerH',
'QSettings*' => 'QSettingsH',
'QShared*' => 'QSharedH',
'QShowEvent*'  =>  'QShowEventH' ,
'QSignal*' => 'QSignalH',
'QSignalDict&'  => 'QSignalDictH' ,
'QSignalDict*' => 'QSignalDictH',
'QSignalDictIt&'  => 'QSignalDictItH' ,
'QSignalDictIt*' => 'QSignalDictItH',
'QSignalMapper*' => 'QSignalMapperH',
'QSignalVec&' => 'QSignalVecH',
'QSignalVec*' => 'QSignalVecH',
'QSimpleRichText*' => 'QSimpleRichTextH',
'QSize&' => 'QSizeH',
'QSize' => 'QSizeH',
'QSize*'  => 'QSizeH' ,
'QSizeGrip*' => 'QSizeGripH',
'QSizePolicy&'  =>  'QSizePolicyH' ,
'QSizePolicy'  =>  'QSizePolicyH' ,
'QSizePolicy*' => 'QSizePolicyH',
'QSizePolicy::ExpandData'  =>  'longint' ,
'QSizePolicy::SizeTypehData::Minimum'  =>  'longint' ,
'QSizePolicy::SizeTypevData::Minimum'  =>  'longint' ,
'QSjisCodec*' => 'QSjisCodecH',
'QSlider*' => 'QSliderH',
'QSmartPtr&'  =>  'QSmartPtrH' ,
'QSmartPtr*' => 'QSmartPtrH',
'QSmartPtrPrivate*' => 'QSmartPtrPrivateH',
'QSocket*' => 'QSocketH',
'QSocketDevice*'  =>  'QSocketDeviceH' ,
'QSocketNotifier*' => 'QSocketNotifierH',
'QSocketNotifier::Type' => 'longint',
'QSortedList*' => 'QSortedListH',
'QSound*' => 'QSoundH',
'QSpacerItem*'  =>  'QSpacerItemH' ,
'QSpinBox*' => 'QSpinBoxH',
'QSpinWidget*' => 'QSpinWidgetH',
'QSplitter*' => 'QSplitterH',
'QSql*' => 'QSqlH',
'QSql::Confirm' => 'longint',
'QSql::Op' => 'longint',
'QSqlCursor&' => 'QSqlCursorH',
'QSqlCursor' => 'QSqlCursorH',
'QSqlCursor*' => 'QSqlCursorH',
'QSqlDatabase*' => 'QSqlDatabaseH',
'QSqlDriver*' => 'QSqlDriverH',
'QSqlDriverCreator*' => 'QSqlDriverCreatorH',
'QSqlDriverCreatorBase*' => 'QSqlDriverCreatorBaseH',
'QSqlDriverFactoryInterface*' => 'QSqlDriverFactoryInterfaceH',
'QSqlDriverPlugin*' => 'QSqlDriverPluginH',
'QSqlEditorFactory*' => 'QSqlEditorFactoryH',
'QSqlError&' => 'QSqlErrorH',
'QSqlError' => 'QSqlErrorH',
'QSqlError*' => 'QSqlErrorH',
'QSqlField&' => 'QSqlFieldH',
'QSqlField' => 'QSqlFieldH',
'QSqlField*' => 'QSqlFieldH',
'QSqlFieldInfo&' => 'QSqlFieldInfoH',
'QSqlFieldInfo*' => 'QSqlFieldInfoH',
'QSqlForm' => 'QSqlFormH',
'QSqlForm*' => 'QSqlFormH',
'QSqlIndex&' => 'QSqlIndexH',
'QSqlIndex' => 'QSqlIndexH',
'QSqlIndex*' => 'QSqlIndexH',
'QSqlPropertyMap*' => 'QSqlPropertyMapH',
'QSqlQuery&' => 'QSqlQueryH',
'QSqlQuery' => 'QSqlQueryH',
'QSqlQuery*' => 'QSqlQueryH',
'QSqlRecord&' => 'QSqlRecordH',
'QSqlRecord' => 'QSqlRecordH',
'QSqlRecord*' => 'QSqlRecordH',
'QSqlRecordInfo&' => 'QSqlRecordInfoH',
'QSqlRecordInfo' => 'QSqlRecordInfoH',
'QSqlRecordInfo*' => 'QSqlRecordInfoH',
# template handling is far from being usable
'QSqlRecordInfoList&' => 'QSqlFieldInfoListH',
'QSqlRecordInfoList*' => 'QSqlFieldInfoListH',
'QSqlRecordInfo' => 'QSqlFieldInfoListH',
'QSqlRecordPrivate*' => 'QSqlRecordPrivateH',
'QSqlRecordShared*' => 'QSqlRecordSharedH',
'QSqlResult' => 'QSqlResultH',
'QSqlResult*' => 'QSqlResultH',
'QSqlResultShared*' => 'QSqlResultSharedH',
'QStack*' => 'QStackH',
'QStatusBar*'  => 'QStatusBarH' ,
'QStoredDrag*' => 'QStoredDragH',
'QStrIList' => 'kde_QStrIList',
'QStrIList*' => 'QStrIListH',
'QStrIVec*' => 'QStrIVecH',
'QStrList&' => 'QStrListH',
'QStrList' => 'QStrListH',
'QStrList*' => 'QStrListH',
'QStrListIterator*' => 'QStrListIteratorH',
'QStrVec*' => 'QStrVecH',
'QString&' => 'QStringH',
'QString&::null'  =>  'QStringH' ,
'QString&button0Text::null'  =>  'QStringH' ,
'QString&button1Text::null'  =>  'QStringH' ,
'QString&button2Text::null'  =>  'QStringH' ,
'QString&buttonText::null'  =>  'QStringH' ,
'QString&caption::null'  =>  'QStringH' ,
'QString&charSet::null'  =>  'QStringH' ,
'QString&context::null'  =>  'QStringH' ,
'QString&defValue::null'  =>  'QStringH' ,
'QString&dir::null'  =>  'QStringH' ,
'QString&directory::null'  =>  'QStringH' ,
'QString&filter::null'  =>  'QStringH' ,
'QString&initially::null'  =>  'QStringH' ,
'QString&location::null'  =>  'QStringH' ,
'QString&n::null'  =>  'QStringH' ,
'QString&nameFilter::null'  =>  'QStringH' ,
'QString&noButtonText::null'  =>  'QStringH' ,
'QString&search_delimiters::null'  =>  'QStringH' ,
'QString&style::null'  =>  'QStringH' ,
'QString&suffix::null'  =>  'QStringH' ,
'QString&text::null'  =>  'QStringH' ,
'QString&text_::null'  =>  'QStringH' ,
'QString&translation::null'  =>  'QStringH' ,
'QString&yesButtonText::null'  =>  'QStringH' ,
'QString' => 'QStringH',
'QString*'  => 'QStringH' ,
'QString::null'  =>  'qt_QString_null()' ,
'QStringBucket*' => 'QStringBucketH',
'QStringData*' => 'QStringDataH',
'QStringList&'  =>  'QStringListH' ,
'QStringList'  =>  'QStringListH' ,
'QStringList*'  => 'QStringListH' ,
'QStringcharSetName::null'  =>  'QStringcharSetNameH' ,
'QStyle&'  =>  'QStyleH' ,
'QStyle'  =>  'QStyleH' ,
'QStyle*' => 'QStyleH' ,
'QStyle::ScrollControl'  => 'longint' ,
'QStyle::StylePixmap' => 'longint',
'QStyle::SubControl' => 'longint',
'QStyle::SubRect' => 'longint',
'QStyleFactory*' => 'QStyleFactoryH',
'QStyleFactoryInterface*' => 'QStyleFactoryInterfaceH',
'QStyleHintReturn*' => 'QStyleHintReturnH',
'QStyleOption&' => 'longint',
'QStyleOption' => 'longint',
'QStyleOption*' => 'QStyleOptionH',
'QStylePlugin*' => 'QStylePluginH',
'QStyleSheet*'  =>  'QStyleSheetH' ,
'QStyleSheetItem&'  =>  'QStyleSheetItemH' ,
'QStyleSheetItem*'  =>  'QStyleSheetItemH' ,
'QStyleSheetItem::DisplayMode*' => 'longint',
'QStyleSheetItem::ListStyle*' => 'longint',
'QStyleSheetItem::WhiteSpaceMode' => 'longint',
'QTLWExtra*'  =>  'QTLWExtraH' ,
'QTSCIICodec*' => 'QTSCIICodecH',
'QTSMFI'  =>  'longint' ,
'QTSManip*' => 'QTSManipH',
'QTab*' => 'QTabH',
'QTabBar*'  =>  'QTabBarH' ,
'QTabBar::Shape'  => 'longint' ,
'QTabDialog*' => 'QTabDialogH',
'QTabWidget*' => 'QTabWidgetH',
'QTable*'  =>  'QTableH' ,
'QTableHeader*' => 'QTableHeaderH',
'QTableItem*'  =>  'QTableItemH' ,
'QTableSelection&'  =>  'QTableSelectionH' ,
'QTableSelection'  =>  'QTableSelectionH' ,
'QTableSelection*' => 'QTableSelectionH',
'QTableView*' => 'QTableViewH',
'QTabletEvent*' => 'QTabletEventH',
'QTextBrowser*' => 'QTextBrowserH',
'QTextCodec*'  =>  'QTextCodecH' ,
'QTextCodecFactory*' => 'QTextCodecFactoryH',
'QTextCodecFactoryInterface*' => 'QTextCodecFactoryInterfaceH',
'QTextCodecPlugin*' => 'QTextCodecPluginH',
'QTextCursor*' => 'QTextCursorH',
'QTextDecoder*'  =>  'QTextDecoderH' ,
'QTextDocument*' => 'QTextDocumentH',
'QTextDrag*' => 'QTextDragH',
'QTextEdit*' => 'QTextEditH',
'QTextEncoder*'  =>  'QTextEncoderH' ,
'QTextFormat*' => 'QTextFormatH',
'QTextIStream*' => 'QTextIStreamH',
'QTextOStream&'  =>  'QTextOStreamH' ,
'QTextOStream*' => 'QTextOStreamH',
'QTextOStreamIterator*' => 'QTextOStreamIteratorH',
'QTextParag**' => 'PQTextParagH',
'QTextStream&'  => 'QTextStreamH' ,
'QTextStream*'  => 'QTextStreamH' ,
'QTextView*' => 'QTextViewH',
'QThread*' => 'QThreadH',
'QThreadData*' => 'QThreadDataH',
'QThreadEvent*' => 'QThreadEventH',
'QTime&' => 'QTimeH',
'QTime' => 'QTimeH',
'QTime*' => 'QTimeH',
'QTimeEdit*' => 'QTimeEditH',
'QTimeWatch*' => 'QTimeWatchH',
'QTimer*' => 'QTimerH',
'QTimerEvent*'  => 'QTimerEventH' ,
'QToolBar*'  => 'QToolBarH' ,
'QToolButton*'  =>  'QToolButtonH' ,
'QToolTip*' => 'QToolTipH',
'QToolTipGroup*' => 'QToolTipGroupH',
'QTranslator*'  =>  'QTranslatorH' ,
'QTranslatorMessage&'  =>  'QTranslatorMessageH' ,
'QTranslatorMessage'  =>  'QTranslatorMessageH' ,
'QTranslatorMessage*' => 'QTranslatorMessageH',
'QTsciiCodec*' => 'QTsciiCodecH',
'QUObject*' => 'QUObjectH',
'QUnknownInterface*' => 'QUnknownInterfaceH',
'QUnknownInterface**' => 'var QUnknownInterfaceH',
'QUriDrag*' => 'QUriDragH',
'QUrl&'  =>  'QUrlH' ,
'QUrl'  =>  'QUrlH' ,
'QUrl*' => 'QUrlH',
'QUrlInfo&'  =>  'QUrlInfoH' ,
'QUrlInfo'  =>  'QUrlInfoH' ,
'QUrlInfo*' => 'QUrlInfoH',
'QUrlOperator&'  =>  'QUrlOperatorH' ,
'QUrlOperator*'  =>  'QUrlOperatorH' ,
'QUtf16Codec*' => 'QUtf16CodecH',
'QUtf8Codec*' => 'QUtf8CodecH',
'QUuid&' => 'QUuidH',
'QUuid*' => 'QUuidH',
'QVBox*'  => 'QVBoxH' ,
'QVBoxLayout*' => 'QVBoxLayoutH',
'QVButtonGroup*' => 'QVButtonGroupH',
'QVFbHeader*' => 'QVFbHeaderH',
'QVFbKeyData*' => 'QVFbKeyDataH',
'QVGroupBox*' => 'QVGroupBoxH',
'QValidator*' => 'QValidatorH',
'QValidator::State' => 'longint',
'QValueList*' => 'QValueListH',
'QValueListConstIterator*' => 'QValueListConstIteratorH',
'QValueListIterator*' => 'QValueListIteratorH',
'QValueListNode*' => 'QValueListNodeH',
'QValueListPrivate*' => 'QValueListPrivateH',
'QValueStack*' => 'QValueStackH',
'QValueVector*' => 'QValueVectorH',
'QValueVectorPrivate*' => 'QValueVectorPrivateH',
'QVariant&' => 'QVariantH',
'QVariant' => 'QVariantH',
'QVariant*' => 'QVariantH',
'QVariant::Type'  => 'longint' ,
'QVariantPrivate*'  =>  'QVariantPrivateH' ,
'QVector*' => 'QVectorH',
'QWExtra*'  =>  'QWExtraH' ,
'QWMatrix&' => 'QWMatrixH',
'QWMatrix' => 'QWMatrixH',
'QWMatrix*' => 'QWMatrixH',
'QWSDecoration&'  =>  'QWSDecorationH' ,
'QWSDecoration*'  =>  'QWSDecorationH' ,
'QWSDisplay*'  =>  'QWSDisplayH' ,
'QWSEvent*'  =>  'QWSEventH' ,
'QWaitCondition*' => 'QWaitConditionH',
'QWhatsThis*' => 'QWhatsThisH',
'QWheelEvent*'  =>  'QWheelEventH' ,
'QWidget *' => 'QWidgetH',
'QWidget' => 'QWidgetH',
'QWidget*' => 'QWidgetH',
'QWidgetFactory*' => 'QWidgetFactoryH',
'QWidgetIntDict&'  => 'QWidgetIntDictH' ,
'QWidgetIntDict*' => 'QWidgetIntDictH',
'QWidgetIntDictIt&'  => 'QWidgetIntDictItH' ,
'QWidgetIntDictIt*' => 'QWidgetIntDictItH',
'QWidgetItem*' => 'QWidgetItemH',
'QWidgetList&'  => 'QWidgetListH' ,
'QWidgetList&'  => 'QWidgetListH' ,
'QWidgetList'  =>  'QWidgetListH' ,
'QWidgetList'  =>  'QWidgetListH' ,
'QWidgetList*' => 'QWidgetListH',
'QWidgetList*' => 'QWidgetListH',
'QWidgetListIt&'  => 'QWidgetListItH' ,
'QWidgetListIt*' => 'QWidgetListItH',
'QWidgetMapper*' => 'QWidgetMapperH',
'QWidgetPlugin*' => 'QWidgetPluginH',
'QWidgetStack*' => 'QWidgetStackH',
'QWindowsMime*'  =>  'QWindowsMimeH' ,
'QWindowsStyle*' => 'QWindowsStyleH',
'QWizard*' => 'QWizardH',
'QWorkspace*' => 'QWorkspaceH',
'QXEmbed*'  =>  'QXEmbedH' ,
'QXmlAttributes&'  =>  'QXmlAttributesH' ,
'QXmlAttributes*' => 'QXmlAttributesH',
'QXmlContentHandler*'  =>  'QXmlContentHandlerH' ,
'QXmlDTDHandler*'  =>  'QXmlDTDHandlerH' ,
'QXmlDeclHandler*'  =>  'QXmlDeclHandlerH' ,
'QXmlDefaultHandler*' => 'QXmlDefaultHandlerH',
'QXmlEntityResolver*'  =>  'QXmlEntityResolverH' ,
'QXmlErrorHandler*'  =>  'QXmlErrorHandlerH' ,
'QXmlInputSource&'  =>  'QXmlInputSourceH' ,
'QXmlInputSource*&' => 'QXmlInputSourceH',
'QXmlInputSource*'  =>  'QXmlInputSourceH' ,
'QXmlLexicalHandler*'  =>  'QXmlLexicalHandlerH' ,
'QXmlLocator*'  =>  'QXmlLocatorH' ,
'QXmlNamespaceSupport*' => 'QXmlNamespaceSupportH',
'QXmlParseException&'  =>  'QXmlParseExceptionH' ,
'QXmlParseException*' => 'QXmlParseExceptionH',
'QXmlReader*' => 'QXmlReaderH',
'QXmlSimpleReader*'  =>  'QXmlSimpleReaderH' ,
'QXtApplication*' => 'QXtApplicationH',
'QXtWidget*' => 'QXtWidgetH',
'Q_INT16&' => 'var smallint',
'Q_INT16' => 'smallint',
'Q_INT32&' => 'var longint',
'Q_INT32' => 'longint',
'Q_INT8&' => 'var shortint',
'Q_INT8' => 'shortint',
'Q_LONG&' => 'var longint',
'Q_LONG' => 'longint',
'Q_PACKED*' => 'pointer',
'Q_UINT16&' => 'var word',
'Q_UINT16' => 'word',
'Q_UINT32&' => 'var dword',
'Q_UINT32' => 'dword',
'Q_UINT8&' => 'var byte',
'Q_UINT8' => 'byte',
'Q_UINT8*'  =>  'pbyte' ,
'Q_ULONG&' => 'var longint',
'Q_ULONG' => 'longint',
'Qt*'  =>  'QtH' ,
'Qt::ArrowType'  =>  'longint' ,
'Qt::BackgroundMode' => 'longint',
'Qt::DateFormat' => 'longint',
'Qt::GUIStyle'  => 'longint' ,
'Qt::GUIStylecolorStyle::WindowsStyle'  => 'longint' ,
'Qt::GUIStylestyle::WindowsStyle'  => 'longint' ,
'Qt::Orientation'  =>  'longint' ,
'Qt::RasterOp'  =>  'longint' ,
'Qt::UIEffect'  =>  'longint' ,
'Qt::WFlags'  =>  'longint' ,
'QtMultiLineEdit*' => 'QtMultiLineEditH',
'QtMultiLineEditRow*' => 'QtMultiLineEditRowH',
'QtTableView*' => 'QtTableViewH',
'QwAbsSpriteFieldView*'  =>  'QwAbsSpriteFieldViewH' ,
'QwClusterizer*'  =>  'QwClusterizerH' ,
'QwEllipse*' => 'QwEllipseH',
'QwImageSpriteField*' => 'QwImageSpriteFieldH',
'QwMobilePositionedSprite*' => 'QwMobilePositionedSpriteH',
'QwMobileSprite*' => 'QwMobileSpriteH',
'QwPolygon*' => 'QwPolygonH',
'QwPolygonalGraphic*' => 'QwPolygonalGraphicH',
'QwPositionedSprite*' => 'QwPositionedSpriteH',
'QwPublicList*'  =>  'QwPublicListH' ,
'QwRealMobileSprite*' => 'QwRealMobileSpriteH',
'QwRealSprite*' => 'QwRealSpriteH',
'QwRectangle*' => 'QwRectangleH',
'QwScrollingSpriteFieldView*' => 'QwScrollingSpriteFieldViewH',
'QwSprite*' => 'QwSpriteH',
'QwSpriteField*'  =>  'QwSpriteFieldH' ,
'QwSpriteField*'  => 'QwSpriteFieldH' ,
'QwSpriteFieldGraphic&'  => 'QwSpriteFieldGraphicH' ,
'QwSpriteFieldGraphic*'  =>  'QwSpriteFieldGraphicH' ,
'QwSpriteFieldView*' => 'QwSpriteFieldViewH',
'QwSpritePixmap*'  =>  'QwSpritePixmapH' ,
'QwSpritePixmapSequence*'  => 'QwSpritePixmapSequenceH' ,
'QwTextSprite*' => 'QwTextSpriteH',
'QwTiledSpriteField*' => 'QwTiledSpriteFieldH',
'QwVirtualSprite*' => 'QwVirtualSpriteH',
'RArray*' => 'PRArray',
'RGBColor&' => 'kde_RGBColor*',
'RGBColor' => 'kde_RGBColor*',
'RGBColor*' => 'PRGBColor',
'Range&' => 'kde_Range*',
'Range' => 'kde_Range*',
'Range*' => 'PRange',
'RangeException&' => 'kde_RangeException*',
'RangeException*' => 'PRangeException',
'RangeImpl*' => 'PRangeImpl',
'RasterOp' => 'longint',
'RawDataPacket*' => 'PRawDataPacket',
'ReadOnlyPart*' => 'PReadOnlyPart',
'ReadWritePart*' => 'PReadWritePart',
'Rect&' => 'kde_Rect*',
'Rect' => 'kde_Rect*',
'Rect*' => 'PRect',
'Reference&' => 'var pointer',
'Reference*' => 'ppointer',
'_reference' => 'pointer',
'reference' => 'pointer',
'ReferenceClean*' => 'PReferenceClean',
'ReferenceHelper*' => 'PReferenceHelper',
'Region' => 'longint',
'RegionType' => 'longint',
'RemoteScheduleNode*' => 'PRemoteScheduleNode',
'RenameDlg*' => 'PRenameDlg',
'RenderStyle*'  =>  'kde_RenderStyle*' ,
'Rep*' => 'PRep',
'RunMode'  =>  'longint' ,
'SButton*' => 'PSButton',
'SCFlags' => 'longint',
'SFlags' => 'longint',
'ScheduleNode*' => 'PScheduleNode',
'Scheduler*' => 'PScheduler',
'ScrollBarMode' => 'longint',
'ScrollControl'  =>  'longint' ,
'SearchInterface*' => 'PSearchInterface',
'Section&'  =>  'kde_Section*' ,
'Section*&'  =>  'kde_Section*' ,
'Section*'  =>  'kde_Section*' ,
'SegmentStyle' => 'longint',
'SelectionInterface*' => 'PSelectionInterface',
'Separator' => 'longint',
'Server&'  =>  'Server*' ,
'Server*' => 'PServer',
'ServerHello&' => 'kde_ServerHello*',
'ServerHello*' => 'PServerHello',
'Service*' => 'PService',
'SessionData*' => 'PSessionData',
'SimpleFormat*' => 'PSimpleFormat',
'SimpleJob*' => 'PSimpleJob',
'SimpleSoundServer&' => 'kde_SimpleSoundServer*',
'SimpleSoundServer' => 'kde_SimpleSoundServer*',
'SimpleSoundServer*' => 'PSimpleSoundServer',
'SimpleSoundServer_base*' => 'PSimpleSoundServer_base',
'SimpleSoundServer_skel*' => 'PSimpleSoundServer_skel',
'SimpleSoundServer_stub*' => 'PSimpleSoundServer_stub',
'SkipDlg*' => 'PSkipDlg',
'Slave*' => 'PSlave',
'SlaveBase*' => 'PSlaveBase',
'SlaveBasePrivate*' => 'PSlaveBasePrivate',
'SlaveConfig*' => 'PSlaveConfig',
'SlaveInterface*' => 'PSlaveInterface',
'SocketConnection*' => 'PSocketConnection',
'Spec' => 'longint',
'SpecialEvent*' => 'PSpecialEvent',
'SshProcess*' => 'PSshProcess',
'SshProcessPrivate*' => 'PSshProcessPrivate',
'StartupClass*' => 'PStartupClass',
'StartupManager*' => 'PStartupManager',
'StatJob*' => 'PStatJob',
'State' => 'longint',
'StatusbarProgress*' => 'PStatusbarProgress',
'StdAddressBook*' => 'PStdAddressBook',
'StdFlowSystem*' => 'PStdFlowSystem',
'StdIOManager*' => 'PStdIOManager',
'StdScheduleNode*' => 'PStdScheduleNode',
'StdSynthModule*' => 'PStdSynthModule',
'StereoEffect&' => 'kde_StereoEffect*',
'StereoEffect' => 'kde_StereoEffect*',
'StereoEffect*' => 'PStereoEffect',
'StereoEffectStack&' => 'kde_StereoEffectStack*',
'StereoEffectStack' => 'kde_StereoEffectStack*',
'StereoEffectStack*' => 'PStereoEffectStack',
'StereoEffectStack_base*' => 'PStereoEffectStack_base',
'StereoEffectStack_skel*' => 'PStereoEffectStack_skel',
'StereoEffectStack_stub*' => 'PStereoEffectStack_stub',
'StereoEffect_base*' => 'PStereoEffect_base',
'StereoEffect_skel*' => 'PStereoEffect_skel',
'StereoEffect_stub*' => 'PStereoEffect_stub',
'StereoFFTScope&' => 'kde_StereoFFTScope*',
'StereoFFTScope' => 'kde_StereoFFTScope*',
'StereoFFTScope*' => 'PStereoFFTScope',
'StereoFFTScope_base*' => 'PStereoFFTScope_base',
'StereoFFTScope_skel*' => 'PStereoFFTScope_skel',
'StereoFFTScope_stub*' => 'PStereoFFTScope_stub',
'StereoVolumeControl&' => 'kde_StereoVolumeControl*',
'StereoVolumeControl' => 'kde_StereoVolumeControl*',
'StereoVolumeControl*' => 'PStereoVolumeControl',
'StereoVolumeControl_base*' => 'PStereoVolumeControl_base',
'StereoVolumeControl_skel*' => 'PStereoVolumeControl_skel',
'StereoVolumeControl_stub*' => 'PStereoVolumeControl_stub',
'StreamMode&' => 'longint',
'String*' => 'PString',
'StringSectionMap::iterator&'  =>  'kde_StringSectionMap*' ,
'StringSectionMap::iterator'  =>  'kde_StringSectionMap*r' ,
'StubProcess*' => 'PStubProcess',
'StyleHint' => 'longint',
'StyleListImpl*' => 'PStyleListImpl',
'StylePixmap' => 'longint',
'StyleSheet&' => 'kde_StyleSheet*',
'StyleSheet' => 'kde_StyleSheet*',
'StyleSheet*' => 'PStyleSheet',
'StyleSheetImpl*' => 'PStyleSheetImpl',
'StyleSheetList&' => 'kde_StyleSheetList*',
'StyleSheetList' => 'kde_StyleSheetList',
'StyleSheetList*' => 'PStyleSheetList',
'StyleSheetListImpl*' => 'PStyleSheetListImpl',
'StyleStrategy' => 'longint',
'SuProcess*' => 'PSuProcess',
'SubClass&' => 'kde_SubClass*',
'SubClass*' => 'PSubClass',
'SubControl' => 'longint',
'SubRect' => 'longint',
'SynthBuffer*' => 'PSynthBuffer',
'SynthModule&' => 'kde_SynthModule*',
'SynthModule' => 'kde_SynthModule*',
'SynthModule*' => 'PSynthModule',
'SynthModule_base*' => 'PSynthModule_base',
'SynthModule_skel*' => 'PSynthModule_skel',
'SynthModule_stub*' => 'PSynthModule_stub',
'SynthOut*' => 'PSynthOut',
'Synth_ADD&' => 'kde_Synth_ADD*',
'Synth_ADD' => 'kde_Synth_ADD*',
'Synth_ADD*' => 'PSynth_ADD',
'Synth_ADD_base*' => 'PSynth_ADD_base',
'Synth_ADD_skel*' => 'PSynth_ADD_skel',
'Synth_ADD_stub*' => 'PSynth_ADD_stub',
'Synth_AMAN_PLAY&' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY*' => 'PSynth_AMAN_PLAY',
'Synth_AMAN_PLAY_base*' => 'PSynth_AMAN_PLAY_base',
'Synth_AMAN_PLAY_skel*' => 'PSynth_AMAN_PLAY_skel',
'Synth_AMAN_PLAY_stub*' => 'PSynth_AMAN_PLAY_stub',
'Synth_AMAN_RECORD&' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD*' => 'PSynth_AMAN_RECORD',
'Synth_AMAN_RECORD_base*' => 'PSynth_AMAN_RECORD_base',
'Synth_AMAN_RECORD_skel*' => 'PSynth_AMAN_RECORD_skel',
'Synth_AMAN_RECORD_stub*' => 'PSynth_AMAN_RECORD_stub',
'Synth_BUS_DOWNLINK&' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK*' => 'PSynth_BUS_DOWNLINK',
'Synth_BUS_DOWNLINK_base*' => 'PSynth_BUS_DOWNLINK_base',
'Synth_BUS_DOWNLINK_skel*' => 'PSynth_BUS_DOWNLINK_skel',
'Synth_BUS_DOWNLINK_stub*' => 'PSynth_BUS_DOWNLINK_stub',
'Synth_BUS_UPLINK&' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK*' => 'PSynth_BUS_UPLINK',
'Synth_BUS_UPLINK_base*' => 'PSynth_BUS_UPLINK_base',
'Synth_BUS_UPLINK_skel*' => 'PSynth_BUS_UPLINK_skel',
'Synth_BUS_UPLINK_stub*' => 'PSynth_BUS_UPLINK_stub',
'Synth_FREQUENCY&' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY*' => 'PSynth_FREQUENCY',
'Synth_FREQUENCY_base*' => 'PSynth_FREQUENCY_base',
'Synth_FREQUENCY_skel*' => 'PSynth_FREQUENCY_skel',
'Synth_FREQUENCY_stub*' => 'PSynth_FREQUENCY_stub',
'Synth_MUL&' => 'kde_Synth_MUL*',
'Synth_MUL' => 'kde_Synth_MUL*',
'Synth_MUL*' => 'PSynth_MUL',
'Synth_MULTI_ADD&' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD*' => 'PSynth_MULTI_ADD',
'Synth_MULTI_ADD_base*' => 'PSynth_MULTI_ADD_base',
'Synth_MULTI_ADD_skel*' => 'PSynth_MULTI_ADD_skel',
'Synth_MULTI_ADD_stub*' => 'PSynth_MULTI_ADD_stub',
'Synth_MUL_base*' => 'PSynth_MUL_base',
'Synth_MUL_skel*' => 'PSynth_MUL_skel',
'Synth_MUL_stub*' => 'PSynth_MUL_stub',
'Synth_PLAY&' => 'kde_Synth_PLAY*',
'Synth_PLAY' => 'kde_Synth_PLAY*',
'Synth_PLAY*' => 'PSynth_PLAY',
'Synth_PLAY_WAV&' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV*' => 'PSynth_PLAY_WAV',
'Synth_PLAY_WAV_base*' => 'PSynth_PLAY_WAV_base',
'Synth_PLAY_WAV_skel*' => 'PSynth_PLAY_WAV_skel',
'Synth_PLAY_WAV_stub*' => 'PSynth_PLAY_WAV_stub',
'Synth_PLAY_base*' => 'PSynth_PLAY_base',
'Synth_PLAY_skel*' => 'PSynth_PLAY_skel',
'Synth_PLAY_stub*' => 'PSynth_PLAY_stub',
'Synth_RECORD&' => 'kde_Synth_RECORD*',
'Synth_RECORD' => 'kde_Synth_RECORD*',
'Synth_RECORD*' => 'PSynth_RECORD',
'Synth_RECORD_base*' => 'PSynth_RECORD_base',
'Synth_RECORD_skel*' => 'PSynth_RECORD_skel',
'Synth_RECORD_stub*' => 'PSynth_RECORD_stub',
'Synth_WAVE_SIN&' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN*' => 'PSynth_WAVE_SIN',
'Synth_WAVE_SIN_base*' => 'PSynth_WAVE_SIN_base',
'Synth_WAVE_SIN_skel*' => 'PSynth_WAVE_SIN_skel',
'Synth_WAVE_SIN_stub*' => 'PSynth_WAVE_SIN_stub',
'T&'  =>  'var' ,
'T'  =>  'const' ,
'T*'  =>  'pointer' ,
'TCPConnection*' => 'PTCPConnection',
'TCPServer*' => 'PTCPServer',
'TCPSlaveBase*' => 'PTCPSlaveBase',
'TRUE' => '1',
'Task*' => 'PTask',
'Text&' => 'kde_Text*',
'Text' => 'kde_Text*',
'Text*' => 'PText',
'TextFormat'  =>  'longint' ,
'TextImpl*' => 'PTextImpl',
'ThumbCreator*' => 'PThumbCreator',
'TickSetting' => 'longint',
'Ticket*' => 'PTicket',
'TimeNotify*' => 'PTimeNotify',
'TimeWatcher*' => 'PTimeWatcher',
'TimeZone&' => 'kde_TimeZone*',
'TimeZone*' => 'PTimeZone',
'TmpGlobalComm&' => 'kde_TmpGlobalComm*',
'TmpGlobalComm' => 'kde_TmpGlobalComm*',
'TmpGlobalComm*' => 'PTmpGlobalComm',
'TmpGlobalComm_base*' => 'PTmpGlobalComm_base',
'TmpGlobalComm_skel*' => 'PTmpGlobalComm_skel',
'TmpGlobalComm_stub*' => 'PTmpGlobalComm_stub',
'ToolBarDock&'  =>  'longint' ,
'ToolBarDock' => 'longint',
'TraderOffer&' => 'kde_TraderOffer*',
'TraderOffer' => 'kde_TraderOffer*',
'TraderOffer*' => 'PTraderOffer',
'TraderOffer_base*' => 'PTraderOffer_base',
'TraderOffer_skel*' => 'PTraderOffer_skel',
'TraderOffer_stub*' => 'PTraderOffer_stub',
'TraderQuery&' => 'kde_TraderQuery*',
'TraderQuery' => 'kde_TraderQuery*',
'TraderQuery*' => 'PTraderQuery',
'TraderQuery_base*' => 'PTraderQuery_base',
'TraderQuery_skel*' => 'PTraderQuery_skel',
'TraderQuery_stub*' => 'PTraderQuery_stub',
'TransferJob*' => 'PTransferJob',
'TreeWalker&' => 'kde_TreeWalker*',
'TreeWalker' => 'kde_TreeWalker*',
'TreeWalker*' => 'PTreeWalker',
'TreeWalkerImpl*' => 'PTreeWalkerImpl',
'True' => '1',
'Type&' => 'kde_Type*',
'Type' => 'longint',
'Type*' => 'PType',
'TypeComponent&' => 'kde_TypeComponent*',
'TypeComponent*' => 'PTypeComponent',
'TypeDef&' => 'kde_TypeDef*',
'TypeDef' => 'kde_TypeDef*',
'TypeDef*' => 'PTypeDef',
'TypeEntry*' => 'PTypeEntry',
'TypeInfo*' => 'PTypeInfo',
'UChar&' => 'var char',
'UChar' => 'char',
'UChar*' => 'pchar',
'UCharReference&' => 'kde_UCharReference*',
'UCharReference' => 'kde_UCharReference*',
'UCharReference*' => 'PUCharReference',
'UDSAtom*' => 'PUDSAtom',
'UDSEntry&' => 'kde_UDSEntry*',
'UDSEntryList&' => 'kde_UDSEntryList*',
'UIServer*' => 'PUIServer',
'UIServer_stub*' => 'PUIServer_stub',
'ULONG_MAX' => 'ULONG_MAX',
'URLArgs&' => 'kde_URLArgs*',
'URLArgs' => 'kde_URLArgs*',
'URLArgs*' => 'PURLArgs',
'UString&' => 'kde_UString*',
'UString' => 'kde_UString*',
'UString*' => 'PUString',
'Undefined*' => 'PUndefined',
'UndoInterface*' => 'PUndoInterface',
'UndoRedoInfo*' => 'PUndoRedoInfo',
'UnixConnection*' => 'PUnixConnection',
'UnixServer*' => 'PUnixServer',
'VCardFormat*' => 'PVCardFormat',
'VPort*' => 'PVPort',
'Value&' => 'kde_Value*',
'Value' => 'kde_Value*',
'Value*' => 'PValue',
'VerticalAlignment*' => 'PVerticalAlignment',
'View*'  =>  'kde_View*' ,
'ViewCursorInterface*' => 'PViewCursorInterface',
'VoiceManager*' => 'PVoiceManager',
'WFlags' => 'longint',
'WId' => 'dword',
'WState' => 'longint',
'WavPlayObject&' => 'kde_WavPlayObject*',
'WavPlayObject' => 'kde_WavPlayObject*',
'WavPlayObject*' => 'PWavPlayObject',
'WavPlayObject_base*' => 'PWavPlayObject_base',
'WavPlayObject_skel*' => 'PWavPlayObject_skel',
'WavPlayObject_stub*' => 'PWavPlayObject_stub',
'WeakReference*' => 'PWeakReference',
'WeakReferenceBase*' => 'PWeakReferenceBase',
'Widget'  =>  'longint' ,
'WidgetClass'  =>  'longint' ,
'WidthMode' => 'longint',
'Window' => 'kde_Window*',
'Window*' => 'PWindow',
'WindowArgs&' => 'kde_WindowArgs*',
'WindowArgs*' => 'PWindowArgs',
'WindowsVersion'  =>  'longint' ,
'XEvent *' => 'XEvent *',
'XEvent*' => 'PXEvent',
'XrmOptionDescRec*'  =>  'PXrmOptionDescRec' ,
'array_data*'  =>  'pointer' ,
'bitarr_data*' => 'pointer',
'bool&'  =>  'longint' ,
'bool' => 'longint',
'bool*' => 'pboolean',
'char *' => 'pchar',
'char&'  =>  'char' ,
'char' => 'char',
'char* bugsEmailAddress @bugs.kde.org"' => 'String',
'char*&' => 'var pchar',
'char*' => 'pchar',
'char**' => 'ppchar',
'char*xpm[]'  =>  'char**' ,
'classConnection*' => 'PclassConnection',
'classDeviceManager*' => 'PclassDeviceManager',
'classExtensionLoader*' => 'PclassExtensionLoader',
'classMidiStatus*' => 'PclassMidiStatus',
'classObjectReference' => 'kde_classObjectReference*',
'classQPainter*' => 'PclassQPainter',
'classStartupClass*' => 'PclassStartupClass',
'double d .0' => 'double',
'double nDefault .0' => 'double',
'double pri .0' => 'double',
'double&'  =>  'var double' ,
'double' => 'double',
'double*'  =>  'pdouble' ,
'false' => '0',
'float desat .3' => 'single',
'float&'  =>  'var single' ,
'float' => 'single',
'float*' => 'psingle',
'image_io_handler'  =>  'longint' ,
'int a  |' => 'longint',
'int buttonMask|Apply|Cancel' => 'longint',
'int buttonMask|No|Cancel' => 'longint',
'int desktop' => 'longint',
'int&' => 'longint',
'int' => 'longint',
'int*' => 'plongint',
'unsigned int&' => 'dword',
'unsigned int' => 'dword',
'unsigned int*' => 'pdword',
'kdbgstream&'  => 'kde_Kdbgstream*' ,
'kdbgstream*'  =>  'kde_kdbgstream*',
'khtml*'  =>  'kde_khtml*',
'khtml::ChildFrame*'  => 'kde_khtml_ChildFrame*' ,
'khtml::DrawContentsEvent*'  => 'kde_khtml_DrawContentsEvent*' ,
'khtml::MouseDoubleClickEvent*'  => 'kde_khtml_MouseDoubleClickEvent*' ,
'khtml::MouseMoveEvent*'  => 'kde_khtml_MouseMoveEvent*' ,
'khtml::MousePressEvent*'  => 'kde_khtml_MousePressEvent*' ,
'khtml::MouseReleaseEvent*'  => 'kde_khtml_MouseReleaseEvent*' ,
'khtml::RenderObject*'  => 'kde_khtml_RenderObject*' ,
'khtml::RenderStyle*'  => 'kde_khtml_RenderStyle*' ,
'khtml__DrawContentsEvent*'  =>  'kde_khtml__DrawContentsEvent*',
'khtml__MouseDoubleClickEvent*'  =>  'kde_khtml__MouseDoubleClickEvent*',
'khtml__MouseEvent*'  =>  'kde_khtml__MouseEvent*',
'khtml__MouseMoveEvent*'  =>  'kde_khtml__MouseMoveEvent*',
'khtml__MousePressEvent*'  =>  'kde_khtml__MousePressEvent*',
'khtml__MouseReleaseEvent*'  =>  'kde_khtml__MouseReleaseEvent*',
'kndbgstream&'  => 'void**' ,
'kndbgstream*'  =>  'kde_kndbgstream*',
'ksockaddr_in*'  => 'pointer' ,
'long _blockSize *' => 'long *',
'long int' => 'longint',
'long unsigned int' => 'longint',
'long&'  =>  'var longint' ,
'long' => 'longint',
'long_blockSize*'  =>  'long_blockSize*' ,
'int' => 'longint',
'longunsigned int' => 'unsigned long',
'lt_dlhandle'  =>  'void *' ,
'lt_user_dlloader*'  =>  'kde_lt_user_dlloader*',
'mcopbyte&' => 'void *',
'mcopbyte' => 'unsigned char',
'mode_t _mode (mode_t) -1' => 'longint',
'mode_t'  =>  'longint' ,
'noteCmd' => 'kde_noteCmd*',
'noteCmd*' => 'PnoteCmd',
'ostream&' => 'longint',
'ostream*' => 'longint',
'pid_t'  =>  'longint' ,
'poTime&' => 'kde_poTime*',
'poTime*' => 'PpoTime',
'short unsigned' => 'word',
'short' => 'word',
'short*' => 'pshort',
'shortunsigned' => 'word',
'signed int&'  =>  'var longint' ,
'signed long&'  =>  'var longint' ,
'signed short&'  =>  'var integer' ,
'signed'  =>  'signed' ,
'size_t'  =>  'longint' ,
'size_t*' => 'pdword',
'size_type'  =>  'longint' ,
'snd_seq_event_t*' => 'Psnd_seq_event_t',
'ssize_t' => 'longint',
'std*' => 'Pstd',
'std::string&'  =>  'var pchar' ,
'std::string'  =>  'pchar' ,
'time_t'  =>  'longint' ,
'timeval&' => 'var longint',
'true' => '1',
'type&'  =>  'var longint' ,
'type*'  =>  'plongint' ,
'type**'  =>  'pplongint' ,
'Type&'  =>  'var longint' ,
'Type*'  =>  'plongint' ,
'Type**'  =>  'pplongint' ,
'uchar&'  =>  'var char' ,
'uchar'  =>  'char' ,
'uchar*' => 'pchar',
'uchar**' => 'ppchar',
'uint&' => 'dword',
'uint' => 'dword',
'uint*'  =>  'pdword' ,
'uintf~0'  =>  'dword' ,
'ulong' => 'dword',
'unsigned char&' => 'byte',
'unsigned char'  =>  'byte' ,
'unsigned char*'  =>  'pbyte' ,
'unsigned int&'  =>  'unsigned int' ,
'unsigned int'  =>  'unsigned int' ,
'unsigned int*'  =>  'pdword' ,
'unsigned long int' => 'dword',
'unsigned long&'  =>  'dword' ,
'unsigned long'  =>  'dword' ,
'unsigned short int'  =>  'word' ,
'unsigned short&'  =>  'word' ,
'unsigned short'  =>  'word' ,
'unsigned short*'  =>  'pword' ,
'unsigned shortint'  =>  'word' ,
'unsigned'  =>  'dword' ,
'ushort&' => 'var word',
'ushort*'  =>  'pword' ,
'ushort' => 'word',
'voice*' => 'longint',
'void' => 'void',
'void(*)()'  =>  'void(*)()' ,
'void*' => 'pointer',
'~' => '~',
'QValueList<int>' => 'QIntValueListH',
'QValueList<int>&' => 'QIntValueListH',
'QValueList<QIconDragItem>&' => 'QIconDragItemValueListH',
'QValueList<QPixmap>' => 'QPixmapValueListH',
'QValueList<QString>&' => 'QStringValueListH',
'QValueList<QVariant>&' => 'QVariantValueListH',
'QValueList<QUrlInfo>*' => 'QUrlInfoValueListH',
'QValueList<KDataToolInfo>&' => 'kde_KDataToolInfoValueList*',
'QPtrList<KAction>&' => 'kde_KActionPtrList*',
'QPtrList<KSSLCertificate>&' => 'kde_KSSLCertificatePtrList*',
'QPtrList<KXMLGUIClient>*' => 'kde_KXMLGUIClientPtrList*',
'QPtrList<QDockWindow>*' => 'QDockWindowPtrListH',
'QPtrList<QPixmap>' => 'QPixmapPtrListH',
'QPtrList<QPoint>' => 'QPointPtrListH',
'KService::Ptr&' => 'kde_KServicePtr*',
'ClassContext*' => 'PClassContext',
'ClassStoreIface*' => 'PClassStoreIface',
'ClipboardDocumentIface*' => 'PClipboardDocumentIface',
'CodeCompletionDocumentIface*' => 'PCodeCompletionDocumentIface',
'CursorDocumentIface*' => 'PCursorDocumentIface',
'DebugDocumentIface*' => 'PDebugDocumentIface',
'DocumentInterface*' => 'PDocumentInterface',
'EditDocumentIface*' => 'PEditDocumentIface',
'EditorInterface*' => 'PEditorInterface',
'FileContext*' => 'PFileContext',
'KDevAppFrontendIface*' => 'PKDevAppFrontendIface',
'KDevCoreIface*' => 'PKDevCoreIface',
'KDevMakeFrontendIface*' => 'PKDevMakeFrontendIface',
'KEditor*' => 'PKEditor',
'KEditor::Document*' => 'kde_Document*',
'ParsedClassContainer&' => 'kde_ParsedClassContainer*',
'ParsedContainer&' => 'kde_ParsedContainer*',
'ParsedScopeContainer&' => 'kde_ParsedScopeContainer*',
'QValueList<ParsedMethod>*' => 'kde_ParsedMethodList*',
'QValueList<CompletionEntry>' => 'kde_CompletionEntryValueList*',
'StatusDocumentIface*' => 'PStatusDocumentIface',
'UndoDocumentIface*' => 'PUndoDocumentIface',
'KShortcut&' => 'kde_KShortcut*',
'KShortcut' => 'kde_KShortcut*',
'KShortcut*' => 'PKShortcut',
'KKey&' => 'kde_KKey*',
'KKey*' => 'PKKey',
'KKeyNative&' => 'kde_KKeyNative*',
'KKeyNative*' => 'PKKeyNative',
'KKeyVariations&' => 'kde_KKeyVariations*',
'KKeyVariations*' => 'PKKeyVariations',
'KKeyX11&' => 'kde_KKeyX11*',
'KKeyX11' => 'kde_KKeyX11*',
'KKeyX11*' => 'PKKeyX11',
'KAccelActions' => 'kde_KAccelActions*',
'KRandomSequence&' => 'kde_KRandomSequence*',
'KIcon::Context' => 'longint',
'KIcon::Group' => 'longint',
'K' => 'var',
'_NPStream*' => 'pointer',
'pointer' => 'pointer',
);


# A hard coded type translation table (the idea from the Roberto Alsina's Qtc
# python conversion scripts). The particular format used here makes it possible to use
# the same table with three different kdoc based Qt/KDE language binding generators;
# C, Objective-C and Java.
%ctypemap = (

'ASConsumer*' => 'kde_ASConsumer*',
'ASProducer*' => 'kde_ASProducer*',
'ASYNC'  =>  'void' ,
'Address&'  =>  'kde_Address*' ,
'Address*' => 'kde_Address*',
'AddressBook*' => 'kde_AddressBook*',
'AddressBook::Entry&'  =>  'kde_Entry*' ,
'Addressee&' => 'kde_Addressee*',
'Addressee*' => 'kde_Addressee*',
'AddresseeData*' => 'kde_AddresseeData*',
'AddresseeDialog*' => 'kde_AddresseeDialog*',
'AddresseeItem*' => 'kde_AddresseeItem*',
'AlsaOut*' => 'kde_AlsaOut*',
'AnyConstRef&' => 'kde_AnyConstRef*',
'AnyConstRef*' => 'kde_AnyConstRef*',
'AnyRef&' => 'kde_AnyRef*',
'AnyRef*' => 'kde_AnyRef*',
'AnyRefBase&' => 'kde_AnyRefBase*',
'AnyRefBase*' => 'kde_AnyRefBase*',
'ArgList'  =>  'int' ,
'ArrowType'  =>  'int' ,
'Arts*' => 'kde_Arts*',
'Arts::AudioManagerClient' => 'int',
'Arts::Buffer&' => 'kde_Arts_Buffer*',
'Arts::Buffer*' => 'kde_Arts_Buffer*',
'Arts::ByteSoundProducer' => 'kde_Arts_ByteSoundProducer*',
'Arts::Connection*' => 'kde_Arts_Connection*',
'Arts::DynamicCast&' => 'kde_Arts_DynamicCast*',
'Arts::FlowSystemReceiver' => 'kde_Arts_FlowSystemReceiver*',
'Arts::FlowSystemSender' => 'kde_Arts_FlowSystemSender*',
'Arts::Format&' => 'kde_Arts_Format*',
'Arts::Format' => 'kde_Arts_Format',
'Arts::GenericAsyncStream*' => 'kde_Arts_GenericAsyncStream*',
'Arts::GenericDataChannel*' => 'kde_Arts_GenericDataChannel*',
'Arts::InterfaceDef' => 'kde_Arts_InterfaceDef*',
'Arts::MethodDef&' => 'kde_Arts_MethodDef*',
'Arts::ModuleDef&' => 'kde_Arts_ModuleDef*',
'Arts::Notification&' => 'kde_Arts_Notification*',
'Arts::Object' => 'kde_Arts_Object*',
'Arts::Object::Pool&' => 'kde_Arts_Object_Pool*',
'Arts::ObjectReference' => 'kde_Arts_ObjectReference*',
'Arts::PlayObject' => 'kde_Arts_PlayObject*',
'Arts::Reference&' => 'kde_Arts_Reference*',
'Arts::StereoEffect' => 'kde_Arts_StereoEffect*',
'Arts::StereoEffectStack' => 'kde_Arts_StereoEffectStack*',
'Arts::SubClass&' => 'kde_Arts_SubClass*',
'Arts::TypeDef' => 'kde_Arts_TypeDef*',
'Arts::poTime&' => 'kde_Arts_poTime*',
'Arts::poTime' => 'kde_Arts_poTime',
'AsyncStream*' => 'kde_AsyncStream*',
'Attr&' => 'kde_Attr*',
'Attr' => 'kde_Attr*',
'Attr*' => 'kde_Attr*',
'AttrImpl*' => 'kde_AttrImpl*',
'AttributeDef&' => 'kde_AttributeDef*',
'AttributeDef*' => 'kde_AttributeDef*',
'AudioManager&' => 'kde_AudioManager*',
'AudioManager' => 'kde_AudioManager*',
'AudioManager*' => 'kde_AudioManager*',
'AudioManagerClient&' => 'kde_AudioManagerClient*',
'AudioManagerClient' => 'kde_AudioManagerClient*',
'AudioManagerClient*' => 'kde_AudioManagerClient*',
'AudioManagerClient_base*' => 'kde_AudioManagerClient_base*',
'AudioManagerClient_skel*' => 'kde_AudioManagerClient_skel*',
'AudioManagerClient_stub*' => 'kde_AudioManagerClient_stub*',
'AudioManagerInfo&' => 'kde_AudioManagerInfo*',
'AudioManagerInfo*' => 'kde_AudioManagerInfo*',
'AudioManager_base*' => 'kde_AudioManager_base*',
'AudioManager_skel*' => 'kde_AudioManager_skel*',
'AudioManager_stub*' => 'kde_AudioManager_stub*',
'AudioPort*' => 'kde_AudioPort*',
'AudioSubSystem*' => 'kde_AudioSubSystem*',
'AudioSubSystemStart*' => 'kde_AudioSubSystemStart*',
'AuthAccept&' => 'kde_AuthAccept*',
'AuthAccept*' => 'kde_AuthAccept*',
'AuthInfo&' => 'kde_AuthInfo*',
'AuthInfo*' => 'kde_AuthInfo*',
'BGMode' => 'int',
'BMToken*' => 'kde_BMToken*',
'BackgroundMode' => 'int',
'BlockSelectionInterface*' => 'kde_BlockSelectionInterface*',
'BookmarkTokenizer*' => 'kde_BookmarkTokenizer*',
'Bool'  =>  'int' ,
'Boolean&' => 'kde_Boolean*',
'Boolean*' => 'kde_Boolean*',
'BrowserExtension*' => 'kde_BrowserExtension*',
'BrowserHostExtension*' => 'kde_BrowserHostExtension*',
'BrowserInterface*' => 'kde_BrowserInterface*',
'BrushStyle' => 'int',
'Buffer&' => 'kde_Buffer*',
'Buffer*' => 'kde_Buffer*',
'ButtonCode'  =>  'int' ,
'ButtonState'  =>  'int' ,
'ByteAsyncStream*' => 'kde_ByteAsyncStream*',
'ByteDataPacket*' => 'kde_ByteDataPacket*',
'ByteSoundProducer&' => 'kde_ByteSoundProducer*',
'ByteSoundProducer' => 'kde_ByteSoundProducer*',
'ByteSoundProducer*' => 'kde_ByteSoundProducer*',
'ByteSoundProducer_base*' => 'kde_ByteSoundProducer_base*',
'ByteSoundProducer_skel*' => 'kde_ByteSoundProducer_skel*',
'ByteSoundProducer_stub*' => 'kde_ByteSoundProducer_stub*',
'ByteStreamToAudio&' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio*' => 'kde_ByteStreamToAudio*',
'ByteStreamToAudio_base*' => 'kde_ByteStreamToAudio_base*',
'ByteStreamToAudio_skel*' => 'kde_ByteStreamToAudio_skel*',
'ByteStreamToAudio_stub*' => 'kde_ByteStreamToAudio_stub*',
'CDATASection&' => 'kde_CDATASection*',
'CDATASection' => 'kde_CDATASection*',
'CDATASection*' => 'kde_CDATASection*',
'CFlags' => 'int',
'COORD'  =>  'short' ,
'CSSCharsetRule&' => 'kde_CSSCharsetRule*',
'CSSCharsetRule*' => 'kde_CSSCharsetRule*',
'CSSCharsetRuleImpl*' => 'kde_CSSCharsetRuleImpl*',
'CSSException&' => 'kde_CSSException*',
'CSSException*' => 'kde_CSSException*',
'CSSFontFaceRule&' => 'kde_CSSFontFaceRule*',
'CSSFontFaceRule*' => 'kde_CSSFontFaceRule*',
'CSSFontFaceRuleImpl*' => 'kde_CSSFontFaceRuleImpl*',
'CSSImportRule&' => 'kde_CSSImportRule*',
'CSSImportRule*' => 'kde_CSSImportRule*',
'CSSImportRuleImpl*' => 'kde_CSSImportRuleImpl*',
'CSSMediaRule&' => 'kde_CSSMediaRule*',
'CSSMediaRule*' => 'kde_CSSMediaRule*',
'CSSMediaRuleImpl*' => 'kde_CSSMediaRuleImpl*',
'CSSPageRule&' => 'kde_CSSPageRule*',
'CSSPageRule*' => 'kde_CSSPageRule*',
'CSSPageRuleImpl*' => 'kde_CSSPageRuleImpl*',
'CSSPrimitiveValue&' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValue*' => 'kde_CSSPrimitiveValue*',
'CSSPrimitiveValueImpl*' => 'kde_CSSPrimitiveValueImpl*',
'CSSRule&' => 'kde_CSSRule*',
'CSSRule' => 'kde_CSSRule*',
'CSSRule*' => 'kde_CSSRule*',
'CSSRuleImpl*' => 'kde_CSSRuleImpl*',
'CSSRuleList&' => 'kde_CSSRuleList*',
'CSSRuleList' => 'kde_CSSRuleList*',
'CSSRuleList*' => 'kde_CSSRuleList*',
'CSSRuleListImpl*' => 'kde_CSSRuleListImpl*',
'CSSStyleDeclaration&' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclaration*' => 'kde_CSSStyleDeclaration*',
'CSSStyleDeclarationImpl*' => 'kde_CSSStyleDeclarationImpl*',
'CSSStyleRule&' => 'kde_CSSStyleRule*',
'CSSStyleRule*' => 'kde_CSSStyleRule*',
'CSSStyleRuleImpl*' => 'kde_CSSStyleRuleImpl*',
'CSSStyleSheet&' => 'kde_CSSStyleSheet*',
'CSSStyleSheet' => 'kde_CSSStyleSheet*',
'CSSStyleSheet*' => 'kde_CSSStyleSheet*',
'CSSStyleSheetImpl*' => 'kde_CSSStyleSheetImpl*',
'CSSUnknownRule&' => 'kde_CSSUnknownRule*',
'CSSUnknownRule*' => 'kde_CSSUnknownRule*',
'CSSUnknownRuleImpl*' => 'kde_CSSUnknownRuleImpl*',
'CSSValue&' => 'kde_CSSValue*',
'CSSValue' => 'kde_CSSValue*',
'CSSValue*' => 'kde_CSSValue*',
'CSSValueImpl*' => 'kde_CSSValueImpl*',
'CSSValueList&' => 'kde_CSSValueList*',
'CSSValueList*' => 'kde_CSSValueList*',
'CSSValueListImpl*' => 'kde_CSSValueListImpl*',
'CString&' => 'kde_CString*',
'CString' => 'kde_CString*',
'CString*' => 'kde_CString*',
'Cache*' => 'kde_Cache*',
'CacheInfo*' => 'kde_CacheInfo*',
'CachedObject*' => 'kde_CachedObject*',
'CachedWav*' => 'kde_CachedWav*',
'Cardinal'  =>  'int' ,
'CharSet' => 'int',
'CharacterData&' => 'kde_CharacterData*',
'CharacterData*' => 'kde_CharacterData*',
'CharacterDataImpl*' => 'kde_CharacterDataImpl*',
'ChmodJob*' => 'kde_ChmodJob*',
'ClassInfo*' => 'kde_ClassInfo*',
'ClassStore*' => 'kde_ClassStore*',
'ClassTreeNode*' => 'kde_ClassTreeNode*',
'ClientHello&' => 'kde_ClientHello*',
'ClientHello*' => 'kde_ClientHello*',
'ClipboardInterface*' => 'kde_ClipboardInterface*',
'CodeCompletionInterface*' => 'kde_CodeCompletionInterface*',
'ColorMode' => 'int',
'Comment&' => 'kde_Comment*',
'Comment' => 'kde_Comment*',
'Comment*' => 'kde_Comment*',
'CommentImpl*' => 'kde_CommentImpl*',
'ComparisonFlags' => 'int',
'Compl' => 'kde_Compl',
'Completion&' => 'kde_Completion*',
'Completion*' => 'kde_Completion*',
'CompletionEntry&' => 'kde_CompletionEntry*',
'CompletionEntry*' => 'kde_CompletionEntry*',
'ComplexControl' => 'int',
'ComponentFactory*' => 'kde_ComponentFactory*',
'ConfigInterface*' => 'kde_ConfigInterface*',
'Connection*' => 'kde_Connection*',
'ConstIterator'  =>  'int' ,
'Constructor' => 'kde_Constructor*',
'Constructor*' => 'kde_Constructor*',
'ConstructorImp*' => 'kde_ConstructorImp*',
'ContentsType' => 'int',
'Context&' => 'kde_Context*',
'Context*' => 'kde_Context*',
'ControlElement' => 'int',
'CopyInfo*' => 'kde_CopyInfo*',
'CopyJob*' => 'kde_CopyJob*',
'Core*' => 'kde_Core*',
'Counter&' => 'kde_Counter*',
'Counter' => 'kde_Counter*',
'Counter*' => 'kde_Counter*',
'Cursor*' => 'kde_Cursor*',
'CursorInterface*' => 'kde_CursorInterface*',
'DCOPClient*' => 'kde_DCOPClient*',
'DCOPClientTransaction*'  =>  'kde_DCOPClientTransaction*' ,
'DCOPObject*' => 'kde_DCOPObject*',
'DCOPObjectProxy*' => 'kde_DCOPObjectProxy*',
'DCOPRef&'  =>  'kde_DCOPRef*' ,
'DCOPRef*' => 'kde_DCOPRef*',
'DCOPStub*' => 'kde_DCOPStub*',
'DOM*' => 'kde_DOM*',
'DOM::CSSProperty*'  =>  'kde_CSSProperty*' ,
'DOM::DOMString&'  =>  'kde_DOMString*' ,
'DOM::DOMString'  =>  'kde_DOMString*' ,
'DOM::Document&'  =>  'kde_DOMDocument*' ,
'DOM::Document'  =>  'kde_DOMDocument*' ,
'DOM::Document*'  =>  'kde_DOMDocument*' ,
'DOM::ElementImpl*'  =>  'kde_DOM_ElementImpl*' ,
'DOM::HTMLDocument'  =>  'kde_HTMLDocument*' ,
'DOM::MediaList&' => 'kde_MediaList*',
'DOM::MediaList' => 'kde_MediaList',
'DOM::MediaList*' => 'kde_MediaList*',
'DOM::Node&'  =>  'kde_DOMNode*' ,
'DOM::Node'  =>  'kde_DOMNode*' ,
'DOM::NodeList&' => 'kde_DOMNodeList*',
'DOM::NodeList' => 'kde_DOMNodeList*',
'DOM::NodeList*' => 'kde_DOMNodeList*',
'DOM::Range'  =>  'kde_Range*' ,
'DOM::StyleSheetList&' => 'kde_StyleSheetList*',
'DOM::StyleSheetList' => 'kde_StyleSheetList',
'DOM::StyleSheetList*' => 'kde_StyleSheetList*',
'DOMException&' => 'kde_DOMException*',
'DOMException*' => 'kde_DOMException*',
'DOMImplementation&' => 'kde_DOMImplementation*',
'DOMImplementation' => 'kde_DOMImplementation*',
'DOMImplementation*' => 'kde_DOMImplementation*',
'DOMImplementationImpl*' => 'kde_DOMImplementationImpl*',
'DOMString&' => 'kde_DOMString*',
'DOMString' => 'kde_DOMString*',
'DOMString*' => 'kde_DOMString*',
'DOMStringImpl*' => 'kde_DOMStringImpl*',
'DW_EXPORT*' => 'void*',
'DataPacket*' => 'kde_DataPacket*',
'DateFormat' => 'int',
'Debug*' => 'kde_Debug*',
'DecoderFn'  =>  'int' ,
'DefaultProgress*' => 'kde_DefaultProgress*',
'DeleteJob*' => 'kde_DeleteJob*',
'DeviceManager*' => 'kde_DeviceManager*',
'Direction' => 'int',
'DispatchFunction' => 'kde_DispatchFunction*',
'Dispatcher*' => 'kde_Dispatcher*',
'Display' => 'Display',
'Display*' => 'Display*',
'DistributionList*' => 'kde_DistributionList*',
'DistributionListEditor*' => 'kde_DistributionListEditor*',
'DistributionListManager*' => 'kde_DistributionListManager*',
'Dock&' => 'int',
'Dock' => 'int',
'DockMainWindow*' => 'kde_DockMainWindow*',
'DockPosData&'  =>  'kde_DockPosData*' ,
'DockPosData*' => 'kde_DockPosData*',
'DockWindowData*' => 'long',
'Document&' => 'kde_Document*',
'Document' => 'kde_Document*',
'Document*' => 'kde_Document*',
'DocumentFragment&' => 'kde_DocumentFragment*',
'DocumentFragment' => 'kde_DocumentFragment*',
'DocumentFragment*' => 'kde_DocumentFragment*',
'DocumentFragmentImpl*' => 'kde_DocumentFragmentImpl*',
'DocumentImpl*' => 'kde_DocumentImpl*',
'DocumentStyle&' => 'kde_DocumentStyle*',
'DocumentStyle*' => 'kde_DocumentStyle*',
'DocumentType&' => 'kde_DocumentType*',
'DocumentType' => 'kde_DocumentType*',
'DocumentType*' => 'kde_DocumentType*',
'DocumentationContext*' => 'kde_DocumentationContext*',
'DomShared*' => 'kde_DomShared*',
'DrageMode' => 'int',
'DrawContentsEvent*' => 'kde_DrawContentsEvent*',
'DwAddress&' => 'kde_DwAddress*',
'DwAddress*' => 'kde_DwAddress*',
'DwAddressList&' => 'kde_DwAddressList*',
'DwAddressList*' => 'kde_DwAddressList*',
'DwBody&' => 'kde_DwBody*',
'DwBody*' => 'kde_DwBody*',
'DwBodyPart&' => 'kde_DwBodyPart*',
'DwBodyPart*' => 'kde_DwBodyPart*',
'DwBool' => 'int',
'DwDateTime&' => 'kde_DwDateTime*',
'DwDateTime*' => 'kde_DwDateTime*',
'DwDispositionType&' => 'kde_DwDispositionType*',
'DwDispositionType*' => 'kde_DwDispositionType*',
'DwEntity&' => 'kde_DwEntity*',
'DwField&' => 'kde_DwField*',
'DwField*' => 'kde_DwField*',
'DwFieldBody&' => 'kde_DwFieldBody*',
'DwFieldBody*' => 'kde_DwFieldBody*',
'DwGroup&' => 'kde_DwGroup*',
'DwGroup*' => 'kde_DwGroup*',
'DwHeaders&' => 'kde_DwHeaders*',
'DwHeaders*' => 'kde_DwHeaders*',
'DwInt32' => 'int',
'DwMailbox&' => 'kde_DwMailbox*',
'DwMailbox*' => 'kde_DwMailbox*',
'DwMailboxList&' => 'kde_DwMailboxList*',
'DwMailboxList*' => 'kde_DwMailboxList*',
'DwMechanism&' => 'kde_DwMechanism*',
'DwMechanism*' => 'kde_DwMechanism*',
'DwMediaType&' => 'kde_DwMediaType*',
'DwMediaType*' => 'kde_DwMediaType*',
'DwMessage&' => 'kde_DwMessage*',
'DwMessage*' => 'kde_DwMessage*',
'DwMessageComponent&' => 'kde_DwMessageComponent*',
'DwMessageComponent*' => 'kde_DwMessageComponent*',
'DwMime*' => 'kde_DwMime*',
'DwMsgId&' => 'kde_DwMsgId*',
'DwMsgId*' => 'kde_DwMsgId*',
'DwObserver*' => 'kde_DwObserver*',
'DwParameter&' => 'kde_DwParameter*',
'DwParameter*' => 'kde_DwParameter*',
'DwProtocolClient*' => 'kde_DwProtocolClient*',
'DwString&' => 'kde_DwString*',
'DwString' => 'kde_DwString',
'DwString*' => 'kde_DwString*',
'DwText&' => 'kde_DwText*',
'DwText*' => 'kde_DwText*',
'DwTokenizer&' => 'kde_DwTokenizer*',
'DwUint16' => 'unsigned short',
'DwUint32' => 'unsigned int',
'DwUint8' => 'unsigned char',
'DynamicCast*' => 'kde_DynamicCast*',
'DynamicRequest&' => 'kde_DynamicRequest*',
'DynamicRequest*' => 'kde_DynamicRequest*',
'EXPORT_DOCKCLASS*' => 'kde_EXPORT_DOCKCLASS*',
'EchoMode' => 'int',
'EditInterface*' => 'kde_EditInterface*',
'Editor*' => 'kde_Editor*',
'EditorContext*' => 'kde_EditorContext*',
'Element&' => 'kde_Element*',
'Element' => 'kde_Element*',
'Element*' => 'kde_Element*',
'ElementImpl*' => 'kde_ElementImpl*',
'EmailSelectDialog*' => 'kde_EmailSelectDialog*',
'EncoderFn'  =>  'int' ,
'Endian' => 'int',
'Entity&' => 'kde_Entity*',
'Entity*' => 'kde_Entity*',
'EntityReference&' => 'kde_EntityReference*',
'EntityReference' => 'kde_EntityReference*',
'EntityReference*' => 'kde_EntityReference*',
'Entry&'  =>  'kde_Entry*' ,
'Entry*' => 'kde_Entry*',
'Entry::Address&'  =>  'kde_EntryAddress' ,
'EnumComponent&' => 'kde_EnumComponent*',
'EnumComponent*' => 'kde_EnumComponent*',
'EnumDef&' => 'kde_EnumDef*',
'EnumDef*' => 'kde_EnumDef*',
'EnumEntry*' => 'kde_EnumEntry*',
'Error*' => 'kde_Error*',
'Event*' => 'kde_Event*',
'ExecState*' => 'kde_ExecState*',
'ExtensionLoader*' => 'kde_ExtensionLoader*',
'FALSE' => '0',
'FILE*' => 'FILE*',
'FMOut*' => 'kde_FMOut*',
'Factory*' => 'kde_Factory*',
'False' => '0',
'FileCopyJob*' => 'kde_FileCopyJob*',
'FileProtocol*' => 'kde_FileProtocol*',
'FileView&'  =>  'int' ,
'FloatAsyncStream*' => 'kde_FloatAsyncStream*',
'FloatDataPacket*' => 'kde_FloatDataPacket*',
'FlowSystem&' => 'kde_FlowSystem*',
'FlowSystem' => 'kde_FlowSystem*',
'FlowSystem*' => 'kde_FlowSystem*',
'FlowSystemReceiver&' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver*' => 'kde_FlowSystemReceiver*',
'FlowSystemReceiver_base*' => 'kde_FlowSystemReceiver_base*',
'FlowSystemReceiver_skel*' => 'kde_FlowSystemReceiver_skel*',
'FlowSystemReceiver_stub*' => 'kde_FlowSystemReceiver_stub*',
'FlowSystemSender&' => 'kde_FlowSystemSender*',
'FlowSystemSender' => 'kde_FlowSystemSender*',
'FlowSystemSender*' => 'kde_FlowSystemSender*',
'FlowSystemSender_base*' => 'kde_FlowSystemSender_base*',
'FlowSystemSender_skel*' => 'kde_FlowSystemSender_skel*',
'FlowSystemSender_stub*' => 'kde_FlowSystemSender_stub*',
'FlowSystem_base*' => 'kde_FlowSystem_base*',
'FlowSystem_impl*' => 'kde_FlowSystem_impl*',
'FlowSystem_skel*' => 'kde_FlowSystem_skel*',
'FlowSystem_stub*' => 'kde_FlowSystem_stub*',
'FocusPolicy' => 'int',
'Format&' => 'kde_Format*',
'Format*' => 'kde_Format*',
'Function*' => 'kde_Function*',
'FunctionImp*' => 'kde_FunctionImp*',
'GCI&'  =>  'GCI*' ,
'GCI'  =>  'GCI*' ,
'GCI*'  =>  'GCI*' ,
'GUIActivateEvent*' => 'kde_GUIActivateEvent*',
'GUIStyle' => 'int',
'GUSOut*' => 'kde_GUSOut*',
'GenericAsyncStream*' => 'kde_GenericAsyncStream*',
'GenericDataChannel*' => 'kde_GenericDataChannel*',
'GenericDataPacket*' => 'kde_GenericDataPacket*',
'GenericFactory*' => 'kde_GenericFactory*',
'GenericFactoryBase*' => 'kde_GenericFactoryBase*',
'Global*' => 'kde_Global*',
'GlobalComm&' => 'kde_GlobalComm*',
'GlobalComm' => 'kde_GlobalComm*',
'GlobalComm*' => 'kde_GlobalComm*',
'GlobalComm_base*' => 'kde_GlobalComm_base*',
'GlobalComm_skel*' => 'kde_GlobalComm_skel*',
'GlobalComm_stub*' => 'kde_GlobalComm_stub*',
'HANDLE' => 'unsigned int',
'HBITMAP'  =>  'void *' ,
'HCURSOR'  =>  'void *' ,
'HDC'  =>  'void *' ,
'HFONT'  =>  'void *' ,
'HPALETTE'  =>  'void *' ,
'HRGN'  =>  'void *' ,
'HTMLAnchorElement&' => 'kde_HTMLAnchorElement*',
'HTMLAnchorElement*' => 'kde_HTMLAnchorElement*',
'HTMLAnchorElementImpl*' => 'kde_HTMLAnchorElementImpl*',
'HTMLAppletElement&' => 'kde_HTMLAppletElement*',
'HTMLAppletElement*' => 'kde_HTMLAppletElement*',
'HTMLAppletElementImpl*' => 'kde_HTMLAppletElementImpl*',
'HTMLAreaElement&' => 'kde_HTMLAreaElement*',
'HTMLAreaElement*' => 'kde_HTMLAreaElement*',
'HTMLAreaElementImpl*' => 'kde_HTMLAreaElementImpl*',
'HTMLBRElement&' => 'kde_HTMLBRElement*',
'HTMLBRElement*' => 'kde_HTMLBRElement*',
'HTMLBRElementImpl*' => 'kde_HTMLBRElementImpl*',
'HTMLBaseElement&' => 'kde_HTMLBaseElement*',
'HTMLBaseElement*' => 'kde_HTMLBaseElement*',
'HTMLBaseElementImpl*' => 'kde_HTMLBaseElementImpl*',
'HTMLBaseFontElement&' => 'kde_HTMLBaseFontElement*',
'HTMLBaseFontElement*' => 'kde_HTMLBaseFontElement*',
'HTMLBaseFontElementImpl*' => 'kde_HTMLBaseFontElementImpl*',
'HTMLBlockquoteElement&' => 'kde_HTMLBlockquoteElement*',
'HTMLBlockquoteElement*' => 'kde_HTMLBlockquoteElement*',
'HTMLBlockquoteElementImpl*' => 'kde_HTMLBlockquoteElementImpl*',
'HTMLBodyElement&' => 'kde_HTMLBodyElement*',
'HTMLBodyElement*' => 'kde_HTMLBodyElement*',
'HTMLBodyElementImpl*' => 'kde_HTMLBodyElementImpl*',
'HTMLButtonElement&' => 'kde_HTMLButtonElement*',
'HTMLButtonElement*' => 'kde_HTMLButtonElement*',
'HTMLButtonElementImpl*' => 'kde_HTMLButtonElementImpl*',
'HTMLCollection&' => 'kde_HTMLCollection*',
'HTMLCollection' => 'kde_HTMLCollection*',
'HTMLCollection*' => 'kde_HTMLCollection*',
'HTMLCollectionImpl*' => 'kde_HTMLCollectionImpl*',
'HTMLDListElement&' => 'kde_HTMLDListElement*',
'HTMLDListElement*' => 'kde_HTMLDListElement*',
'HTMLDListElementImpl*' => 'kde_HTMLDListElementImpl*',
'HTMLDirectoryElement&' => 'kde_HTMLDirectoryElement*',
'HTMLDirectoryElement*' => 'kde_HTMLDirectoryElement*',
'HTMLDirectoryElementImpl*' => 'kde_HTMLDirectoryElementImpl*',
'HTMLDivElement&' => 'kde_HTMLDivElement*',
'HTMLDivElement*' => 'kde_HTMLDivElement*',
'HTMLDivElementImpl*' => 'kde_HTMLDivElementImpl*',
'HTMLDocument&' => 'kde_HTMLDocument*',
'HTMLDocument*' => 'kde_HTMLDocument*',
'HTMLDocumentImpl*' => 'kde_HTMLDocumentImpl*',
'HTMLElement&' => 'kde_HTMLElement*',
'HTMLElement' => 'kde_HTMLElement*',
'HTMLElement*' => 'kde_HTMLElement*',
'HTMLElementImpl*' => 'kde_HTMLElementImpl*',
'HTMLFieldSetElement&' => 'kde_HTMLFieldSetElement*',
'HTMLFieldSetElement*' => 'kde_HTMLFieldSetElement*',
'HTMLFieldSetElementImpl*' => 'kde_HTMLFieldSetElementImpl*',
'HTMLFontElement&' => 'kde_HTMLFontElement*',
'HTMLFontElement*' => 'kde_HTMLFontElement*',
'HTMLFontElementImpl*' => 'kde_HTMLFontElementImpl*',
'HTMLFormElement&' => 'kde_HTMLFormElement*',
'HTMLFormElement' => 'kde_HTMLFormElement*',
'HTMLFormElement*' => 'kde_HTMLFormElement*',
'HTMLFormElementImpl*' => 'kde_HTMLFormElementImpl*',
'HTMLFrameElement&' => 'kde_HTMLFrameElement*',
'HTMLFrameElement*' => 'kde_HTMLFrameElement*',
'HTMLFrameElementImpl*' => 'kde_HTMLFrameElementImpl*',
'HTMLFrameSetElement&' => 'kde_HTMLFrameSetElement*',
'HTMLFrameSetElement*' => 'kde_HTMLFrameSetElement*',
'HTMLFrameSetElementImpl*' => 'kde_HTMLFrameSetElementImpl*',
'HTMLHRElement&' => 'kde_HTMLHRElement*',
'HTMLHRElement*' => 'kde_HTMLHRElement*',
'HTMLHRElementImpl*' => 'kde_HTMLHRElementImpl*',
'HTMLHeadElement&' => 'kde_HTMLHeadElement*',
'HTMLHeadElement*' => 'kde_HTMLHeadElement*',
'HTMLHeadElementImpl*' => 'kde_HTMLHeadElementImpl*',
'HTMLHeadingElement&' => 'kde_HTMLHeadingElement*',
'HTMLHeadingElement*' => 'kde_HTMLHeadingElement*',
'HTMLHeadingElementImpl*' => 'kde_HTMLHeadingElementImpl*',
'HTMLHtmlElement&' => 'kde_HTMLHtmlElement*',
'HTMLHtmlElement*' => 'kde_HTMLHtmlElement*',
'HTMLHtmlElementImpl*' => 'kde_HTMLHtmlElementImpl*',
'HTMLIFrameElement&' => 'kde_HTMLIFrameElement*',
'HTMLIFrameElement*' => 'kde_HTMLIFrameElement*',
'HTMLIFrameElementImpl*' => 'kde_HTMLIFrameElementImpl*',
'HTMLImageElement&' => 'kde_HTMLImageElement*',
'HTMLImageElement*' => 'kde_HTMLImageElement*',
'HTMLImageElementImpl*' => 'kde_HTMLImageElementImpl*',
'HTMLInputElement&' => 'kde_HTMLInputElement*',
'HTMLInputElement*' => 'kde_HTMLInputElement*',
'HTMLInputElementImpl*' => 'kde_HTMLInputElementImpl*',
'HTMLIsIndexElement&' => 'kde_HTMLIsIndexElement*',
'HTMLIsIndexElement*' => 'kde_HTMLIsIndexElement*',
'HTMLIsIndexElementImpl*' => 'kde_HTMLIsIndexElementImpl*',
'HTMLLIElement&' => 'kde_HTMLLIElement*',
'HTMLLIElement*' => 'kde_HTMLLIElement*',
'HTMLLIElementImpl*' => 'kde_HTMLLIElementImpl*',
'HTMLLabelElement&' => 'kde_HTMLLabelElement*',
'HTMLLabelElement*' => 'kde_HTMLLabelElement*',
'HTMLLabelElementImpl*' => 'kde_HTMLLabelElementImpl*',
'HTMLLegendElement&' => 'kde_HTMLLegendElement*',
'HTMLLegendElement*' => 'kde_HTMLLegendElement*',
'HTMLLegendElementImpl*' => 'kde_HTMLLegendElementImpl*',
'HTMLLinkElement&' => 'kde_HTMLLinkElement*',
'HTMLLinkElement*' => 'kde_HTMLLinkElement*',
'HTMLLinkElementImpl*' => 'kde_HTMLLinkElementImpl*',
'HTMLMapElement&' => 'kde_HTMLMapElement*',
'HTMLMapElement*' => 'kde_HTMLMapElement*',
'HTMLMapElementImpl*' => 'kde_HTMLMapElementImpl*',
'HTMLMenuElement&' => 'kde_HTMLMenuElement*',
'HTMLMenuElement*' => 'kde_HTMLMenuElement*',
'HTMLMenuElementImpl*' => 'kde_HTMLMenuElementImpl*',
'HTMLMetaElement&' => 'kde_HTMLMetaElement*',
'HTMLMetaElement*' => 'kde_HTMLMetaElement*',
'HTMLMetaElementImpl*' => 'kde_HTMLMetaElementImpl*',
'HTMLModElement&' => 'kde_HTMLModElement*',
'HTMLModElement*' => 'kde_HTMLModElement*',
'HTMLModElementImpl*' => 'kde_HTMLModElementImpl*',
'HTMLOListElement&' => 'kde_HTMLOListElement*',
'HTMLOListElement*' => 'kde_HTMLOListElement*',
'HTMLOListElementImpl*' => 'kde_HTMLOListElementImpl*',
'HTMLObjectElement&' => 'kde_HTMLObjectElement*',
'HTMLObjectElement*' => 'kde_HTMLObjectElement*',
'HTMLObjectElementImpl*' => 'kde_HTMLObjectElementImpl*',
'HTMLOptGroupElement&' => 'kde_HTMLOptGroupElement*',
'HTMLOptGroupElement*' => 'kde_HTMLOptGroupElement*',
'HTMLOptGroupElementImpl*' => 'kde_HTMLOptGroupElementImpl*',
'HTMLOptionElement&' => 'kde_HTMLOptionElement*',
'HTMLOptionElement*' => 'kde_HTMLOptionElement*',
'HTMLOptionElementImpl*' => 'kde_HTMLOptionElementImpl*',
'HTMLParagraphElement&' => 'kde_HTMLParagraphElement*',
'HTMLParagraphElement*' => 'kde_HTMLParagraphElement*',
'HTMLParagraphElementImpl*' => 'kde_HTMLParagraphElementImpl*',
'HTMLParamElement&' => 'kde_HTMLParamElement*',
'HTMLParamElement*' => 'kde_HTMLParamElement*',
'HTMLParamElementImpl*' => 'kde_HTMLParamElementImpl*',
'HTMLPreElement&' => 'kde_HTMLPreElement*',
'HTMLPreElement*' => 'kde_HTMLPreElement*',
'HTMLPreElementImpl*' => 'kde_HTMLPreElementImpl*',
'HTMLQuoteElement&' => 'kde_HTMLQuoteElement*',
'HTMLQuoteElement*' => 'kde_HTMLQuoteElement*',
'HTMLQuoteElementImpl*' => 'kde_HTMLQuoteElementImpl*',
'HTMLScriptElement&' => 'kde_HTMLScriptElement*',
'HTMLScriptElement*' => 'kde_HTMLScriptElement*',
'HTMLScriptElementImpl*' => 'kde_HTMLScriptElementImpl*',
'HTMLSelectElement&' => 'kde_HTMLSelectElement*',
'HTMLSelectElement*' => 'kde_HTMLSelectElement*',
'HTMLSelectElementImpl*' => 'kde_HTMLSelectElementImpl*',
'HTMLStyleElement&' => 'kde_HTMLStyleElement*',
'HTMLStyleElement*' => 'kde_HTMLStyleElement*',
'HTMLStyleElementImpl*' => 'kde_HTMLStyleElementImpl*',
'HTMLTableCaptionElement&' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement*' => 'kde_HTMLTableCaptionElement*',
'HTMLTableCaptionElementImpl*' => 'kde_HTMLTableCaptionElementImpl*',
'HTMLTableCellElement&' => 'kde_HTMLTableCellElement*',
'HTMLTableCellElement*' => 'kde_HTMLTableCellElement*',
'HTMLTableCellElementImpl*' => 'kde_HTMLTableCellElementImpl*',
'HTMLTableColElement&' => 'kde_HTMLTableColElement*',
'HTMLTableColElement*' => 'kde_HTMLTableColElement*',
'HTMLTableColElementImpl*' => 'kde_HTMLTableColElementImpl*',
'HTMLTableElement&' => 'kde_HTMLTableElement*',
'HTMLTableElement*' => 'kde_HTMLTableElement*',
'HTMLTableElementImpl*' => 'kde_HTMLTableElementImpl*',
'HTMLTableRowElement&' => 'kde_HTMLTableRowElement*',
'HTMLTableRowElement*' => 'kde_HTMLTableRowElement*',
'HTMLTableRowElementImpl*' => 'kde_HTMLTableRowElementImpl*',
'HTMLTableSectionElement&' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElement*' => 'kde_HTMLTableSectionElement*',
'HTMLTableSectionElementImpl*' => 'kde_HTMLTableSectionElementImpl*',
'HTMLTextAreaElement&' => 'kde_HTMLTextAreaElement*',
'HTMLTextAreaElement*' => 'kde_HTMLTextAreaElement*',
'HTMLTextAreaElementImpl*' => 'kde_HTMLTextAreaElementImpl*',
'HTMLTitleElement&' => 'kde_HTMLTitleElement*',
'HTMLTitleElement*' => 'kde_HTMLTitleElement*',
'HTMLTitleElementImpl*' => 'kde_HTMLTitleElementImpl*',
'HTMLUListElement&' => 'kde_HTMLUListElement*',
'HTMLUListElement*' => 'kde_HTMLUListElement*',
'HTMLUListElementImpl*' => 'kde_HTMLUListElementImpl*',
'HandlerType'  =>  'qt_HandlerType*' ,
'HashEntry*' => 'kde_HashEntry*',
'HashTable*' => 'kde_HashTable*',
'Header&' => 'kde_Header*',
'Header*' => 'kde_Header*',
'HighlightingInterface*' => 'kde_HighlightingInterface*',
'HistoryProvider*' => 'kde_HistoryProvider*',
'HostImp*' => 'kde_HostImp*',
'IDLFileReg*' => 'kde_IDLFileReg*',
'IOManager*' => 'kde_IOManager*',
'IONotify*' => 'kde_IONotify*',
'IOType*' => 'kde_IOType*',
'IOWatchFD*' => 'kde_IOWatchFD*',
'Icon' => 'int',
'IconListBox*' => 'kde_IconListBox*',
'Imp*' => 'void*',
'Info*' => 'kde_Info*',
'InterfaceDef&' => 'kde_InterfaceDef*',
'InterfaceDef' => 'kde_InterfaceDef*',
'InterfaceDef*' => 'kde_InterfaceDef*',
'InterfaceEntry*' => 'kde_InterfaceEntry*',
'InterfaceRepo&' => 'kde_InterfaceRepo*',
'InterfaceRepo' => 'kde_InterfaceRepo*',
'InterfaceRepo*' => 'kde_InterfaceRepo*',
'InterfaceRepo_base*' => 'kde_InterfaceRepo_base*',
'InterfaceRepo_impl*' => 'kde_InterfaceRepo_impl*',
'InterfaceRepo_skel*' => 'kde_InterfaceRepo_skel*',
'InterfaceRepo_stub*' => 'kde_InterfaceRepo_stub*',
'InternalFunctionImp*' => 'kde_InternalFunctionImp*',
'Interpreter*' => 'kde_Interpreter*',
'Invocation&' => 'kde_Invocation*',
'Invocation*' => 'kde_Invocation*',
'Item&'  =>  'Item*' ,
'Item'  =>  'Item*' ,
'Item*'  =>  'Item*' ,
'Iterator'  =>  'Iterator*' ,
'Job*' => 'void*',
'K&'  =>  'K*' ,
'KAboutApplication*' => 'kde_KAboutApplication*',
'KAboutContainer*'  =>  'kde_KAboutContainer*' ,
'KAboutContributor*' => 'kde_KAboutContributor*',
'KAboutData*'  =>  'kde_KAboutData*' ,
'KAboutDialog*' => 'kde_KAboutDialog*',
'KAboutKDE*' => 'kde_KAboutKDE*',
'KAboutPerson*' => 'kde_KAboutPerson*',
'KAboutTranslator*' => 'kde_KAboutTranslator*',
'KAboutWidget*' => 'kde_KAboutWidget*',
'KAccel*'  =>  'kde_KAccel*' ,
'KAccelAction&' => 'kde_KAccelAction*',
'KAccelAction*' => 'kde_KAccelAction*',
'KAccelActions&' => 'kde_KAccelActions*',
'KAccelActions*' => 'kde_KAccelActions*',
'KAccelBase*' => 'kde_KAccelBase*',
'KAccelGen*' => 'kde_KAccelGen*',
'KAccelMenu*' => 'kde_KAccelMenu*',
'KAccelSequence&' => 'kde_KAccelSequence*',
'KAccelSequence' => 'kde_KAccelSequence*',
'KAccelSequence*' => 'kde_KAccelSequence*',
'KAccelShortcut&' => 'kde_KAccelShortcut*',
'KAccelShortcut' => 'kde_KAccelShortcut*',
'KAccelShortcut*' => 'kde_KAccelShortcut*',
'KAccelShortcuts&' => 'kde_KAccelShortcuts*',
'KAccelShortcuts*' => 'kde_KAccelShortcuts*',
'KAction*'  =>  'kde_KAction*' ,
'KActionCollection&'  => 'kde_KActionCollection*' ,
'KActionCollection'  => 'kde_KActionCollection*' ,
'KActionCollection*'  => 'kde_KActionCollection*' ,
'KActionMenu*' => 'kde_KActionMenu*',
'KActionSeparator*' => 'kde_KActionSeparator*',
'KAddressInfo*' => 'kde_KAddressInfo*',
'KAlphaPainter*' => 'kde_KAlphaPainter*',
'KAnimWidget*'  =>  'kde_KAnimWidget*' ,
'KAppTreeListItem*'  =>  'kde_KAppTreeListItem*' ,
'KApplication*'  =>  'kde_KApplication*' ,
'KApplicationPropsPlugin*' => 'kde_KApplicationPropsPlugin*',
'KApplicationTree*' => 'kde_KApplicationTree*',
'KArchive*' => 'kde_KArchive*',
'KArchiveDirectory*' => 'kde_KArchiveDirectory*',
'KArchiveEntry*' => 'kde_KArchiveEntry*',
'KArchiveFile*' => 'kde_KArchiveFile*',
'KArrowButton*' => 'kde_KArrowButton*',
'KArtsDispatcher*' => 'kde_KArtsDispatcher*',
'KArtsFloatWatch*' => 'kde_KArtsFloatWatch*',
'KAsyncIO*' => 'kde_KAsyncIO*',
'KAudioPlayer*' => 'kde_KAudioPlayer*',
'KAuthIcon*' => 'kde_KAuthIcon*',
'KAutoMount*' => 'kde_KAutoMount*',
'KAutoUnmount*' => 'kde_KAutoUnmount*',
'KBindingPropsPlugin*' => 'kde_KBindingPropsPlugin*',
'KBlankEffect*' => 'kde_KBlankEffect*',
'KBufferedIO*' => 'kde_KBufferedIO*',
'KBugReport*' => 'kde_KBugReport*',
'KButtonBox*' => 'kde_KButtonBox*',
'KCModule*'  =>  'kde_KCModule*' ,
'KCatalogue&' => 'kde_KCatalogue*',
'KCatalogue*' => 'kde_KCatalogue*',
'KCharSelect*' => 'kde_KCharSelect*',
'KCharSelectTable*' => 'kde_KCharSelectTable*',
'KCharsets*'  =>  'kde_KCharsets*' ,
'KCmdLineArgs*'  =>  'kde_KCmdLineArgs*' ,
'KCmdLineOptions*'  => 'kde_KCmdLineOptions*' ,
'KCodecs*' => 'kde_KCodecs*',
'KColor&'  => 'kde_KColor*' ,
'KColor*' => 'kde_KColor*',
'KColorButton*' => 'kde_KColorButton*',
'KColorCells*' => 'kde_KColorCells*',
'KColorCombo*' => 'kde_KColorCombo*',
'KColorDialog*' => 'kde_KColorDialog*',
'KColorDrag*'  =>  'kde_KColorDrag*' ,
'KColorPatch*' => 'kde_KColorPatch*',
'KCombiView*' => 'kde_KCombiView*',
'KComboBox*'  =>  'kde_KComboBox*' ,
'KCommand*' => 'kde_KCommand*',
'KCommandHistory*' => 'kde_KCommandHistory*',
'KCompletion*'  =>  'kde_KCompletion*' ,
'KCompletionBase*' => 'kde_KCompletionBase*',
'KCompletionBase::KeyBindingType'  => 'kde_KCompletionBase_KeyBindingType*' ,
'KCompletionBox*' => 'kde_KCompletionBox*',
'KConfig*'  => 'kde_KConfig*' ,
'KConfigBackEnd*' => 'kde_KConfigBackEnd*',
'KConfigBase&' => 'kde_KConfigBase*',
'KConfigBase*'  => 'kde_KConfigBase*' ,
'KConfigBase::ConfigState'  => 'kde_KConfigBase_ConfigState' ,
'KConfigGroup*' => 'kde_KConfigGroup*',
'KConfigGroupSaver*' => 'kde_KConfigGroupSaver*',
'KConfigINIBackEnd*' => 'kde_KConfigINIBackEnd*',
'KContainerLayout*' => 'kde_KContainerLayout*',
'KContainerLayoutItem*'  => 'kde_KContainerLayoutItem*' ,
'KContextMenuManager*' => 'kde_KContextMenuManager*',
'KCookie*' => 'kde_KCookie*',
'KCrash*' => 'kde_KCrash*',
'KCursor*' => 'kde_KCursor*',
'KDBGFUNC'  => 'void *' ,
'KDCOPActionProxy*' => 'kde_KDCOPActionProxy*',
'KDCOPPropertyProxy*' => 'kde_KDCOPPropertyProxy*',
'KDEAniMenu*' => 'kde_KDEAniMenu*',
'KDEDModule*' => 'kde_KDEDModule*',
'KDEDesktopMimeType*' => 'kde_KDEDesktopMimeType*',
'KDEDesktopMimeType::Service&'  => 'kde_KDEDesktopMimeType_Service*' ,
'KDESasl*' => 'kde_KDESasl*',
'KDEStyle*' => 'kde_KDEStyle*',
'KDEsuClient*' => 'kde_KDEsuClient*',
'KDataTool*' => 'kde_KDataTool*',
'KDataToolAction*' => 'kde_KDataToolAction*',
'KDataToolInfo&' => 'kde_KDataToolInfo*',
'KDataToolInfo*' => 'kde_KDataToolInfo*',
'KDateInternalMonthPicker*' => 'kde_KDateInternalMonthPicker*',
'KDateInternalYearSelector*' => 'kde_KDateInternalYearSelector*',
'KDatePicker*' => 'kde_KDatePicker*',
'KDateTable*' => 'kde_KDateTable*',
'KDateValidator*' => 'kde_KDateValidator*',
'KDateWidget*' => 'kde_KDateWidget*',
'KDesktopFile*'  => 'kde_KDesktopFile*' ,
'KDevApi*' => 'kde_KDevApi*',
'KDevAppFrontend*' => 'kde_KDevAppFrontend*',
'KDevCompilerOptions*' => 'kde_KDevCompilerOptions*',
'KDevCore*' => 'kde_KDevCore*',
'KDevFactory*' => 'kde_KDevFactory*',
'KDevLanguageSupport*' => 'kde_KDevLanguageSupport*',
'KDevMakeFrontend*' => 'kde_KDevMakeFrontend*',
'KDevPart*' => 'kde_KDevPart*',
'KDevProject*' => 'kde_KDevProject*',
'KDevVersionControl*' => 'kde_KDevVersionControl*',
'KDevicePropsPlugin*' => 'kde_KDevicePropsPlugin*',
'KDialog*' => 'kde_KDialog*',
'KDialogBase*'  =>  'kde_KDialogBase*' ,
'KDialogBaseTile*' => 'kde_KDialogBaseTile*',
'KDialogQueue*' => 'kde_KDialogQueue*',
'KDirLister*' => 'kde_KDirLister*',
'KDirNotify*' => 'kde_KDirNotify*',
'KDirNotify_stub*' => 'kde_KDirNotify_stub*',
'KDirOperator*' => 'kde_KDirOperator*',
'KDirSelectDialog*' => 'kde_KDirSelectDialog*',
'KDirSize*'  =>  'kde_KDirSize*' ,
'KDirWatch*'  =>  'kde_KDirWatch*' ,
'KDirectionButton*' => 'kde_KDirectionButton*',
'KDockArea*' => 'kde_KDockArea*',
'KDockMainWindow*' => 'kde_KDockMainWindow*',
'KDockManager*'  => 'kde_KDockManager*' ,
'KDockTabBar*' => 'kde_KDockTabBar*',
'KDockTabBar::TabPos' => 'int',
'KDockTabBarPainter*' => 'kde_KDockTabBarPainter*',
'KDockTabCtl*' => 'kde_KDockTabCtl*',
'KDockTabCtl_PrivateStruct*'  =>  'kde_KDockTabCtl_PrivateStruct*' ,
'KDockTabGroup*'  =>  'kde_KDockTabGroup*' ,
'KDockWidget*'  => 'kde_KDockWidget*' ,
'KDockWidgetAbstractHeader*'  => 'kde_KDockWidgetAbstractHeader*' ,
'KDockWidgetAbstractHeaderDrag*' => 'kde_KDockWidgetAbstractHeaderDrag*',
'KDockWidgetHeader*' => 'kde_KDockWidgetHeader*',
'KDockWidgetHeaderDrag*' => 'kde_KDockWidgetHeaderDrag*',
'KDockWindow*' => 'kde_KDockWindow*',
'KDoubleNumInput*' => 'kde_KDoubleNumInput*',
'KDualColorButton*' => 'kde_KDualColorButton*',
'KEMailSettings*' => 'kde_KEMailSettings*',
'KEdFind*' => 'kde_KEdFind*',
'KEdGotoLine*' => 'kde_KEdGotoLine*',
'KEdReplace*' => 'kde_KEdReplace*',
'KEdit*' => 'kde_KEdit*',
'KEditListBox*' => 'kde_KEditListBox*',
'KEditToolbar*' => 'kde_KEditToolbar*',
'KEditToolbarWidget*' => 'kde_KEditToolbarWidget*',
'KEntry&'  => 'kde_KEntry*' ,
'KEntry'  => 'kde_KEntry*' ,
'KEntry*' => 'kde_KEntry*',
'KEntryKey&'  => 'kde_KEntryKey*' ,
'KEntryKey*' => 'kde_KEntryKey*',
'KEntryMap'  => 'kde_KEntryMap*' ,
'KEntryMap*'  => 'kde_KEntryMap*' ,
'KExecMimeType*' => 'kde_KExecMimeType*',
'KExecPropsPlugin*' => 'kde_KExecPropsPlugin*',
'KExtendedSocket*' => 'kde_KExtendedSocket*',
'KFile*' => 'kde_KFile*',
'KFile::FileView'  => 'int' ,
'KFile::Mode'  => 'int' ,
'KFile::SelectionMode'  => 'int' ,
'KFileBookmark*'  =>  'kde_KFileBookmark*' ,
'KFileBookmarkManager*' => 'kde_KFileBookmarkManager*',
'KFileComboBox*' => 'kde_KFileComboBox*',
'KFileDetailView*' => 'kde_KFileDetailView*',
'KFileDialog*'  =>  'kde_KFileDialog*' ,
'KFileFilter*' => 'kde_KFileFilter*',
'KFileFilterCombo*' => 'kde_KFileFilterCombo*',
'KFileIconView*' => 'kde_KFileIconView*',
'KFileIconViewItem*' => 'kde_KFileIconViewItem*',
'KFileItem&' => 'kde_KFileItem*',
'KFileItem*'  => 'kde_KFileItem*' ,
'KFileItemList&'  => 'kde_KFileItemList*' ,
'KFileItemList'  => 'kde_KFileItemList*' ,
'KFileItemList*'  => 'kde_KFileItemList*' ,
'KFileListViewItem*' => 'kde_KFileListViewItem*',
'KFileMetaInfo*' => 'kde_KFileMetaInfo*',
'KFileMetaInfoItem*' => 'kde_KFileMetaInfoItem*',
'KFileMetaInfoProvider*' => 'kde_KFileMetaInfoProvider*',
'KFileOpenWithHandler*' => 'kde_KFileOpenWithHandler*',
'KFilePermissionsPropsPlugin*' => 'kde_KFilePermissionsPropsPlugin*',
'KFilePlugin*' => 'kde_KFilePlugin*',
'KFilePreview*' => 'kde_KFilePreview*',
'KFilePropsPlugin*' => 'kde_KFilePropsPlugin*',
'KFileReader*'  => 'kde_KFileReader*' ,
'KFileTreeBranch*' => 'kde_KFileTreeBranch*',
'KFileTreeView*' => 'kde_KFileTreeView*',
'KFileTreeViewItem*' => 'kde_KFileTreeViewItem*',
'KFileTreeViewToolTip*' => 'kde_KFileTreeViewToolTip*',
'KFileView*'  => 'kde_KFileView*' ,
'KFileView::FileView' => 'int',
'KFileViewItem&' => 'kde_KFileViewItem*',
'KFileViewItem*'  => 'kde_KFileViewItem*' ,
'KFileViewItem**'  => 'kde_KFileViewItem**' ,
'KFileViewItemList&'  => 'kde_KFileViewItemList*' ,
'KFileViewItemList*'  => 'kde_KFileViewItemList*' ,
'KFileViewSignaler*' => 'kde_KFileViewSignaler*',
'KFilterBase*' => 'kde_KFilterBase*',
'KFilterDev*' => 'kde_KFilterDev*',
'KFloatValidator*' => 'kde_KFloatValidator*',
'KFloatWatchProxy&' => 'kde_KFloatWatchProxy*',
'KFloatWatchProxy' => 'kde_KFloatWatchProxy*',
'KFloatWatchProxy*' => 'kde_KFloatWatchProxy*',
'KFolderType*' => 'kde_KFolderType*',
'KFontAction*' => 'kde_KFontAction*',
'KFontChooser*' => 'kde_KFontChooser*',
'KFontCombo*' => 'kde_KFontCombo*',
'KFontDialog*' => 'kde_KFontDialog*',
'KFontSizeAction*' => 'kde_KFontSizeAction*',
'KGenericFactory*' => 'kde_KGenericFactory*',
'KGenericFactoryBase*' => 'kde_KGenericFactoryBase*',
'KGlobal*' => 'kde_KGlobal*',
'KGlobalAccel*'  =>  'kde_KGlobalAccel*' ,
'KGlobalSettings*' => 'kde_KGlobalSettings*',
'KGlobalSettings::Completion'  => 'int' ,
'KGradientSelector*' => 'kde_KGradientSelector*',
'KGuiItem&' => 'kde_KGuiItem*',
'KGuiItem' => 'kde_KGuiItem*',
'KGuiItem*' => 'kde_KGuiItem*',
'KHSSelector*' => 'kde_KHSSelector*',
'KHTMLPart*'  =>  'kde_KHTMLPart*' ,
'KHTMLSettings&' => 'kde_KHTMLSettings*',
'KHTMLSettings*'  => 'kde_KHTMLSettings*' ,
'KHTMLView*'  => 'kde_KHTMLView*' ,
'KHelpMenu*' => 'kde_KHelpMenu*',
'KHistoryCombo*' => 'kde_KHistoryCombo*',
'KIO*' => 'kde_KIO*',
'KIO::AuthInfo&' => 'kde_AuthInfo*',
'KIO::CopyJob*'  => 'kde_CopyJob*' ,
'KIO::DeleteJob*'  => 'kde_DeleteJob*' ,
'KIO::Job*'  => 'kde_Job*' ,
'KIO::ListJob*'  => 'kde_ListJob*' ,
'KIO::MetaData&' => 'kde_MetaData*',
'KIO::RenameDlg_Mode' => 'int',
'KIO::RenameDlg_Result' => 'int',
'KIO::SimpleJob*' => 'kde_SimpleJob*',
'KIO::SkipDlg_Result' => 'int',
'KIO::Slave*' => 'kde_Slave*',
'KIO::UDSEntry&'  => 'kde_UDSEntry*' ,
'KIO::UDSEntryList&'  => 'kde_UDSEntryList*' ,
'KIOInputStream&' => 'kde_KIOInputStream*',
'KIOInputStream*' => 'kde_KIOInputStream*',
'KIOTestSlow&' => 'kde_KIOTestSlow*',
'KIOTestSlow' => 'kde_KIOTestSlow*',
'KIOTestSlow*' => 'kde_KIOTestSlow*',
'KIPC*' => 'kde_KIPC*',
'KIcon'  => 'kde_KIcon*' ,
'KIcon*' => 'kde_KIcon*',
'KIconButton*' => 'kde_KIconButton*',
'KIconCanvas*' => 'kde_KIconCanvas*',
'KIconDialog*' => 'kde_KIconDialog*',
'KIconEffect*'  =>  'kde_KIconEffect*' ,
'KIconLoader*'  => 'kde_KIconLoader*' ,
'KIconSelectAction*' => 'kde_KIconSelectAction*',
'KIconTheme*'  => 'kde_KIconTheme*' ,
'KIconView*' => 'kde_KIconView*',
'KIconViewItem*' => 'kde_KIconViewItem*',
'KImageEffect*' => 'kde_KImageEffect*',
'KImageFilePreview*' => 'kde_KImageFilePreview*',
'KImageIO*' => 'kde_KImageIO*',
'KInetSocketAddress&' => 'kde_KInetSocketAddress*',
'KInetSocketAddress*' => 'kde_KInetSocketAddress*',
'KInstance&'  => 'kde_KInstance*' ,
'KInstance'  => 'kde_KInstance*' ,
'KInstance*'  => 'kde_KInstance*' ,
'KIntNumInput*' => 'kde_KIntNumInput*',
'KIntSpinBox*' => 'kde_KIntSpinBox*',
'KIntValidator*' => 'kde_KIntValidator*',
'KJS*' => 'kde_KJS*',
'KJS::KJSO&' => 'kde_KJS_KJSO*',
'KJS::UString&' => 'kde_KJS_UString*',
'KJSO&' => 'kde_KJSO*',
'KJSO' => 'kde_KJSO*',
'KJSO*' => 'kde_KJSO*',
'KJScript*' => 'kde_KJScript*',
'KJanusWidget*' => 'kde_KJanusWidget*',
'KJavaApplet*'  =>  'kde_KJavaApplet*' ,
'KJavaAppletContext*'  => 'kde_KJavaAppletContext*' ,
'KJavaAppletServer*'  =>  'kde_KJavaAppletServer*' ,
'KJavaAppletWidget*' => 'kde_KJavaAppletWidget*',
'KJavaProcess*' => 'kde_KJavaProcess*',
'KJavaScriptAdvice&'  => 'kde_KJavaScriptAdvice*' ,
'KKeyChooser*' => 'kde_KKeyChooser*',
'KKeyChooserItem*' => 'kde_KKeyChooserItem*',
'KKeyDialog*' => 'kde_KKeyDialog*',
'KKeyEntry&'  => 'kde_KKeyEntry*' ,
'KKeyEntry*' => 'kde_KKeyEntry*',
'KKeyEntryMap&'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap'  => 'kde_KKeyEntryMap*' ,
'KKeyEntryMap*'  => 'kde_KKeyEntryMap*' ,
'KKeySequence&' => 'kde_KKeySequence*',
'KKeySequence' => 'kde_KKeySequence*',
'KKeySequence*' => 'kde_KKeySequence*',
'KKeySequence::I18N' => 'int',
'KKeySequences&' => 'kde_KKeySequences*',
'KKeySequences' => 'kde_KKeySequences*',
'KKeySequences*' => 'kde_KKeySequences*',
'KLed*' => 'kde_KLed*',
'KLibFactory*'  =>  'kde_KLibFactory*' ,
'KLibLoader*'  =>  'kde_KLibLoader*' ,
'KLibrary*'  => 'kde_KLibrary*' ,
'KLineEdit*'  =>  'kde_KLineEdit*' ,
'KLineEditDlg*' => 'kde_KLineEditDlg*',
'KListAction*' => 'kde_KListAction*',
'KListBox*' => 'kde_KListBox*',
'KListView*'  => 'kde_KListView*' ,
'KListViewItem*' => 'kde_KListViewItem*',
'KLocale&'  => 'kde_KLocale*' ,
'KLocale*'  => 'kde_KLocale*' ,
'KMJobViewer*' => 'kde_KMJobViewer*',
'KMMainView*' => 'kde_KMMainView*',
'KMManager*' => 'kde_KMManager*',
'KMObject*' => 'kde_KMObject*',
'KMPrinter&' => 'kde_KMPrinter*',
'KMPrinter*' => 'kde_KMPrinter*',
'KMPrinterList*' => 'kde_KMPrinterList*',
'KMPrinterPage*' => 'kde_KMPrinterPage*',
'KMacroCommand*' => 'kde_KMacroCommand*',
'KMainWindow*' => 'kde_KMainWindow*',
'KMainWindowInterface*' => 'kde_KMainWindowInterface*',
'KMenuBar*'  => 'kde_KMenuBar*' ,
'KMessageBox*' => 'kde_KMessageBox*',
'KMidSimpleAPI*' => 'kde_KMidSimpleAPI*',
'KMimeMagic*'  =>  'kde_KMimeMagic*' ,
'KMimeMagicResult*'  => 'kde_KMimeMagicResult*' ,
'KMimeSourceFactory*'  => 'kde_KMimeSourceFactory*' ,
'KMimeType*' => 'kde_KMimeType*',
'KMimeType::List&'  => 'kde_KMimeType_List*' ,
'KMimeType::Ptr&'  => 'kde_KMimeType_Ptr*' ,
'KMimeType::Ptr'  => 'kde_KMimeType_Ptr' ,
'KMouseSettings*' => 'kde_KMouseSettings*',
'KMultipleDrag*' => 'kde_KMultipleDrag*',
'KNDBGFUNC'  => 'void *' ,
'KNotifyClient*' => 'kde_KNotifyClient*',
'KNumInput*'  => 'kde_KNumInput*' ,
'KOCRDialog*' => 'kde_KOCRDialog*',
'KOCRDialogFactory*' => 'kde_KOCRDialogFactory*',
'KOpenSSLProxy*' => 'kde_KOpenSSLProxy*',
'KOpenWithDlg*' => 'kde_KOpenWithDlg*',
'KOpenWithHandler*'  =>  'kde_KOpenWithHandler*' ,
'KPAC*' => 'kde_KPAC*',
'KPReloadObject*' => 'kde_KPReloadObject*',
'KPalette&'  => 'kde_KPalette*' ,
'KPalette*' => 'kde_KPalette*',
'KPaletteTable*' => 'kde_KPaletteTable*',
'KPanelAppMenu*' => 'kde_KPanelAppMenu*',
'KPanelApplet*' => 'kde_KPanelApplet*',
'KPanelExtension*' => 'kde_KPanelExtension*',
'KPanelMenu*'  =>  'kde_KPanelMenu*' ,
'KParts*' => 'kde_KParts*',
'KParts::BrowserExtension*'  => 'kde_BrowserExtension*' ,
'KParts::GUIActivateEvent*'  => 'kde_GUIActivateEvent*' ,
'KParts::Part*' => 'kde_Part*',
'KParts::PartManager*'  => 'kde_PartManager*' ,
'KParts::ReadOnlyPart*'  => 'kde_ReadOnlyPart*' ,
'KParts::URLArgs&'  => 'kde_URLArgs*' ,
'KParts::URLArgs' => 'kde_URLArgs*',
'KPasswordDialog*' => 'kde_KPasswordDialog*',
'KPasswordEdit*' => 'kde_KPasswordEdit*',
'KPixmap&'  => 'kde_KPixmap*' ,
'KPixmap'  => 'kde_KPixmap*' ,
'KPixmap*' => 'kde_KPixmap*',
'KPixmapEffect*' => 'kde_KPixmapEffect*',
'KPixmapIO*' => 'kde_KPixmapIO*',
'KPixmapProvider*'  => 'kde_KPixmapProvider*' ,
'KPixmapSplitter*' => 'kde_KPixmapSplitter*',
'KPlayObject*' => 'kde_KPlayObject*',
'KPlayObjectFactory*' => 'kde_KPlayObjectFactory*',
'KPopupFrame*' => 'kde_KPopupFrame*',
'KPopupMenu*'  => 'kde_KPopupMenu*' ,
'KPopupTitle*' => 'kde_KPopupTitle*',
'KPreviewWidgetBase*' => 'kde_KPreviewWidgetBase*',
'KPrintAction*' => 'kde_KPrintAction*',
'KPrintDialogPage*' => 'kde_KPrintDialogPage*',
'KPrinter*' => 'kde_KPrinter*',
'KPrinterWrapper*' => 'kde_KPrinterWrapper*',
'KProcIO*'  =>  'kde_KProcIO*' ,
'KProcess&'  => 'kde_KProcess*' ,
'KProcess*'  => 'kde_KProcess*' ,
'KProcessController*' => 'kde_KProcessController*',
'KProcessRunner*' => 'kde_KProcessRunner*',
'KProgress*' => 'kde_KProgress*',
'KPropertiesDialog*'  => 'kde_KPropertiesDialog*' ,
'KPropsDlgPlugin*'  => 'kde_KPropsDlgPlugin*' ,
'KProtocolInfo*' => 'kde_KProtocolInfo*',
'KProtocolManager*' => 'kde_KProtocolManager*',
'KPushButton*' => 'kde_KPushButton*',
'KRFCDate*' => 'kde_KRFCDate*',
'KRadioAction*' => 'kde_KRadioAction*',
'KRandomSequence*' => 'kde_KRandomSequence*',
'KRecentDocument*' => 'kde_KRecentDocument*',
'KRecentFilesAction*'  =>  'kde_KRecentFilesAction*' ,
'KRegExp*' => 'kde_KRegExp*',
'KRegExpEditor*' => 'kde_KRegExpEditor*',
'KRegExpEditorInterface*' => 'kde_KRegExpEditorInterface*',
'KRestrictedLine*' => 'kde_KRestrictedLine*',
'KRootPermsIcon*' => 'kde_KRootPermsIcon*',
'KRootPixmap*' => 'kde_KRootPixmap*',
'KRootProp*' => 'kde_KRootProp*',
'KRuler*' => 'kde_KRuler*',
'KRun*' => 'kde_KRun*',
'KSSL&' => 'kde_KSSL*',
'KSSL*' => 'kde_KSSL*',
'KSSLAuthAction' => 'int',
'KSSLAuthAction*' => 'int*',
'KSSLCertBox*' => 'kde_KSSLCertBox*',
'KSSLCertChain&' => 'kde_KSSLCertChain*',
'KSSLCertChain*' => 'kde_KSSLCertChain*',
'KSSLCertDlg*' => 'kde_KSSLCertDlg*',
'KSSLCertDlgRet' => 'kde_KSSLCertDlgRet*',
'KSSLCertDlgRet*' => 'kde_KSSLCertDlgRet*',
'KSSLCertificate&' => 'kde_KSSLCertificate*',
'KSSLCertificate*' => 'kde_KSSLCertificate*',
'KSSLCertificateCache*' => 'kde_KSSLCertificateCache*',
'KSSLCertificateFactory*' => 'kde_KSSLCertificateFactory*',
'KSSLCertificateHome*' => 'kde_KSSLCertificateHome*',
'KSSLConnectionInfo&' => 'kde_KSSLConnectionInfo*',
'KSSLConnectionInfo*' => 'kde_KSSLConnectionInfo*',
'KSSLInfoDlg*' => 'kde_KSSLInfoDlg*',
'KSSLKeyGen*' => 'kde_KSSLKeyGen*',
'KSSLKeyType' => 'kde_KSSLKeyType',
'KSSLPKCS12*' => 'kde_KSSLPKCS12*',
'KSSLPKCS7*' => 'kde_KSSLPKCS7*',
'KSSLPeerInfo&' => 'kde_KSSLPeerInfo*',
'KSSLPeerInfo*' => 'kde_KSSLPeerInfo*',
'KSSLSettings*' => 'kde_KSSLSettings*',
'KSSLSigners*' => 'kde_KSSLSigners*',
'KSSLX509Map*' => 'kde_KSSLX509Map*',
'KSSLX509V3&' => 'kde_KSSLX509V3*',
'KSSLX509V3*' => 'kde_KSSLX509V3*',
'KSaveFile*' => 'kde_KSaveFile*',
'KScanDialog*' => 'kde_KScanDialog*',
'KScanDialogFactory*' => 'kde_KScanDialogFactory*',
'KScreenSaver*' => 'kde_KScreenSaver*',
'KScriptClientInterface*' => 'kde_KScriptClientInterface*',
'KScriptClientInterface::Result' => 'int',
'KScriptInterface*' => 'kde_KScriptInterface*',
'KScriptManager*' => 'kde_KScriptManager*',
'KSelectAction*' => 'kde_KSelectAction*',
'KSelector*' => 'kde_KSelector*',
'KSeparator*' => 'kde_KSeparator*',
'KServerSocket*' => 'kde_KServerSocket*',
'KService&'  => 'kde_KService*' ,
'KService*' => 'kde_KService*',
'KService::List'  => 'kde_KService_List*' ,
'KService::Ptr'  => 'kde_KService_Ptr*' ,
'KServiceGroup*' => 'kde_KServiceGroup*',
'KServiceOffer&'  => 'kde_KServiceOffer*' ,
'KServiceOffer*' => 'kde_KServiceOffer*',
'KServiceType*' => 'kde_KServiceType*',
'KServiceTypeProfile*'  =>  'kde_KServiceTypeProfile*' ,
'KSessionManaged*' => 'kde_KSessionManaged*',
'KShared&'  => 'kde_KShared*' ,
'KShared*' => 'kde_KShared*',
'KSharedPixmap*' => 'kde_KSharedPixmap*',
'KSharedPtr&'  => 'kde_KSharedPtr*' ,
'KSharedPtr*' => 'kde_KSharedPtr*',
'KShellCompletion*' => 'kde_KShellCompletion*',
'KShellProcess*' => 'kde_KShellProcess*',
'KShortcuts&' => 'kde_KShortcuts*',
'KShortcuts' => 'kde_KShortcuts*',
'KShortcuts*' => 'kde_KShortcuts*',
'KShred*' => 'kde_KShred*',
'KSimpleConfig&'  => 'kde_KSimpleConfig*' ,
'KSimpleConfig*' => 'kde_KSimpleConfig*',
'KSimpleFileFilter*' => 'kde_KSimpleFileFilter*',
'KSocket*' => 'kde_KSocket*',
'KSocketAddress&' => 'kde_KSocketAddress*',
'KSocketAddress*' => 'kde_KSocketAddress*',
'KSocks*' => 'kde_KSocks*',
'KSpell*' => 'kde_KSpell*',
'KSpellConfig&'  => 'kde_KSpellConfig*' ,
'KSpellConfig'  => 'kde_KSpellConfig*' ,
'KSpellConfig*'  => 'kde_KSpellConfig*' ,
'KSpellDlg*' => 'kde_KSpellDlg*',
'KSqueezedTextLabel*' => 'kde_KSqueezedTextLabel*',
'KStandardDirs*'  => 'kde_KStandardDirs*' ,
'KStartupInfo*' => 'kde_KStartupInfo*',
'KStartupInfoData&' => 'kde_KStartupInfoData*',
'KStartupInfoData*' => 'kde_KStartupInfoData*',
'KStartupInfoId&' => 'kde_KStartupInfoId*',
'KStartupInfoId' => 'kde_KStartupInfoId*',
'KStartupInfoId*' => 'kde_KStartupInfoId*',
'KStaticDeleter*' => 'kde_KStaticDeleter*',
'KStaticDeleterBase*'  => 'kde_KStaticDeleterBase*' ,
'KStatusBar*'  => 'kde_KStatusBar*' ,
'KStatusBar::BarStatusstat::Toggle'  =>  'int' ,
'KStatusBarLabel*' => 'kde_KStatusBarLabel*',
'KStdAccel*' => 'kde_KStdAccel*',
'KStdAccel::StdAccel'  => 'int' ,
'KStdAction*' => 'kde_KStdAction*',
'KStdGuiItem*' => 'kde_KStdGuiItem*',
'KStringHandler*' => 'kde_KStringHandler*',
'KStyle*'  => 'kde_KStyle*' ,
'KSycoca*'  =>  'kde_KSycoca*' ,
'KSycocaEntry*'  => 'kde_KSycocaEntry*' ,
'KSycocaFactory*'  => 'kde_KSycocaFactory*' ,
'KSycocaFactoryId'  => 'kde_KSycocaFactoryId' ,
'KSycocaType&'  => 'kde_KSycocaType*' ,
'KSycocaType'  => 'kde_KSycocaType*' ,
'KSystemTray*' => 'kde_KSystemTray*',
'KTMainWindow*' => 'kde_KTMainWindow*',
'KTabButton*' => 'kde_KTabButton*',
'KTabCtl*' => 'kde_KTabCtl*',
'KTar*' => 'kde_KTar*',
'KTarBase*'  =>  'kde_KTarBase*' ,
'KTarData*' => 'kde_KTarData*',
'KTarDirectory*'  => 'kde_KTarDirectory*' ,
'KTarEntry*'  => 'kde_KTarEntry*' ,
'KTarFile*' => 'kde_KTarFile*',
'KTarGz*' => 'kde_KTarGz*',
'KTempFile*' => 'kde_KTempFile*',
'KTextBrowser*' => 'kde_KTextBrowser*',
'KTextEditor*' => 'kde_KTextEditor*',
'KTextEditor__View&'  =>  'kde_KTextEditor__View*',
'KTextEditor__View'  =>  'kde_KTextEditor__View*',
'KTextEditor__View*'  =>  'kde_KTextEditor__View*',
'KThemeBase*'  =>  'kde_KThemeBase*', ,
'KThemeCache*'  =>  'kde_KThemeCache*',
'KThemePixmap&'  => 'kde_KThemePixmap*' ,
'KThemePixmap*'  => 'kde_KThemePixmap*' ,
'KThemeStyle*' => 'kde_KThemeStyle*',
'KTipDatabase*' => 'kde_KTipDatabase*',
'KTipDialog*' => 'kde_KTipDialog*',
'KToggleAction*'  => 'kde_KToggleAction*' ,
'KToolBar*'  => 'kde_KToolBar*' ,
'KToolBar::BarStatus' => 'int',
'KToolBar::BarStatusstat::Toggle'  =>  'int' ,
'KToolBarButton*'  => 'kde_KToolBarButton*' ,
'KToolBarButtonList*' => 'kde_KToolBarButtonList*',
'KToolBarPopupAction*' => 'kde_KToolBarPopupAction*',
'KToolBarPos'  => 'int' ,
'KToolBarRadioGroup*' => 'kde_KToolBarRadioGroup*',
'KToolBarSeparator*' => 'kde_KToolBarSeparator*',
'KToolButtonType'  => 'int' ,
'KTrader*'  =>  'kde_KTrader*' ,
'KTypeList*' => 'kde_KTypeList*',
'KURIFilter*'  =>  'kde_KURIFilter*' ,
'KURIFilterData&'  => 'kde_KURIFilterData*' ,
'KURIFilterData*' => 'kde_KURIFilterData*',
'KURIFilterPlugin*' => 'kde_KURIFilterPlugin*',
'KURIFilterPluginList*' => 'kde_KURIFilterPluginList*',
'KURL& url ()' => 'kde_KURL*',
'KURL& urlName ()' => 'kde_KURL*',
'KURL&'  => 'kde_KURL*' ,
'KURL'  => 'kde_KURL*' ,
'KURL*' => 'kde_KURL*',
'KURL::List&'  => 'kde_KURLList*' ,
'KURL::List'  => 'kde_KURLList*' ,
'KURLComboBox*' => 'kde_KURLComboBox*',
'KURLComboItem*'  => 'kde_KURLComboItem*' ,
'KURLCompletion*' => 'kde_KURLCompletion*',
'KURLDrag*' => 'kde_KURLDrag*',
'KURLLabel*' => 'kde_KURLLabel*',
'KURLPixmapProvider*' => 'kde_KURLPixmapProvider*',
'KURLPropsPlugin*' => 'kde_KURLPropsPlugin*',
'KURLRequester*' => 'kde_KURLRequester*',
'KURLRequesterDlg*' => 'kde_KURLRequesterDlg*',
'KUniqueApplication*' => 'kde_KUniqueApplication*',
'KUnixSocketAddress*' => 'kde_KUnixSocketAddress*',
'KValueSelector*' => 'kde_KValueSelector*',
'KWin*' => 'kde_KWin*',
'KWinModule*' => 'kde_KWinModule*',
'KWindowListMenu*' => 'kde_KWindowListMenu*',
'KWizard*' => 'kde_KWizard*',
'KWordWrap*' => 'kde_KWordWrap*',
'KWritePermsIcon*' => 'kde_KWritePermsIcon*',
'KXMLGUIBuilder*'  =>  'kde_KXMLGUIBuilder*' ,
'KXMLGUIClient*'  => 'kde_KXMLGUIClient*' ,
'KXMLGUIFactory*'  => 'kde_KXMLGUIFactory*' ,
'KXMessages*' => 'kde_KXMessages*',
'KXYSelector*' => 'kde_KXYSelector*',
'KZoneAllocator*' => 'kde_KZoneAllocator*',
'KabAPI*' => 'kde_KabAPI*',
'KabKey&'  => 'kde_KabKey*' ,
'KabKey'  => 'kde_KabKey*' ,
'KabKey*' => 'kde_KabKey*',
'Key&'  =>  'Key*' ,
'KeyBindingMap'  => 'kde_KeyBindingMap*' ,
'KeyValueMap&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*&'  => 'kde_KeyValueMap*' ,
'KeyValueMap*'  => 'kde_KeyValueMap*' ,
'Keymap*' => 'kde_Keymap*',
'LinkStyle&' => 'kde_LinkStyle*',
'LinkStyle*' => 'kde_LinkStyle*',
'List&' => 'kde_List*',
'List' => 'kde_List',
'List*' => 'kde_List*',
'ListIterator&' => 'kde_ListIterator*',
'ListIterator' => 'kde_ListIterator',
'ListIterator*' => 'kde_ListIterator*',
'ListJob*' => 'kde_ListJob*',
'ListNode*' => 'kde_ListNode*',
'ListProgress*' => 'kde_ListProgress*',
'Lookup*' => 'kde_Lookup*',
'MCOPConfig*' => 'kde_MCOPConfig*',
'MCOPUtils*' => 'kde_MCOPUtils*',
'MSG*'  =>  'MSG*' ,
'MailServer&'  =>  'MailServer*' ,
'MailServer*' => 'kde_MailServer*',
'MainWindow*' => 'kde_MainWindow*',
'Mark*' => 'kde_Mark*',
'MarkInterface*' => 'kde_MarkInterface*',
'MediaAsyncStream*' => 'kde_MediaAsyncStream*',
'MediaDataPacket*' => 'kde_MediaDataPacket*',
'MediaFrame*' => 'kde_MediaFrame*',
'MediaList&' => 'kde_MediaList*',
'MediaList' => 'kde_MediaList',
'MediaList*' => 'kde_MediaList*',
'MediaListImpl*' => 'kde_MediaListImpl*',
'MediaModule&' => 'kde_MediaModule*',
'MediaModule' => 'kde_MediaModule*',
'MediaModule*' => 'kde_MediaModule*',
'MediaModule_base*' => 'kde_MediaModule_base*',
'MediaModule_skel*' => 'kde_MediaModule_skel*',
'MediaModule_stub*' => 'kde_MediaModule_stub*',
'MenuDockData*' => 'kde_MenuDockData*',
'MetaData&' => 'kde_MetaData*',
'MetaData' => 'kde_MetaData*',
'MetaData*' => 'kde_MetaData*',
'MethodDef&' => 'kde_MethodDef*',
'MethodDef*' => 'kde_MethodDef*',
'MidiEvent*' => 'kde_MidiEvent*',
'MidiFileInfo*' => 'kde_MidiFileInfo*',
'MidiMapper*' => 'kde_MidiMapper*',
'MidiOut*' => 'kde_MidiOut*',
'MidiPlayer*' => 'kde_MidiPlayer*',
'MidiStatus*' => 'kde_MidiStatus*',
'MidiTrack*' => 'kde_MidiTrack*',
'MimetypeJob*' => 'kde_MimetypeJob*',
'Mode' => 'int',
'ModuleDef&' => 'kde_ModuleDef*',
'ModuleDef*' => 'kde_ModuleDef*',
'MouseDoubleClickEvent*' => 'kde_MouseDoubleClickEvent*',
'MouseEvent*' => 'kde_MouseEvent*',
'MouseMoveEvent*' => 'kde_MouseMoveEvent*',
'MousePressEvent*' => 'kde_MousePressEvent*',
'MouseReleaseEvent*' => 'kde_MouseReleaseEvent*',
'MultiGetJob*' => 'kde_MultiGetJob*',
'MultiPort*' => 'kde_MultiPort*',
'NET*' => 'kde_NET*',
'NET::WindowType'  =>  'int' ,
'NETIcon'  =>  'kdeNETIcon*' ,
'NETIcon*' => 'kde_NETIcon*',
'NETPoint&'  =>  'kde_NETPoint*' ,
'NETPoint'  =>  'kde_NETPoint*' ,
'NETPoint*' => 'kde_NETPoint*',
'NETRect&'  =>  'kde_NETRect*' ,
'NETRect'  =>  'kde_NETRect*' ,
'NETRect*' => 'kde_NETRect*',
'NETRootInfo&'  =>  'kde_NETRootInfo*' ,
'NETRootInfo*' => 'kde_NETRootInfo*',
'NETRootInfoPrivate*' => 'kde_NETRootInfoPrivate*',
'NETSize&'  =>  'kde_NETSize*' ,
'NETSize'  =>  'kde_NETSize*' ,
'NETSize*' => 'kde_NETSize*',
'NETStrut'  =>  'kde_NETStrut*' ,
'NETStrut*' => 'kde_NETStrut*',
'NETWinInfo&'  =>  'kde_NETWinInfo*' ,
'NETWinInfo*' => 'kde_NETWinInfo*',
'NETWinInfoPrivate*' => 'kde_NETWinInfoPrivate*',
'NamedNodeMap&' => 'kde_NamedNodeMap*',
'NamedNodeMap' => 'kde_NamedNodeMap*',
'NamedNodeMap*' => 'kde_NamedNodeMap*',
'NamedNodeMapImpl*' => 'kde_NamedNodeMapImpl*',
'NetAccess*' => 'kde_NetAccess*',
'NetRC*' => 'kde_NetRC*',
'Node&' => 'kde_DOMNode*',
'Node' => 'kde_DOMNode*',
'Node*' => 'kde_DOMNode*',
'NodeFilter&' => 'kde_NodeFilter*',
'NodeFilter' => 'kde_NodeFilter*',
'NodeFilter*' => 'kde_NodeFilter*',
'NodeFilterImpl*' => 'kde_NodeFilterImpl*',
'NodeImpl*' => 'kde_NodeImpl*',
'NodeIterator&' => 'kde_NodeIterator*',
'NodeIterator' => 'kde_NodeIterator*',
'NodeIterator*' => 'kde_NodeIterator*',
'NodeIteratorImpl*' => 'kde_NodeIteratorImpl*',
'NodeList&' => 'kde_DOMNodeList*',
'NodeList' => 'kde_DOMNodeList*',
'NodeList*' => 'kde_DOMNodeList*',
'NodeListImpl*' => 'kde_NodeListImpl*',
'NodePtr'  =>  'int' ,
'NodeType'  =>  'int' ,
'Notation&' => 'kde_Notation*',
'Notation*' => 'kde_Notation*',
'NoteArray*' => 'kde_NoteArray*',
'Notification&' => 'kde_Notification*',
'Notification' => 'kde_Notification*',
'Notification*' => 'kde_Notification*',
'NotificationClient*' => 'kde_NotificationClient*',
'NotificationManager*' => 'kde_NotificationManager*',
'Null*' => 'null',
'Number&' => 'kde_Number*',
'Number*' => 'kde_Number*',
'Object&' => 'kde_Object*',
'Object' => 'kde_Object*',
'Object*' => 'kde_Object*',
'ObjectImp*' => 'kde_ObjectImp*',
'ObjectManager*' => 'kde_ObjectManager*',
'ObjectReference&' => 'kde_ObjectReference*',
'ObjectReference*' => 'kde_ObjectReference*',
'Object_base*' => 'kde_Object_base*',
'Object_skel*' => 'kde_Object_skel*',
'Object_stub*' => 'kde_Object_stub*',
'Observer*' => 'kde_Observer*',
'OfferList'  =>  'kde_OfferList*' ,
'Offset' => 'int',
'OnewayDispatchFunction' => 'kde_OnewayDispatchFunction*',
'OnewayInvocation&' => 'kde_OnewayInvocation*',
'OnewayInvocation*' => 'kde_OnewayInvocation*',
'OpenURLEvent*' => 'kde_OpenURLEvent*',
'Orientation' => 'int',
'PFlags' => 'int',
'PIAccess' => 'int',
'PID' => 'long',
'PIType' => 'int',
'PTY*' => 'kde_PTY*',
'PageSize' => 'int',
'ParamDef&' => 'kde_ParamDef*',
'ParamDef*' => 'kde_ParamDef*',
'ParsedArgument*' => 'kde_ParsedArgument*',
'ParsedAttribute*' => 'kde_ParsedAttribute*',
'ParsedClass&' => 'kde_ParsedClass&',
'ParsedClass*' => 'kde_ParsedClass*',
'ParsedClassContainer*' => 'kde_ParsedClassContainer*',
'ParsedContainer*' => 'kde_ParsedContainer*',
'ParsedItem*' => 'kde_ParsedItem*',
'ParsedMethod*' => 'kde_ParsedMethod*',
'ParsedParent*' => 'kde_ParsedParent*',
'ParsedScopeContainer*' => 'kde_ParsedScopeContainer*',
'ParsedSignalSlot*' => 'kde_ParsedSignalSlot*',
'ParsedStruct*' => 'kde_ParsedStruct*',
'Part*' => 'kde_Part*',
'PartActivateEvent*' => 'kde_PartActivateEvent*',
'PartBase*' => 'kde_PartBase*',
'PartManager*' => 'kde_PartManager*',
'PartSelectEvent*' => 'kde_PartSelectEvent*',
'PassDlg*' => 'kde_PassDlg*',
'PasswordDialog*' => 'kde_PasswordDialog*',
'PenCapStyle'  =>  'int' ,
'PenJoinStyle'  =>  'int' ,
'PenStyle' => 'int',
'PersistantClassStore*' => 'kde_PersistantClassStore*',
'PhoneNumber&' => 'kde_PhoneNumber*',
'PhoneNumber*' => 'kde_PhoneNumber*',
'PipeBuffer*' => 'kde_PipeBuffer*',
'PipeSegment*' => 'kde_PipeSegment*',
'Pix&'  =>  'kde_Pix*' ,
'Pix'  =>  'kde_Pix*' ,
'PixelMetric' => 'int',
'PlayObject&' => 'kde_PlayObject*',
'PlayObject' => 'kde_PlayObject*',
'PlayObject*' => 'kde_PlayObject*',
'PlayObjectFactory&' => 'kde_PlayObjectFactory*',
'PlayObjectFactory' => 'kde_PlayObjectFactory',
'PlayObjectFactory*' => 'kde_PlayObjectFactory*',
'PlayObjectFactory_base*' => 'kde_PlayObjectFactory_base*',
'PlayObjectFactory_skel*' => 'kde_PlayObjectFactory_skel*',
'PlayObjectFactory_stub*' => 'kde_PlayObjectFactory_stub*',
'PlayObject_base*' => 'kde_PlayObject_base*',
'PlayObject_private&' => 'kde_PlayObject_private*',
'PlayObject_private' => 'kde_PlayObject_private',
'PlayObject_private*' => 'kde_PlayObject_private*',
'PlayObject_private_base*' => 'kde_PlayObject_private_base*',
'PlayObject_private_skel*' => 'kde_PlayObject_private_skel*',
'PlayObject_private_stub*' => 'kde_PlayObject_private_stub*',
'PlayObject_skel*' => 'kde_PlayObject_skel*',
'PlayObject_stub*' => 'kde_PlayObject_stub*',
'PlayerController*' => 'kde_PlayerController*',
'Plugin*' => 'kde_Plugin*',
'PluginInfo*' => 'kde_PluginInfo*',
'Policy' => 'int',
'Pool&' => 'kde_Pool*',
'Pool*' => 'kde_Pool*',
'PopupMenuInterface*' => 'kde_PopupMenuInterface*',
'Port*' => 'kde_Port*',
'PreviewJob*' => 'kde_PreviewJob*',
'PrimitiveElement' => 'int',
'PrintInterface*' => 'kde_PrintInterface*',
'PrinterMode' => 'int',
'ProcessingInstruction&' => 'kde_ProcessingInstruction*',
'ProcessingInstruction' => 'kde_ProcessingInstruction*',
'ProcessingInstruction*' => 'kde_ProcessingInstruction*',
'ProgressBase*' => 'kde_ProgressBase*',
'ProgressItem*' => 'kde_ProgressItem*',
'PropagationMode' => 'int',
'ProtocolInfo*' => 'kde_ProtocolInfo*',
'Ptr' => 'void *',
'PtyProcess*' => 'kde_PtyProcess*',
'QAccel*' => 'qt_QAccel*',
'QAccessible*' => 'qt_QAccessible*',
'QAccessibleFactoryInterface*' => 'qt_QAccessibleFactoryInterface*',
'QAccessibleInterface*' => 'qt_QAccessibleInterface*',
'QAccessibleInterface**' => 'qt_QAccessibleInterface**',
'QAccessibleObject*' => 'qt_QAccessibleObject*',
'QAction*'  =>  'qt_QAction*' ,
'QActionGroup*' => 'qt_QActionGroup*',
'QApplication*'  => 'qt_QApplication*' ,
'QArabicCodec*' => 'qt_QArabicCodec*',
'QArray*' => 'qt_QArray*',
'QAsciiBucket*' => 'qt_QAsciiBucket*',
'QAsciiCache*' => 'qt_QAsciiCache*',
'QAsciiCacheIterator*' => 'qt_QAsciiCacheIterator*',
'QAsciiDict*' => 'qt_QAsciiDict*',
'QAsciiDictIterator*' => 'qt_QAsciiDictIterator*',
'QAsyncIO*' => 'qt_QAsyncIO*',
'QAuBucket*'  =>  'qt_QAuBucket*' ,
'QAuServer*' => 'qt_QAuServer*',
'QBaseBucket*'  =>  'qt_QBaseBucket*' ,
'QBig5Codec*' => 'qt_QBig5Codec*',
'QBitArray&'  => 'qt_QBitArray*' ,
'QBitArray'  => 'qt_QBitArray*' ,
'QBitArray*'  =>  'qt_QBitArray*' ,
'QBitVal&'  => 'qt_QBitVal*' ,
'QBitVal'  => 'qt_QBitVal*' ,
'QBitVal*' => 'qt_QBitVal*',
'QBitmap&' => 'qt_QBitmap *',
'QBitmap' => 'qt_QBitmap *',
'QBitmap*' => 'qt_QBitmap *',
'QBoxLayout*' => 'qt_QBoxLayout*',
'QBrush&' => 'qt_QBrush *',
'QBrush'  =>  'qt_QBrush*' ,
'QBrush*'  => 'qt_QBrush*' ,
'QBrushData*' => 'qt_QBrushData*',
'QBuffer*' => 'qt_QBuffer*',
'QButton*' => 'qt_QButton *',
'QButtonGroup*'  =>  'qt_QButtonGroup*' ,
'QByteArray& arr ()' => 'qt_QByteArray*',
'QByteArray&'  => 'qt_QByteArray*' ,
'QByteArray' => 'qt_QByteArray*',
'QByteArray*' => 'qt_QByteArray*',
'QCDEStyle*' => 'qt_QCDEStyle*',
'QCOORD&' => 'short',
'QCOORD' => 'short',
'QCOORD*' => 'short *',
'QCString&'  =>  'qt_QCString*' ,
'QCString'  =>  'qt_QCString*' ,
'QCString*'  =>  'qt_QCString*' ,
'QCStringLess*'  =>  'qt_QCStringLess*' ,
'QCStringList'  => 'kde_QCStringList*' ,
'QCache*' => 'qt_QCache*',
'QCacheIterator*' => 'qt_QCacheIterator*',
'QCanvas*'  =>  'qt_QCanvas*' ,
'QCanvasEllipse*' => 'qt_QCanvasEllipse*',
'QCanvasItem*'  =>  'qt_QCanvasItem*' ,
'QCanvasItemList'  =>  'qt_QCanvasItemList*' ,
'QCanvasItemList*' => 'qt_QCanvasItemList*',
'QCanvasLine*' => 'qt_QCanvasLine*',
'QCanvasPixmap*'  =>  'qt_QCanvasPixmap*' ,
'QCanvasPixmapArray*'  =>  'qt_QCanvasPixmapArray*' ,
'QCanvasPolygon*' => 'qt_QCanvasPolygon*',
'QCanvasPolygonalItem*' => 'qt_QCanvasPolygonalItem*',
'QCanvasRectangle*' => 'qt_QCanvasRectangle*',
'QCanvasSpline*' => 'qt_QCanvasSpline*',
'QCanvasSprite*' => 'qt_QCanvasSprite*',
'QCanvasText*' => 'qt_QCanvasText*',
'QCanvasView*'  =>  'qt_QCanvasView*' ,
'QChain*'  => 'qt_QChain*' ,
'QChar&'  =>  'qt_QChar*' ,
'QChar'  =>  'qt_QChar*' ,
'QChar*'  =>  'qt_QChar*' ,
'QChar::Category'  =>  'int' ,
'QChar::Decomposition'  =>  'int' ,
'QChar::Direction'  =>  'int' ,
'QChar::Joining'  =>  'int' ,
'QCharRef&'  =>  'qt_QCharRef*' ,
'QCharRef'  =>  'qt_QCharRef*' ,
'QCharRef*' => 'qt_QCharRef*',
'QCheckBox*' => 'qt_QCheckBox*',
'QCheckListItem*' => 'qt_QCheckListItem *',
'QCheckTableItem*' => 'qt_QCheckTableItem*',
'QChildEvent*'  => 'qt_QChildEvent*' ,
'QClassInfo*'  =>  'qt_QClassInfo*' ,
'QCleanupHandler*' => 'qt_QCleanupHandler*',
'QClipboard*' => 'qt_QClipboard *',
'QCloseEvent*'  => 'qt_QCloseEvent*' ,
'QCollection&'  => 'qt_QCollection*' ,
'QCollection*' => 'qt_QCollection*',
'QCollection::Item&'  =>  'void *' ,
'QCollection::Item'  =>  'void *' ,
'QColor &' => 'qt_QColor *',
'QColor&' => 'qt_QColor *',
'QColor&fillColor::white'  =>  'int' ,
'QColor&linkColor::blue'  =>  'int' ,
'QColor' => 'qt_QColor *',
'QColor*'  => 'qt_QColor*' ,
'QColorDialog*' => 'qt_QColorDialog*',
'QColorDrag*' => 'qt_QColorDrag*',
'QColorGroup&' => 'qt_QColorGroup *',
'QColorGroup'  =>  'qt_QColorGroup*' ,
'QColorGroup*'  => 'qt_QColorGroup*' ,
'QColorGroup::ColorRole'  => 'int' ,
'QComboBox*'  =>  'qt_QComboBox*' ,
'QComboBox::Policy'  => 'int' ,
'QComboBox::Policypolicy::AtBottom'  => 'int' ,
'QComboTableItem*' => 'qt_QComboTableItem*',
'QCommonStyle*' => 'qt_QCommonStyle*',
'QCompactStyle*' => 'qt_QCompactStyle*',
'QComponentFactory*' => 'qt_QComponentFactory*',
'QComponentFactoryInterface*' => 'qt_QComponentFactoryInterface*',
'QComponentInterface*' => 'qt_QComponentInterface*',
'QComponentRegistration*' => 'qt_QComponentRegistration*',
'QComponentServerInterface*' => 'qt_QComponentServerInterface*',
'QConfigDB*'  =>  'qt_QConfigDB*' ,
'QConfigDB*'  => 'qt_QConfigDB*' ,
'QConnection*' => 'qt_QConnection*',
'QConnectionList&'  => 'qt_QConnectionList*' ,
'QConnectionList*'  =>  'qt_QConnectionList*' ,
'QConnectionListIt&'  => 'qt_QConnectionListIt*' ,
'QConnectionListIt*' => 'qt_QConnectionListIt*',
'QConstString' => 'qt_QConstString*',
'QConstString*' => 'qt_QConstString*',
'QContextMenuEvent*' => 'qt_QContextMenuEvent*',
'QCursor&' => 'qt_QCursor *',
'QCursor'  =>  'qt_QCursor*' ,
'QCursor*' => 'qt_QCursor *',
'QCustomEvent*'  =>  'qt_QCustomEvent*' ,
'QCustomMenuItem*'  =>  'qt_QCustomMenuItem*' ,
'QDOM_NodeListPrivate*'  =>  'void*' ,
'QDOM_NodePrivate*'  =>  'void*' ,
'QDataBrowser*' => 'qt_QDataBrowser*',
'QDataPump*' => 'qt_QDataPump*',
'QDataSink*'  => 'qt_QDataSink*' ,
'QDataSource*'  => 'qt_QDataSource*' ,
'QDataStream&' => 'qt_QDataStream *',
'QDataStream*'  => 'qt_QDataStream*' ,
'QDataTable*' => 'qt_QDataTable*',
'QDataView*' => 'qt_QDataView*',
'QDate &' => 'qt_QDate *',
'QDate date()' => 'qt_QDate*',
'QDate&' => 'qt_QDate *',
'QDate' => 'qt_QDate *',
'QDate*' => 'qt_QDate*',
'QDateEdit*' => 'qt_QDateEdit*',
'QDateTime&' => 'qt_QDateTime *',
'QDateTime' => 'qt_QDateTime *',
'QDateTime*'  => 'qt_QDateTime*' ,
'QDateTimeEdit*' => 'qt_QDateTimeEdit*',
'QDateTimeEditBase*' => 'qt_QDateTimeEditBase*',
'QDesktopWidget*' => 'qt_QDesktopWidget*',
'QDial*' => 'qt_QDial*',
'QDialog*' => 'qt_QDialog*',
'QDict*' => 'qt_QDict*',
'QDictIterator*' => 'qt_QDictIterator*',
'QDir&' => 'qt_QDir *',
'QDir' => 'qt_QDir *',
'QDir*' => 'qt_QDir *',
'QDir::SortSpec&'  => 'int' ,
'QDir::SortSpec'  => 'int' ,
'QDirSortItem*' => 'qt_QDirSortItem*',
'QDiskFont*' => 'qt_QDiskFont*',
'QDispatchInterface*' => 'qt_QDispatchInterface*',
'QDns*' => 'qt_QDns*',
'QDnsSocket*' => 'qt_QDnsSocket*',
'QDockArea*' => 'qt_QDockArea*',
'QDockAreaLayout*' => 'qt_QDockAreaLayout*',
'QDockWindow*' => 'qt_QDockWindow*',
'QDomAttr&'  =>  'qt_QDomAttr*' ,
'QDomAttr'  =>  'qt_QDomAttr*' ,
'QDomAttr*' => 'qt_QDomAttr*',
'QDomCDATASection&'  =>  'qt_QDomCDATASection*' ,
'QDomCDATASection'  =>  'qt_QDomCDATASection*' ,
'QDomCDATASection*' => 'qt_QDomCDATASection*',
'QDomCharacterData&'  =>  'qt_QDomCharacterData*' ,
'QDomCharacterData'  =>  'qt_QDomCharacterData*' ,
'QDomCharacterData*' => 'qt_QDomCharacterData*',
'QDomComment&'  =>  'qt_QDomComment*' ,
'QDomComment'  =>  'qt_QDomComment*' ,
'QDomComment*' => 'qt_QDomComment*',
'QDomDocument&'  =>  'qt_QDomDocument*' ,
'QDomDocument'  =>  'qt_QDomDocument*' ,
'QDomDocument*' => 'qt_QDomDocument*',
'QDomDocumentFragment&'  =>  'qt_QDomDocumentFragment*' ,
'QDomDocumentFragment'  =>  'qt_QDomDocumentFragment*' ,
'QDomDocumentFragment*' => 'qt_QDomDocumentFragment*',
'QDomDocumentType&'  =>  'qt_QDomDocumentType*' ,
'QDomDocumentType'  =>  'qt_QDomDocumentType*' ,
'QDomDocumentType*' => 'qt_QDomDocumentType*',
'QDomElement&'  =>  'qt_QDomElement*' ,
'QDomElement'  =>  'qt_QDomElement*' ,
'QDomElement*' => 'qt_QDomElement*',
'QDomEntity&'  =>  'qt_QDomEntity*' ,
'QDomEntity'  =>  'qt_QDomEntity*' ,
'QDomEntity*' => 'qt_QDomEntity*',
'QDomEntityReference&'  =>  'qt_QDomEntityReference*' ,
'QDomEntityReference'  =>  'qt_QDomEntityReference*' ,
'QDomEntityReference*' => 'qt_QDomEntityReference*',
'QDomImplementation&'  =>  'qt_QDomImplementation*' ,
'QDomImplementation'  =>  'qt_QDomImplementation*' ,
'QDomImplementation*' => 'qt_QDomImplementation*',
'QDomNamedNodeMap&'  =>  'qt_QDomNamedNodeMap*' ,
'QDomNamedNodeMap'  =>  'qt_QDomNamedNodeMap*' ,
'QDomNamedNodeMap*' => 'qt_QDomNamedNodeMap*',
'QDomNode&'  =>  'qt_QDomNode*' ,
'QDomNode'  =>  'qt_QDomNode*' ,
'QDomNode*' => 'qt_QDomNode*',
'QDomNode::NodeType' => 'int',
'QDomNodeList&'  =>  'qt_QDomNodeList*' ,
'QDomNodeList'  =>  'qt_QDomNodeList*' ,
'QDomNodeList*' => 'qt_QDomNodeList*',
'QDomNodePrivate*' => 'qt_QDomNodePrivate*',
'QDomNotation&'  =>  'qt_QDomNotation*' ,
'QDomNotation'  =>  'qt_QDomNotation*' ,
'QDomNotation*' => 'qt_QDomNotation*',
'QDomProcessingInstruction&'  =>  'qt_QDomProcessingInstruction*' ,
'QDomProcessingInstruction'  =>  'qt_QDomProcessingInstruction*' ,
'QDomProcessingInstruction*' => 'qt_QDomProcessingInstruction*',
'QDomText&'  =>  'qt_QDomText*' ,
'QDomText'  =>  'qt_QDomText*' ,
'QDomText*' => 'qt_QDomText*',
'QDoubleValidator*' => 'qt_QDoubleValidator*',
'QDragEnterEvent*'  => 'qt_QDragEnterEvent*' ,
'QDragLeaveEvent*'  => 'qt_QDragLeaveEvent*' ,
'QDragManager*' => 'qt_QDragManager*',
'QDragMoveEvent*'  => 'qt_QDragMoveEvent*' ,
'QDragObject*'  => 'qt_QDragObject*' ,
'QDragResponseEvent*' => 'qt_QDragResponseEvent*',
'QDropEvent*'  => 'qt_QDropEvent*' ,
'QDropSite*' => 'qt_QDropSite*',
'QEditorFactory*' => 'qt_QEditorFactory*',
'QErrorMessage*' => 'qt_QErrorMessage*',
'QEucJpCodec*' => 'qt_QEucJpCodec*',
'QEucKrCodec*' => 'qt_QEucKrCodec*',
'QEvent*' => 'qt_QEvent *',
'QFeatureListInterface*' => 'qt_QFeatureListInterface*',
'QFile&' => 'qt_QFile *',
'QFile*'  => 'qt_QFile*' ,
'QFileDialog*' => 'qt_QFileDialog*',
'QFileIconProvider*'  => 'qt_QFileIconProvider*' ,
'QFileInfo&' => 'qt_QFileInfo *',
'QFileInfo*' => 'qt_QFileInfo*',
'QFileInfoList*'  => 'qt_QFileInfoList*' ,
'QFilePreview*'  =>  'qt_QFilePreview*' ,
'QFocusData*'  =>  'qt_QFocusData*' ,
'QFocusEvent*'  => 'qt_QFocusEvent*' ,
'QFont&' => 'qt_QFont *',
'QFont' => 'qt_QFont *',
'QFont*' => 'qt_QFont *',
'QFont::CharSet' => 'int',
'QFont::CharSetcharset::Unicode'  => 'int' ,
'QFont::StyleHint' => 'int',
'QFontData&'  => 'qt_QFontData*' ,
'QFontDatabase*' => 'qt_QFontDatabase*',
'QFontDialog*' => 'qt_QFontDialog*',
'QFontInfo&' => 'qt_QFontInfo *',
'QFontInfo' => 'qt_QFontInfo *',
'QFontInfo*' => 'qt_QFontInfo*',
'QFontMetrics&' => 'qt_QFontMetrics *',
'QFontMetrics' => 'qt_QFontMetrics *',
'QFontMetrics*' => 'qt_QFontMetrics*',
'QFrame*'  => 'qt_QFrame*' ,
'QFtp*' => 'qt_QFtp*',
'QGArray&'  => 'qt_QGArray*' ,
'QGArray*' => 'qt_QGArray*',
'QGCache&'  => 'qt_QGCache*' ,
'QGCache*' => 'qt_QGCache*',
'QGCacheIterator&'  => 'qt_QGCacheIterator*' ,
'QGCacheIterator*' => 'qt_QGCacheIterator*',
'QGDict&'  => 'qt_QGDict*' ,
'QGDict*' => 'qt_QGDict*',
'QGDictIterator&'  => 'qt_QGDictIterator*' ,
'QGDictIterator*' => 'qt_QGDictIterator*',
'QGL*' => 'qt_QGL*',
'QGLColormap&' => 'qt_QGLColormap*',
'QGLColormap*' => 'qt_QGLColormap*',
'QGLContext*'  =>  'qt_QGLContext*' ,
'QGLFormat&'  =>  'qt_QGLFormat*' ,
'QGLFormat'  =>  'qt_QGLFormat*' ,
'QGLFormat*' => 'qt_QGLFormat*',
'QGLWidget*'  =>  'qt_QGLWidget*' ,
'QGLayoutIterator*'  =>  'qt_QGLayoutIterator*' ,
'QGList&'  => 'qt_QGList*' ,
'QGList*'  =>  'qt_QGList*' ,
'QGListIterator&'  => 'qt_QGListIterator*' ,
'QGListIterator*' => 'qt_QGListIterator*',
'QGPlugin*' => 'qt_QGPlugin*',
'QGPluginManager*' => 'qt_QGPluginManager*',
'QGVector&'  => 'qt_QGVector*' ,
'QGVector*'  => 'qt_QGVector*' ,
'QGbkCodec*' => 'qt_QGbkCodec*',
'QGfx*'  =>  'qt_QGfx*' ,
'QGrid*'  => 'qt_QGrid*' ,
'QGrid::Direction'  => 'int' ,
'QGridLayout*' => 'qt_QGridLayout*',
'QGridView*' => 'qt_QGridView*',
'QGroupBox*' => 'qt_QGroupBox*',
'QGuardedPtr*' => 'qt_QGuardedPtr*',
'QGuardedPtrPrivate*' => 'qt_QGuardedPtrPrivate*',
'QHBox*'  => 'qt_QHBox*' ,
'QHBoxLayout*'  =>  'qt_QHBoxLayout*' ,
'QHButtonGroup*' => 'qt_QHButtonGroup*',
'QHGroupBox*' => 'qt_QHGroupBox*',
'QHeader*' => 'qt_QHeader *',
'QHebrewCodec*' => 'qt_QHebrewCodec*',
'QHideEvent*'  => 'qt_QHideEvent*' ,
'QHostAddress&'  =>  'qt_QHostAddress*' ,
'QHostAddress'  =>  'qt_QHostAddress*' ,
'QHostAddress*'  =>  'qt_QHostAddress*' ,
'QHttp*' => 'qt_QHttp*',
'QIMEvent*' => 'qt_QIMEvent*',
'QIODevice*' => 'qt_QIODevice *',
'QIODevice::Offset' => 'int',
'QIODeviceSource*' => 'qt_QIODeviceSource*',
'QIOManager*' => 'qt_QIOManager*',
'QIOWatch*' => 'qt_QIOWatch*',
'QIconDrag*' => 'qt_QIconDrag*',
'QIconDragItem&'  =>  'qt_QIconDragItem*' ,
'QIconDragItem*' => 'qt_QIconDragItem*',
'QIconSet&'  => 'qt_QIconSet*' ,
'QIconSet'  => 'qt_QIconSet*' ,
'QIconSet*'  =>  'qt_QIconSet*' ,
'QIconView*'  => 'qt_QIconView*' ,
'QIconViewItem*'  =>  'qt_QIconViewItem*' ,
'QImage&' => 'qt_QImage *',
'QImage' => 'qt_QImage *',
'QImage*'  => 'qt_QImage*' ,
'QImageConsumer*'  =>  'qt_QImageConsumer*' ,
'QImageData*' => 'qt_QImageData*',
'QImageDecoder*' => 'qt_QImageDecoder*',
'QImageDrag*' => 'qt_QImageDrag*',
'QImageFormat*'  =>  'qt_QImageFormat*' ,
'QImageFormatInterface*' => 'qt_QImageFormatInterface*',
'QImageFormatPlugin*' => 'qt_QImageFormatPlugin*',
'QImageFormatType*'  => 'qt_QImageFormatType*' ,
'QImageIO*' => 'qt_QImageIO*',
'QImageTextKeyLang&'  =>  'qt_QImageTextKeyLang*' ,
'QImageTextKeyLang*' => 'qt_QImageTextKeyLang*',
'QInputDialog*' => 'qt_QInputDialog*',
'QIntBucket*' => 'qt_QIntBucket*',
'QIntCache*' => 'qt_QIntCache*',
'QIntCacheIterator*' => 'qt_QIntCacheIterator*',
'QIntDict*' => 'qt_QIntDict*',
'QIntDictIterator*' => 'qt_QIntDictIterator*',
'QIntValidator*' => 'qt_QIntValidator*',
'QInterfaceListInterface*' => 'qt_QInterfaceListInterface*',
'QInterfacePtr*' => 'qt_QInterfacePtr*',
'QInterlaceStyle*' => 'qt_QInterlaceStyle*',
'QInternal*' => 'qt_QInternal*',
'QJisCodec*' => 'qt_QJisCodec*',
'QJpUnicodeConv*'  =>  'qt_QJpUnicodeConv*' ,
'QKeyEvent*'  => 'qt_QKeyEvent*' ,
'QKeySequence&' => 'qt_QKeySequence*',
'QKeySequence' => 'qt_QKeySequence*',
'QKeySequence*' => 'qt_QKeySequence*',
'QKoi8Codec*' => 'qt_QKoi8Codec*',
'QLCDNumber*' => 'qt_QLCDNumber*',
'QLNode*'  => 'qt_QLNode*' ,
'QLabel*' => 'qt_QLabel *',
'QLayout*' => 'qt_QLayout *',
'QLayoutItem*'  =>  'qt_QLayoutItem*' ,
'QLayoutIterator&'  =>  'qt_QLayoutIterator*' ,
'QLayoutIterator'  =>  'qt_QLayoutIterator*' ,
'QLayoutIterator*' => 'qt_QLayoutIterator*',
'QLibrary*' => 'qt_QLibrary*',
'QLibrary::Policy' => 'int',
'QLibraryInterface*' => 'qt_QLibraryInterface*',
'QLineEdit*'  =>  'qt_QLineEdit*' ,
'QLineEdit::EchoMode'  =>  'int' ,
'QList*' => 'qt_QList*',
'QListBox*' => 'qt_QListBox *',
'QListBoxItem*' => 'qt_QListBoxItem *',
'QListBoxPixmap*' => 'qt_QListBoxPixmap*',
'QListBoxText*' => 'qt_QListBoxText*',
'QListIterator*' => 'qt_QListIterator*',
'QListView*' => 'qt_QListView *',
'QListViewItem*&' => 'qt_QListViewItem*',
'QListViewItem*' => 'qt_QListViewItem *',
'QListViewItemIterator&'  =>  'qt_QListViewItemIterator*' ,
'QListViewItemIterator'  =>  'qt_QListViewItemIterator*' ,
'QListViewItemIterator*' => 'qt_QListViewItemIterator*',
'QLocalFs*' => 'qt_QLocalFs*',
'QMCPI*' => 'qt_QMCPI*',
'QMSG*'  => 'QMSG*' ,
'QMainWindow*'  =>  'qt_QMainWindow*' ,
'QMainWindow::ToolBarDock' => 'int',
'QMainWindow::ToolBarDock::Top'  =>  'int' ,
'QMap&'  =>  'qt_QMap*' ,
'QMap*' => 'qt_QMap*',
'QMapConstIterator*' => 'qt_QMapConstIterator*',
'QMapIterator*' => 'qt_QMapIterator*',
'QMapNode*' => 'qt_QMapNode*',
'QMapNodeBase*&'  =>  'qt_QMapNodeBase*' ,
'QMapNodeBase*'  =>  'qt_QMapNodeBase*' ,
'QMapPrivate*' => 'qt_QMapPrivate*',
'QMapPrivateBase*'  =>  'qt_QMapPrivateBase*' ,
'QMemArray*' => 'qt_QMemArray*',
'QMember'  => 'qt_QMember*' ,
'QMember*'  => 'qt_QMember*' ,
'QMenuBar*' => 'qt_QMenuBar *',
'QMenuData*' => 'qt_QMenuData*',
'QMenuData**'  => 'qt_QMenuData**' ,
'QMenuItem*' => 'qt_QMenuItem *',
'QMessageBox*' => 'qt_QMessageBox*',
'QMetaData*'  =>  'qt_QMetaData*' ,
'QMetaData::Access*'  =>  'int*' ,
'QMetaEnum*'  =>  'qt_QMetaEnum*' ,
'QMetaEnum::Item*'  =>  'int*' ,
'QMetaObject*&' => 'qt_QMetaObject*',
'QMetaObject*' => 'qt_QMetaObject *',
'QMetaObjectCleanUp*' => 'qt_QMetaObjectCleanUp*',
'QMetaObjectInit*' => 'qt_QMetaObjectInit*',
'QMetaProperty*'  =>  'qt_QMetaProperty*' ,
'QMimeSource*'  =>  'qt_QMimeSource*' ,
'QMimeSourceFactory*'  =>  'qt_QMimeSourceFactory*' ,
'QMotifPlusStyle*' => 'qt_QMotifPlusStyle*',
'QMotifStyle*' => 'qt_QMotifStyle*',
'QMouseEvent*'  => 'qt_QMouseEvent*' ,
'QMoveEvent*'  =>  'qt_QMoveEvent*' ,
'QMovie&' => 'qt_QMovie *',
'QMovie*' => 'qt_QMovie *',
'QMultiLineEdit*' => 'qt_QMultiLineEdit*',
'QMultiLineEditRow*' => 'qt_QMultiLineEditRow*',
'QMutex*' => 'qt_QMutex*',
'QNPInstance*' => 'qt_QNPInstance*',
'QNPStream*' => 'qt_QNPStream*',
'QNPWidget*' => 'qt_QNPWidget*',
'QNPlugin*' => 'qt_QNPlugin*',
'QNetworkOperation*'  =>  'qt_QNetworkOperation*' ,
'QNetworkProtocol*'  =>  'qt_QNetworkProtocol*' ,
'QNetworkProtocol::Operation'  =>  'int' ,
'QNetworkProtocol::State'  =>  'int' ,
'QNetworkProtocolFactory*' => 'qt_QNetworkProtocolFactory*',
'QNetworkProtocolFactoryBase*'  =>  'qt_QNetworkProtocolFactoryBase*' ,
'QObject*' => 'qt_QObject*',
'QObjectCleanupHandler*' => 'qt_QObjectCleanupHandler*',
'QObjectDictionary&'  => 'qt_QObjectDictionary*' ,
'QObjectDictionary*' => 'qt_QObjectDictionary*',
'QObjectInterface*' => 'qt_QObjectInterface*',
'QObjectList&'  => 'qt_QObjectList*' ,
'QObjectList*' => 'qt_QObjectList *',
'QObjectListIt&'  => 'qt_QObjectListIt*' ,
'QObjectListIt*' => 'qt_QObjectListIt*',
'QPDevCmdParam*'  =>  'qt_QPDevCmdParam*' ,
'QPNGImagePacker*' => 'qt_QPNGImagePacker*',
'QPNGImageWriter*' => 'qt_QPNGImageWriter*',
'QPaintDevice*' => 'qt_QPaintDevice *',
'QPaintDeviceMetrics*' => 'qt_QPaintDeviceMetrics*',
'QPaintDeviceX11Data*'  =>  'qt_QPaintDeviceX11Data*' ,
'QPaintEvent*'  => 'qt_QPaintEvent*' ,
'QPainter&'  =>  'qt_QPainter*' ,
'QPainter*' => 'qt_QPainter *',
'QPair*' => 'qt_QPair*',
'QPalData*' => 'qt_QPalData*',
'QPalette&' => 'qt_QPalette *',
'QPalette' => 'qt_QPalette *',
'QPalette*' => 'qt_QPalette *',
'QPen&' => 'qt_QPen *',
'QPen'  =>  'qt_QPen*' ,
'QPen*' => 'qt_QPen*',
'QPenData*' => 'qt_QPenData*',
'QPicture&' => 'qt_QPicture *',
'QPicture' => 'qt_QPicture*',
'QPicture*' => 'qt_QPicture*',
'QPicturePrivate*' => 'qt_QPicturePrivate*',
'QPixmap& pixmap()' => 'kde_QPixmap*',
'QPixmap&' => 'qt_QPixmap *',
'QPixmap' => 'qt_QPixmap *',
'QPixmap*' => 'qt_QPixmap *',
'QPixmap::Optimization'  =>  'int' ,
'QPixmap::Optimization' => 'int',
'QPixmap::Optimization::DefaultOptim'  =>  'int' ,
'QPixmapCache*' => 'qt_QPixmapCache*',
'QPixmapData*' => 'qt_QPixmapData*',
'QPlatinumStyle*' => 'qt_QPlatinumStyle*',
'QPluginManager*' => 'qt_QPluginManager*',
'QPoint&' => 'qt_QPoint*',
'QPoint&pos()'  =>  'int' ,
'QPoint&pos::pos()'  =>  'int' ,
'QPoint' => 'qt_QPoint*',
'QPoint*'  => 'qt_QPoint*' ,
'QPointArray&' => 'qt_QPointArray*',
'QPointArray' => 'qt_QPointArray*',
'QPointArray*' => 'qt_QPointArray*',
'QPointVal&'  => 'qt_QPointVal*' ,
'QPointVal'  => 'qt_QPointVal*' ,
'QPolygonScanner*' => 'qt_QPolygonScanner*',
'QPopupMenu*' => 'qt_QPopupMenu*',
'QPrintDialog*' => 'qt_QPrintDialog*',
'QPrinter*'  => 'qt_QPrinter*' ,
'QPrinter::PrinterMode' => 'int',
'QProcess*' => 'qt_QProcess*',
'QProgressBar*' => 'qt_QProgressBar*',
'QProgressDialog*' => 'qt_QProgressDialog*',
'QPtrBucket*' => 'qt_QPtrBucket*',
'QPtrCollection&' => 'qt_QPtrCollection*',
'QPtrCollection*' => 'qt_QPtrCollection*',
'QPtrDict*' => 'qt_QPtrDict*',
'QPtrDictIterator*' => 'qt_QPtrDictIterator*',
'QPtrList*' => 'qt_QPtrList*',
'QPtrListIterator*' => 'qt_QPtrListIterator*',
'QPtrQueue*' => 'qt_QPtrQueue*',
'QPtrStack*' => 'qt_QPtrStack*',
'QPtrVector*' => 'qt_QPtrVector*',
'QPushButton*' => 'qt_QPushButton*',
'QQueue*' => 'qt_QQueue*',
'QRESULT' => 'long',
'QRadioButton*' => 'qt_QRadioButton*',
'QRangeControl*' => 'qt_QRangeControl*',
'QRect&' => 'qt_QRect*',
'QRect' => 'qt_QRect*',
'QRect*' => 'qt_QRect*',
'QRegExp&' => 'qt_QRegExp*',
'QRegExp*' => 'qt_QRegExp*',
'QRegExpValidator*' => 'qt_QRegExpValidator*',
'QRegion&' => 'qt_QRegion *',
'QRegion' => 'qt_QRegion *',
'QRegion*' => 'qt_QRegion*',
'QRegionData*' => 'qt_QRegionData*',
'QRemoteFactory*' => 'qt_QRemoteFactory*',
'QRemotePlugin*' => 'qt_QRemotePlugin*',
'QResizeEvent*'  => 'qt_QResizeEvent*' ,
'QRgb' => 'unsigned int',
'QRgb*' => 'int *',
'QRichText&'  =>  'qt_QRichText*' ,
'QSGIStyle*' => 'qt_QSGIStyle*',
'QScrollBar&'  =>  'qt_QScrollBar*' ,
'QScrollBar*'  =>  'qt_QScrollBar*' ,
'QScrollView*' => 'qt_QScrollView*',
'QSemaphore*' => 'qt_QSemaphore*',
'QSemiModal*' => 'qt_QSemiModal*',
'QSenderObject*' => 'qt_QSenderObject*',
'QServerSocket*' => 'qt_QServerSocket*',
'QSessionManager&'  =>  'qt_QSessionManager*' ,
'QSessionManager*' => 'qt_QSessionManager*',
'QSettings*' => 'qt_QSettings*',
'QShared*' => 'qt_QShared*',
'QShowEvent*'  =>  'qt_QShowEvent*' ,
'QSignal*' => 'qt_QSignal *',
'QSignalDict&'  => 'qt_QSignalDict*' ,
'QSignalDict*' => 'qt_QSignalDict*',
'QSignalDictIt&'  => 'qt_QSignalDictIt*' ,
'QSignalDictIt*' => 'qt_QSignalDictIt*',
'QSignalMapper*' => 'qt_QSignalMapper*',
'QSignalVec&' => 'qt_QSignalVec*',
'QSignalVec*' => 'qt_QSignalVec*',
'QSimpleRichText*' => 'qt_QSimpleRichText*',
'QSize&' => 'qt_QSize *',
'QSize' => 'qt_QSize *',
'QSize*'  => 'qt_QSize*' ,
'QSizeGrip*' => 'qt_QSizeGrip*',
'QSizePolicy&'  =>  'qt_QSizePolicy*' ,
'QSizePolicy'  =>  'qt_QSizePolicy*' ,
'QSizePolicy*' => 'qt_QSizePolicy*',
'QSizePolicy::ExpandData'  =>  'int' ,
'QSizePolicy::SizeTypehData::Minimum'  =>  'int' ,
'QSizePolicy::SizeTypevData::Minimum'  =>  'int' ,
'QSjisCodec*' => 'qt_QSjisCodec*',
'QSlider*' => 'qt_QSlider*',
'QSmartPtr&'  =>  'qt_QSmartPtr*' ,
'QSmartPtr*' => 'qt_QSmartPtr*',
'QSmartPtrPrivate*' => 'qt_QSmartPtrPrivate*',
'QSocket*' => 'qt_QSocket*',
'QSocketDevice*'  =>  'qt_QSocketDevice*' ,
'QSocketNotifier*' => 'qt_QSocketNotifier*',
'QSocketNotifier::Type' => 'int',
'QSortedList*' => 'qt_QSortedList*',
'QSound*' => 'qt_QSound*',
'QSpacerItem*'  =>  'qt_QSpacerItem*' ,
'QSpinBox*' => 'qt_QSpinBox*',
'QSpinWidget*' => 'qt_QSpinWidget*',
'QSplitter*' => 'qt_QSplitter*',
'QSql*' => 'qt_QSql*',
'QSql::Confirm' => 'int',
'QSql::Op' => 'int',
'QSqlCursor&' => 'qt_QSqlCursor*',
'QSqlCursor' => 'qt_QSqlCursor*',
'QSqlCursor*' => 'qt_QSqlCursor*',
'QSqlDatabase*' => 'qt_QSqlDatabase*',
'QSqlDriver*' => 'qt_QSqlDriver*',
'QSqlDriverCreator*' => 'qt_QSqlDriverCreator*',
'QSqlDriverCreatorBase*' => 'qt_QSqlDriverCreatorBase*',
'QSqlDriverFactoryInterface*' => 'qt_QSqlDriverFactoryInterface*',
'QSqlDriverPlugin*' => 'qt_QSqlDriverPlugin*',
'QSqlEditorFactory*' => 'qt_QSqlEditorFactory*',
'QSqlError&' => 'qt_QSqlError*',
'QSqlError' => 'qt_QSqlError*',
'QSqlError*' => 'qt_QSqlError*',
'QSqlField&' => 'qt_QSqlField*',
'QSqlField' => 'qt_QSqlField*',
'QSqlField*' => 'qt_QSqlField*',
'QSqlFieldInfo&' => 'qt_QSqlFieldInfo*',
'QSqlFieldInfo*' => 'qt_QSqlFieldInfo*',
'QSqlForm' => 'qt_QSqlForm*',
'QSqlForm*' => 'qt_QSqlForm*',
'QSqlIndex&' => 'qt_QSqlIndex*',
'QSqlIndex' => 'qt_QSqlIndex*',
'QSqlIndex*' => 'qt_QSqlIndex*',
'QSqlPropertyMap*' => 'qt_QSqlPropertyMap*',
'QSqlQuery&' => 'qt_QSqlQuery*',
'QSqlQuery' => 'qt_QSqlQuery*',
'QSqlQuery*' => 'qt_QSqlQuery*',
'QSqlRecord&' => 'qt_QSqlRecord*',
'QSqlRecord' => 'qt_QSqlRecord*',
'QSqlRecord*' => 'qt_QSqlRecord*',
'QSqlRecordInfo&' => 'qt_QSqlRecordInfo*',
'QSqlRecordInfo' => 'qt_QSqlRecordInfo*',
'QSqlRecordInfo*' => 'qt_QSqlRecordInfo*',
'QSqlRecordPrivate*' => 'qt_QSqlRecordPrivate*',
'QSqlRecordShared*' => 'qt_QSqlRecordShared*',
'QSqlResult' => 'qt_QSqlResult*',
'QSqlResult*' => 'qt_QSqlResult*',
'QSqlResultShared*' => 'qt_QSqlResultShared*',
'QStack*' => 'qt_QStack*',
'QStatusBar*'  => 'qt_QStatusBar*' ,
'QStoredDrag*' => 'qt_QStoredDrag*',
'QStrIList' => 'kde_QStrIList',
'QStrIList*' => 'qt_QStrIList*',
'QStrIVec*' => 'qt_QStrIVec*',
'QStrList&' => 'qt_QStrList *',
'QStrList' => 'qt_QStrList *',
'QStrList*' => 'qt_QStrList *',
'QStrListIterator*' => 'qt_QStrListIterator*',
'QStrVec*' => 'qt_QStrVec*',
'QString&' => 'qt_QString *',
'QString&::null'  =>  'qt_QString*' ,
'QString&button0Text::null'  =>  'qt_QString*' ,
'QString&button1Text::null'  =>  'qt_QString*' ,
'QString&button2Text::null'  =>  'qt_QString*' ,
'QString&buttonText::null'  =>  'qt_QString*' ,
'QString&caption::null'  =>  'qt_QString*' ,
'QString&charSet::null'  =>  'qt_QString*' ,
'QString&context::null'  =>  'qt_QString*' ,
'QString&defValue::null'  =>  'qt_QString*' ,
'QString&dir::null'  =>  'qt_QString*' ,
'QString&directory::null'  =>  'qt_QString*' ,
'QString&filter::null'  =>  'qt_QString*' ,
'QString&initially::null'  =>  'qt_QString*' ,
'QString&location::null'  =>  'qt_QString*' ,
'QString&n::null'  =>  'qt_QString*' ,
'QString&nameFilter::null'  =>  'qt_QString*' ,
'QString&noButtonText::null'  =>  'qt_QString*' ,
'QString&search_delimiters::null'  =>  'qt_QString*' ,
'QString&style::null'  =>  'qt_QString*' ,
'QString&suffix::null'  =>  'qt_QString*' ,
'QString&text::null'  =>  'qt_QString*' ,
'QString&text_::null'  =>  'qt_QString*' ,
'QString&translation::null'  =>  'qt_QString*' ,
'QString&yesButtonText::null'  =>  'qt_QString*' ,
'QString' => 'qt_QString *',
'QString*'  => 'qt_QString*' ,
'QString::null'  =>  'qt_QString_null()' ,
'QStringBucket*' => 'qt_QStringBucket*',
'QStringData*' => 'qt_QStringData*',
'QStringList&'  =>  'qt_QStringList*' ,
'QStringList'  =>  'qt_QStringList*' ,
'QStringList*'  => 'qt_QStringList*' ,
'QStringcharSetName::null'  =>  'qt_QStringcharSetName*' ,
'QStyle&'  =>  'qt_QStyle*' ,
'QStyle*'  =>  'qt_QStyle*' ,
'QStyle::ScrollControl'  => 'int' ,
'QStyle::StylePixmap' => 'int',
'QStyle::SubControl' => 'int',
'QStyle::SubRect' => 'int',
'QStyleFactory*' => 'qt_QStyleFactory*',
'QStyleFactoryInterface*' => 'qt_QStyleFactoryInterface*',
'QStyleHintReturn*' => 'qt_QStyleHintReturn*',
'QStyleOption&' => 'int',
'QStyleOption' => 'int',
'QStyleOption*' => 'int*',
'QStylePlugin*' => 'qt_QStylePlugin*',
'QStyleSheet*'  =>  'qt_QStyleSheet*' ,
'QStyleSheetItem&'  =>  'qt_QStyleSheetItem*' ,
'QStyleSheetItem*'  =>  'qt_QStyleSheetItem*' ,
'QStyleSheetItem::DisplayMode*' => 'int',
'QStyleSheetItem::ListStyle*' => 'int',
'QStyleSheetItem::WhiteSpaceMode' => 'int',
'QTLWExtra*'  =>  'qt_QTLWExtra*' ,
'QTSCIICodec*' => 'qt_QTSCIICodec*',
'QTSMFI'  =>  'int' ,
'QTSManip*' => 'qt_QTSManip*',
'QTab*' => 'qt_QTab*',
'QTabBar*'  =>  'qt_QTabBar*' ,
'QTabBar::Shape'  => 'int' ,
'QTabDialog*' => 'qt_QTabDialog*',
'QTabWidget*' => 'qt_QTabWidget*',
'QTable*'  =>  'qt_QTable*' ,
'QTableHeader*' => 'qt_QTableHeader*',
'QTableItem*'  =>  'qt_QTableItem*' ,
'QTableSelection&'  =>  'qt_QTableSelection*' ,
'QTableSelection'  =>  'qt_QTableSelection*' ,
'QTableSelection*' => 'qt_QTableSelection*',
'QTableView*' => 'qt_QTableView*',
'QTabletEvent*' => 'qt_QTabletEvent*',
'QTextBrowser*' => 'qt_QTextBrowser*',
'QTextCodec*'  =>  'qt_QTextCodec*' ,
'QTextCodecFactory*' => 'qt_QTextCodecFactory*',
'QTextCodecFactoryInterface*' => 'qt_QTextCodecFactoryInterface*',
'QTextCodecPlugin*' => 'qt_QTextCodecPlugin*',
'QTextCursor*' => 'qt_QTextCursor*',
'QTextDecoder*'  =>  'qt_QTextDecoder*' ,
'QTextDocument*' => 'qt_QTextDocument*',
'QTextDrag*' => 'qt_QTextDrag*',
'QTextEdit*' => 'qt_QTextEdit*',
'QTextEncoder*'  =>  'qt_QTextEncoder*' ,
'QTextFormat*' => 'qt_QTextFormat*',
'QTextIStream*' => 'qt_QTextIStream*',
'QTextOStream&'  =>  'qt_QTextOStream*' ,
'QTextOStream*' => 'qt_QTextOStream*',
'QTextOStreamIterator*' => 'qt_QTextOStreamIterator*',
'QTextParag**' => 'qt_QTextParag**',
'QTextStream&'  => 'qt_QTextStream*' ,
'QTextStream*'  => 'qt_QTextStream*' ,
'QTextView*' => 'qt_QTextView*',
'QThread*' => 'qt_QThread*',
'QThreadData*' => 'qt_QThreadData*',
'QThreadEvent*' => 'qt_QThreadEvent*',
'QTime&' => 'qt_QTime *',
'QTime' => 'qt_QTime *',
'QTime*' => 'qt_QTime*',
'QTimeEdit*' => 'qt_QTimeEdit*',
'QTimeWatch*' => 'qt_QTimeWatch*',
'QTimer*' => 'qt_QTimer*',
'QTimerEvent*'  => 'qt_QTimerEvent*' ,
'QToolBar*'  => 'qt_QToolBar*' ,
'QToolButton*'  =>  'qt_QToolButton*' ,
'QToolTip*' => 'qt_QToolTip*',
'QToolTipGroup*' => 'qt_QToolTipGroup *',
'QTranslator*'  =>  'qt_QTranslator*' ,
'QTranslatorMessage&'  =>  'qt_QTranslatorMessage*' ,
'QTranslatorMessage'  =>  'qt_QTranslatorMessage*' ,
'QTranslatorMessage*' => 'qt_QTranslatorMessage*',
'QTsciiCodec*' => 'qt_QTsciiCodec*',
'QUObject*' => 'qt_QUObject*',
'QUnknownInterface*' => 'qt_QUnknownInterface*',
'QUnknownInterface**' => 'qt_QUnknownInterface**',
'QUriDrag*' => 'qt_QUriDrag*',
'QUrl&'  =>  'qt_QUrl*' ,
'QUrl'  =>  'qt_QUrl*' ,
'QUrl*' => 'qt_QUrl*',
'QUrlInfo&'  =>  'qt_QUrlInfo*' ,
'QUrlInfo'  =>  'qt_QUrlInfo*' ,
'QUrlInfo*' => 'qt_QUrlInfo*',
'QUrlOperator&'  =>  'qt_QUrlOperator*' ,
'QUrlOperator*'  =>  'qt_QUrlOperator*' ,
'QUtf16Codec*' => 'qt_QUtf16Codec*',
'QUtf8Codec*' => 'qt_QUtf8Codec*',
'QUuid&' => 'qt_QUuid*',
'QUuid*' => 'qt_QUuid*',
'QVBox*'  => 'qt_QVBox*' ,
'QVBoxLayout*' => 'qt_QVBoxLayout*',
'QVButtonGroup*' => 'qt_QVButtonGroup*',
'QVFbHeader*' => 'qt_QVFbHeader*',
'QVFbKeyData*' => 'qt_QVFbKeyData*',
'QVGroupBox*' => 'qt_QVGroupBox*',
'QValidator*' => 'qt_QValidator *',
'QValidator::State' => 'int',
'QValueList*' => 'qt_QValueList*',
'QValueListConstIterator*' => 'qt_QValueListConstIterator*',
'QValueListIterator*' => 'qt_QValueListIterator*',
'QValueListNode*' => 'qt_QValueListNode*',
'QValueListPrivate*' => 'qt_QValueListPrivate*',
'QValueStack*' => 'qt_QValueStack*',
'QValueVector*' => 'qt_QValueVector*',
'QValueVectorPrivate*' => 'qt_QValueVectorPrivate*',
'QVariant&' => 'qt_QVariant *',
'QVariant' => 'qt_QVariant *',
'QVariant*' => 'qt_QVariant*',
'QVariant::Type'  => 'int' ,
'QVariantPrivate*'  =>  'qt_QVariantPrivate*' ,
'QVector*' => 'qt_QVector*',
'QWExtra*'  =>  'qt_QWExtra*' ,
'QWMatrix&' => 'qt_QWMatrix *',
'QWMatrix' => 'qt_QWMatrix *',
'QWMatrix*' => 'qt_QWMatrix*',
'QWSDecoration&'  =>  'qt_QWSDecoration*' ,
'QWSDecoration*'  =>  'qt_QWSDecoration*' ,
'QWSDisplay*'  =>  'qt_QWSDisplay*' ,
'QWSEvent*'  =>  'qt_QWSEvent*' ,
'QWaitCondition*' => 'qt_QWaitCondition*',
'QWhatsThis*' => 'qt_QWhatsThis*',
'QWheelEvent*'  =>  'qt_QWheelEvent*' ,
'QWidget *' => 'qt_QWidget *',
'QWidget' => 'qt_QWidget *',
'QWidget*' => 'qt_QWidget *',
'QWidgetFactory*' => 'qt_QWidgetFactory*',
'QWidgetIntDict&'  => 'qt_QWidgetIntDict*' ,
'QWidgetIntDict*' => 'qt_QWidgetIntDict*',
'QWidgetIntDictIt&'  => 'qt_QWidgetIntDictIt*' ,
'QWidgetIntDictIt*' => 'qt_QWidgetIntDictIt*',
'QWidgetItem*' => 'qt_QWidgetItem*',
'QWidgetList&'  => 'qt_QWidgetList *' ,
'QWidgetList&'  => 'qt_QWidgetList*' ,
'QWidgetList'  =>  'qt_QWidgetList *' ,
'QWidgetList'  =>  'qt_QWidgetList*' ,
'QWidgetList*' => 'qt_QWidgetList *',
'QWidgetList*' => 'qt_QWidgetList*',
'QWidgetListIt&'  => 'qt_QWidgetListIt*' ,
'QWidgetListIt*' => 'qt_QWidgetListIt*',
'QWidgetMapper*' => 'qt_QWidgetMapper*',
'QWidgetPlugin*' => 'qt_QWidgetPlugin*',
'QWidgetStack*' => 'qt_QWidgetStack*',
'QWindowsMime*'  =>  'qt_QWindowsMime*' ,
'QWindowsStyle*' => 'qt_QWindowsStyle*',
'QWizard*' => 'qt_QWizard*',
'QWorkspace*' => 'qt_QWorkspace*',
'QXEmbed*'  =>  'qt_QXEmbed*' ,
'QXmlAttributes&'  =>  'qt_QXmlAttributes*' ,
'QXmlAttributes*' => 'qt_QXmlAttributes*',
'QXmlContentHandler*'  =>  'qt_QXmlContentHandler*' ,
'QXmlDTDHandler*'  =>  'qt_QXmlDTDHandler*' ,
'QXmlDeclHandler*'  =>  'qt_QXmlDeclHandler*' ,
'QXmlDefaultHandler*' => 'qt_QXmlDefaultHandler*',
'QXmlEntityResolver*'  =>  'qt_QXmlEntityResolver*' ,
'QXmlErrorHandler*'  =>  'qt_QXmlErrorHandler*' ,
'QXmlInputSource&'  =>  'qt_QXmlInputSource*' ,
'QXmlInputSource*&' => 'qt_QXmlInputSource*',
'QXmlInputSource*'  =>  'qt_QXmlInputSource*' ,
'QXmlLexicalHandler*'  =>  'qt_QXmlLexicalHandler*' ,
'QXmlLocator*'  =>  'qt_QXmlLocator*' ,
'QXmlNamespaceSupport*' => 'qt_QXmlNamespaceSupport*',
'QXmlParseException&'  =>  'qt_QXmlParseException*' ,
'QXmlParseException*' => 'qt_QXmlParseException*',
'QXmlReader*' => 'qt_QXmlReader*',
'QXmlSimpleReader*'  =>  'qt_QXmlSimpleReader*' ,
'QXtApplication*' => 'qt_QXtApplication*',
'QXtWidget*' => 'qt_QXtWidget*',
'Q_INT16&' => 'short',
'Q_INT16' => 'short',
'Q_INT32&' => 'int',
'Q_INT32' => 'int',
'Q_INT8&' => 'char',
'Q_INT8' => 'char',
'Q_LONG&' => 'long',
'Q_LONG' => 'long',
'Q_PACKED*' => 'void*',
'Q_UINT16&' => 'unsigned short',
'Q_UINT16' => 'unsigned short',
'Q_UINT32&' => 'unsigned int',
'Q_UINT32' => 'unsigned int',
'Q_UINT8&' => 'unsigned char',
'Q_UINT8' => 'unsigned char',
'Q_UINT8*'  =>  'unsigned char*' ,
'Q_ULONG&' => 'long',
'Q_ULONG' => 'long',
'Qt*'  =>  'qt_Qt*' ,
'Qt::ArrowType'  =>  'int' ,
'Qt::BackgroundMode' => 'int',
'Qt::DateFormat' => 'int',
'Qt::GUIStyle'  => 'int' ,
'Qt::GUIStylecolorStyle::WindowsStyle'  => 'int' ,
'Qt::GUIStylestyle::WindowsStyle'  => 'int' ,
'Qt::Orientation'  =>  'int' ,
'Qt::RasterOp'  =>  'int' ,
'Qt::UIEffect'  =>  'int' ,
'Qt::WFlags'  =>  'int' ,
'QtMultiLineEdit*' => 'qt_QtMultiLineEdit*',
'QtMultiLineEditRow*' => 'qt_QtMultiLineEditRow*',
'QtTableView*' => 'qt_QtTableView*',
'QwAbsSpriteFieldView*'  =>  'qt_QwAbsSpriteFieldView*' ,
'QwClusterizer*'  =>  'qt_QwClusterizer*' ,
'QwEllipse*' => 'qt_QwEllipse*',
'QwImageSpriteField*' => 'qt_QwImageSpriteField*',
'QwMobilePositionedSprite*' => 'qt_QwMobilePositionedSprite*',
'QwMobileSprite*' => 'qt_QwMobileSprite*',
'QwPolygon*' => 'qt_QwPolygon*',
'QwPolygonalGraphic*' => 'qt_QwPolygonalGraphic*',
'QwPositionedSprite*' => 'qt_QwPositionedSprite*',
'QwPublicList*'  =>  'qt_QwPublicList*' ,
'QwRealMobileSprite*' => 'qt_QwRealMobileSprite*',
'QwRealSprite*' => 'qt_QwRealSprite*',
'QwRectangle*' => 'qt_QwRectangle*',
'QwScrollingSpriteFieldView*' => 'qt_QwScrollingSpriteFieldView*',
'QwSprite*' => 'qt_QwSprite*',
'QwSpriteField*'  =>  'qt_QwSpriteField*' ,
'QwSpriteField*'  => 'qt_QwSpriteField*' ,
'QwSpriteFieldGraphic&'  => 'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldGraphic*'  =>  'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldView*' => 'qt_QwSpriteFieldView*',
'QwSpritePixmap*'  =>  'qt_QwSpritePixmap*' ,
'QwSpritePixmapSequence*'  => 'qt_QwSpritePixmapSequence*' ,
'QwTextSprite*' => 'qt_QwTextSprite*',
'QwTiledSpriteField*' => 'qt_QwTiledSpriteField*',
'QwVirtualSprite*' => 'qt_QwVirtualSprite*',
'RArray*' => 'kde_RArray*',
'RGBColor&' => 'kde_RGBColor*',
'RGBColor' => 'kde_RGBColor*',
'RGBColor*' => 'kde_RGBColor*',
'Range&' => 'kde_Range*',
'Range' => 'kde_Range*',
'Range*' => 'kde_Range*',
'RangeException&' => 'kde_RangeException*',
'RangeException*' => 'kde_RangeException*',
'RangeImpl*' => 'kde_RangeImpl*',
'RasterOp' => 'int',
'RawDataPacket*' => 'kde_RawDataPacket*',
'ReadOnlyPart*' => 'kde_ReadOnlyPart*',
'ReadWritePart*' => 'kde_ReadWritePart*',
'Rect&' => 'kde_Rect*',
'Rect' => 'kde_Rect*',
'Rect*' => 'kde_Rect*',
'Reference&' => 'kde_Reference*',
'Reference*' => 'kde_Reference*',
'ReferenceClean*' => 'kde_ReferenceClean*',
'ReferenceHelper*' => 'kde_ReferenceHelper*',
'Region' => 'int',
'RegionType' => 'int',
'RemoteScheduleNode*' => 'kde_RemoteScheduleNode*',
'RenameDlg*' => 'kde_RenameDlg*',
'RenderStyle*'  =>  'kde_RenderStyle*' ,
'Rep*' => 'kde_Rep*',
'RunMode'  =>  'int' ,
'SButton*' => 'kde_SButton*',
'SCFlags' => 'int',
'SFlags' => 'int',
'ScheduleNode*' => 'kde_ScheduleNode*',
'Scheduler*' => 'kde_Scheduler*',
'ScrollBarMode' => 'int',
'ScrollControl'  =>  'int' ,
'SearchInterface*' => 'kde_SearchInterface*',
'Section&'  =>  'kde_Section*' ,
'Section*&'  =>  'kde_Section*' ,
'Section*'  =>  'kde_Section*' ,
'SegmentStyle' => 'int',
'SelectionInterface*' => 'kde_SelectionInterface*',
'Separator' => 'int',
'Server&'  =>  'Server*' ,
'Server*' => 'kde_Server*',
'ServerHello&' => 'kde_ServerHello*',
'ServerHello*' => 'kde_ServerHello*',
'Service*' => 'kde_Service*',
'SessionData*' => 'kde_SessionData*',
'SimpleFormat*' => 'kde_SimpleFormat*',
'SimpleJob*' => 'kde_SimpleJob*',
'SimpleSoundServer&' => 'kde_SimpleSoundServer*',
'SimpleSoundServer' => 'kde_SimpleSoundServer*',
'SimpleSoundServer*' => 'kde_SimpleSoundServer*',
'SimpleSoundServer_base*' => 'kde_SimpleSoundServer_base*',
'SimpleSoundServer_skel*' => 'kde_SimpleSoundServer_skel*',
'SimpleSoundServer_stub*' => 'kde_SimpleSoundServer_stub*',
'SkipDlg*' => 'kde_SkipDlg*',
'Slave*' => 'kde_Slave*',
'SlaveBase*' => 'kde_SlaveBase*',
'SlaveBasePrivate*' => 'kde_SlaveBasePrivate*',
'SlaveConfig*' => 'kde_SlaveConfig*',
'SlaveInterface*' => 'kde_SlaveInterface*',
'SocketConnection*' => 'kde_SocketConnection*',
'Spec' => 'int',
'SpecialEvent*' => 'kde_SpecialEvent*',
'SshProcess*' => 'kde_SshProcess*',
'SshProcessPrivate*' => 'kde_SshProcessPrivate*',
'StartupClass*' => 'kde_StartupClass*',
'StartupManager*' => 'kde_StartupManager*',
'StatJob*' => 'kde_StatJob*',
'State' => 'int',
'StatusbarProgress*' => 'kde_StatusbarProgress*',
'StdAddressBook*' => 'kde_StdAddressBook*',
'StdFlowSystem*' => 'kde_StdFlowSystem*',
'StdIOManager*' => 'kde_StdIOManager*',
'StdScheduleNode*' => 'kde_StdScheduleNode*',
'StdSynthModule*' => 'kde_StdSynthModule*',
'StereoEffect&' => 'kde_StereoEffect*',
'StereoEffect' => 'kde_StereoEffect*',
'StereoEffect*' => 'kde_StereoEffect*',
'StereoEffectStack&' => 'kde_StereoEffectStack*',
'StereoEffectStack' => 'kde_StereoEffectStack*',
'StereoEffectStack*' => 'kde_StereoEffectStack*',
'StereoEffectStack_base*' => 'kde_StereoEffectStack_base*',
'StereoEffectStack_skel*' => 'kde_StereoEffectStack_skel*',
'StereoEffectStack_stub*' => 'kde_StereoEffectStack_stub*',
'StereoEffect_base*' => 'kde_StereoEffect_base*',
'StereoEffect_skel*' => 'kde_StereoEffect_skel*',
'StereoEffect_stub*' => 'kde_StereoEffect_stub*',
'StereoFFTScope&' => 'kde_StereoFFTScope*',
'StereoFFTScope' => 'kde_StereoFFTScope*',
'StereoFFTScope*' => 'kde_StereoFFTScope*',
'StereoFFTScope_base*' => 'kde_StereoFFTScope_base*',
'StereoFFTScope_skel*' => 'kde_StereoFFTScope_skel*',
'StereoFFTScope_stub*' => 'kde_StereoFFTScope_stub*',
'StereoVolumeControl&' => 'kde_StereoVolumeControl*',
'StereoVolumeControl' => 'kde_StereoVolumeControl*',
'StereoVolumeControl*' => 'kde_StereoVolumeControl*',
'StereoVolumeControl_base*' => 'kde_StereoVolumeControl_base*',
'StereoVolumeControl_skel*' => 'kde_StereoVolumeControl_skel*',
'StereoVolumeControl_stub*' => 'kde_StereoVolumeControl_stub*',
'StreamMode&' => 'int',
'String*' => 'kde_String*',
'StringSectionMap::iterator&'  =>  'kde_StringSectionMap*' ,
'StringSectionMap::iterator'  =>  'kde_StringSectionMap*r' ,
'StubProcess*' => 'kde_StubProcess*',
'StyleHint' => 'int',
'StyleListImpl*' => 'kde_StyleListImpl*',
'StylePixmap' => 'int',
'StyleSheet&' => 'kde_StyleSheet*',
'StyleSheet' => 'kde_StyleSheet*',
'StyleSheet*' => 'kde_StyleSheet*',
'StyleSheetImpl*' => 'kde_StyleSheetImpl*',
'StyleSheetList&' => 'kde_StyleSheetList*',
'StyleSheetList' => 'kde_StyleSheetList',
'StyleSheetList*' => 'kde_StyleSheetList*',
'StyleSheetListImpl*' => 'kde_StyleSheetListImpl*',
'StyleStrategy' => 'int',
'SuProcess*' => 'kde_SuProcess*',
'SubClass&' => 'kde_SubClass*',
'SubClass*' => 'kde_SubClass*',
'SubControl' => 'int',
'SubRect' => 'int',
'SynthBuffer*' => 'kde_SynthBuffer*',
'SynthModule&' => 'kde_SynthModule*',
'SynthModule' => 'kde_SynthModule*',
'SynthModule*' => 'kde_SynthModule*',
'SynthModule_base*' => 'kde_SynthModule_base*',
'SynthModule_skel*' => 'kde_SynthModule_skel*',
'SynthModule_stub*' => 'kde_SynthModule_stub*',
'SynthOut*' => 'kde_SynthOut*',
'Synth_ADD&' => 'kde_Synth_ADD*',
'Synth_ADD' => 'kde_Synth_ADD*',
'Synth_ADD*' => 'kde_Synth_ADD*',
'Synth_ADD_base*' => 'kde_Synth_ADD_base*',
'Synth_ADD_skel*' => 'kde_Synth_ADD_skel*',
'Synth_ADD_stub*' => 'kde_Synth_ADD_stub*',
'Synth_AMAN_PLAY&' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY*' => 'kde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY_base*' => 'kde_Synth_AMAN_PLAY_base*',
'Synth_AMAN_PLAY_skel*' => 'kde_Synth_AMAN_PLAY_skel*',
'Synth_AMAN_PLAY_stub*' => 'kde_Synth_AMAN_PLAY_stub*',
'Synth_AMAN_RECORD&' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD*' => 'kde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD_base*' => 'kde_Synth_AMAN_RECORD_base*',
'Synth_AMAN_RECORD_skel*' => 'kde_Synth_AMAN_RECORD_skel*',
'Synth_AMAN_RECORD_stub*' => 'kde_Synth_AMAN_RECORD_stub*',
'Synth_BUS_DOWNLINK&' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK*' => 'kde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK_base*' => 'kde_Synth_BUS_DOWNLINK_base*',
'Synth_BUS_DOWNLINK_skel*' => 'kde_Synth_BUS_DOWNLINK_skel*',
'Synth_BUS_DOWNLINK_stub*' => 'kde_Synth_BUS_DOWNLINK_stub*',
'Synth_BUS_UPLINK&' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK*' => 'kde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK_base*' => 'kde_Synth_BUS_UPLINK_base*',
'Synth_BUS_UPLINK_skel*' => 'kde_Synth_BUS_UPLINK_skel*',
'Synth_BUS_UPLINK_stub*' => 'kde_Synth_BUS_UPLINK_stub*',
'Synth_FREQUENCY&' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY*' => 'kde_Synth_FREQUENCY*',
'Synth_FREQUENCY_base*' => 'kde_Synth_FREQUENCY_base*',
'Synth_FREQUENCY_skel*' => 'kde_Synth_FREQUENCY_skel*',
'Synth_FREQUENCY_stub*' => 'kde_Synth_FREQUENCY_stub*',
'Synth_MUL&' => 'kde_Synth_MUL*',
'Synth_MUL' => 'kde_Synth_MUL*',
'Synth_MUL*' => 'kde_Synth_MUL*',
'Synth_MULTI_ADD&' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD*' => 'kde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD_base*' => 'kde_Synth_MULTI_ADD_base*',
'Synth_MULTI_ADD_skel*' => 'kde_Synth_MULTI_ADD_skel*',
'Synth_MULTI_ADD_stub*' => 'kde_Synth_MULTI_ADD_stub*',
'Synth_MUL_base*' => 'kde_Synth_MUL_base*',
'Synth_MUL_skel*' => 'kde_Synth_MUL_skel*',
'Synth_MUL_stub*' => 'kde_Synth_MUL_stub*',
'Synth_PLAY&' => 'kde_Synth_PLAY*',
'Synth_PLAY' => 'kde_Synth_PLAY*',
'Synth_PLAY*' => 'kde_Synth_PLAY*',
'Synth_PLAY_WAV&' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV*' => 'kde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV_base*' => 'kde_Synth_PLAY_WAV_base*',
'Synth_PLAY_WAV_skel*' => 'kde_Synth_PLAY_WAV_skel*',
'Synth_PLAY_WAV_stub*' => 'kde_Synth_PLAY_WAV_stub*',
'Synth_PLAY_base*' => 'kde_Synth_PLAY_base*',
'Synth_PLAY_skel*' => 'kde_Synth_PLAY_skel*',
'Synth_PLAY_stub*' => 'kde_Synth_PLAY_stub*',
'Synth_RECORD&' => 'kde_Synth_RECORD*',
'Synth_RECORD' => 'kde_Synth_RECORD*',
'Synth_RECORD*' => 'kde_Synth_RECORD*',
'Synth_RECORD_base*' => 'kde_Synth_RECORD_base*',
'Synth_RECORD_skel*' => 'kde_Synth_RECORD_skel*',
'Synth_RECORD_stub*' => 'kde_Synth_RECORD_stub*',
'Synth_WAVE_SIN&' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN*' => 'kde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN_base*' => 'kde_Synth_WAVE_SIN_base*',
'Synth_WAVE_SIN_skel*' => 'kde_Synth_WAVE_SIN_skel*',
'Synth_WAVE_SIN_stub*' => 'kde_Synth_WAVE_SIN_stub*',
'T&'  =>  'T*' ,
'T'  =>  'T*' ,
'T*'  =>  'T*' ,
'TCPConnection*' => 'kde_TCPConnection*',
'TCPServer*' => 'kde_TCPServer*',
'TCPSlaveBase*' => 'kde_TCPSlaveBase*',
'TRUE' => '1',
'Task*' => 'kde_Task*',
'Text&' => 'kde_Text*',
'Text' => 'kde_Text*',
'Text*' => 'kde_Text*',
'TextFormat'  =>  'int' ,
'TextImpl*' => 'kde_TextImpl*',
'ThumbCreator*' => 'kde_ThumbCreator*',
'TickSetting' => 'int',
'Ticket*' => 'kde_Ticket*',
'TimeNotify*' => 'kde_TimeNotify*',
'TimeWatcher*' => 'kde_TimeWatcher*',
'TimeZone&' => 'kde_TimeZone*',
'TimeZone*' => 'kde_TimeZone*',
'TmpGlobalComm&' => 'kde_TmpGlobalComm*',
'TmpGlobalComm' => 'kde_TmpGlobalComm*',
'TmpGlobalComm*' => 'kde_TmpGlobalComm*',
'TmpGlobalComm_base*' => 'kde_TmpGlobalComm_base*',
'TmpGlobalComm_skel*' => 'kde_TmpGlobalComm_skel*',
'TmpGlobalComm_stub*' => 'kde_TmpGlobalComm_stub*',
'ToolBarDock&'  =>  'int' ,
'ToolBarDock' => 'int',
'TraderOffer&' => 'kde_TraderOffer*',
'TraderOffer' => 'kde_TraderOffer*',
'TraderOffer*' => 'kde_TraderOffer*',
'TraderOffer_base*' => 'kde_TraderOffer_base*',
'TraderOffer_skel*' => 'kde_TraderOffer_skel*',
'TraderOffer_stub*' => 'kde_TraderOffer_stub*',
'TraderQuery&' => 'kde_TraderQuery*',
'TraderQuery' => 'kde_TraderQuery*',
'TraderQuery*' => 'kde_TraderQuery*',
'TraderQuery_base*' => 'kde_TraderQuery_base*',
'TraderQuery_skel*' => 'kde_TraderQuery_skel*',
'TraderQuery_stub*' => 'kde_TraderQuery_stub*',
'TransferJob*' => 'kde_TransferJob*',
'TreeWalker&' => 'kde_TreeWalker*',
'TreeWalker' => 'kde_TreeWalker*',
'TreeWalker*' => 'kde_TreeWalker*',
'TreeWalkerImpl*' => 'kde_TreeWalkerImpl*',
'True' => '1',
'Type&' => 'kde_Type*',
'Type' => 'int',
'Type*' => 'kde_Type*',
'TypeComponent&' => 'kde_TypeComponent*',
'TypeComponent*' => 'kde_TypeComponent*',
'TypeDef&' => 'kde_TypeDef*',
'TypeDef' => 'kde_TypeDef*',
'TypeDef*' => 'kde_TypeDef*',
'TypeEntry*' => 'kde_TypeEntry*',
'TypeInfo*' => 'kde_TypeInfo*',
'UChar&' => 'kde_UChar*',
'UChar' => 'kde_UChar*',
'UChar*' => 'kde_UChar*',
'UCharReference&' => 'kde_UCharReference*',
'UCharReference' => 'kde_UCharReference*',
'UCharReference*' => 'kde_UCharReference*',
'UDSAtom*' => 'kde_UDSAtom*',
'UDSEntry&' => 'kde_UDSEntry*',
'UDSEntryList&' => 'kde_UDSEntryList*',
'UIServer*' => 'kde_UIServer*',
'UIServer_stub*' => 'kde_UIServer_stub*',
'ULONG_MAX' => 'ULONG_MAX',
'URLArgs&' => 'kde_URLArgs*',
'URLArgs' => 'kde_URLArgs*',
'URLArgs*' => 'kde_URLArgs*',
'UString&' => 'kde_UString*',
'UString' => 'kde_UString*',
'UString*' => 'kde_UString*',
'Undefined*' => 'kde_Undefined*',
'UndoInterface*' => 'kde_UndoInterface*',
'UndoRedoInfo*' => 'int*',
'UnixConnection*' => 'kde_UnixConnection*',
'UnixServer*' => 'kde_UnixServer*',
'VCardFormat*' => 'kde_VCardFormat*',
'VPort*' => 'kde_VPort*',
'Value&' => 'kde_Value*',
'Value' => 'kde_Value*',
'Value*' => 'kde_Value*',
'VerticalAlignment*' => 'int*',
'View*'  =>  'kde_View*' ,
'ViewCursorInterface*' => 'kde_ViewCursorInterface*',
'VoiceManager*' => 'kde_VoiceManager*',
'WFlags' => 'int',
'WId' => 'unsigned int',
'WState' => 'int',
'WavPlayObject&' => 'kde_WavPlayObject*',
'WavPlayObject' => 'kde_WavPlayObject*',
'WavPlayObject*' => 'kde_WavPlayObject*',
'WavPlayObject_base*' => 'kde_WavPlayObject_base*',
'WavPlayObject_skel*' => 'kde_WavPlayObject_skel*',
'WavPlayObject_stub*' => 'kde_WavPlayObject_stub*',
'WeakReference*' => 'kde_WeakReference*',
'WeakReferenceBase*' => 'kde_WeakReferenceBase*',
'Widget'  =>  'int' ,
'WidgetClass'  =>  'int' ,
'WidthMode' => 'int',
'Window' => 'kde_Window*',
'Window*' => 'kde_Window*',
'WindowArgs&' => 'kde_WindowArgs*',
'WindowArgs*' => 'kde_WindowArgs*',
'WindowsVersion'  =>  'int' ,
'XEvent *' => 'XEvent *',
'XEvent*' => 'XEvent*',
'XrmOptionDescRec*'  =>  'XrmOptionDescRec*' ,
'array_data*'  =>  'void*' ,
'bitarr_data*' => 'void*',
'bool&'  =>  'int' ,
'bool' => 'int',
'bool*' => 'int*',
'char *' => 'char *',
'char&'  =>  'char' ,
'char' => 'char',
'char* bugsEmailAddress @bugs.kde.org"' => 'String',
'char*&' => 'char*',
'char*' => 'char*',
'char**' => 'char**',
'char*xpm[]'  =>  'char**' ,
'classConnection*' => 'kde_classConnection*',
'classDeviceManager*' => 'kde_classDeviceManager*',
'classExtensionLoader*' => 'kde_classExtensionLoader*',
'classMidiStatus*' => 'kde_classMidiStatus*',
'classObjectReference' => 'kde_classObjectReference*',
'classQPainter*' => 'kde_classQPainter*',
'classStartupClass*' => 'kde_classStartupClass*',
'double d .0' => 'double',
'double nDefault .0' => 'double',
'double pri .0' => 'double',
'double&'  =>  'double' ,
'double' => 'double',
'double*'  =>  'double*' ,
'false' => '0',
'float desat .3' => 'float',
'float&'  =>  'float' ,
'float' => 'float',
'float*' => 'float*',
'image_io_handler'  =>  'int' ,
'int a  |' => 'int',
'int buttonMask|Apply|Cancel' => 'int',
'int buttonMask|No|Cancel' => 'int',
'int desktop' => 'int',
'int&' => 'int',
'int' => 'int',
'int*' => 'int*',
'kdbgstream&'  => 'kde_Kdbgstream*' ,
'kdbgstream*'  =>  'kde_kdbgstream*',
'khtml*'  =>  'kde_khtml*',
'khtml::ChildFrame*'  => 'kde_khtml_ChildFrame*' ,
'khtml::DrawContentsEvent*'  => 'kde_khtml_DrawContentsEvent*' ,
'khtml::MouseDoubleClickEvent*'  => 'kde_khtml_MouseDoubleClickEvent*' ,
'khtml::MouseMoveEvent*'  => 'kde_khtml_MouseMoveEvent*' ,
'khtml::MousePressEvent*'  => 'kde_khtml_MousePressEvent*' ,
'khtml::MouseReleaseEvent*'  => 'kde_khtml_MouseReleaseEvent*' ,
'khtml::RenderObject*'  => 'kde_khtml_RenderObject*' ,
'khtml::RenderStyle*'  => 'kde_khtml_RenderStyle*' ,
'khtml__DrawContentsEvent*'  =>  'kde_khtml__DrawContentsEvent*',
'khtml__MouseDoubleClickEvent*'  =>  'kde_khtml__MouseDoubleClickEvent*',
'khtml__MouseEvent*'  =>  'kde_khtml__MouseEvent*',
'khtml__MouseMoveEvent*'  =>  'kde_khtml__MouseMoveEvent*',
'khtml__MousePressEvent*'  =>  'kde_khtml__MousePressEvent*',
'khtml__MouseReleaseEvent*'  =>  'kde_khtml__MouseReleaseEvent*',
'kndbgstream&'  => 'void**' ,
'kndbgstream*'  =>  'kde_kndbgstream*',
'ksockaddr_in*'  => 'void*' ,
'long _blockSize *' => 'long *',
'long int' => 'long',
'long unsigned int' => 'long',
'long&'  =>  'long' ,
'long' => 'long',
'long_blockSize*'  =>  'long_blockSize*' ,
'long' => 'long',
'longunsigned int' => 'unsigned long',
'lt_dlhandle'  =>  'void *' ,
'lt_user_dlloader*'  =>  'kde_lt_user_dlloader*',
'mcopbyte&' => 'void *',
'mcopbyte' => 'unsigned char',
'mode_t _mode (mode_t) -1' => 'int',
'mode_t'  =>  'long' ,
'noteCmd' => 'kde_noteCmd*',
'noteCmd*' => 'kde_noteCmd*',
'ostream&' => 'int',
'ostream*' => 'int',
'pid_t'  =>  'long' ,
'poTime&' => 'kde_poTime*',
'poTime*' => 'kde_poTime*',
'short unsigned' => 'short',
'short' => 'short',
'short*' => 'short*',
'shortunsigned' => 'unsigned short',
'signed int&'  =>  'signed int' ,
'signed long&'  =>  'signed long' ,
'signed short&'  =>  'signed short' ,
'signed'  =>  'signed' ,
'size_t'  =>  'int' ,
'size_t*' => 'int*',
'size_type'  =>  'int' ,
'snd_seq_event_t*' => 'int*',
'ssize_t' => 'int',
'std*' => 'kde_std*',
'std::string&'  =>  'char *' ,
'std::string'  =>  'char *' ,
'time_t'  =>  'long' ,
'timeval&' => 'int',
'true' => '1',
'type&'  =>  'int' ,
'type*'  =>  'int*' ,
'type**'  =>  'int**' ,
'uchar&'  =>  'unsigned char' ,
'uchar'  =>  'unsigned char' ,
'uchar*' => 'unsigned char*',
'uchar**' => 'unsigned char**',
'uint&' => 'unsigned int',
'uint' => 'unsigned int',
'uint*'  =>  'unsigned int*' ,
'uintf~0'  =>  'unsigned int' ,
'ulong' => 'unsigned long',
'unsigned char&' => 'unsigned char',
'unsigned char'  =>  'unsigned char' ,
'unsigned char*'  =>  'unsigned char*' ,
'unsigned int&'  =>  'unsigned int' ,
'unsigned int'  =>  'unsigned int' ,
'unsigned int*'  =>  'int*' ,
'unsigned long int' => 'long',
'unsigned long&'  =>  'unsigned long' ,
'unsigned long'  =>  'unsigned long' ,
'unsigned short int'  =>  'unsigned short' ,
'unsigned short&'  =>  'unsigned short' ,
'unsigned short'  =>  'unsigned short' ,
'unsigned short*'  =>  'short*' ,
'unsigned shortint'  =>  'unsigned short' ,
'unsigned'  =>  'unsigned int' ,
'ushort' => 'unsigned short',
'ushort*'  =>  'short*' ,
'voice*' => 'int',
'void' => 'void',
'void(*)()'  =>  'void(*)()' ,
'void*' => 'void*',
'~' => '~',
'QValueList<int>' => 'qt_QIntValueList*',
'QValueList<int>&' => 'qt_QIntValueList*',
'QValueList<QIconDragItem>&' => 'qt_QIconDragItemValueList*',
'QValueList<QPixmap>' => 'qt_QPixmapValueList*',
'QValueList<QString>&' => 'qt_QStringValueList*',
'QValueList<QVariant>&' => 'qt_QVariantValueList*',
'QValueList<QUrlInfo>*' => 'qt_QUrlInfoValueList*',
'QValueList<KDataToolInfo>&' => 'kde_KDataToolInfoValueList*',
'QPtrList<KAction>&' => 'kde_KActionPtrList*',
'QPtrList<KSSLCertificate>&' => 'kde_KSSLCertificatePtrList*',
'QPtrList<KXMLGUIClient>*' => 'kde_KXMLGUIClientPtrList*',
'QPtrList<QDockWindow>*' => 'qt_QDockWindowPtrList*',
'QPtrList<QPixmap>' => 'qt_QPixmapPtrList*',
'QPtrList<QPoint>' => 'qt_QPointPtrList*',
'KService::Ptr&' => 'kde_KServicePtr*',
'ClassContext*' => 'kde_ClassContext*',
'ClassStoreIface*' => 'kde_ClassStoreIface*',
'ClipboardDocumentIface*' => 'kde_ClipboardDocumentIface*',
'CodeCompletionDocumentIface*' => 'kde_CodeCompletionDocumentIface*',
'CursorDocumentIface*' => 'kde_CursorDocumentIface*',
'DebugDocumentIface*' => 'kde_DebugDocumentIface*',
'DocumentInterface*' => 'kde_DocumentInterface*',
'EditDocumentIface*' => 'kde_EditDocumentIface*',
'EditorInterface*' => 'kde_EditorInterface*',
'FileContext*' => 'kde_FileContext*',
'KDevAppFrontendIface*' => 'kde_KDevAppFrontendIface*',
'KDevCoreIface*' => 'kde_KDevCoreIface*',
'KDevMakeFrontendIface*' => 'kde_KDevMakeFrontendIface*',
'KEditor*' => 'kde_KEditor*',
'KEditor::Document*' => 'kde_Document*',
'ParsedClassContainer&' => 'kde_ParsedClassContainer*',
'ParsedContainer&' => 'kde_ParsedContainer*',
'ParsedScopeContainer&' => 'kde_ParsedScopeContainer*',
'QValueList<ParsedMethod>*' => 'kde_ParsedMethodList*',
'QValueList<CompletionEntry>' => 'kde_CompletionEntryValueList*',
'StatusDocumentIface*' => 'kde_StatusDocumentIface*',
'UndoDocumentIface*' => 'kde_UndoDocumentIface*',
'KShortcut&' => 'kde_KShortcut*',
'KShortcut' => 'kde_KShortcut*',
'KShortcut*' => 'kde_KShortcut*',
'KKey&' => 'kde_KKey*',
'KKey*' => 'kde_KKey*',
'KKeyNative&' => 'kde_KKeyNative*',
'KKeyNative*' => 'kde_KKeyNative*',
'KKeyVariations&' => 'kde_KKeyVariations*',
'KKeyVariations*' => 'kde_KKeyVariations*',
'KKeyX11&' => 'kde_KKeyX11*',
'KKeyX11' => 'kde_KKeyX11*',
'KKeyX11*' => 'kde_KKeyX11*',
'KAccelActions' => 'kde_KAccelActions*',
'KRandomSequence&' => 'kde_KRandomSequence*',
'KIcon::Context' => 'int',
'KIcon::Group' => 'int',
);

  # Initialize %builtins, used by resolveType
  my @noreflist = qw( const int char long double template
		    unsigned signed float void bool true false uint
		    uint32 uint64 extern static inline virtual operator );
  foreach my $r ( @noreflist ) {
     $builtins{ $r } = $r;
  }

}

sub interfacemap
{
	my ( $interfaceType )  = @_;
	return $interfacemap{$interfaceType};
}

sub ctypemap
{
	my ( $cType )  = @_;
	return $ctypemap{$cType};
}

sub setctypemap
{
	my ( $cType, $cValue )  = @_;

	$ctypemap{$cType} = $cValue;
	return;
}

sub pastypemap
{
	my ( $pasType )  = @_;
	return $pastypemap{$pasType};
}

sub pasenummap
{
	my ( $pasenum )  = @_;
	if ($pasenummap{$pasenum} eq "") {
		return $pasenum;
        } else {
        	return $pasenummap{$pasenum};
        }
}

sub setpastypemap
{
	my ( $pasType, $pasValue )  = @_;

	$pastypemap{$pasType} = $pasValue;
	return;
}

sub addNamespace
{
	my ( $className )  = @_;

	if ( $className =~ /Bridge$/ ) {
		return $className;
	}

	if ( $className =~ /^(AbstractView|Attr|CDATASection|CSSCharsetRule|CSSException|CSSFontFaceRule|CSSImportRule|CSSMediaRule|CSSPageRule|CSSPrimitiveValue|CSSRule|CSSRuleList|CSSStyleDeclaration|CSSStyleRule|CSSStyleSheet|CSSUnknownRule|CSSValue|CSSValueList|CharacterData|Comment|Counter|CustomNodeFilter|DOMException|DOMImplementation|DOMString|Document|DocumentFragment|DocumentStyle|DocumentType|DomShared|Element|Entity|EntityReference|EventException|EventListener|LinkStyle|MediaList|MutationEvent|NamedNodeMap|Node|NodeFilter|NodeIterator|NodeList|Notation|ProcessingInstruction|RGBColor|Range|RangeException|Rect|StyleSheet|StyleSheetList|Text|TreeWalker|UIEvent|HTML.*)/ )
	{
		return "DOM::".$className;
	}

	if ( $className =~ /^(BrowserExtension|BrowserHostExtensionBrowserInterface|ComponentFactory|DockMainWindow|Event|Factory|GUIActivateEvent|HistoryProvider|MainWindow|OpenURLEvent|Part|PartActivateEvent|PartBase|PartManager|PartSelectEvent|Plugin|PluginInfo|ReadOnlyPart|ReadWritePart|URLArgs|WindowArgs)/ )
	{
		return "KParts::".$className;
	}

	if ( $className =~ /^(AuthInfo|AutoLogin|CacheInfo|ChmodJob|Connection|CopyInfo|CopyJob|DefaultProgress|DeleteJob|FileCopyJob|Job|ListJob|MetaData|MimetypeJob|MultiGetJob|NetAccess|NetRC|PasswordDialog|PreviewJob|ProgressBase|RenameDlg|Scheduler|SessionData|SimpleJob|SkipDlg|Slave|SlaveBase|SlaveConfig|SlaveInterface|StatJob|StatusbarProgress|TCPSlaveBase|Task|TransferJob|UDSAtom)/ )
	{
		return "KIO::".$className;
	}

	if ( $className =~ /^(DrawContentsEvent|MouseDoubleClickEvent|MouseEvent|MouseMoveEvent|MousePressEvent|MouseReleaseEvent)/ )
	{
		return "khtml::".$className;
	}

	if ( $className =~ /^(OfferList)/ )
	{
		return "KTrader::".$className;
	}

	if ( $className =~ /^(BlockSelectionInterface|ClipboardInterface|CodeCompletionInterface|CompletionEntry|ConfigInterface|Cursor|CursorInterface|Document|EditInterface|Editor|HighlightingInterface|Mark|MarkInterface|PopupMenuInterface|PrintInterface|SearchInterface|SelectionInterface|UndoInterface|View|ViewCursorInterface)/ )
	{
		return "KTextEditor::".$className;
	}


	return $className;
}


# Helper for resolveType. This one is recursive and returns undef if not found.
sub resolveTypeInternal($$$)
{
	my ( $argType, $contextClass, $rootnode ) = @_;

	#print "resolveTypeInternal type:'$argType' context:'$contextClass->{astNodeName}' ($contextClass)\n";

	my $contextClassName = join( "::", kdocAstUtil::heritage($contextClass) );

	# 'A' resolves to 'A' in context 'A' ;)  (i.e. classname itself)
	return $contextClassName if ( $argType eq $contextClass->{astNodeName} );

	# Try as an identifier of contextClass
	#print "Trying as ".$contextClassName."::".$argType."\n";

	my $node = kdocAstUtil::findRef( $rootnode, $contextClassName."::".$argType );

	#print "Found as $node->{NodeType}\n" if $node;

	return $contextClassName."::".$argType if ( $node
		 && $node->{NodeType} ne 'method'
		 && $node->{NodeType} ne 'deleted'
	         && $node->{NodeType} ne 'var' );

	my $found;

	# Then look at ancestors, and try for each one
	Iter::Ancestors( $contextClass, $rootnode, undef, undef,
		   sub {
		     my ( $ances, $name, $type, $template ) = @_;
		     unless ($found) {
			$found = resolveTypeInternal( $argType, $ances, $rootnode );
		     }
		   },
		   undef
		 );

	return $found;
}

=head2

  Look up a type, following the class hierarchy.
  e.g. "Mode", if ContextClassName is A, will be looked as A::Mode,
  then as B::Mode (if B is a parent class of A), then as Qt::Mode,
  then as just Mode.

=cut

sub resolveType($$$)
{
	my ( $argType, $contextClass, $rootnode ) = @_;
	$argType =~ s/\s*(\*)\s*$/$1/g; # remove space before *
	#print "resolveType: '$argType'\n";

	# Look for builtin words (int etc.)
	return $builtins{ $argType } if exists $builtins{ $argType };

	# Parse 'const' in front of it, and '*' or '&' after it
	my $prefix = $argType =~ s/^const\s+// ? 'const ' : '';
	my $suffix = $argType =~ s/\s*([\&\*]+)$// ? $1 : '';
	#print "resolveType: prefix:$prefix, '$argType', suffix:$suffix\n";

	# Launch the (possibly recursive) resolveTypeInternal
	my $result = resolveTypeInternal( $argType, $contextClass, $rootnode );
	return $prefix.$result.$suffix if $result;

	# Not found, so look as a toplevel class
	#print "Checking that ".$argType." exists.\n";
	return $prefix.$argType.$suffix if ( kdocAstUtil::findRef( $rootnode, $argType ) );

	#print "resolveType: $argType not found (context $contextClass->{astNodeName})\n\n";

	return $prefix.$argType.$suffix;
}

1;
