//
// C++ Implementation: dlsmanager
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "dlsmanager.h"

DLSManager::DLSManager(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


DLSManager::~DLSManager()
{
}

void DLSManager::writeDLS2File(QString path_and_filename,QStringList* filenames,QValueList <beatline_data> bld){
    QString filename=QFileInfo(path_and_filename).fileName();
    QString dirpath=QFileInfo(path_and_filename).dirPath();
    char nb_keygroups=filenames->size();
    qHeapSort(bld);

    IpatchFile *file;
    IpatchDLSFile *dlsfile;
    IpatchDLS2Sample *sample;
    GError *err = NULL;
    
    /* initialize libInstPatch */
    ipatch_init ();

    IpatchDLS2* dls2=ipatch_dls2_new();

    /*create new DLS2 instrument (++ ref) */
    IpatchDLS2Inst* inst = ipatch_dls2_inst_new ();
    /* set instrument name */
    g_object_set (inst, "name",filename.ascii(), NULL); 
    /* append instrument to DLS2 (ensure that its name is unique) */
    ipatch_container_add_unique (IPATCH_CONTAINER (dls2),IPATCH_ITEM (inst));



    
    for (int i=0;i<nb_keygroups;i++){
        QString temp_filename=filenames->operator[](i);
        temp_filename.prepend(dirpath+"/");
        int midiNote=bld[i].midiNote;
        if (midiNote==-1){
            cout<<"file: "<<temp_filename<<" midi: "<<midiNote<<"\n";
            continue;
        }
        /* identify and open file (++ new object reference) */
        file = ipatch_file_identify_open (temp_filename.ascii(), "r", &err);
        if (!file){
	  fprintf (stderr, "Failed to identify file '%s': %s\n", temp_filename.ascii(),
		   ipatch_gerror_message (err));
	  g_clear_error (&err);
	  continue;
	}

	/* attempt to convert sample file to DLS sample object
	 * ++ ref */
	sample = (IpatchDLS2Sample *)ipatch_convert_object_to_type (G_OBJECT (file), IPATCH_TYPE_DLS2_SAMPLE, &err);

	if (!sample)
	{
	  fprintf (stderr, "Failed to convert file '%s' to DLS2 sample: %s\n",
		   temp_filename.ascii(), ipatch_gerror_message (err));

          g_clear_error (&err);
	  g_object_unref (file); /* remove file reference */

	  continue;
	}

        /* append sample to DLS2 (ensure that its name is unique) */
        ipatch_container_add_unique (IPATCH_CONTAINER (dls2),
                                    IPATCH_ITEM (sample));
    
        g_object_set (sample, "root-note", midiNote, NULL); /* set the sample's root-note */      

        /* create new instrument zone and link sample to it */
        
        IpatchDLS2Region* region=ipatch_dls2_region_new();
        ipatch_dls2_region_set_sample (region,sample);
        ipatch_container_add (IPATCH_CONTAINER (inst), IPATCH_ITEM (region));
        
	IpatchRange* range=ipatch_range_new (midiNote, midiNote);
        g_object_set(region,"key-range", range, NULL);
        ipatch_range_free(range);

        g_object_unref(region);
        g_object_unref (sample); /* -- unref DLS sample */
        g_object_unref (file);	/* -- unref file */
    }
    g_object_unref (inst);	/* -- unref DLS instrument */

    /* create DLS2 file object, set its name and open for writing */
    dlsfile = ipatch_dls_file_new ();
    
    if (!ipatch_file_open (IPATCH_FILE (dlsfile), QString(dirpath+"/"+filename+".dls").ascii(), "w", &err)){
        fprintf (stderr, "Failed to open output file for writing: %s\n",
                ipatch_gerror_message (err));
    
        g_object_unref (dlsfile);	/* -- unref DLS file */
        g_object_unref (dls2);	/* -- unref DLS object */
    
        return;
    }
    
    /* convert DLS2 object to DLS2 file (write it) */
    if (!ipatch_convert_objects (G_OBJECT (dls2), G_OBJECT (dlsfile), &err))
        {
        fprintf (stderr, "Failed to save DLS to file: %s\n",
                ipatch_gerror_message (err));
        g_clear_error (&err);
        }

    g_object_unref (dlsfile);	/* -- unref DLS2 file */
    g_object_unref (dls2);		/* -- unref DLS2 object */

    //return (0);			/* we done, yeah! :) */
}
