/*  FreeJ
 *  (c) Copyright 2007 Denis Rojo <jaromil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * "$Id: freej.cpp 654 2005-08-18 16:52:47Z jaromil $"
 *
 */

#include <callbacks_js.h>
#include <jsparser_data.h>
#include <config.h>

#ifdef WITH_OGGTHEORA

#include <shouter.h>
#include <oggtheora_encoder.h>

DECLARE_CLASS("Shouter", js_shouter_class, js_shouter_constructor);

/////////////////////////////////
// Shouter methods
JSFunctionSpec js_shouter_methods[] = {
  { "host",   shouter_host,  1},
  { "port",   shouter_port,  1},
  { "mountpoint",  shouter_mount, 1},
  { "title",   shouter_title, 1},
  { "username", shouter_username, 1},
  { "password", shouter_password, 1},
  { "homepage", shouter_homepage, 1},
  { "description", shouter_description, 1},
  {0}
};

JS(js_shouter_constructor) {
  func("%u:%s:%s",__LINE__,__FILE__,__FUNCTION__);
  Shouter *shout;
  shout = new Shouter();
  if(!shout) {
    error("JS::Shouter : error constructing shouter icecast streamer");
    return JS_FALSE;
  }
  if(!JS_SetPrivate(cx,obj,(void*)shout)) {
    error("JS::Shouter : can't set the private value");
    delete shout; return JS_FALSE;
  }
  *rval = OBJECT_TO_JSVAL(obj);
  return JS_TRUE;
}

#endif 
