/*  histogram.cc

    Mark Woolrich, FMRIB Image Analysis Group

    Copyright (C) 1999-2000 University of Oxford  */

/*  CCOPYRIGHT  */

#include "miscmaths.h"
#include "histogram.h"

#include <strstream>
using namespace std;

#ifndef NO_NAMESPACE
namespace MISCMATHS {
#endif

  void Histogram::generate()
    {
      Tracer ts("Histogram::generate");

      int size = sourceData.Nrows();
      
      if(calcRange)
	{
	  // calculate range automatically
	  histMin=histMax=sourceData(1);
	  for(int i=1; i<=size; i++)
	    {
	      if (sourceData(i)>histMax)
		histMax=sourceData(i);
	      if (sourceData(i)<histMin)
		histMin=sourceData(i);
	    }
	}
      
      // zero histogram
      histogram.ReSize(bins);
      histogram=0;
      
      // create histogram; the MIN is so that the maximum value falls in the
      // last valid bin, not the (last+1) bin
      for(int i=1; i<=size; i++)
	{
	   histogram(getBin(sourceData(i)))++;
	}
    }

  void Histogram::smooth()
    {
      Tracer ts("Histogram::smooth");

      ColumnVector newhist=histogram;

      // smooth in i direction
      newhist=0;

      for(int i=1; i<=bins; i++)
	  {
	    float val=0.5*histogram(i);
	    float norm=0.5;

	    if(i>1)
	      {
		val+=0.2283*(histogram(i-1));
		norm+=0.2283;
	      }
	    if(i>2)
	      {
		val+=0.0219*(histogram(i-2));
		norm+=0.0219;		
	      }
	    if(i<bins)
	      {
		val+=0.2283*(histogram(i+1));
		norm+=0.2283;
	      }
	    if(i<bins-1)
	      {
		val+=0.0219*(histogram(i+2));
		norm+=0.0219;		
	      }
	    val/=norm;

	    newhist(i)=val;
	  }

      histogram=newhist;

    }

  int Histogram::integrate(float value1, float value2) const
    {
      int upperLimit = getBin(value2);
      int sum = 0;

      for(int i = getBin(value1)+1; i< upperLimit; i++)
	{
	  sum += (int)histogram(i);
	}
      return sum;
    }

  float Histogram::mode() const
    {
      int maxbin = 0;
      int maxnum = 0;

      for(int i = 1; i< bins; i++)
	{
	  if((int)histogram(i) > maxnum) {
	    maxnum = (int)histogram(i);
	    maxbin = i;
	  }
	}

      return getValue(maxbin);
    }

#ifndef NO_NAMESPACE
}
#endif




































