/*  Copyright (C) 1999-2004 University of Oxford  */

/*  CCOPYRIGHT */

#include "options.h"

namespace Utilities {

  BaseOption * OptionParser::find_matching_option(const string& optstr)
  {
    for(Options::iterator o = options_.begin();
	o != options_.end();
	++o)
      if((*o)->matches(optstr))
	return *o;

    return 0;
  }

  unsigned int OptionParser::parse_option(const string& optstr, const string& valstr,
					  char *argv[], int valpos, int argc)
    throw(X_OptionError)
  {
    BaseOption * theOption = 0;
    bool spasMode = true;

    if((theOption = find_matching_option(optstr)) == 0)
      throw X_OptionError(optstr, "Option doesn't exist");

    if(theOption->unset() || spasMode) 
      {
	if(theOption->has_arg()) {
	  if(valstr.length() > 0) {
	    if(theOption->set_value(valstr,argv,valpos,argc))
	      return 1 + theOption->nrequired();
	    else {
	      string errstr = valstr;
	      for (int nn=valpos+1; nn<=valpos + theOption->nrequired(); nn++) {
		if (nn<argc)  errstr += " " + string(argv[nn]);
	      }
	      throw X_OptionError(optstr, errstr); }
	  } else {
	    throw X_OptionError(optstr);
	  }
	}
	theOption->set_value(string());
	return 1;
      } 
    else 
      {
	throw X_OptionError(optstr, "Option already set");
      }

    throw X_OptionError(optstr);
    return 0;
  }


  unsigned int OptionParser::parse_long_option(const string& str)
  {
    string optstr(str);
    string valstr;

    string::size_type pos = 0;
    if((pos = str.find("=", 0)) != string::npos) {
      optstr = str.substr(0, pos);
      valstr = str.substr(pos + 1, str.length() - pos + 1);
    }

    parse_option(optstr, valstr, 0,0,0);

    return 1;
  }

  unsigned int OptionParser::parse_command_line(unsigned int argc, 
						char **argv, int skip) 
  {
    unsigned int optpos = 1 + skip;
    unsigned int valpos = 1 + skip;

    while(optpos < argc) {

      unsigned int increments = 0;
      
      string optstr(argv[optpos]), valstr;

      if(optstr[0] != '-')	// End of parsable options
	break;

      if(optstr[1] == '-') {	// Parse a long opt

	increments = parse_long_option(optstr);
	optpos += increments;

      } else {

	valpos = optpos + 1;

	for(unsigned int i = 1; i < optstr.length(); ++i)
	  {
	    string suboptstr = "-" + optstr.substr(i, 1);
	    
	    if (valpos<argc) valstr=string(argv[valpos]); else valstr=string();
	    increments = parse_option(suboptstr, valstr, argv, valpos, argc);
	    
	    valpos += increments - 1;
	  }
	
	optpos = valpos;
      }
    } 
    return optpos;		// User should process any remaining args
  }

}
