#ifndef FTPCONFIG_H
#define FTPCONFIG_H

#include <kdialogbase.h>
#include <knuminput.h>
#include <kurlrequester.h>
#include <qcheckbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h> 
#include <kcombobox.h>
#include <kconfig.h>
#include <klineedit.h>

class QString;

class FTPConfig : public KDialogBase
{
    Q_OBJECT

    public:
        FTPConfig(KConfig * ksConfig,
                QWidget * parent = 0,
                const char * name = 0
                );
        ~FTPConfig();
        KIntNumInput * updateInterval_;
        KIntNumInput * notifyInterval_;
        KIntNumInput * infoPopupTime_;
        KLineEdit * middleMouseClick_;
        KComboBox * ftpdaemonSelector_;
        KURLRequester * pathSelector_;
        QCheckBox * popupEnableBox;	 
        QCheckBox * middleMouseClickSet_;
        QCheckBox * useSudo_;

        protected slots:
            void notificationsStateChanged();	
        void ftpdaemonChanged();
        void middleMouseClickStatusChanged();

    private:
        QLabel * pathLabel;
        KConfig * myksConfig;
        QFrame *page;
        QGroupBox *b, *b1, *b2, *b3, *b4, b5; 
        QBoxLayout *bl, *bl1, *bl2, *bl3;
        QVBoxLayout * gl;
};

#endif
