/***************************************************************************
 *   Copyright (C) 2004 by Nilesh Bansal                                   *
 *   nilesh@iitb.ac.in                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "FTPMonitorLoop.h"
#include <kmessagebox.h> 
#include <kdeversion.h>
#include <ktempfile.h>
#include <kdebug.h>

FTPMonitorLoopPrivate::FTPMonitorLoopPrivate()
{
    //do nothing
}

FTPMonitorLoopPrivate::~FTPMonitorLoopPrivate()
{
    //do nothing
    delete timer_;
}
    FTPMonitorLoop::FTPMonitorLoop(int interval, QObject* parent, char * name)
:QObject(parent, name)
{
    d = new FTPMonitorLoopPrivate;
    d->interval_ = interval * 1000;
    d->timer_ = new QTimer(this);
    connect(d->timer_, SIGNAL(timeout()), this,
            SLOT(slotTimeout()));
    no_of_connections = 0;
    old_no_of_connections = 0;
    whoIsRunning = 0;
    path = QString("/usr/local/sbin/pure-ftpwho");
    proc = new QProcess(this);
    connect( proc, SIGNAL(processExited()),
            this, SLOT(readFromStdout()) );
}


FTPMonitorLoop::~FTPMonitorLoop()
{
    delete d;
}

void FTPMonitorLoop::setInterval(int i){
    stop();
    d->interval_ = i * 1000;
    start();
}

int FTPMonitorLoop::getInterval(){
    return d->interval_ / 1000;

}

int 
FTPMonitorLoop::setPath(QString str){
    if(str.isNull() || str.isEmpty()){
        return 0;
        KMessageBox::error(0, i18n("Path to pure-ftpwho can't be empty."));
    }
    if(!QFile::exists(str)){
        KMessageBox::error(0, i18n("File %1 does not exist").arg(str));
        return 0;
    }

    path = str;

    return 1;
}

void
FTPMonitorLoop::setPathPrivate(QString str){
    if(str.isNull() || str.isEmpty()){
        return;
    }
    if(!QFile::exists(str)){
        //	KMessageBox::error(0,  i18n("File %1 does not exist").arg(str));
        return;
    }

    path = str;
}

    void 
FTPMonitorLoop::start()
{
    d->timer_->start(d->interval_, true);
}

    void
FTPMonitorLoop::stop()
{
    d->timer_->stop();
}

    void 
FTPMonitorLoop::slotTimeout()
{
    execWho();
    d->timer_->start(d->interval_, true);
}

    void
FTPMonitorLoop::execWhoPureFtpd()
{
    proc->clearArguments();
    if(useSudo)
        proc->addArgument( "sudo");
    proc->addArgument( path);

    if ( !proc->start() ) {
        delete ftp_string;
        ftp_string=new QString(i18n("Error %1").arg(proc->readStderr ()));
    }else{
        whoIsRunning = 1;
    }
}

    void
FTPMonitorLoop::execWhoNcFtpd()
{

    proc->clearArguments();
    if(useSudo)
        proc->addArgument( "sudo");
    proc->addArgument(path);
    proc->addArgument( "-h");
    proc->addArgument( "who");
    if ( !proc->start() ) {
        delete ftp_string;
        ftp_string=new QString(i18n("Error %1").arg(proc->readStderr ()));
    }else{
        whoIsRunning = 1;
    }

}

    void
FTPMonitorLoop::execWhoVsFtpd()
{
    proc->clearArguments();
    if(useSudo)
        proc->addArgument( "sudo");
    proc->addArgument( "/bin/ps");
    proc->addArgument( "-fe");
    if ( !proc->start() ) {
        delete ftp_string;
        ftp_string=new QString(i18n("Error %1").arg(proc->exitStatus()));
    }else{
        whoIsRunning = 1;
    }

}

    void
FTPMonitorLoop::execWhoProFtpd()
{
    proc->clearArguments();
    if(useSudo)
        proc->addArgument( "sudo");
    proc->addArgument( path);
    proc->addArgument( "-v");
    proc->addArgument( "-o");
    proc->addArgument( "oneline");
    if ( !proc->start() ) {
        delete ftp_string;
        ftp_string=new QString(i18n("Error %1").arg(proc->exitStatus()));
    }else{
        whoIsRunning = 1;
    }

}

void
    FTPMonitorLoop::execWho(){
        if(whoIsRunning){
            return;
        }
        if(ftpdaemon == 1)
            execWhoPureFtpd();
        else if(ftpdaemon == 0){
            execWhoNcFtpd();
        }		
        else if(ftpdaemon == 2){
            execWhoVsFtpd();

        }else if(ftpdaemon == 3){
            execWhoProFtpd();
        }
        else{
            if(ftp_string != NULL)
                delete ftp_string;
            ftp_string = new QString("Invalid FTP Daemon specified");
        }

    }

    void FTPMonitorLoop::readFromStdout(){
        if(ftpdaemon == 1){
            readFromStdoutPureFtpd();
        }else if(ftpdaemon == 0){
            readFromStdoutNcFtpd();
        }else if(ftpdaemon == 2){
            readFromStdoutVsFtpd();
        }
        else if(ftpdaemon == 3){
            readFromStdoutProFtpd();
        }
        else{
            if(ftp_string != NULL)
                delete ftp_string;
            ftp_string = new QString("Invalid FTP Daemon specified");
        }
        whoIsRunning = 0;
    }

void FTPMonitorLoop::readFromStdoutPureFtpd()
{
    delete ftp_string;
    QString * raw_ftp_string = new QString(proc->readStdout ());
    QStringList raw_string_list = 	QStringList::split("\n", *raw_ftp_string);
    delete raw_ftp_string;
    ftp_string=new QString("");
    QStringList::Iterator it = raw_string_list.begin();
    if(it == raw_string_list.end())
        return;
    it++;
    if(it == raw_string_list.end())
        return;
    it++;
    if(it == raw_string_list.end())
        return;
    it++;
    (*ftp_string).append("<table border=1>");
    (*ftp_string).append("<tr>");
    (*ftp_string).append("<td>"+i18n("PID")+"</td>");
    (*ftp_string).append("<td>"+i18n("Login")+"</td>");
    (*ftp_string).append("<td>"+i18n("For/Speed")+"</td>");
    (*ftp_string).append("<td>"+i18n("What")+"</td>");
    (*ftp_string).append("<td>"+i18n("File/IP")+"</td>");
    (*ftp_string).append("</tr>");
    for (; it != raw_string_list.end(); ++it ) {
        (*ftp_string).append("<tr>");
        QStringList raw_ftp_line = QStringList::split("|", *it);
        for(QStringList::Iterator it_line = raw_ftp_line.begin(); 
                it_line != raw_ftp_line.end(); ++it_line){
            if(! ( (*it_line).contains("+------+---------+-------+------+"))){
                (*ftp_string).append("<td>");
                (*ftp_string).append(*it_line);
                (*ftp_string).append("</td>");
            }
        }
        (*ftp_string).append("</tr>");
    }
    (*ftp_string).append("</table>");
    (*ftp_string).remove("|");
    no_of_connections =  (*ftp_string).contains("->");
    if(old_no_of_connections!=no_of_connections){
        emit(change_in_conn()); 	
        old_no_of_connections=no_of_connections;
        emit(reverse());
    }
    if(no_of_connections==0){
        delete ftp_string;
        ftp_string = new QString(i18n("No one is connected"));
    }
}


void FTPMonitorLoop::readFromStdoutProFtpd()
{
    delete ftp_string;
    QString * raw_ftp_string = new QString(proc->readStdout ());
    QStringList raw_string_list = 	QStringList::split("\n", *raw_ftp_string);
    delete raw_ftp_string;
    ftp_string=new QString("");

    QStringList::Iterator it = raw_string_list.begin();
    if(it == raw_string_list.end())
        return;
    it++;
    (*ftp_string).append("<table border=1>");
    (*ftp_string).append("<tr>");
    (*ftp_string).append("<td>"+i18n("PID")+"</td>");
    (*ftp_string).append("<td>"+i18n("Login")+"</td>");
    (*ftp_string).append("<td>"+i18n("Client")+"</td>");
    (*ftp_string).append("<td>"+i18n("Location")+"</td>");
    (*ftp_string).append("<td>"+i18n("What")+"</td>");
    (*ftp_string).append("</tr>");
    for ( ; it != raw_string_list.end() ; ++it ) {
        //	KMessageBox::information(0, "in "+*it);
        QString temp_string_1 = *it;
        if(temp_string_1.startsWith("Service")|| 
                temp_string_1.startsWith("no users connected")
                || (!temp_string_1.contains("client"))
                || (!temp_string_1.contains("server"))
                || (!temp_string_1.contains("location"))
          ){
        }else{
            (*ftp_string).append("<tr>");
            QStringList raw_ftp_line = QStringList::split(" ", *it);
            QStringList::Iterator it_line = raw_ftp_line.begin();
            QString pid = *it_line;
            it_line++;
            QString login = *it_line;
            it_line++;
            QString client("");	
            QString what("idle");
            QString location("");
            int got_client=0;
            int got_what=0;
            int got_server=0;
            for(; it_line != raw_ftp_line.end(); it_line++){
                if(*it_line == "client:")
                    got_what=1;
                if(*it_line == "server:")
                    got_client=1;
                if(*it_line == "location:")
                    got_server=1;
                if(got_server==1){
                    location += *it_line;
                }else if(got_what==1 && got_client==0){
                    client += *it_line;
                }else if(got_client==0){
                    what += *it_line;
                }
            }
            QString temp_string_4="<td>"+pid+"</td><td>"+login
                +"</td><td>"+client+"</td><td>"+location+"</td><td>"+what;
            (*ftp_string)+=temp_string_4;
            (*ftp_string).append("</tr>");
        }
    }
    (*ftp_string).append("</table>");
    (*ftp_string).remove("client:");
    (*ftp_string).remove("location:");
    no_of_connections =  (*ftp_string).contains("<tr>")-1;
    if(old_no_of_connections!=no_of_connections){
        emit(change_in_conn()); 	
        old_no_of_connections=no_of_connections;
        emit(reverse());
    }
    if(no_of_connections==0){
        delete ftp_string;
        ftp_string = new QString(i18n("No one is connected"));
    }
    //KMessageBox::information( 0, "exiting ");

}



void FTPMonitorLoop::readFromStdoutNcFtpd()
{
    delete ftp_string;
    ftp_string=new QString("");
    QString * raw_ftp_string = new QString(proc->readStdout ());

    ftp_string = raw_ftp_string;
    no_of_connections =  (*ftp_string).contains("<tr>");
    if(old_no_of_connections!=no_of_connections){
        emit(change_in_conn()); 	
        old_no_of_connections=no_of_connections;
        emit(reverse());
    }

}

void FTPMonitorLoop::readFromStdoutVsFtpd()
{
    delete ftp_string;
    ftp_string=new QString("");
    QString * raw_ftp_string = new QString(proc->readStdout ());
    QStringList processList = QStringList::split (QString("\n") , *raw_ftp_string);
    delete raw_ftp_string;
    (*ftp_string) += "<table border=1> ";
    for ( QStringList::Iterator it = processList.begin(); it != processList.end(); ++it ) {
        if((*it).contains("vsftpd") ){
            int fieldCounter = 0;
            (*ftp_string) += "<tr>";
            QStringList lf =   QStringList::split (
                    QString(" ") , *it);
            for ( QStringList::Iterator it1 = lf.begin(); 
                    it1 != lf.end(); ++it1 ) {
                fieldCounter++;
                if (fieldCounter < 3) {
                    (*ftp_string) += "<td>";
                    (*ftp_string) += *it1;
                    (*ftp_string) += "</td>";
                }
                if (fieldCounter == 9) {
                    (*ftp_string) += "<td>";
                    (*ftp_string) += *it1;
                }

                if (fieldCounter > 9) {
                    (*ftp_string) += " ";
                    (*ftp_string) += *it1;
                }

            }
            (*ftp_string) += "</td></tr>";
        }
    }
    (*ftp_string) += "</table>";
    no_of_connections =  (*ftp_string).contains("<tr>");
    no_of_connections = no_of_connections/2;
    if (no_of_connections < 0)
        no_of_connections = 1;
    if(old_no_of_connections!=no_of_connections){
        emit(change_in_conn()); 	
        old_no_of_connections=no_of_connections;
        emit(reverse());
    }
    if(no_of_connections==0){
        delete ftp_string;
        ftp_string = new QString(i18n("No one is connected"));
    }

}


