
#include "global.h"

#include "ObjectTreeViewItem.h"

#include "fwbuilder/Firewall.h"

#include <qfont.h>
#include <qpainter.h>

using namespace std;
using namespace libfwbuilder;

void ObjectTreeViewItem::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
    if (!p) return;
    
    FWObject * obj=getFWObject();
    Firewall * o=NULL;
    
    if (obj!=NULL || getProperty("type")==Firewall::TYPENAME) 
    {
        o=Firewall::cast( obj );
    }
    
    if (o!=NULL)
    {
        bool mf= !o->getInactive() && (o->needsInstall()) ; 
        p->save();
        QFont f=p->font();
        f.setBold (mf);
        p->setFont(f);
        QListViewItem::paintCell(p,cg,column,width,align);
        p->restore();
    }
    else
    {
        QListViewItem::paintCell(p,cg,column,width,align);
    }
}

