// ---------------------------------------------------------------------
// $Id: Split.hh,v 1.2 2007/03/28 09:47:10 daaugusto Exp $
//
//   Split.hh (created on Fri Aug  4 12:59:27 BRT 2006)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2007 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// ---------------------------------------------------------------------

#ifndef Split_hh
#define Split_hh

#include "../Optimizer.hh"

using namespace std;

// ---------------------------------------------------------------------
/**
 * Split an input into pieces
 */
class Split: public Optimizer {
public:
   /**
    * Calls the base constructor and prints some information if needed.
    */
   Split(vector<SizeName>& sn, Params& p):Optimizer(sn,p) {}

   /**
    * Just split the input (in original order) according to target size,
    * i. e., select file by file until fit the specified volume.
    */
   void Evolve();

protected:
   /** 
    * Writes some information (like algorithm name and parameters) in
    * ostream object (usually cout).
    */
   ostream& Write(ostream&) const; 
};

// ---------------------------------------------------------------------

#endif
