 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: tab.h                                                            *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourcetagtable.h>

/* tab functions */
gint new_tab ( const gchar * title, gchar * content );
void rem_tab (gint page);

/* tab label functions */
GtkWidget * new_tab_header( void );
const gchar * get_label_of_tab (gint page);
void set_label_of_tab (gint page, gchar* text);

/* filename functions */
gchar * get_filename_of_tab ( gint page );
void set_filename_of_tab ( gint page, const gchar * filename );

/* tab content functions */
GtkWidget * new_tab_content( void );
gchar * get_text_of_tab(gint page);
void set_text_of_tab (gint page, gchar* text);

/* additional functions */
GtkWidget * get_textview_of_tab (gint page);
GtkSourceBuffer * get_buffer_of_tab (gint page);
void button_callback ( GtkWidget * widget );
gint get_page_by_label (const gchar * label);
gchar * get_title_from_filename ( const gchar * filename );
