/**
 * @file meta-account.h Meta-Account API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_META_ACCOUNT_H_
#define _GALAGOD_META_ACCOUNT_H_

typedef struct _GalagodMetaAccount GalagodMetaAccount;

#include <libgalago/galago.h>
#include "meta-person.h"
#include "meta-service.h"

struct _GalagodMetaAccount
{
	GalagoAccount *account;

	GList *accounts;
};

#define GALAGOD_META_ACCOUNT(account) \
	(g_object_get_data(G_OBJECT(account), "meta-account"))

GalagodMetaAccount *galagod_meta_account_new(GalagodMetaService *meta_service,
											 GalagodMetaPerson *meta_person,
											 const char *username);
void galagod_meta_account_destroy(GalagodMetaAccount *meta_account);

GalagoAccount *galagod_meta_account_get_account(
	const GalagodMetaAccount *meta_account);

GList *galagod_meta_account_get_accounts(
	const GalagodMetaAccount *meta_account);

void galagod_meta_account_add_account(GalagodMetaAccount *meta_account,
									  GalagoAccount *account);
void galagod_meta_account_remove_account(GalagodMetaAccount *meta_account,
										 GalagoAccount *account);

#endif /* _GALAGOD_META_ACCOUNT_H_ */
