/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryFileFilter;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.ExifData;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.UrlMessageDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageUtils {
    public static final String MODULE = "ImageUtils";
    static ArrayList toDelete;
    static long totalTime;
    static int totalIter;
    public static boolean useIM;
    static String imPath;
    static int jpegQuality;
    static boolean imIgnoreErrorCode;
    public static boolean useJpegtran;
    public static boolean useJpegtranCrop;
    static String jpegtranPath;
    static boolean jpegtranIgnoreErrorCode;
    static File tmpDir;
    public static final int THUMB = 0;
    public static final int PREVIEW = 1;
    public static final int UPLOAD = 2;
    static String[] filterName;
    static String[] format;
    public static final String DEFAULT_RESOURCE = "/default.gif";
    public static final String UNRECOGNIZED_RESOURCE = "/default.gif";
    public static Image defaultThumbnail;
    public static Image unrecognizedThumbnail;
    public static boolean deferredStopUsingIM;
    public static boolean deferredStopUsingJpegtran;
    public static boolean deferredStopUsingJpegtranCrop;
    public static boolean deferredOutOfMemory;
    public static ImageObserver observer;
    static Boolean exifAvailable;

    public static Image load(String filename, Dimension d, int usage) {
        return ImageUtils.load(filename, d, usage, false);
    }

    public static Image load(String filename, Dimension d, int usage, boolean ignoreFailure) {
        if (!new File(filename).exists()) {
            return null;
        }
        Image r = null;
        long start = System.currentTimeMillis();
        if (!GalleryFileFilter.canManipulate(filename)) {
            return unrecognizedThumbnail;
        }
        if (useIM) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(imPath);
            if (filterName[usage] != null && filterName[usage].length() > 0) {
                cmd.add("-filter");
                cmd.add(filterName[usage]);
            }
            cmd.add(filename);
            cmd.add("-resize");
            if (GalleryRemote._().properties.getBooleanProperty("slideshowNoStretch")) {
                cmd.add(d.width + "x" + d.height + ">");
            } else {
                cmd.add(d.width + "x" + d.height);
            }
            cmd.add("+profile");
            cmd.add("*");
            File temp = ImageUtils.deterministicTempFile("thumb", "." + format[usage], tmpDir, filename + d);
            if (!temp.exists()) {
                toDelete.add(temp);
                cmd.add(temp.getPath());
                int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
                if (exitValue != 0 && !imIgnoreErrorCode && !ignoreFailure || !temp.exists()) {
                    if (exitValue != -1 && !temp.exists()) {
                        Log.log(0, MODULE, "ImageMagick doesn't seem to be working. Disabling");
                        ImageUtils.stopUsingIM();
                    }
                } else {
                    try {
                        r = ImageIO.read(temp);
                    }
                    catch (IOException e) {
                        Log.logException(1, MODULE, e);
                    }
                    catch (Throwable e) {
                        Log.logException(1, MODULE, e);
                        Log.log(1, MODULE, "Out of memory while loading image " + temp);
                        ImageUtils.outOfMemoryError();
                    }
                }
            } else {
                try {
                    r = ImageIO.read(temp);
                }
                catch (IOException e) {
                    Log.logException(1, MODULE, e);
                }
                catch (Throwable e) {
                    Log.logException(1, MODULE, e);
                    Log.log(1, MODULE, "Out of memory while loading image " + temp);
                    ImageUtils.outOfMemoryError();
                }
            }
        }
        if (!useIM && r == null) {
            r = ImageUtils.loadJava(filename, d, GalleryRemote._().properties.getBooleanProperty("slideshowNoStretch"));
        }
        long time = System.currentTimeMillis() - start;
        Log.log(3, MODULE, "Time: " + time + " - Avg: " + (totalTime += time) / (long)(++totalIter));
        return r;
    }

    public static Image loadJava(Object reference, Dimension d, boolean noStretch) {
        try {
            BufferedImage r;
            if (reference instanceof String) {
                r = ImageIO.read(new File((String)reference));
            } else if (reference instanceof URL) {
                r = ImageIO.read((URL)reference);
            } else {
                throw new IllegalArgumentException("loadJava can only be called with a URL or a filename");
            }
            Dimension newD = ImageUtils.getSizeKeepRatio(new Dimension(((Image)r).getWidth(observer), ((Image)r).getHeight(observer)), d, noStretch);
            if (newD == null) {
                return r;
            }
            BufferedImage scaled = ImageUtils.createResizedCopy(r, newD.width, newD.height, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            r.flush();
            r = null;
            return scaled;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return null;
        }
        catch (Throwable e) {
            Log.logException(1, MODULE, e);
            Log.log(1, MODULE, "Out of memory while loading image " + reference);
            ImageUtils.outOfMemoryError();
            return null;
        }
    }

    public static File resize(String filename, Dimension d) {
        return ImageUtils.resize(filename, d, null, -1);
    }

    public static File resize(String filename, Dimension d, Rectangle cropTo, int resizeJpegQuality) {
        File r = null;
        long start = System.currentTimeMillis();
        if (!GalleryFileFilter.canManipulate(filename)) {
            return new File(filename);
        }
        if (useIM) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(imPath);
            if (filterName[2] != null && filterName[2].length() > 0) {
                cmd.add("-filter");
                cmd.add(filterName[2]);
            }
            cmd.add(filename);
            if (cropTo != null) {
                cmd.add("-crop");
                cmd.add(cropTo.width + "x" + cropTo.height + "+" + cropTo.x + "+" + cropTo.y);
            }
            if (d != null) {
                cmd.add("-resize");
                cmd.add(d.width + "x" + d.height + ">");
            }
            cmd.add("-quality");
            cmd.add("" + (resizeJpegQuality == -1 ? jpegQuality : resizeJpegQuality));
            r = ImageUtils.deterministicTempFile("res", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + d + cropTo);
            toDelete.add(r);
            cmd.add(r.getPath());
            int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
            if (exitValue != 0 && !imIgnoreErrorCode || !r.exists()) {
                if (exitValue != -1 && !r.exists()) {
                    Log.log(0, MODULE, "ImageMagick doesn't seem to be working. Disabling");
                    ImageUtils.stopUsingIM();
                }
                r = null;
            }
        }
        if (!useIM && r == null && (r = ImageUtils.resizeJava(filename, d)) == null) {
            Log.log(3, MODULE, "All methods of resize failed: sending original file");
            r = new File(filename);
        }
        long time = System.currentTimeMillis() - start;
        Log.log(3, MODULE, "Time: " + time + " - Avg: " + (totalTime += time) / (long)(++totalIter));
        return r;
    }

    public static File resizeJava(String filename, Dimension d) {
        File r;
        if (!GalleryRemote._().properties.getBooleanProperty("useJavaResize")) {
            return null;
        }
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJava") && ImageUtils.stopUsingJavaResize()) {
            return null;
        }
        try {
            ImageOutputStream ios;
            ImageWriter writer;
            IIOImage image;
            ImageInputStream iis = ImageIO.createImageInputStream(new File(filename));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(iis, true, false);
            BufferedImage rim = (BufferedImage)reader.readAsRenderedImage(0, param);
            iis.close();
            reader.dispose();
            Dimension newD = ImageUtils.getSizeKeepRatio(new Dimension(rim.getWidth(), rim.getHeight()), d, true);
            if (newD != null) {
                BufferedImage scaled = ImageUtils.createResizedCopy(rim, newD.width, newD.height, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                image = new IIOImage(scaled, null, null);
                r = ImageUtils.deterministicTempFile("jres", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + d);
                toDelete.add(r);
                writer = ImageIO.getImageWriter(reader);
                if (writer == null) {
                    Log.log(1, MODULE, "No writer to write out " + filename + " ImageIO probably doesn't support it. Resize aborted.");
                    return new File(filename);
                }
                try {
                    r.delete();
                    ios = ImageIO.createImageOutputStream(r);
                }
                catch (IOException e) {
                    throw new IIOException("Can't create output stream!", e);
                }
            } else {
                return new File(filename);
            }
            writer.setOutput(ios);
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality((float)jpegQuality / 100.0f);
            writer.write(null, image, iwp);
            ios.flush();
            ios.close();
            writer.dispose();
            Log.log(3, MODULE, "Java resized " + filename + " to " + r.getPath());
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return new File(filename);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File rotate(String filename, int angle, boolean flip, boolean resetExifOrientation) {
        File r = null;
        if (!GalleryFileFilter.canManipulateJpeg(filename)) {
            Log.log(3, MODULE, "jpegtran doesn't support rotating anything but jpeg");
            return new File(filename);
        }
        if (useJpegtran) {
            File orig = null;
            File dest = null;
            try {
                if (GalleryRemote.IS_MAC_OS_X) {
                    orig = new File(filename);
                    dest = ImageUtils.deterministicTempFile("tmp", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + angle + flip);
                    orig.renameTo(dest);
                    filename = dest.getPath();
                }
                if (flip) {
                    r = ImageUtils.jpegtranExec(filename, "-flip", "horizontal", false);
                    filename = r.getPath();
                }
                if (angle != 0) {
                    r = ImageUtils.jpegtranExec(filename, "-rotate", "" + angle * 90, false);
                }
            }
            finally {
                if (orig != null && dest != null) {
                    dest.renameTo(orig);
                }
            }
        }
        if (!useJpegtran && r == null) {
            throw new UnsupportedOperationException("jpegtran must be installed for this operation");
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File losslessCrop(String filename, Rectangle cropTo) {
        File r = null;
        if (!GalleryFileFilter.canManipulateJpeg(filename)) {
            throw new UnsupportedOperationException("jpegtran doesn't support cropping anything but jpeg");
        }
        if (useJpegtran) {
            File orig = null;
            File dest = null;
            try {
                if (GalleryRemote.IS_MAC_OS_X) {
                    orig = new File(filename);
                    dest = ImageUtils.deterministicTempFile("tmp", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + cropTo);
                    orig.renameTo(dest);
                    filename = dest.getPath();
                }
                r = ImageUtils.jpegtranExec(filename, "-crop", cropTo.width + "x" + cropTo.height + "+" + cropTo.x + "+" + cropTo.y, true);
            }
            finally {
                if (orig != null && dest != null) {
                    dest.renameTo(orig);
                }
            }
        }
        if (!useJpegtran && r == null) {
            throw new UnsupportedOperationException("jpegtran with CROP PATCH must be installed for this operation");
        }
        return r;
    }

    private static File jpegtranExec(String filename, String arg1, String arg2, boolean crop) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(jpegtranPath);
        cmd.add("-copy");
        cmd.add("all");
        cmd.add(arg1);
        cmd.add(arg2);
        File r = ImageUtils.deterministicTempFile(crop ? "crop" : "rot", "." + GalleryFileFilter.getExtension(filename), tmpDir, filename + arg1 + arg2);
        toDelete.add(r);
        cmd.add("-outfile");
        cmd.add(r.getPath());
        cmd.add(filename);
        int exitValue = ImageUtils.exec(cmd.toArray(new String[0]));
        if (exitValue != 0 && !jpegtranIgnoreErrorCode || !r.exists()) {
            if (exitValue != -1 && !r.exists()) {
                if (crop) {
                    Log.log(0, MODULE, "jpegtran doesn't seem to be working for cropping. Disabling");
                    ImageUtils.stopUsingJpegtranCrop();
                } else {
                    Log.log(0, MODULE, "jpegtran doesn't seem to be working. Disabling");
                    ImageUtils.stopUsingJpegtran();
                }
            }
            r = null;
        }
        return r;
    }

    public static Image rotateImage(Image thumb, int angle, boolean flipped, Component c) {
        if (angle != 0 || flipped) {
            int height1;
            int width1;
            int width = thumb.getWidth(c);
            int height = thumb.getHeight(c);
            if (angle % 2 == 0) {
                width1 = width;
                height1 = height;
            } else {
                width1 = height;
                height1 = width;
            }
            BufferedImage vImg = (BufferedImage)c.createImage(width1, height1);
            Graphics2D g = (Graphics2D)vImg.getGraphics();
            AffineTransform transform = ImageUtils.getRotationTransform(width, height, angle, flipped);
            g.drawImage(thumb, transform, c);
            thumb = vImg;
        }
        return thumb;
    }

    public static AffineTransform getRotationTransform(int width, int height, int angle, boolean flipped) {
        if (angle != 0 || flipped) {
            int height1;
            int width1;
            if (angle % 2 == 0) {
                width1 = width;
                height1 = height;
            } else {
                width1 = height;
                height1 = width;
            }
            AffineTransform transform = AffineTransform.getTranslateInstance(width / 2, height / 2);
            if (angle != 0) {
                transform.rotate((double)angle * Math.PI / 2.0);
            }
            if (flipped) {
                transform.scale(-1.0, 1.0);
            }
            transform.translate(-width1 / 2 - (angle == 3 ? width - width1 : 0) + (flipped ? width - width1 : 0) * (angle == 1 ? -1 : 1), -height1 / 2 - (angle == 1 ? height - height1 : 0));
            return transform;
        }
        return null;
    }

    public static AffineTransform createTransform(Rectangle container, Rectangle contentResized, Dimension content, int angle, boolean flipped) {
        double scale = Math.sqrt(1.0f * (float)content.width * (float)content.height / (float)contentResized.width / (float)contentResized.height);
        AffineTransform transform = new AffineTransform();
        transform.translate(content.width / 2, content.height / 2);
        if (flipped) {
            transform.scale(-scale, scale);
        } else {
            transform.scale(scale, scale);
        }
        if (angle != 0) {
            transform.rotate((double)(-angle) * Math.PI / 2.0);
        }
        transform.translate(-container.width / 2, -container.height / 2);
        return transform;
    }

    public static LocalInfo getLocalFilenameForPicture(Picture p, boolean full) {
        Dimension d;
        URL u;
        if (!full && p.getSizeResized() == null) {
            return null;
        }
        if (full) {
            u = p.safeGetUrlFull();
            d = p.safeGetSizeFull();
        } else {
            u = p.getUrlResized();
            d = p.getSizeResized();
        }
        String uid = p.getUniqueId();
        String ext = p.getForceExtension();
        if (uid == null || ext == null) {
            uid = u.getPath();
            int i = uid.lastIndexOf(47);
            uid = uid.substring(i + 1);
            i = uid.lastIndexOf(46);
            ext = uid.substring(i + 1);
            uid = uid.substring(0, i);
        }
        String filename = uid + "." + ext;
        return new LocalInfo(ext, filename, ImageUtils.deterministicTempFile("server", "." + ext, tmpDir, uid + d), u, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(Picture p, Dimension d, StatusUpdate su, CancellableTransferListener tl) {
        String filename;
        File f;
        URL pictureUrl;
        Object resizedInfo;
        if (!p.isOnline()) {
            return p.getSource();
        }
        LocalInfo fullInfo = ImageUtils.getLocalFilenameForPicture(p, true);
        boolean stop = false;
        if (p.getSizeResized() != null) {
            resizedInfo = ImageUtils.getLocalFilenameForPicture(p, false);
            if ((d.width > p.getSizeResized().width || d.height > p.getSizeResized().height || fullInfo.file.exists()) && !GalleryRemote._().properties.getBooleanProperty("slideshowLowRez")) {
                pictureUrl = fullInfo.url;
                f = fullInfo.file;
                filename = fullInfo.filename;
            } else {
                pictureUrl = ((LocalInfo)resizedInfo).url;
                f = ((LocalInfo)resizedInfo).file;
                filename = ((LocalInfo)resizedInfo).filename;
            }
        } else {
            pictureUrl = fullInfo.url;
            f = fullInfo.file;
            filename = fullInfo.filename;
        }
        Log.log(3, MODULE, "Going to download " + pictureUrl);
        try {
            resizedInfo = p;
            synchronized (resizedInfo) {
                int l;
                if (f.exists()) {
                    Log.log(3, MODULE, filename + " already existed: no need to download it again");
                    return f;
                }
                long start = System.currentTimeMillis();
                URLConnection conn = ImageUtils.openUrlConnection(pictureUrl, p);
                int size = conn.getContentLength();
                su.startProgress(1, 0, size, GRI18n.getString(MODULE, "down.start", new Object[]{filename}), false);
                Log.log(3, MODULE, "Saving " + p + " to " + f.getPath());
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buffer = new byte[2048];
                int dl = 0;
                long t = -1L;
                while (!stop && (l = in.read(buffer)) != -1) {
                    out.write(buffer, 0, l);
                    dl += l;
                    long now = System.currentTimeMillis();
                    if (t != -1L && now - t > 1000L) {
                        su.updateProgressValue(1, dl);
                        int speed = (int)((long)dl / (now - start) * 1000L / 1024L);
                        su.updateProgressStatus(1, GRI18n.getString(MODULE, "down.progress", new Object[]{filename, new Integer(dl / 1024), new Integer(size / 1024), new Integer(speed)}));
                        t = now;
                    }
                    if (t == -1L) {
                        t = now;
                    }
                    if (tl == null) continue;
                    stop = !tl.dataTransferred(dl, size, 0.0, p);
                }
                in.close();
                out.flush();
                out.close();
                if (stop) {
                    Log.log(3, MODULE, "Stopped downloading " + p);
                    f.delete();
                } else {
                    Log.log(3, MODULE, "Downloaded " + p + " (" + dl + ") in " + (System.currentTimeMillis() - start) / 1000L + "s");
                    toDelete.add(f);
                }
            }
            su.stopProgress(1, GRI18n.getString(MODULE, "down.end", new Object[]{filename}));
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            f = null;
            su.stopProgress(1, "Downloading " + p + " failed");
        }
        if (stop) {
            return null;
        }
        return f;
    }

    public static URLConnection openUrlConnection(URL pictureUrl, Picture p) throws IOException {
        URLConnection conn = pictureUrl.openConnection();
        conn.setDefaultUseCaches(false);
        String userAgent = p.getAlbumOnServer().getGallery().getUserAgent();
        if (userAgent != null) {
            conn.setRequestProperty("User-Agent", userAgent);
        }
        conn.addRequestProperty("Referer", p.getAlbumOnServer().getGallery().getGalleryUrl("").toString());
        Cookie[] cookies = CookieModule.listAllCookies();
        for (int i = 0; i < cookies.length; ++i) {
            conn.addRequestProperty("Cookie", cookies[i].toString());
        }
        conn.connect();
        return conn;
    }

    public static Dimension getPictureDimension(Picture p) {
        if (p.isOnline()) {
            return null;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(p.getSource());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            reader.setInput(iis, true, false);
            Dimension d = new Dimension(reader.getWidth(0), reader.getHeight(0));
            iis.close();
            reader.dispose();
            return d;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return null;
        }
    }

    public static void purgeTemp() {
        Iterator it = toDelete.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            file.delete();
        }
    }

    public static Dimension getSizeKeepRatio(Dimension source, Dimension target, boolean noStretch) {
        if (noStretch && target.width > source.width && target.height > source.height) {
            return null;
        }
        Dimension result = new Dimension();
        float sourceRatio = Math.abs((float)source.width / (float)source.height);
        float targetRatio = Math.abs((float)target.width / (float)target.height);
        if (Math.abs(targetRatio) > Math.abs(sourceRatio)) {
            result.height = target.height;
            result.width = (int)((float)target.height * sourceRatio * (float)(target.height * target.width > 0 ? 1 : -1));
        } else {
            result.width = target.width;
            result.height = (int)((float)target.width / sourceRatio * (float)(target.height * target.width > 0 ? 1 : -1));
        }
        return result;
    }

    public static float getRatio(Dimension source, Dimension target) {
        float heightRatio = (float)target.height / (float)source.height;
        float widthRatio = (float)target.width / (float)source.width;
        if (heightRatio > widthRatio) {
            return widthRatio;
        }
        return heightRatio;
    }

    public static File deterministicTempFile(String prefix, String suffix, File directory, String hash) {
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        return new File(directory, prefix + hash.hashCode() + suffix);
    }

    public static ExifData getExifData(String filename) {
        try {
            Class<?> c = Class.forName("com.gallery.GalleryRemote.util.ExifImageUtils");
            Method m = c.getMethod("getExifData", String.class);
            return (ExifData)m.invoke(null, filename);
        }
        catch (Throwable e) {
            Log.log(1, MODULE, "Exif library is not installed.");
            return null;
        }
    }

    public static boolean isExifAvailable() {
        if (exifAvailable == null) {
            try {
                Class<?> c = Class.forName("com.gallery.GalleryRemote.util.ExifImageUtils");
                c.getMethod("getExifData", String.class);
                exifAvailable = Boolean.TRUE;
            }
            catch (Throwable e) {
                Log.log(1, MODULE, "Exif library is not installed.");
                exifAvailable = Boolean.FALSE;
            }
        }
        return exifAvailable;
    }

    public static List expandDirectories(List filesAndFolders) throws IOException {
        ArrayList<File> allFilesList = new ArrayList<File>();
        Iterator iter = filesAndFolders.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (f.isDirectory()) {
                allFilesList.addAll(ImageUtils.listFilesRecursive(f));
                continue;
            }
            allFilesList.add(f);
        }
        return allFilesList;
    }

    public static List listFilesRecursive(File dir) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        if (fileArray == null) {
            if (dir.isDirectory()) {
                throw new IOException("i/o exception listing directory: " + dir.getPath());
            }
            Log.log(0, MODULE, "assertion failed: listFilesRecursive called on a non-dir file");
            return ret;
        }
        List<File> files = Arrays.asList(fileArray);
        Iterator<File> iter = files.iterator();
        while (iter.hasNext()) {
            File f = iter.next();
            if (f.isDirectory()) {
                ret.addAll(ImageUtils.listFilesRecursive(f));
                continue;
            }
            ret.add(f);
        }
        return ret;
    }

    public static int exec(String cmdline) {
        return ImageUtils.exec(cmdline, null);
    }

    public static int exec(String cmdline, StringBuffer output) {
        Log.log(3, MODULE, "Executing " + cmdline);
        try {
            Process p = Runtime.getRuntime().exec(cmdline);
            return ImageUtils.pumpExec(p, output);
        }
        catch (InterruptedException e) {
            Log.logException(1, MODULE, e);
            return -1;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return 1;
        }
    }

    public static int exec(String[] cmd) {
        return ImageUtils.exec(cmd, null);
    }

    public static int exec(String[] cmd, StringBuffer output) {
        Log.log(3, MODULE, "Executing " + Arrays.asList(cmd));
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return ImageUtils.pumpExec(p, output);
        }
        catch (InterruptedException e) {
            Log.logException(1, MODULE, e);
            return -1;
        }
        catch (IOException e) {
            Log.logException(1, MODULE, e);
            return 1;
        }
    }

    private static int pumpExec(Process p, StringBuffer output) throws InterruptedException, IOException {
        String line;
        DataInputStream out = new DataInputStream(new BufferedInputStream(p.getInputStream()));
        DataInputStream err = new DataInputStream(new BufferedInputStream(p.getErrorStream()));
        int exitValue = p.waitFor();
        while ((line = out.readLine()) != null) {
            Log.log(3, MODULE, "Out: " + line);
            if (output == null) continue;
            output.append(line).append("\n");
        }
        while ((line = err.readLine()) != null) {
            Log.log(3, MODULE, "Err: " + line);
        }
        Log.log(3, MODULE, "Returned with value " + exitValue);
        return exitValue;
    }

    public static void deferredTasks() {
        if (deferredStopUsingIM) {
            deferredStopUsingIM = false;
            ImageUtils.stopUsingIM();
        }
        if (deferredStopUsingJpegtran) {
            deferredStopUsingJpegtran = false;
            ImageUtils.stopUsingJpegtran();
        }
        if (deferredStopUsingJpegtranCrop) {
            deferredStopUsingJpegtranCrop = false;
            ImageUtils.stopUsingJpegtranCrop();
        }
        if (deferredOutOfMemory) {
            deferredOutOfMemory = false;
            ImageUtils.outOfMemoryError();
        }
    }

    static void stopUsingIM() {
        useIM = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningIM", false)) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextIM"), GRI18n.getString(MODULE, "warningUrlIM"), GRI18n.getString(MODULE, "warningUrlTextIM"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningIM", true);
                }
            } else {
                deferredStopUsingIM = true;
            }
        }
    }

    static boolean stopUsingJavaResize() {
        boolean useJavaResize;
        UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJava"), null, null, GRI18n.getString(MODULE, "useJava"), GRI18n.getString(MODULE, "dontUseJava"));
        boolean bl = useJavaResize = md.getButtonChosen() == 1;
        if (md.dontShow()) {
            GalleryRemote._().properties.setBooleanProperty("suppressWarningJava", true);
            GalleryRemote._().properties.setBooleanProperty("useJavaResize", useJavaResize);
        }
        return !useJavaResize;
    }

    static void stopUsingJpegtran() {
        useJpegtran = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJpegtran", false)) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJpegtran"), GRI18n.getString(MODULE, "warningUrlJpegtran"), GRI18n.getString(MODULE, "warningUrlTextJpegtran"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningJpegtran", true);
                }
            } else {
                deferredStopUsingJpegtran = true;
            }
        }
    }

    static void stopUsingJpegtranCrop() {
        useJpegtranCrop = false;
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningJpegtranCrop", false)) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextJpegtranCrop"), GRI18n.getString(MODULE, "warningUrlJpegtranCrop"), GRI18n.getString(MODULE, "warningUrlTextJpegtranCrop"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningJpegtranCrop", true);
                }
            } else {
                deferredStopUsingJpegtranCrop = true;
            }
        }
    }

    static void outOfMemoryError() {
        if (!GalleryRemote._().properties.getBooleanProperty("suppressWarningOutOfMemory", false)) {
            if (GalleryRemote._().getMainFrame() != null && GalleryRemote._().getMainFrame().isVisible()) {
                UrlMessageDialog md = new UrlMessageDialog(GRI18n.getString(MODULE, "warningTextOutOfMemory"), GRI18n.getString(MODULE, "warningUrlOutOfMemory"), GRI18n.getString(MODULE, "warningUrlTextOutOfMemory"));
                if (md.dontShow()) {
                    GalleryRemote._().properties.setBooleanProperty("suppressWarningOutOfMemory", true);
                }
            } else {
                deferredOutOfMemory = true;
            }
        }
    }

    public static void displayMetadata(Node root) {
        ImageUtils.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageUtils.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                ImageUtils.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            ImageUtils.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight, Object hint) {
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D g = scaledBI.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    static {
        GalleryProperties p;
        PropertiesFile pt;
        toDelete = new ArrayList();
        totalTime = 0L;
        totalIter = 0;
        useIM = false;
        imPath = null;
        jpegQuality = 75;
        imIgnoreErrorCode = false;
        useJpegtran = false;
        useJpegtranCrop = false;
        jpegtranPath = null;
        jpegtranIgnoreErrorCode = false;
        tmpDir = null;
        filterName = new String[3];
        format = new String[3];
        defaultThumbnail = null;
        unrecognizedThumbnail = null;
        deferredStopUsingIM = false;
        deferredStopUsingJpegtran = false;
        deferredStopUsingJpegtranCrop = false;
        deferredOutOfMemory = false;
        observer = new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return false;
            }
        };
        tmpDir = new File(System.getProperty("java.io.tmpdir"), "thumbs-" + System.getProperty("user.name"));
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        Log.log(2, MODULE, "tmpDir: " + tmpDir.getPath());
        try {
            pt = new File("imagemagick/im.properties").exists() ? new PropertiesFile("imagemagick/im") : new PropertiesFile("im");
            pt.read();
            p = new GalleryProperties(pt);
            GalleryRemote._().defaults.copyProperties(p);
            p = GalleryRemote._().properties;
            useIM = p.getBooleanProperty("im.enabled");
            Log.log(2, MODULE, "useIM: " + useIM);
            if (useIM) {
                imPath = p.getProperty("im.convertPath");
                Log.log(2, MODULE, "imPath: " + imPath);
                imIgnoreErrorCode = p.getBooleanProperty("im.ignoreErrorCode", imIgnoreErrorCode);
                Log.log(2, MODULE, "imIgnoreErrorCode: " + imIgnoreErrorCode);
                if (imPath.indexOf(47) == -1 && imPath.indexOf(92) == -1 && System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
                    StringBuffer output = new StringBuffer();
                    int retval = ImageUtils.exec("reg query HKLM\\Software\\ImageMagick\\Current /v BinPath", output);
                    if (retval == 0) {
                        Pattern pat = Pattern.compile("^\\s*BinPath\\s*REG_SZ\\s*(.*)", 10);
                        Matcher m = pat.matcher(output.toString());
                        if (m.find()) {
                            imPath = m.group(1) + "\\" + imPath;
                            if (!imPath.endsWith(".exe")) {
                                imPath = imPath + ".exe";
                            }
                            Log.log(2, MODULE, "Found ImageMagick in registry. imPath is now " + imPath);
                        }
                    } else {
                        File tempFile = File.createTempFile("gr_regdump", null);
                        retval = ImageUtils.exec("regedit /E \"" + tempFile.getPath() + "\" \"HKEY_LOCAL_MACHINE\\Software\\ImageMagick\\Current\"", output);
                        if (retval == 0) {
                            String line;
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "UTF-16"));
                            Pattern pat = Pattern.compile("^\\\"BinPath\\\"=\\\"(.*)\\\"", 2);
                            while ((line = br.readLine()) != null) {
                                Matcher m = pat.matcher(line);
                                if (!m.find()) continue;
                                imPath = m.group(1) + "\\" + imPath;
                                if (!imPath.endsWith(".exe")) {
                                    imPath = imPath + ".exe";
                                }
                                Log.log(2, MODULE, "Found ImageMagick in registry. imPath is now " + imPath);
                                break;
                            }
                            br.close();
                        }
                        tempFile.delete();
                    }
                }
                if (imPath.indexOf(47) == -1 && imPath.indexOf(92) == -1) {
                    Log.log(0, MODULE, "ImageMagick path is not fully qualified, presence won't be tested until later");
                } else if (!new File(imPath).exists()) {
                    Log.log(0, MODULE, "Can't find ImageMagick Convert at the above path");
                    ImageUtils.stopUsingIM();
                }
            }
            if (useIM) {
                ImageUtils.filterName[0] = p.getProperty("im.thumbnailResizeFilter");
                ImageUtils.filterName[1] = p.getProperty("im.previewResizeFilter");
                ImageUtils.filterName[2] = p.getProperty("im.uploadResizeFilter");
                if (filterName[2] == null) {
                    ImageUtils.filterName[2] = filterName[1];
                }
                ImageUtils.format[0] = p.getProperty("im.thumbnailResizeFormat", "gif");
                ImageUtils.format[1] = p.getProperty("im.previewResizeFormat", "jpg");
                ImageUtils.format[2] = null;
            }
            jpegQuality = p.getIntProperty("im.jpegQuality", jpegQuality);
        }
        catch (Exception e) {
            Log.logException(0, MODULE, e);
            ImageUtils.stopUsingIM();
        }
        defaultThumbnail = ImageUtils.loadJava(ImageUtils.class.getResource("/default.gif"), GalleryRemote._().properties.getThumbnailSize(), true);
        unrecognizedThumbnail = ImageUtils.loadJava(ImageUtils.class.getResource("/default.gif"), GalleryRemote._().properties.getThumbnailSize(), true);
        try {
            pt = new File("jpegtran/jpegtran.properties").exists() ? new PropertiesFile("jpegtran/jpegtran") : new PropertiesFile("jpegtran");
            pt.read();
            p = new GalleryProperties(pt);
            GalleryRemote._().defaults.copyProperties(p);
            p = GalleryRemote._().properties;
            useJpegtran = p.getBooleanProperty("jp.enabled");
            useJpegtranCrop = p.getBooleanProperty("jp.crop.enabled");
            Log.log(2, MODULE, "useJpegtran: " + useJpegtran);
            if (useJpegtran) {
                jpegtranPath = p.getProperty("jp.path");
                Log.log(2, MODULE, "jpegtranPath: " + jpegtranPath);
                jpegtranIgnoreErrorCode = p.getBooleanProperty("jp.ignoreErrorCode", jpegtranIgnoreErrorCode);
                Log.log(2, MODULE, "jpegtranIgnoreErrorCode: " + jpegtranIgnoreErrorCode);
                if (jpegtranPath.indexOf(47) == -1 && jpegtranPath.indexOf(92) == -1) {
                    Log.log(0, MODULE, "jpegtran path is not fully qualified, presence won't be tested until later");
                }
                if (!new File(jpegtranPath).exists()) {
                    Log.log(0, MODULE, "Can't find jpegtran at the above path");
                    ImageUtils.stopUsingJpegtran();
                }
            }
        }
        catch (Exception e) {
            Log.logException(0, MODULE, e);
            ImageUtils.stopUsingJpegtran();
        }
        exifAvailable = null;
    }

    public static class AngleFlip {
        public int angle = 0;
        public boolean flip = false;

        public AngleFlip(int angle, boolean flip) {
            this.angle = angle;
            this.flip = flip;
        }
    }

    static class LocalInfo {
        String ext;
        String filename;
        File file;
        URL url;
        Dimension size;

        public LocalInfo(String ext, String filename, File file, URL url, Dimension size) {
            this.ext = ext;
            this.filename = filename;
            this.file = file;
            this.url = url;
            this.size = size;
        }
    }
}

