#! /usr/local/Gambit-C/bin/gsi-script

; File: "web-repl.scm", Time-stamp: <2006-09-19 14:45:02 feeley>

; Copyright (C) 2004-2006 by Marc Feeley, All Rights Reserved.

(define (ide-repl-pump ide-repl-connection in-port out-port)

  (define m (make-mutex))

  (define (process-input)
    (let loop ()
      (let ((c (read-char ide-repl-connection)))
        (if (char? c)
            (begin
              (mutex-lock! m)
              (write-char c out-port)
              (force-output out-port)
              (mutex-unlock! m)
              (loop))))))

  (define (process-output)
    (let loop ()
      (let ((c (read-char in-port)))
        (if (char? c)
            (begin
              (mutex-lock! m)
              (write-char c ide-repl-connection)
              (force-output ide-repl-connection)
              (mutex-unlock! m)
              (loop))))))

  (thread-start! (make-thread process-input))
  (thread-start! (make-thread process-output)))

(define (make-ide-repl-ports ide-repl-connection)
  (receive (in-rd-port in-wr-port) (open-string-pipe '(direction: input))
    (receive (out-wr-port out-rd-port) (open-string-pipe '(direction: output))
      (begin
        (ide-repl-pump ide-repl-connection out-rd-port in-wr-port)
        (values in-rd-port out-wr-port)))))

(define (setup-ide-repl-channel ide-repl-connection)
  (receive (in-port out-port) (make-ide-repl-ports ide-repl-connection)
    (let ((repl-channel (##make-repl-channel-ports in-port out-port)))
      (set! ##thread-make-repl-channel (lambda () repl-channel)))))

(define (start-ide-repl)
  (##repl-debug-main))

(define (start-ide-repl-in-new-thread)
  (thread-start! (make-thread start-ide-repl)))

(define repl-server-port 7000)

(define (start-repl-server)
  (let ((server
         (open-tcp-server
          (list port-number: repl-server-port
                reuse-address: #t))))
    (let loop ()
      (let ((ide-repl-connection (read server)))
        (setup-ide-repl-channel ide-repl-connection)
        (start-ide-repl)
;        (start-ide-repl-in-new-thread)
        (loop)))))

(start-repl-server)
