import sys
import os
import gobject
import gtk

from gapti.GladeDialog import GladeDialog

class SubscriptionConfirmDialog(GladeDialog):
    
    def __init__(self, path, domain=None):
        """Dialog asking the user if they are sure they want to subscribe to
           an offered Apt Channel."""
        root = 'confirm_dialog'
        GladeDialog.__init__(self, path, root, domain)
        
        # Cancel button.
        gtk.Dialog.add_button(self, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
        
        # Add button.
        self.add_button = gtk.Button(stock=gtk.STOCK_ADD)
        self.add_button.show()
        self.add_button.set_sensitive(False)
        gtk.Dialog.add_action_widget(self, self.add_button, gtk.RESPONSE_ACCEPT)
        
    def set_provider(self, provider):
        """Sets the text in the provider Gtk.Label."""
        self.provider_label.set_text(provider)
        
    def run(self):
        countdown = 3    
        self.countdown_n = countdown
        gobject.timeout_add(1000, self.countdown_cb)
        return gtk.Dialog.run(self)
        
    def countdown_cb(self):
        """Invoked on a timer of one second. Sets the add button sensitive when
        the count hits 0."""
        if self.countdown_n <= 0:
            self.add_button.set_sensitive(True)
            return False
        else:
            self.add_button.set_sensitive(False)
            self.countdown_n = self.countdown_n - 1
            return True
        
gobject.type_register(SubscriptionConfirmDialog)