package GCPlugins::GCfilms::GCFilmAffinityES;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginFilmAffinityES;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if (($tagname eq 'a') && 
                   ($attr->{href} =~ /\/es\/addreview.php\?movie_id=([0-9]*)/))
                {
                    $self->{hasUrl} = 'film'.$1.'.html';
                }
            }
            elsif (!$self->{isMovie} &&
                ($tagname eq 'a') && 
                ($attr->{href} =~ /^\/es\/(film.*)$/))
			{
                my $url = $1;
                $self->{isMovie} = 1;
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
            }
            elsif (($tagname eq 'span') && 
                   ($attr->{style} eq 'font-size: 10px; color:#666666'))
            {
                $self->{isDirector} = 1;
            }
            elsif (($tagname eq 'div') && 
                   ($attr->{style} eq 'font-size: 10px'))
            {
                $self->{isActors} = 1;
            }
        }
        else
        {
            if (($tagname eq 'span') && 
                ($attr->{style} eq 'color:#990000; font-size:16; font-weight: bold;'))
            {
                $self->{isTitle} = 1;
            }
            elsif ($tagname eq 'img')
            {
                if ($attr->{src} =~ /^\/imgs\/countries/)
                {
                    $self->{curInfo}->{country} = $attr->{alt};
                }
                elsif ($attr->{src} =~ /filmaffinity\.com\/imgs\/movies\/full/)
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub adjustSynopsis
    {
        my ($self, $synopsis) = @_;
        $synopsis =~ s/(SINOPSIS:\s|\s\(FILMAFFINITY\))//g;
        $synopsis =~ s/(SINOPSIS CORTA:\s|\s\(FILMAFFINITY\))//g;
        $synopsis =~ s/(SINOPSIS LARGA:\s|\s\(FILMAFFINITY\))//g;

        return $synopsis;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if ($self->{hasUrl})
                {
                    $self->{itemsList}[0]->{url} = $self->{hasUrl};
                    $self->{hasUrl} = 0;
                }
                return;
            }
            if ($self->{inside}->{title} && ($origtext !~ /^Busqueda de /))
            {
                $self->{parsingEnded} = 1;
                $self->{hasUrl} = 0;
                $self->{itemIdx} = 0;
            }
            elsif ($self->{isMovie})
            {
                return if $origtext !~ /\w/;
                return if $origtext eq 'Añadir a listas';
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isMovie} = 0;
                $self->{isTitle} = 1;
            }
            elsif ($self->{isTitle})
            {
                (my $year = $origtext) =~ s/\s*\(([0-9]{4})\)\s*/$1/;
                $self->{itemsList}[$self->{itemIdx}]->{date} = $year;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isDirector})
            {
                $self->{itemsList}[$self->{itemIdx}]->{director} = $origtext;
                $self->{isDirector} = 0;
            }
            elsif ($self->{isActors})
            {
                $self->{itemsList}[$self->{itemIdx}]->{actors} = $origtext;
                $self->{isActors} = 0;
            }
        }
        else
        {
            $origtext =~ s/^\s*//;
                 
            return if (!$origtext || $origtext eq 'Más información');       
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isOrig})
            {
                $self->{curInfo}->{original} = $origtext;
                $self->{isOrig} = 0;   
            }
            elsif ($self->{isDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{isDate} = 0;   
            }
            elsif ($self->{isTime})
            {
                $self->{curInfo}->{time} = $origtext;
                $self->{isTime} = 0;   
            }
            elsif ($self->{isDirector})
            {
                $self->{curInfo}->{director} = $origtext;
                $self->{isDirector} = 0;   
            }
            elsif ($self->{isActors})
            {
                if ($self->{inside}->{a} && $origtext)
                {
                    $self->{curInfo}->{actors} .= $origtext.', ';
                }
            }
            elsif ($self->{isDescription})
            {
                my $origtextback = $origtext;
                my @arrayFinal;

                $self->{curInfo}->{synopsis} = $origtext;
                $origtext =~ /^(.*?)\/(.*?)\/(.*?)$/ms;
                if (! $1)
                {
                    $origtextback =~ /^(.*?)\/(.*?)$/ms;
                    $self->{curInfo}->{genre} = $1;
                    @arrayFinal = ($self->adjustSynopsis($2));
                }
                else
                {
                    $self->{curInfo}->{genre} = $2;
                    @arrayFinal = ($self->adjustSynopsis($3),'---------------', $1);
                }
                $self->{curInfo}->{synopsis} = join("\n\n",@arrayFinal);
                $self->{curInfo}->{genre} =~ s/\.\s*/,/g;
                $self->{curInfo}->{synopsis} =~ s/^\s+//;
                $self->{isDescription} = 0;
            }
            
            if ($self->{inside}->{b})
            {
                if ($origtext eq 'TITULO ORIGINAL')
                {
                    $self->{isOrig} = 1;
                }
                elsif ($origtext eq 'AÑO')
                {
                    $self->{isDate} = 1;
                }
                elsif ($origtext eq 'DURACIÓN')
                {
                    $self->{isTime} = 1;
                }
                elsif ($origtext eq 'DIRECTOR')
                {
                    $self->{isDirector} = 1;
                }
                elsif ($origtext eq 'REPARTO')
                {
                    $self->{isActors} = 1;
                }
                elsif ($origtext eq 'PRODUCTORA')
                {
                    $self->{curInfo}->{actors} =~ s/,\s*$//g;
                    $self->{curInfo}->{actors} =~ s/, PRODUCTORA//;
                    $self->{isActors} = 0;
                }
                elsif ($origtext eq 'GÉNERO Y CRÍTICA')
                {
                    $self->{isDescription} = 1;
                }
            }
            
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 1,
            actors => 1,
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $self->{parsingEnded} = 0;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.filmaffinity.com/es/search.php?stext=$word&stype=title";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.filmaffinity.com/es/'.$url;
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "Film affinity (ES)";
    }
    
    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }

    sub getAuthor
    {
        return 'Tian && PIN';
    }
    
    sub getLang
    {
        return 'ES';
    }
}

1;
