/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace OSGeo.OGR {

using System;
using System.Runtime.InteropServices;

public class Geometry : IDisposable {
  private HandleRef swigCPtr;
  protected object swigCMemOwner;

  internal Geometry(IntPtr cPtr, object cMemoryOwner) {
    swigCMemOwner = cMemoryOwner;
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(Geometry obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }
  internal static HandleRef getCPtrAndDisown(Geometry obj, object cMemoryOwner) {
    obj.swigCMemOwner = cMemoryOwner;
    return getCPtr(obj);
  }

  ~Geometry() {
    Dispose();
  }

  public virtual void Dispose() {
  lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwner == null) {
        swigCMemOwner = new object();
        ogrPINVOKE.delete_Geometry(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
    }
  }
public int ExportToWkb( byte[] buffer, int byte_order ) {
      int retval;
      int size = WkbSize();
      if (buffer.Length < size)
        throw new ArgumentException("Buffer size is small (ExportToWkb)");
        
      IntPtr ptr = Marshal.AllocHGlobal(size * Marshal.SizeOf(buffer[0]));
      try {
          retval = ExportToWkb(size, ptr, byte_order);
          Marshal.Copy(ptr, buffer, 0, size);
      } finally {
          Marshal.FreeHGlobal(ptr);
      }
      GC.KeepAlive(this);
      return retval;
  }
  public int ExportToWkb( byte[] buffer ) {
      return ExportToWkb( buffer, ogr.wkbXDR);
  }
  public Geometry(int type, string wkt, int wkb, string wkb_buf, string gml) : this(ogrPINVOKE.new_Geometry(type, wkt, wkb, wkb_buf, gml), null) {
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public int ExportToWkt(out string argout) {
    int ret = ogrPINVOKE.Geometry_ExportToWkt(swigCPtr, out argout);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public string ExportToGML() {
    string ret = ogrPINVOKE.Geometry_ExportToGML(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void AddPoint(double x, double y, double z) {
    ogrPINVOKE.Geometry_AddPoint(swigCPtr, x, y, z);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public int AddGeometryDirectly(Geometry other) {
    int ret = ogrPINVOKE.Geometry_AddGeometryDirectly(swigCPtr, Geometry.getCPtrAndDisown(other, this));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int AddGeometry(Geometry other) {
    int ret = ogrPINVOKE.Geometry_AddGeometry(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry Clone() {
    IntPtr cPtr = ogrPINVOKE.Geometry_Clone(swigCPtr);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int GetGeometryType() {
    int ret = ogrPINVOKE.Geometry_GetGeometryType(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public string GetGeometryName() {
    string ret = ogrPINVOKE.Geometry_GetGeometryName(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public double GetArea() {
    double ret = ogrPINVOKE.Geometry_GetArea(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int GetPointCount() {
    int ret = ogrPINVOKE.Geometry_GetPointCount(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public double GetX(int point) {
    double ret = ogrPINVOKE.Geometry_GetX(swigCPtr, point);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public double GetY(int point) {
    double ret = ogrPINVOKE.Geometry_GetY(swigCPtr, point);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public double GetZ(int point) {
    double ret = ogrPINVOKE.Geometry_GetZ(swigCPtr, point);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int GetGeometryCount() {
    int ret = ogrPINVOKE.Geometry_GetGeometryCount(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void SetPoint(int point, double x, double y, double z) {
    ogrPINVOKE.Geometry_SetPoint(swigCPtr, point, x, y, z);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public Geometry GetGeometryRef(int geom) {
    IntPtr cPtr = ogrPINVOKE.Geometry_GetGeometryRef(swigCPtr, geom);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, false? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry GetBoundary() {
    IntPtr cPtr = ogrPINVOKE.Geometry_GetBoundary(swigCPtr);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry ConvexHull() {
    IntPtr cPtr = ogrPINVOKE.Geometry_ConvexHull(swigCPtr);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry Buffer(double distance, int quadsecs) {
    IntPtr cPtr = ogrPINVOKE.Geometry_Buffer(swigCPtr, distance, quadsecs);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry Intersection(Geometry other) {
    IntPtr cPtr = ogrPINVOKE.Geometry_Intersection(swigCPtr, Geometry.getCPtr(other));
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry Union(Geometry other) {
    IntPtr cPtr = ogrPINVOKE.Geometry_Union(swigCPtr, Geometry.getCPtr(other));
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry Difference(Geometry other) {
    IntPtr cPtr = ogrPINVOKE.Geometry_Difference(swigCPtr, Geometry.getCPtr(other));
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public Geometry SymmetricDifference(Geometry other) {
    IntPtr cPtr = ogrPINVOKE.Geometry_SymmetricDifference(swigCPtr, Geometry.getCPtr(other));
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public double Distance(Geometry other) {
    double ret = ogrPINVOKE.Geometry_Distance(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void Empty() {
    ogrPINVOKE.Geometry_Empty(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public bool Intersect(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Intersect(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Equal(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Equal(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Disjoint(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Disjoint(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Touches(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Touches(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Crosses(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Crosses(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Within(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Within(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Contains(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Contains(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public bool Overlaps(Geometry other) {
    bool ret = ogrPINVOKE.Geometry_Overlaps(swigCPtr, Geometry.getCPtr(other));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int TransformTo(SpatialReference reference) {
    int ret = ogrPINVOKE.Geometry_TransformTo(swigCPtr, SpatialReference.getCPtr(reference));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int Transform(CoordinateTransformation trans) {
    int ret = ogrPINVOKE.Geometry_Transform(swigCPtr, CoordinateTransformation.getCPtr(trans));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public SpatialReference GetSpatialReference() {
    IntPtr cPtr = ogrPINVOKE.Geometry_GetSpatialReference(swigCPtr);
    SpatialReference ret = (cPtr == IntPtr.Zero) ? null : new SpatialReference(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void AssignSpatialReference(SpatialReference reference) {
    ogrPINVOKE.Geometry_AssignSpatialReference(swigCPtr, SpatialReference.getCPtr(reference));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public void CloseRings() {
    ogrPINVOKE.Geometry_CloseRings(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public void FlattenTo2D() {
    ogrPINVOKE.Geometry_FlattenTo2D(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public void GetEnvelope(Envelope env) {
    ogrPINVOKE.Geometry_GetEnvelope(swigCPtr, Envelope.getCPtr(env));
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public Geometry Centroid() {
    IntPtr cPtr = ogrPINVOKE.Geometry_Centroid(swigCPtr);
    Geometry ret = (cPtr == IntPtr.Zero) ? null : new Geometry(cPtr, true? null : this);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int WkbSize() {
    int ret = ogrPINVOKE.Geometry_WkbSize(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int GetCoordinateDimension() {
    int ret = ogrPINVOKE.Geometry_GetCoordinateDimension(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public void SetCoordinateDimension(int dimension) {
    ogrPINVOKE.Geometry_SetCoordinateDimension(swigCPtr, dimension);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
  }

  public int GetDimension() {
    int ret = ogrPINVOKE.Geometry_GetDimension(swigCPtr);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  public int ExportToWkb(int bufLen, IntPtr buffer, int byte_order) {
    int ret = ogrPINVOKE.Geometry_ExportToWkb(swigCPtr, bufLen, buffer, byte_order);
    if (ogrPINVOKE.SWIGPendingException.Pending) throw ogrPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
