from libdesklets.controls import Control

import os
import commands

from IExec import IExec

class Exec(Control, IExec):

    def __init__(self):
        self.__cmdline = ""
        self.__result = ""
        self.__executed = 0
        Control.__init__(self)


    def __get_command(self):
        return self.__cmdline

    def __set_command(self, val):
        self.__cmdline = val        
        self.__result = commands.getstatusoutput(val)
        self.__executed = 1
        
    def __get_result(self):
        if (self.__executed):
            return self.__result[0]

    def __get_output(self):
        if (self.__executed):
            return self.__result[1]



    command = property(__get_command, __set_command, doc="The command line to execute")
    result = property(__get_result, doc="The exit code of the command executed")
    output = property(__get_output, doc="The output generated by the command")

def get_class(): return Exec
