from sensor.Sensor import Sensor
import threading


class MetaSensor(Sensor):

	def __init__(self, retriever, rtimer, displayer):
		
		Sensor.__init__(self)

		print 'MetaSensor'

		self.__retriever = retriever
		self.__rtimer    = rtimer
		self.__displayer = displayer

		self.__stop_event    = threading.Event()
		self.__display_event = threading.Event()
		
		self.watch_stop( self.__on_stop )
		self.watch_config( self.__on_update )


		def once():

			print 'MetaSensor is starting'
			self._add_thread( self.__retriever_thread )
			self._add_thread( self.__displayer_thread )
			self._start = None # or Null

		self._start = once


	def __on_stop(self):

		print 'MetaSensor.__on_stop'
		self.__stop_event.set()
		self.__display_event.set()



	def __on_update(self, *dummy):

		print 'MetaSensor.__on_update'
		self.__display_event.set()



	def __retriever_thread(self):

		while not self.__stop_event.isSet():

			print 'MetaSensor:Retrieving'

			if self.__retriever():
				self.__display_event.set()

			self.__stop_event.wait( self.__rtimer() )

		print 'MetaSensor:RBye'




	def __displayer_thread(self):

		while not self.__stop_event.isSet():

			self.__display_event.wait()
			print 'MetaSensor:Displaying'
			self.__displayer()
			self.__display_event.clear()


		print 'MetaSensor:DBye'
