#ifndef __TOKEN_H__
#define __TOKEN_H__

#include <glib.h>

/* token types */
#define EOE     99
#define NUM     100	/* this includes constants, eg pi, e, etc. */
#define ADD     101
#define SUB     102
#define MUL     103
#define DIV     104
#define LB      105
#define RB      106
#define X       107
#define POW     108
#define FUN     109
#define LSB	110
#define RSB	111
#define LCB	112
#define RCB	113
#define ERROR   150


typedef double (*Func) (double);

struct _token_info {
  gint type;
  double value;
  Func func;
  gint params;
  struct _token_info *next;
};

typedef struct _token_info token_list;
typedef struct _token_info token_node;

token_list *make_token_list(gchar *equation);
void free_list(token_list *list);

#endif /* __TOKEN_H__ */
