/****************************************************************************
** sysinfo.h
**
** Michael S. Borella <mike@borella.net>
**
** Class definition for UNIX information on the system
**
*****************************************************************************/

#ifndef SYSINFO_H
#define SYSINFO_H

#include <string>
#include "eh_system.h"

//---------------------------------------------------------------------------
//
// class Sysinfo
//
//---------------------------------------------------------------------------

class Sysinfo
{
private:
  string _name;       // name of the operating system, e.g., "Linux"
  string _release;    // kernel verion, e.g., "2.2.13"
  string _build;      // date of kernel compilation, etc.
  string _hardware;   // type of processor, e.g., i686
  string _domainname; // Domain name - this doesn't work on linux...

public:
  // Constructor and destructor
  Sysinfo() throw(EH_system);
  ~Sysinfo(){}

  // functions to retrieve the values
  string name()       { return _name; }
  string release()    { return _release; }
  string build()      { return _build; }
  string hardware()   { return _hardware; }
  string domainname() { return _domainname; }

  // format the output into somthing I like
  string format() { return _name + " " + _release + 
		      " (" + _build + ") " + _hardware; }
};

#endif



