/*
** 1998-05-31 -	After a long wait, here it finally is - the gdtool GUI config
**		module! This will be *big*, I can feel it.
** 1998-06-16 -	Smartened up the window handling. Now the config window is only ever
**		built (created) once. It is then reused! Environmentally safe.
**		It also allows me to use the config GUI to keep all the state,
**		although I'm not exactly convinced that's what I want to do...
** 1998-06-22 -	Redesigned. Cut away all old notebook-page-creation code (~140
**		lines) and implemented a new, more modular way of doing it.
** 1998-07-26 -	Added a global cache of page descriptors, avoiding having to
**		repeat the describe-calls all the time.
** 1998-08-25 -	Implemented a slim way of having the individual page modules
**		notify this main module of program-wide things they want done when
**		config closes. As an example, it is important to rescan the directories
**		if the styles or types change.
** 1998-08-30 -	Fixed version handling in config file, at least somewhat. Also added
**		a system-wide config, which is loaded if the user doesn't have one.
** 1998-10-16 -	System-wide config path now configurable via a symbol.
** 1999-12-24 -	Now uses the window utility module to handle the root config window,
**		thus making its size and position configurable and savable.
** 2000-07-02 -	Translated.
** 2002-07-19 -	Renamed, and recast the interface to use a tree. Cleaner-looking, and
**		handles nested stuff better.
*/

#include "gentoo.h"

#include <stdlib.h>

#include "cmdseq.h"
#include "dialog.h"
#include "dirpane.h"
#include "fileutil.h"
#include "iconutil.h"
#include "mount.h"
#include "window.h"
#include "xmlutil.h"

#include "configure.h"

#include "cfg_module.h"

#include "cfg_buttonlayout.h"
#include "cfg_buttons.h"
#include "cfg_cmdcfg.h"
#include "cfg_cmdseq.h"
#include "cfg_controls.h"
#include "cfg_dialogs.h"
#include "cfg_dirpane.h"
#include "cfg_errors.h"
#include "cfg_menus.h"
#include "cfg_mount.h"
#include "cfg_paths.h"
#include "cfg_styles.h"
#include "cfg_types.h"
#include "cfg_windows.h"

/* This should be set in the Makefile, and passed along using the -D
** compiler option, If not, let's default to nice old Slackware style.
*/
#if !defined PATH_CFG
#define	PATH_CFG	"/usr/local/etc/"
#endif

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	MainInfo	*min;
	GtkWidget	*dlg;
	GtkWidget	*tree[8];	/* Tree widgets used to organize config pages. */
	GtkWidget	*treeitem[8];
	guint		level;
	GtkWidget	*first;		/* Keeps track of first leaf node during build, for select. */
	GtkWidget	*nbook;		/* A notebook widget holding all the config pages. */
	GtkWidget	*ok, *save, *cancel;
	gint		page;		/* Index of last selected page. */

	guint32		flags;		/* Flags for stuff that need to be done when window closes. */
} CfgGui;

/* A global (yuck!) vector of page descriptor functions. This is where pointers to new pages go. */
static const CMDescribeFunc describe_page[] = {	cdp_describe,
						ccs_describe, ccc_describe,
						cst_describe, ctp_describe,
/*						cmu_describe,*/
						cbt_describe, cbl_describe,
						cpt_describe, cmn_describe,
						cwn_describe, cdl_describe,
						cct_describe, cer_describe
					};

#define	CFG_PAGES	(sizeof describe_page / sizeof describe_page[0])
/* A global vector of the resulting page descriptors. */
static const CfgModule	*cfg_page[CFG_PAGES];


static CfgGui	the_cfggui = { NULL };

/* ----------------------------------------------------------------------------------------- */

/* 1998-06-26 -	Do the work of hiding the config GUI. */
static void hide_config(CfgGui *cgu)
{
	guint	i;

	for(i = 0; i < CFG_PAGES; i++)
	{
		if(cfg_page[i]->hide != NULL)
			cfg_page[i]->hide(cgu->min);
	}
	if(the_cfggui.flags & CFLG_RESET_KEYBOARD)
		kbd_context_clear(cgu->min->gui->kbd_ctx);

	if(the_cfggui.flags & CFLG_REBUILD_MIDDLE)
		rebuild_middle(cgu->min);
	if(the_cfggui.flags & CFLG_REBUILD_BOTTOM)
	{
		rebuild_bottom(cgu->min);
		csq_execute(cgu->min, "ActivateOther");
		csq_execute(cgu->min, "ActivateOther");
	}

	if(the_cfggui.flags & CFLG_FLUSH_ICONS)
		ico_flush(cgu->min);

	if(the_cfggui.flags & CFLG_RESCAN_LEFT)
		dp_rescan(&cgu->min->gui->pane[0]);
	else if(the_cfggui.flags & CFLG_REDISP_LEFT)
		dp_redisplay_preserve(&cgu->min->gui->pane[0]);

	if(the_cfggui.flags & CFLG_RESCAN_RIGHT)
		dp_rescan(&cgu->min->gui->pane[1]);
	else if(the_cfggui.flags & CFLG_REDISP_RIGHT)
		dp_redisplay_preserve(&cgu->min->gui->pane[1]);

	if(the_cfggui.flags & CFLG_RESET_MOUNT)
		mnt_init(cgu->min);
	if(the_cfggui.flags & CFLG_RESET_KEYBOARD)
		ctrl_keys_install(cgu->min->cfg.ctrlinfo, cgu->min->gui->kbd_ctx);

	gtk_grab_remove(cgu->dlg);
	win_window_relink(cgu->min->cfg.wininfo, WIN_CONFIG, cgu->dlg);
	win_window_close(cgu->dlg);
}

/* 1998-06-26 -	The user just clicked the OK button. Let all page modules know, then hide the
**		GUI.
*/
static gint evt_ok_clicked(GtkWidget *wid, gpointer user)
{
	CfgGui		*cgu = user;
	MainInfo	*min = cgu->min;
	guint		i;

	cfg_modified_set(min);

	for(i = 0; i < CFG_PAGES; i++)
	{
		if(cfg_page[i]->accept != NULL)
			cfg_page[i]->accept(min);
	}
	hide_config(cgu);
	return TRUE;
}

/* 1998-09-18 -	Broke the saving code out of the button handler, and made it globally
**		accessible.
*/
void cfg_save_all(MainInfo *min)
{
	gchar		*root = "GentooConfig", *home, rcname[PATH_MAX];
	FILE		*out;
	guint		i;
	const CfgModule	*page;

	if((home = getenv("HOME")) != NULL)
	{
		strcpy(rcname, home);
		strcat(rcname, "/" RCNAME);
	}
	else
		return;

	cfg_modified_clear(min);
	if((out = xml_put_open(rcname)) != NULL)
	{
		xml_put_node_open(out, root);
		xml_put_text(out, "version", VERSION);
		for(i = 0; i < CFG_PAGES; i++)
		{
			if((page = describe_page[i](min)) != NULL && (page->save != NULL))
				page->save(min, out);
		}
		xml_put_node_close(out, root);
		xml_put_close(out);
	}
	else
		dlg_dialog_async_new_error(_("Couldn't open configuration file for output"));
}

/* 1998-07-25 -	I guess it's becoming time to grow up and start outputting a config file.
**		XML seems to be the format of the week, so I'll just go for something like
**		that.
** 1998-09-18 -	Broke out the actual saving code and put in in a function of its own.
*/
static gint evt_save_clicked(GtkWidget *wid, gpointer user)
{
	CfgGui		*cgu = user;
	MainInfo	*min = cgu->min;
	guint		i;

	cfg_modified_clear(min);
	for(i = 0; i < CFG_PAGES; i++)
	{
		if(cfg_page[i]->accept != NULL)
			cfg_page[i]->accept(min);
	}
	cfg_save_all(min);
	hide_config(cgu);

	return TRUE;
}

/* 1998-07-12 -	User clicked the cancel button. Hide the GUI. */
static gint evt_cancel_clicked(GtkWidget *wid, gpointer user)
{
	hide_config(user);
	return TRUE;
}

/* 1998-05-31 -	Build the buttons at the bottom of the config window (OK, Save, Cancel). */
static void build_buttons(CfgGui *cgu)
{
	cgu->ok = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(cgu->ok), "clicked", GTK_SIGNAL_FUNC(evt_ok_clicked), cgu);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cgu->dlg)->action_area), cgu->ok, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(cgu->ok, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(cgu->ok);

	cgu->save = gtk_button_new_with_label(_("Save"));
	gtk_signal_connect(GTK_OBJECT(cgu->save), "clicked", GTK_SIGNAL_FUNC(evt_save_clicked), cgu);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cgu->dlg)->action_area), cgu->save, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(cgu->save, GTK_CAN_DEFAULT);
	cgu->cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(cgu->cancel), "clicked", GTK_SIGNAL_FUNC(evt_cancel_clicked), cgu);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cgu->dlg)->action_area), cgu->cancel, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(cgu->cancel, GTK_CAN_DEFAULT);
}

/* 1998-06-16 -	This gets called as the user clicks the close button of the config GUI.
**		Unlike what the function name might lead you to expect, we don't destroy the
**		GUI we so laborously (sp?) created. We just hide it so we can use it again
**		later. Neat for several reasons.
*/
static gint evt_cfg_delete(GtkWidget *wid, GdkEvent *evt, gpointer user)
{
	hide_config(user);
	
	return TRUE;
}

/* 2002-07-19 -	A tree item was selected, so show the corresponding config page. */
static void evt_tree_item_select(GtkWidget *wid, gpointer user)
{
	the_cfggui.page = GPOINTER_TO_INT(user);
	gtk_notebook_set_page(GTK_NOTEBOOK(the_cfggui.nbook), the_cfggui.page);
}

/* 1998-06-16 -	Cooled up (?) this routine a lot. It is now recursive, in a rather
**		interesting manner. The point is not to reconstruct the entire config-
**		GUI each time it is needed, but rather to just build it once and then
**		hide/show it as needed.
*/
gint cfg_configure(MainInfo *min)
{
	CfgGui		*cgu = &the_cfggui;
	gchar		*name = NULL;
	guint		i;
	GtkWidget	*scwin, *hbox, *simple;

	the_cfggui.flags = 0U;

	/* Do the widgets already exist? Then just update and display. */
	if(cgu->dlg != NULL)
	{
		for(i = 0; i < CFG_PAGES; i++)
		{
			if(cfg_page[i]->update != NULL)
				cfg_page[i]->update(min);
		}
		win_window_show(cgu->dlg);
		gtk_notebook_set_page(GTK_NOTEBOOK(cgu->nbook), the_cfggui.page);
		gtk_widget_show_all(cgu->dlg);
		gtk_grab_add(cgu->dlg);
		return 1;
	}

	/* Initialize the cache of page descriptors. */
	for(i = 0; i < CFG_PAGES; i++)
		cfg_page[i] = describe_page[i](min);

	cgu->min = min;
	cgu->dlg = win_window_open(min->cfg.wininfo, WIN_CONFIG);
	gtk_widget_set_usize(cgu->dlg, -1, 464);
	gtk_signal_connect(GTK_OBJECT(cgu->dlg), "delete_event", GTK_SIGNAL_FUNC(evt_cfg_delete), cgu);
	cgu->tree[0] = gtk_tree_new();
	gtk_tree_set_selection_mode(GTK_TREE(cgu->tree[0]), GTK_SELECTION_BROWSE);
	gtk_tree_set_view_mode(GTK_TREE(cgu->tree[0]), GTK_TREE_VIEW_LINE);
	gtk_tree_set_view_lines(GTK_TREE(cgu->tree[0]), FALSE);
	cgu->level = 0U;
	cgu->first = NULL;
	cgu->nbook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(cgu->nbook), FALSE);

	for(i = 0; i < CFG_PAGES; i++)
	{
		if(cfg_page[i]->init != NULL)
		{
			if((simple = cfg_page[i]->init(min, &name)) != NULL)
			{
				GtkWidget	*ti;
				gint		pn;

				gtk_notebook_append_page(GTK_NOTEBOOK(cgu->nbook), simple, gtk_label_new(name));
				pn = gtk_notebook_page_num(GTK_NOTEBOOK(cgu->nbook), simple);
				ti = gtk_tree_item_new_with_label(name);
				gtk_signal_connect(GTK_OBJECT(ti), "select", GTK_SIGNAL_FUNC(evt_tree_item_select), GINT_TO_POINTER(pn));
				gtk_tree_append(GTK_TREE(cgu->tree[cgu->level]), ti);
				gtk_widget_show(ti);
				if(cgu->first == NULL)
					cgu->first = ti;
			}
		}
	}
	hbox  = gtk_hbox_new(FALSE, 0);
	scwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scwin), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scwin), cgu->tree[0]);
	gtk_box_pack_start(GTK_BOX(hbox), scwin, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cgu->nbook, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(cgu->dlg)->vbox), hbox, TRUE, TRUE, 0);
	build_buttons(cgu);

	if(cgu->first != NULL)
		gtk_tree_select_child(GTK_TREE(cgu->tree[0]), cgu->first);

	return cfg_configure(min);		/* Recurse! */
}

/* ----------------------------------------------------------------------------------------- */

void cfg_tree_level_begin(const gchar *label)
{
	if(the_cfggui.level < sizeof the_cfggui.tree / sizeof *the_cfggui.tree)
	{
		the_cfggui.treeitem[the_cfggui.level] = gtk_tree_item_new_with_label(label);
		gtk_widget_show(the_cfggui.treeitem[the_cfggui.level]);
		gtk_tree_append(GTK_TREE(the_cfggui.tree[the_cfggui.level]), the_cfggui.treeitem[the_cfggui.level]);
		the_cfggui.level++;
		the_cfggui.tree[the_cfggui.level] = gtk_tree_new();
		gtk_tree_set_view_mode(GTK_TREE(the_cfggui.tree[the_cfggui.level]), GTK_TREE_VIEW_ITEM);
	}
}

void cfg_tree_level_append(const gchar *label, GtkWidget *page)
{
	GtkWidget	*item;

	item = gtk_tree_item_new_with_label(label);
	gtk_tree_append(GTK_TREE(the_cfggui.tree[the_cfggui.level]), item);
	gtk_widget_show(item);
	if(page != NULL)
	{
		gint	pn;

		gtk_notebook_append_page(GTK_NOTEBOOK(the_cfggui.nbook), page, NULL);
		pn = gtk_notebook_page_num(GTK_NOTEBOOK(the_cfggui.nbook), page);
		gtk_signal_connect(GTK_OBJECT(item), "select", GTK_SIGNAL_FUNC(evt_tree_item_select), GINT_TO_POINTER(pn));
		gtk_object_set_data(GTK_OBJECT(page), "index", GINT_TO_POINTER(pn));
		if(the_cfggui.first == NULL)
			the_cfggui.first = item;
	}
}

/* 2002-07-19 -	Replace <old> tree widget with the <new> one. Handy for cases where config widgets
**		are seriously rebuilt during update(), such as in cfg_cmdcfg.c.
*/
void cfg_tree_level_replace(GtkWidget *old, GtkWidget *new)
{
	if(old)
	{
		gint	pn;

		pn = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(old), "index"));
		gtk_container_remove(GTK_CONTAINER(the_cfggui.nbook), old);
		gtk_notebook_insert_page(GTK_NOTEBOOK(the_cfggui.nbook), new, NULL, pn);
		gtk_object_set_data(GTK_OBJECT(new), "index", GINT_TO_POINTER(pn));
		gtk_widget_show(new);
	}
}

void cfg_tree_level_end(void)
{
	if(the_cfggui.level > 0)
	{
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(the_cfggui.treeitem[the_cfggui.level - 1]),
						the_cfggui.tree[the_cfggui.level]);
		the_cfggui.level--;
	}
}

/* ----------------------------------------------------------------------------------------- */

static void load_node(const XmlNode *node, gpointer user)
{
	MainInfo	*min = user;
	guint		i;

	for(i = 0; i < CFG_PAGES; i++)
	{
		if(xml_node_has_name(node, cfg_page[i]->node) && cfg_page[i]->load != NULL)
		{
			cfg_page[i]->load(min, node);
			return;
		}
	}
}

/* 1998-07-26 -	Load the entire program configuration. Pretty complex stuff, made considerably
**		less so by the modularization and tree organization.
** 1998-08-30 -	Now keeps knowledge about config file name to itself. First checks if there
**		is a local config; if so, it is loaded. If not, the system-wide default
**		config from /etc/local/etc/ is used. If that fails, whine.
** 1998-10-21 -	Now returns a set of flags, rather than the single first boolean.
** 1999-08-25 -	Made the error dialog shown when no config is found a bit more informative.
*/
guint32 cfg_load_config(MainInfo *min)
{
	XmlNode	*tree;
	gchar	name[PATH_MAX] = "", *hpath;
	guint32	i, flags = 0UL;

	if((hpath = getenv("HOME")) != NULL)
		g_snprintf(name, sizeof name, "%s" G_DIR_SEPARATOR_S "%s", hpath, RCNAME);

	/* Does the user seem to have a local config? */
	if(!fut_can_read_named(name))
		g_snprintf(name, sizeof name, PATH_CFG G_DIR_SEPARATOR_S "%s", RCNAME + 1);	/* Nope, check for global one. */

	/* Initialize the cache of page descriptors. */
	for(i = 0; i < CFG_PAGES; i++)
		cfg_page[i] = describe_page[i](min);

	if((tree = xml_tree_load(name)) != NULL)
	{
		const gchar	*fver;

		if(xml_get_text(tree, "version", &fver) && strcmp(fver, VERSION) != 0)
			g_warning(_("Config file version (%s) doesn't match program version (%s)"), fver, VERSION);
		xml_node_visit_children(tree, load_node, (gpointer) min);
		xml_tree_destroy(tree);
	}
	else
	{
		gchar	homename[PATH_MAX] = "", syscfg[PATH_MAX], whine[2 * PATH_MAX];

		if((hpath = getenv("HOME")) != NULL)
			g_snprintf(homename, sizeof homename, "%s/%s", hpath, RCNAME);

		g_snprintf(syscfg, sizeof syscfg, PATH_CFG G_DIR_SEPARATOR_S "%s", RCNAME + 1);
		g_snprintf(whine, sizeof whine, _("Couldn't find any configuration file; checked\n"
				"both \"%s\" and \"%s\".\n"
				"Using built-in minimal configuration."),
				homename, syscfg);
		dlg_dialog_async_new_error(whine);
		flags |= CLDF_NONE_FOUND;
	}
	return flags;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-25 -	Log a request to get something done. */
void cfg_set_flags(guint32 flags)
{
	the_cfggui.flags |= flags;
}

/* 1999-04-09 -	Set the 'configuration modified' flag. */
void cfg_modified_set(MainInfo *min)
{
	min->cfg.flags |= CFLG_CHANGED;	
}

/* 1999-04-09 -	Clear the 'configuration modified' flag. Use with care. */
void cfg_modified_clear(MainInfo *min)
{
	min->cfg.flags &= ~CFLG_CHANGED;
}
