/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  rand.inl - G::Rand inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  G::random_set_seed
 */

inline void
GFC::G::random_set_seed(unsigned int seed)
{
	g_random_set_seed(seed);
}

/*  G::random_boolean
 */

inline bool
GFC::G::random_boolean()
{
	return g_random_boolean();
}

/*  G::random_int
 */

inline unsigned int
GFC::G::random_int()
{
	return g_random_int();
}

/*  G::random_int_range
 */

inline int
GFC::G::random_int_range(int begin, int end)
{
	return g_random_int_range(begin, end);
}

/*  G::random_double
 */

inline double
GFC::G::random_double()
{
	return g_random_double();
}

/*  G::random_double_range
 */

inline double
GFC::G::random_double_range(double begin, double end)
{
	return g_random_double_range(begin, end);
}

/*  G::Rand
 */

inline GRand*
GFC::G::Rand::g_rand() const
{
	return rand_;
}

inline GFC::G::Rand::operator GRand* () const
{
	return this ? rand_ : 0;
}

inline bool
GFC::G::Rand::get_bool() const
{
	return g_rand_boolean(rand_);
}

inline unsigned int
GFC::G::Rand::get_int() const
{
	return g_rand_int(rand_);
}

inline int
GFC::G::Rand::get_int_range(int begin, int end) const
{
	return g_rand_int_range(rand_, begin, end);
}

inline double
GFC::G::Rand::get_double() const
{
	return g_rand_double(rand_);
}

inline double
GFC::G::Rand::get_double_range(double begin, double end) const
{
	return g_rand_double_range(rand_, begin, end);
}

inline void
GFC::G::Rand::set_seed(unsigned int seed)
{
	g_rand_set_seed(rand_, seed);
}

