/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file gfc/atk/hypertextsignals.hh
/// @brief Atk::Hypertext virtual signal handlers.
///
/// Provides Atk::HypertextSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Atk::Hypertext objects.

#ifndef GFC_ATK_HYPERTEXT_SIGNALS_HH
#define GFC_ATK_HYPERTEXT_SIGNALS_HH

#ifndef GFC_G_TYPE_HH
#include <gfc/glib/type.hh>
#endif

namespace GFC {

namespace Atk {

/// @class HypertextSignals hypertextsignals.hh gfc/atk/hypertextsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Atk::Hypertext.

class HypertextSignals : public virtual G::TypeInterface
{
protected:
/// @name Constructors
/// @{

	HypertextSignals(Hypertext *hypertext);
	///< Constructs a new HypertextSignals object.	
	///< @param hypertext A Hypertext object inheriting the HypertextSignals implementation.
	
	virtual ~HypertextSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{

	virtual void on_link_selected(int link_index);
	///< Called when one of the hyperlinks associated with the HyperText object is selected.
	///< @param link_index The index of the hyperlink which is selected.

/// @}
};

} // namespace Atk

} // namespace GFC

#endif // GFC_ATK_HYPERTEXT_SIGNALS_HH

