/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003 The GFC Development Team.
 *
 *  menuitem.inl - Gtk::MenuItem inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkMenuItem*
GFC::Gtk::MenuItem::gtk_menu_item() const
{
	return reinterpret_cast<GtkMenuItem*>(instance_);
}

inline GFC::Gtk::MenuItem::operator GtkMenuItem* () const
{
	return this ? gtk_menu_item() : 0;
}

inline bool
GFC::Gtk::MenuItem::has_submenu() const
{
	return gtk_menu_item()->submenu;
}

inline bool
GFC::Gtk::MenuItem::get_right_justified() const
{
	return gtk_menu_item_get_right_justified(gtk_menu_item());
}

inline void
GFC::Gtk::MenuItem::activate()
{
	gtk_menu_item_activate(gtk_menu_item());
}

inline void
GFC::Gtk::MenuItem::toggle_size_request(int *requisition)
{
	gtk_menu_item_toggle_size_request(gtk_menu_item(), requisition);
}

inline void
GFC::Gtk::MenuItem::toggle_size_allocate(int allocation)
{
	gtk_menu_item_toggle_size_allocate(gtk_menu_item(), allocation);
}

inline void
GFC::Gtk::MenuItem::set_right_justified(bool right_justified)
{
	gtk_menu_item_set_right_justified(gtk_menu_item(), right_justified);
}

inline void
GFC::Gtk::MenuItem::set_accel_path(const char *accel_path)
{
	gtk_menu_item_set_accel_path(gtk_menu_item(), accel_path);
}

inline const GFC::Gtk::MenuItem::ActivateSignalProxy
GFC::Gtk::MenuItem::sig_activate()
{
	return ActivateSignalProxy(this, &activate_signal);
}

inline const GFC::Gtk::MenuItem::ActivateItemSignalProxy
GFC::Gtk::MenuItem::sig_activate_item()
{
	return ActivateItemSignalProxy(this, &activate_item_signal);
}

inline const GFC::Gtk::MenuItem::ToggleSizeRequestSignalProxy
GFC::Gtk::MenuItem::sig_toggle_size_request()
{
	return ToggleSizeRequestSignalProxy(this, &toggle_size_request_signal);
}

inline const GFC::Gtk::MenuItem::ToggleSizeAllocateSignalProxy
GFC::Gtk::MenuItem::sig_toggle_size_allocate()
{
	return ToggleSizeAllocateSignalProxy(this, &toggle_size_allocate_signal);
}

