/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  radiobutton.cc - GtkRadioButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiobutton.hh"
#include "private/radiobuttonclass.hh"
#include "private/radiobuttonclass.hh"
#include <gfc/glib/private/marshal.hh>

using namespace GFC;

/*  Gtk::RadioButton
 */

Gtk::RadioButton::RadioButton(GtkRadioButton *radio_button, bool owns_reference)
: CheckButton((GtkCheckButton*)radio_button, owns_reference)
{
}

Gtk::RadioButton::RadioButton()
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
}

Gtk::RadioButton::RadioButton(const RadioButton *group)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioButton::RadioButton(const RadioButton *group, const char *label, bool use_underline)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioButton::RadioButton(const RadioButton *group, const String& label, bool use_underline)
: CheckButton((GtkCheckButton*)RadioButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioButton::~RadioButton()
{
}

/*  Gtk::RadioButton signals
 */

const Gtk::RadioButton::GroupChangedSignalType Gtk::RadioButton::group_changed_signal("group-changed", (GCallback)&G::Marshal::void_callback);
