/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  radiomenuitemsignals.cc - Gtk::RadioMenuItem virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiomenuitem.hh"
#include "radiomenuitemsignals.hh"
#include "private/radiomenuitemclass.hh"

using namespace GFC;

/*  Gtk::RadioMenuItemSignals
 */
 
Gtk::RadioMenuItemSignals::RadioMenuItemSignals(RadioMenuItem *radio_menu_item) 
: CheckMenuItemSignals(radio_menu_item)
{
	Gtk::RadioMenuItemClass::init(GTK_RADIO_MENU_ITEM_GET_CLASS(radio_menu_item->gtk_radio_menu_item()));
}

Gtk::RadioMenuItemSignals::~RadioMenuItemSignals()
{
}

void
Gtk::RadioMenuItemSignals::on_group_changed()
{
	GtkRadioMenuItemClass *g_class = RadioMenuItemClass::get_parent_class(instance_);
	if (g_class->group_changed)
		g_class->group_changed((GtkRadioMenuItem*)instance_);
}

/*  Gtk::RadioMenuItemClass
 */

void
Gtk::RadioMenuItemClass::init(GtkRadioMenuItemClass *g_class)
{
	g_class->group_changed = &group_changed_proxy;
}

GtkRadioMenuItemClass*
Gtk::RadioMenuItemClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_RADIO_MENU_ITEM_GET_CLASS(instance));
	return static_cast<GtkRadioMenuItemClass*>(ptr);
}

GType
Gtk::RadioMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RADIO_MENU_ITEM);
	}
	return type;
}

void*
Gtk::RadioMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::RadioMenuItemClass::group_changed_proxy(GtkRadioMenuItem *radio_menu_item)
{
	void *ptr = g_object_get_qdata((GObject*)radio_menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<RadioMenuItemSignals*>(ptr)->on_group_changed();
	else
	{
		GtkRadioMenuItemClass *g_class = RadioMenuItemClass::get_parent_class(radio_menu_item);
		if (g_class->group_changed)
			g_class->group_changed(radio_menu_item);
	}
}

