/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  scalesignals.cc - Gtk::Scale virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "scale.hh"
#include "scalesignals.hh"
#include "private/scaleclass.hh"

using namespace GFC;

/*  Gtk::ScaleSignals
 */
 
Gtk::ScaleSignals::ScaleSignals(Scale *scale)
: RangeSignals(scale)
{
	Gtk::ScaleClass::init(GTK_SCALE_GET_CLASS(scale->gtk_scale()));
}

Gtk::ScaleSignals::~ScaleSignals()
{
}

char*
Gtk::ScaleSignals::on_format_value(double value)
{
	GtkScaleClass *g_class = ScaleClass::get_parent_class(instance_);
	char *fmt = 0;
	if (g_class->format_value)
		fmt = g_class->format_value((GtkScale*)instance_, value);
	return fmt;
}

/*  Gtk::ScaleClass
 */

void
Gtk::ScaleClass::init(GtkScaleClass *g_class)
{
	g_class->format_value = &format_value_proxy;
}

GtkScaleClass*
Gtk::ScaleClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_SCALE_GET_CLASS(instance));
	return static_cast<GtkScaleClass*>(ptr);
}

GType
Gtk::ScaleClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SCALE);
	}
	return type;
}

void*
Gtk::ScaleClass::create()
{
	return g_object_new(get_type(), 0);
}

gchar*
Gtk::ScaleClass::format_value_proxy(GtkScale *scale, gdouble value)
{
	gchar *fmt = 0;
	void *ptr = g_object_get_qdata((GObject*)scale, G::ObjectSignals::quark());
	if (ptr)
		fmt = static_cast<ScaleSignals*>(ptr)->on_format_value(value);
	else
	{
		GtkScaleClass *g_class = ScaleClass::get_parent_class(scale);
		if (g_class->format_value)
			fmt = g_class->format_value(scale, value);
	}
	return fmt;
}

