/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  textviewsignals.cc - Gtk::TextView virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "textview.hh"
#include "textviewsignals.hh"
#include "menu.hh"
#include "private/textviewclass.hh"

using namespace GFC;

/*  Gtk::TextViewSignals
 */

Gtk::TextViewSignals::TextViewSignals(TextView *text_view)
: ContainerSignals(text_view)
{
	Gtk::TextViewClass::init(GTK_TEXT_VIEW_GET_CLASS(text_view->gtk_text_view()));
}

Gtk::TextViewSignals::~TextViewSignals() 
{
}

void
Gtk::TextViewSignals::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkTextViewClass *g_class = TextViewClass::get_parent_class(instance_);
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments((GtkTextView*)instance_, *hadjustment, *vadjustment);
}

void
Gtk::TextViewSignals::on_populate_popup(Menu& menu)
{
	GtkTextViewClass *g_class = TextViewClass::get_parent_class(instance_);
	if (g_class->populate_popup)
		g_class->populate_popup((GtkTextView*)instance_, menu.gtk_menu());
}

void
Gtk::TextViewSignals::on_set_anchor()
{
	GtkTextViewClass *g_class = TextViewClass::get_parent_class(instance_);
	if (g_class->set_anchor)
		g_class->set_anchor((GtkTextView*)instance_);
}

void
Gtk::TextViewSignals::on_insert_at_cursor(const String& str)
{
	GtkTextViewClass *g_class = TextViewClass::get_parent_class(instance_);
	if (g_class->insert_at_cursor)
		g_class->insert_at_cursor((GtkTextView*)instance_, str.c_str());
}

/*  Gtk::TextViewClass
 */

void
Gtk::TextViewClass::init(GtkTextViewClass *g_class)
{
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
	g_class->populate_popup = &populate_popup_proxy;
	g_class->set_anchor = &set_anchor_proxy;
	g_class->insert_at_cursor = &insert_at_cursor_proxy;
}

GtkTextViewClass*
Gtk::TextViewClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TEXT_VIEW_GET_CLASS(instance));
	return static_cast<GtkTextViewClass*>(ptr);
}

GType
Gtk::TextViewClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TEXT_VIEW);
	}
	return type;
}

void*
Gtk::TextViewClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::TextViewClass::set_scroll_adjustments_proxy(GtkTextView *text_view, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	void *ptr = g_object_get_qdata((GObject*)text_view, G::ObjectSignals::quark());
	if (ptr)
	{
		Adjustment *tmp_hadjustment = G::Object::wrap<Adjustment>(hadjustment);
		Adjustment *tmp_vadjustment = G::Object::wrap<Adjustment>(vadjustment);
		static_cast<TextViewSignals*>(ptr)->on_set_scroll_adjustments(tmp_hadjustment, tmp_vadjustment);
	}
	else
	{
		GtkTextViewClass *g_class = TextViewClass::get_parent_class(text_view);
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(text_view, hadjustment, vadjustment);
	}
}

void
Gtk::TextViewClass::populate_popup_proxy(GtkTextView *text_view, GtkMenu *menu)
{
	void *ptr = g_object_get_qdata((GObject*)text_view, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextViewSignals*>(ptr)->on_populate_popup(*G::Object::wrap<Menu>(menu));
	else
	{
		GtkTextViewClass *g_class = TextViewClass::get_parent_class(text_view);
		if (g_class->populate_popup)
			g_class->populate_popup(text_view, menu);
	}
}

void
Gtk::TextViewClass::set_anchor_proxy(GtkTextView *text_view)
{
	void *ptr = g_object_get_qdata((GObject*)text_view, G::ObjectSignals::quark());
	if (ptr)
		static_cast<TextViewSignals*>(ptr)->on_set_anchor();
	else
	{
		GtkTextViewClass *g_class = TextViewClass::get_parent_class(text_view);
		if (g_class->set_anchor)
			g_class->set_anchor(text_view);
	}
}

void
Gtk::TextViewClass::insert_at_cursor_proxy(GtkTextView *text_view, const gchar *str)
{
	void *ptr = g_object_get_qdata((GObject*)text_view, G::ObjectSignals::quark());
	if (ptr)
	{
		std::string tmp_str(str);
		static_cast<TextViewSignals*>(ptr)->on_insert_at_cursor(tmp_str);
	}
	else
	{
		GtkTextViewClass *g_class = TextViewClass::get_parent_class(text_view);
		if (g_class->insert_at_cursor)
			g_class->insert_at_cursor(text_view, str);
	}
}

