import os
import sys
import html
import parser
import docutils.core

GGISRC = '.'
GGIOUT = sys.argv[1]

libs = (
    ('libgg',      'LibGG',      'GGI helpers',                     'ggi-core/libgii'),
    ('libgii',     'LibGII',     'General Input Interface',         'ggi-core/libgii'),
    ('libggi',     'LibGGI',     'General Graphics Interface',      'ggi-core/libggi'),
    ('libgalloc',  'LibGAlloc',  'Graphics Allocator',              'ggi-core/libgalloc'),
    
    ('libggimisc', 'LibGGIMisc', 'Miscellaneous Graphics Features', 'lowlevel/libggimisc'),
    ('libggibuf',  'LibGGIBuf',  'Auxiliary Buffers',               'lowlevel/libbuf'),
    ('libggiblt',  'LibGGIBlt',  'Blitting Extension',              'lowlevel/libblt'),
    ('libggiovl',  'LibGGIOvl',  'Overlay Extension',               'lowlevel/libovl'),
    
    ('libggixmi',  'LibGGIXMI',  'GGI XMI Port',                    'highlevel/libxmi'),
    ('libggiwmh',  'LibGGIWMH',  'Windows Manager Hints',           'misc/libwmh'),
    ('libggigcp',  'LibGGIGCP',  'Color Management Extension',      'misc/libgcp'),
    
    ('piggy',      'Piggy',      'The Python Wrapper',              'wrappers/piggy'),
    )

debug = int(os.getenv('GGIDEBUG','0'))

def publish_site(nbrecent = 5):

    # create the temporary 'latest-news.tmp' file
    if debug: print "creating latest-news.tmp ..."
    o = open(os.path.join(GGISRC, 'latest-news.tmp'),"w")
    f = open(os.path.join(GGISRC, 'news.txt'))
    ll=f.readline()
    found=0
    while found <= nbrecent and ll:
        l=f.readline()
        if ll.strip() and l.strip()=='-'*(len(ll)-1):
            found = found + 1
        if found > 0 and found <= nbrecent:
            o.write(ll)
        ll = l
    o.close()
    f.close()

    # list all releases and hotfixes
    releases = {}
    if debug: print "listing releases ..."
    for i in [ i for i in os.listdir(os.path.join(GGISRC, "releases"))
               if i.endswith(".txt") and i!="index.txt" ]:
        l, v = i[:-4].split('-')
        if not releases.has_key(l):
            releases[l]={}
        v = tuple([ int(j) for j in v.split('.') ])
        
        releases[l][v] = [ i.strip().split()[-2:]
                           for i in file(os.path.join(GGISRC, "releases",i))
                           if i.startswith(".. hotfix::") ]

    # create 'releases/index.txt' from release list
    o = open(os.path.join(GGISRC, "releases", "index.txt"),"w")
    o.write("========\nReleases\n========\n\n")
    for i in libs:
        if releases.has_key(i[0]):
            t = i[1]+" - "+i[2]
            o.write("\n\n"+t+"\n"+'-'*len(t)+"\n\n")
            k =  releases[i[0]].keys()
            k.sort()
            k.reverse()
            for j in k:
                fix = ''
                n=len(releases[i[0]][j])
                if n>0:
                    fix = " (%i fix" % n
                    if n>1:
                        fix+="es"
                    fix += ')'
                o.write("- `%s %s.%s.%s <../releases/%s.html>`__%s\n"%(i[1], j[0], j[1], j[2], i[0]+'-'+'.'.join([ str(v) for v in j]),fix))
    o.close()

    os.chdir(GGISRC)
    a = []
    os.path.walk('.', pub, a)
    for k,l,m in a:
        publish_html(k,l,m)
        
    # copy resources/
    os.system("cp -r %s/resources %s"%(GGISRC, GGIOUT))

def pub(arg, di, f):
    if debug: print "scanning %s..."%di
    for j in f:
        if j.endswith('.txt'):
            # publish file
            ss = os.path.join(GGISRC, di, j)
            dd = os.path.join(GGIOUT, di, j[:-4]+".html")
            try:
                os.makedirs(os.path.join(GGIOUT, di))
            except:
                pass
            dpth = None
            if j == 'index.txt' and di == '.': dpth = 2
            elif j == 'news.txt' and di == '.': dpth = 1
            arg.append((ss,dd,dpth))
    
def publish_html(f, d, dpth = None):
    if debug: print "publishing html file %s -> %s ..."%(f,d)
    html.news_depth = dpth
    docutils.core.publish_file(source = open(f),
                               destination = open(d,"w"),
                               writer = html.SiteWriter(),
                               parser = parser.Parser())


if __name__ == '__main__':
    publish_site()
