/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtktreecontainer.h"

#include "glrr-glib.h"
#include "glrr-gobject.h"
#include "glrr-gtk.h"



static void builtin_module_init (void);

static gpointer create_panel_type_class_generic_info (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);
static gpointer create_panel_type_class_typeflags    (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);
static gpointer create_panel_type_class_typequery    (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);
static gpointer create_panel_type_class_interfaces   (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_type_class (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-type-class";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-type-class-generic-info",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  create_panel_type_class_generic_info,
				  NULL);

  g_inspector_register_procedure ("create-panel-type-class-typeflags",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  create_panel_type_class_typeflags,
				  NULL);

  g_inspector_register_procedure ("create-panel-type-class-typequery",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  create_panel_type_class_typequery,
				  NULL);

  g_inspector_register_procedure ("create-panel-type-class-interfaces",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE, /* XXX */
				  create_panel_type_class_interfaces,
				  NULL);
}



/*
 *
 */

static gpointer
create_panel_type_class_generic_info (gpointer data,
				      gpointer func_data,
				      gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *table;

  type = GPOINTER_TO_TYPE (data);


  panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			NULL);
  top = panel;


  frame = g_inspector_panel_frame_new ();
  g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "General");
  gtk_container_add (GTK_CONTAINER (panel), frame);


  {
    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new        ("GType:"),
		    gtk_label_new_printf ("0x%lx", type),

		    gtk_label_new        ("Name:"),
		    gtk_label_new_printf ("%s", g_type_name (type)),

		    NULL);


    n = g_list_length (label_list);


    table = gtk_table_new (2, n/2, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    4, 0);
	}
      }

    g_list_free (label_list);
  }


  return top;
}


static gpointer
create_panel_type_class_typeflags (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *vbox;


  type = GPOINTER_TO_TYPE (data);


  panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			NULL);
  top = panel;


  frame = g_inspector_panel_frame_new ();
  g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Type Flags");
  gtk_container_add (GTK_CONTAINER (panel), frame);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);


  {
    GtkWidget *label;
    GList *tmp;

    tmp = NULL;

    if (G_TYPE_IS_CLASSED(type))
      {
	tmp = g_list_append (tmp, "classed");
      }
    if (G_TYPE_IS_INSTANTIATABLE(type))
      {
	tmp = g_list_append (tmp, "instantiatable");
      }
    if (G_TYPE_IS_DERIVABLE(type))
      {
	tmp = g_list_append (tmp, "derivable");
      }
    if (G_TYPE_IS_DEEP_DERIVABLE(type))
      {
	tmp = g_list_append (tmp, "deep_derivable");
      }
    if (G_TYPE_IS_ABSTRACT(type))
      {
	tmp = g_list_append (tmp, "abstract");
      }
    if (G_TYPE_IS_VALUE_ABSTRACT(type))
      {
	tmp = g_list_append (tmp, "value_abstract");
      }

    tmp = g_list_first (tmp);
    while (tmp != NULL)
      {
	label = gtk_label_new (tmp->data);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_misc_set_padding   (GTK_MISC (label), 8, 0);

	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);

	tmp = g_list_next (tmp);
      }

    g_list_free (tmp);
  }


  return top;
}


static gpointer
create_panel_type_class_typequery (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *table;


  type = GPOINTER_TO_TYPE (data);


  panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			NULL);
  top = panel;


  frame = g_inspector_panel_frame_new ();
  g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "GTypeQuery");
  gtk_container_add (GTK_CONTAINER (panel), frame);


  {
    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    {
      GTypeQuery type_query;

      g_type_query (type, &type_query);

      if (type_query.type != G_TYPE_INVALID)
	{
	  label_list
	    = g_list_new (gtk_label_new        ("GType:"),
			  gtk_label_new_printf ("0x%lx", type_query.type),
		    
			  gtk_label_new        ("Name:"),
			  gtk_label_new_printf ("%s",   type_query.type_name),

			  gtk_label_new        ("Class Size:"),
			  gtk_label_new_printf ("%d",   type_query.class_size),

			  gtk_label_new        ("Instance Size:"),
			  gtk_label_new_printf ("%d",   type_query.instance_size),

			  NULL);
	}
      else
	{
	  label_list = NULL;
	}

      n = g_list_length (label_list);
    }

    table = gtk_table_new (2, n/2, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    4, 0);
	}
      }

    g_list_free (label_list);
  }


  return top;
}

static gpointer
create_panel_type_class_interfaces (gpointer data,
				    gpointer func_data,
				    gpointer invoke_data)
{
  GType type;
  
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;


  type = GPOINTER_TO_TYPE (data);


  panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			NULL);
  top = panel;


  frame = g_inspector_panel_frame_new ();
  g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "GInterfaces");
  gtk_container_add (GTK_CONTAINER (panel), frame);


  {
    GtkWidget *vbox;
    GtkWidget *label;
    GType *interfaces;
    guint  n_interfaces;
    GType  tmp_interface;
    guint i;

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);


    interfaces = g_type_interfaces (type, &n_interfaces);

    for (i = 0; i < n_interfaces; ++i)
      {
	tmp_interface = interfaces[i];

	label = gtk_label_new (g_type_name (tmp_interface));
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_misc_set_padding   (GTK_MISC (label), 8, 0);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
      }

    if (interfaces != NULL)
      {
	g_free (interfaces);
      }
  }


  return top;
}
